/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client.contract;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.client.contract.Status;
import ru.bitel.bgbilling.modules.phone.client.event.UpdatePhoneContractStatusEvent;
import ru.bitel.bgbilling.modules.phone.common.bean.Gate;
import ru.bitel.bgbilling.modules.phone.common.service.GatesService;
import ru.bitel.bgbilling.modules.phone.common.service.StatusService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;

public class GateManagePanel
extends BGUPanel {
    private BGUComboBox<Status> statusCmb = new BGUComboBox();
    private BGUList<Gate> gateList = new BGUList();
    private JPanel editor = new JPanel();
    private BGUComboBox<Gate> gateCmb = new BGUComboBox();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
    List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private ActionListener statusActionListener = null;

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.statusCmb.addItem((Object)new Status(0));
        this.statusCmb.addItem((Object)new Status(1));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder((Border)new BGTitleBorder("\u0421\u0442\u0430\u0442\u0443\u0441"));
        topPanel.add((Component)this.statusCmb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel gatePanel = new JPanel(new GridBagLayout());
        gatePanel.setBorder((Border)new BGTitleBorder("\u0428\u043b\u044e\u0437\u044b"));
        gatePanel.add((Component)this.gateList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(gatePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.editor.setVisible(false);
        this.editor.setLayout(new GridBagLayout());
        this.editor.add((Component)this.gateCmb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.add((Component)this.okCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateManagePanel.this.performAction("okCancel.clicked", e.getActionCommand());
            }
        });
        this.statusActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateManagePanel.this.performAction("status.changed", e.getActionCommand());
            }
        };
        this.statusCmb.addActionListener(this.statusActionListener);
    }

    private void setData() throws BGException {
        List gates = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).getContractGates(((ClientContext)this.getContext()).getContractId());
        this.gateList.setData(gates);
        int status = ((StatusService)((ClientContext)this.getContext()).getPort(StatusService.class)).getStatus(((ClientContext)this.getContext()).getContractId());
        this.statusCmb.removeActionListener(this.statusActionListener);
        this.statusCmb.setSelectedIndex(status);
        this.statusCmb.addActionListener(this.statusActionListener);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("status.changed", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((StatusService)((ClientContext)GateManagePanel.this.getContext()).getPort(StatusService.class)).setStatus(((ClientContext)GateManagePanel.this.getContext()).getContractId(), ((Status)GateManagePanel.this.statusCmb.getSelectedItem()).status);
                GateManagePanel.this.setData();
                int mid = ((ClientContext)GateManagePanel.this.getContext()).getModuleId();
                int cid = ((ClientContext)GateManagePanel.this.getContext()).getContractId();
                EventBus.publish((Object)new UpdatePhoneContractStatusEvent());
                EventBus.publish((Object)new UpdateContractTreeEvent(mid, cid));
            }
        };
        new AbstractBGUPanel.DefaultAction("okCancel.clicked", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (BGButtonPanelOkCancel.OK.getActionCommand().equals(e.getActionCommand())) {
                    Gate gate = (Gate)GateManagePanel.this.gateCmb.getSelectedItem();
                    ((GatesService)((ClientContext)GateManagePanel.this.getContext()).getPort(GatesService.class)).addContractGate(((ClientContext)GateManagePanel.this.getContext()).getContractId(), gate.getId());
                    GateManagePanel.this.editor.setVisible(false);
                    GateManagePanel.this.fireActionEvent();
                } else {
                    GateManagePanel.this.editor.setVisible(false);
                }
            }
        };
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.setData());
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.editor.setVisible(true);
            this.buildCombobox();
        });
        GateManagePanel thiz = this;
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, arg_0 -> this.lambda$initActions$2((Container)((Object)thiz), arg_0));
    }

    private void buildCombobox() throws BGException {
        List contractGates = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).getContractGates(((ClientContext)this.getContext()).getContractId());
        HashSet contractSet = new HashSet();
        contractSet.addAll(contractGates);
        List allGates = ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).listGates();
        ArrayList<Gate> result = new ArrayList<Gate>();
        for (Gate gate : allGates) {
            if (contractSet.contains(gate)) continue;
            result.add(gate);
        }
        this.gateCmb.setData(result);
    }

    public void addAddActionListener(ActionListener a) {
        this.actionListeners.add(a);
    }

    private void fireActionEvent() {
        for (ActionListener l : this.actionListeners) {
            ActionEvent event = new ActionEvent((Object)this, 0, "ok");
            l.actionPerformed(event);
        }
    }

    private /* synthetic */ void lambda$initActions$2(Container thiz, ActionEvent e) throws BGException {
        Gate gate = (Gate)this.gateList.getSelectedValue();
        if (gate != null && JOptionPane.showConfirmDialog(thiz, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u043b\u044e\u0437:" + gate.getHost() + ":" + gate.getPort() + " ?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            ((GatesService)((ClientContext)this.getContext()).getPort(GatesService.class)).deleteContractGate(((ClientContext)this.getContext()).getContractId(), gate.getId());
            this.setData();
            this.fireActionEvent();
        }
    }
}

