/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforePaymentEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ClickTransactionManager
extends MPSTransactionManager {
    private static final Logger logger = LogManager.getLogger();
    private static final int UNKNOWN_REQUEST_TYPE = 1000;
    private static final int INCORRECT_SUM = 1001;
    private static final int TRANSACTION_ALREADY_CANCELLED = 1002;
    private static final int TRANSACTION_NOT_FOUND = 1003;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest httpRequest, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            MPSRequest request = this.parseRequest(con, moduleId, mpsId, system, httpRequest);
            mpsResponse.setAction(request.getAction());
            mpsResponse.getParameters().putAll(request.parameters);
            Contract contract = this.actionCheck(request);
            if (system.extDenyForJur && contract.getFc() == 1) {
                throw new MPSException(-1, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0432 \u043f\u043e\u043b\u044c\u0437\u0443 \u044e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043b\u0438\u0446!");
            }
            BigDecimal sum = request.getSum();
            switch (request.getAction()) {
                case 1: {
                    if (sum.compareTo(system.minSumm) < 0) {
                        throw new MPSException(22, "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - " + Utils.formatBigDecimalSumm((BigDecimal)system.minSumm) + "!");
                    }
                    if (sum.compareTo(system.maxSumm) > 0) {
                        throw new MPSException(23, "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - " + Utils.formatBigDecimalSumm((BigDecimal)system.maxSumm) + "!");
                    }
                    Transaction payment = this.getTransactionByTransId(con, moduleId, mpsId, request.getTransId(), request.getTime());
                    if (payment != null) {
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c transactionId \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                    }
                    payment = this.prepareTransaction(con, moduleId, mpsId, contract.getId(), request.getTime(), request.getSum(), request.getTransId(), request.getRawNumber(), request.getType());
                    mpsResponse.setId(payment.getId());
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("Success");
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, request.getTransId(), request.getTime());
                    if (transaction != null) {
                        if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                            throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c transactionId \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0432 \u0411\u0414 \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \u041e\u043f\u043b\u0430\u0447\u0435\u043d");
                        }
                        if (transaction.getSum().compareTo(request.getSum()) != 0) {
                            throw new MPSException(1001, "\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0442\u043e\u0439, \u0447\u0442\u043e \u043f\u0440\u0438\u0448\u043b\u0430 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 prepare!");
                        }
                        Object incomeMerchantPrepareId = request.parameters.get("merchantPrepareId");
                        if (incomeMerchantPrepareId != null && !incomeMerchantPrepareId.toString().equals(String.valueOf(transaction.getId()))) {
                            throw new MPSException(1003, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 merchant_prepare_id \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435");
                        }
                        int incomeErrorCode = Utils.parseInt((String)request.parameters.get("error").toString(), (int)0);
                        if (incomeErrorCode < 0) {
                            this.cancelPreparedTransaction(con, moduleId, mpsId, system, transaction);
                            mpsResponse.setResult(ErrorCode.ANSWER_ERROR_TRANSACTION_CANCELLED.errCode);
                            mpsResponse.setMessage("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430");
                            break;
                        }
                        if (transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode())) {
                            throw new MPSException(1002, "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0440\u0430\u043d\u0435\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u0443\u044e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e");
                        }
                        MPSBeforePaymentEvent event = new MPSBeforePaymentEvent(moduleId, sum);
                        event = (MPSBeforePaymentEvent)EventProcessor.getInstance().request((QueueEvent)event);
                        BigDecimal scriptSum = event.getPaymentSum();
                        transaction = this.executePreparedTransaction(con, moduleId, system, transaction, "", scriptSum, sum);
                        mpsResponse.setId(transaction.getId());
                        mpsResponse.setResult(ErrorCode.ANSWER_SUCCESS.errCode);
                        mpsResponse.setMessage("Success");
                        break;
                    }
                    throw new MPSException(5, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c transactionId \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442!");
                }
            }
        }
        catch (MPSException e) {
            this.processError(e, mpsResponse);
        }
        catch (Exception ex) {
            String message = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage();
            logger.error(message, (Throwable)ex);
            this.processError(new MPSException(-1, message), mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        String action;
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043e\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b");
        }
        MPSRequest result = new MPSRequest(con, moduleId, mpsId, request, system);
        switch (action = request.getParameter("action")) {
            case "0": {
                result.setAction(1);
                break;
            }
            case "1": {
                result.setAction(2);
                break;
            }
            default: {
                logger.error("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 action!");
                throw new MPSException(1000, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 action!");
            }
        }
        BigDecimal amount = Utils.parseBigDecimal((String)request.getParameter("amount"), (BigDecimal)BigDecimal.ZERO);
        String merchantTransId = request.getParameter("merchant_trans_id");
        String merchantPrepareId = request.getParameter("merchant_prepare_id");
        String signTime = request.getParameter("sign_time");
        String clickTransId = request.getParameter("click_trans_id");
        String signString = request.getParameter("sign_string");
        String serviceId = request.getParameter("service_id");
        if (logger.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder("\u041f\u0440\u0438\u0448\u0435\u0434\u0448\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: ");
            debugMessage.append("action = " + action);
            debugMessage.append("; merchant_trans_id = " + merchantTransId);
            if (result.getAction() == 2 && Utils.notBlankString((String)merchantPrepareId)) {
                debugMessage.append("; merchant_prepare_id = " + merchantPrepareId);
            }
            debugMessage.append("; amount = " + amount.toString());
            debugMessage.append("; sign_time = " + signTime);
            debugMessage.append("; click_trans_id = " + clickTransId);
            debugMessage.append("; sign_string = " + signString);
            debugMessage.append("; service_id = " + serviceId);
            logger.debug((CharSequence)debugMessage);
        }
        if (Utils.isBlankString((String)merchantTransId) || amount == null || Utils.isBlankString((String)signTime) || Utils.isBlankString((String)signString)) {
            String message = "\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0434\u0438\u043d \u0438\u0437 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432! (merchant_trans_id,amount,sign_time,sign_string)";
            logger.error(message);
            throw new MPSException(21, message);
        }
        result.setType(0);
        result.setSum(amount);
        result.setTimeString(signTime);
        result.setTime(TimeUtils.parseDate((String)signTime, (String)"yyyy-MM-dd HH:mm:ss"));
        result.setTransId(clickTransId);
        result.setNumber(merchantTransId);
        result.setRawNumber(merchantTransId);
        result.parameters.put("clickTransId", clickTransId);
        result.parameters.put("merchantTransId", merchantTransId);
        if (result.getAction() == 2 && Utils.notBlankString((String)merchantPrepareId)) {
            result.parameters.put("merchantPrepareId", merchantPrepareId);
        }
        result.parameters.put("error", request.getParameter("error"));
        result.parameters.put("error_string", request.getParameter("error_note"));
        result.parameters.put("serviceId", serviceId);
        String incomeSign = signString.toLowerCase();
        String secret = system.secret;
        String encoding = Utils.maskBlank((String)system.requestEncoding, (String)"UTF-8");
        String string2Sign = clickTransId + serviceId + secret + merchantTransId;
        if (result.getAction() == 2 && Utils.notBlankString((String)merchantPrepareId)) {
            string2Sign = string2Sign + merchantPrepareId;
        }
        string2Sign = string2Sign + amount + action + signTime;
        if (logger.isDebugEnabled()) {
            String hidePassword = clickTransId + serviceId + "*****" + merchantTransId;
            if (result.getAction() == 2 && Utils.notBlankString((String)merchantPrepareId)) {
                hidePassword = hidePassword + merchantPrepareId;
            }
            hidePassword = hidePassword + amount + action + signTime;
            logger.debug("\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0431\u0438\u043b\u043b\u0438\u043d\u0433 \u0432\u044b\u0447\u0438\u0441\u043b\u044f\u0435\u0442 \u043f\u043e\u0434\u043f\u0438\u0441\u044c: " + hidePassword);
        }
        try {
            byte[] digestBytes = Utils.getDigestBytes((byte[])string2Sign.getBytes(encoding));
            String bgSign = new String(Utils.bytesToHexString((byte[])digestBytes)).toLowerCase();
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u043e\u0434\u043f\u0438\u0441\u044c, \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u043e\u043c: " + bgSign);
            }
            if (!incomeSign.equals(bgSign)) {
                String message = "\u041f\u043e\u0434\u043f\u0438\u0441\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!";
                logger.error(message);
                throw new MPSException(10, message);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430", (Throwable)e);
            throw new MPSException(-1, "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 - \u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430");
        }
        return result;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 21: {
                response.setResult(ErrorCode.ANSWER_ERROR_REQUEST.errCode);
                break;
            }
            case 1003: {
                response.setResult(ErrorCode.ANSWER_ERROR_TRANSACTION_NOT_FOUND.errCode);
                break;
            }
            case 1000: {
                response.setResult(ErrorCode.ANSWER_ERROR_ACTION_NOT_FOUND.errCode);
                break;
            }
            case 3: {
                response.setResult(ErrorCode.ANSWER_ERROR_CONTRACT_NOT_FOUND.errCode);
                break;
            }
            case 10: {
                response.setResult(ErrorCode.ANSWER_ERROR_INCORRECT_SIGN.errCode);
                break;
            }
            case 22: 
            case 23: {
                response.setResult(ErrorCode.ANSWER_ERROR_INCORRECT_SUM.errCode);
                break;
            }
            case 4: {
                response.setResult(ErrorCode.ANSWER_ERROR_ALREADY_PAID.errCode);
                break;
            }
            case -1: {
                response.setResult(ErrorCode.ANSWER_ERROR_SYSTEM.errCode);
                break;
            }
            case 1002: {
                response.setResult(ErrorCode.ANSWER_ERROR_TRANSACTION_CANCELLED.errCode);
                break;
            }
            default: {
                response.setResult(ErrorCode.ANSWER_ERROR_SYSTEM.errCode);
            }
        }
        response.setMessage(ex.message);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        HashMap<String, String> answerParams = new HashMap<String, String>(5);
        answerParams.put("error", String.valueOf(response.getResult()));
        answerParams.put("error_note", response.getMessage());
        if (response.getResult() == ErrorCode.ANSWER_SUCCESS.errCode) {
            answerParams.put("click_trans_id", response.getParameters().get("clickTransId").toString());
            answerParams.put("merchant_trans_id", response.getParameters().get("merchantTransId").toString());
            answerParams.put(response.getAction() == 2 ? "merchant_confirm_id" : "merchant_prepare_id", String.valueOf(response.getId()));
        }
        String jsonAnswer = null;
        try {
            jsonAnswer = mapper.writeValueAsString(answerParams);
        }
        catch (JsonProcessingException e) {
            logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430 \u0434\u043b\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b: " + e.getMessage(), (Throwable)e);
        }
        return jsonAnswer.getBytes();
    }

    private static enum ErrorCode {
        ANSWER_SUCCESS(0),
        ANSWER_ERROR_INCORRECT_SIGN(-1),
        ANSWER_ERROR_INCORRECT_SUM(-2),
        ANSWER_ERROR_ACTION_NOT_FOUND(-3),
        ANSWER_ERROR_ALREADY_PAID(-4),
        ANSWER_ERROR_CONTRACT_NOT_FOUND(-5),
        ANSWER_ERROR_TRANSACTION_NOT_FOUND(-6),
        ANSWER_ERROR_UPDATE_USER_DATA(-7),
        ANSWER_ERROR_REQUEST(-8),
        ANSWER_ERROR_TRANSACTION_CANCELLED(-9),
        ANSWER_ERROR_SYSTEM(-10);

        private int errCode;

        private ErrorCode(int code) {
            this.errCode = code;
        }
    }
}

