/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.megafon.client.MegafonContractProductHistoryTableModel;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class MegafonHistoryPanel
extends BGUPanel {
    private final JTextField contractId = new JTextField(10);
    private final JTextField msisdn = new JTextField(10);
    private final JTextField productId = new JTextField(10);
    private final JTextField productTitle = new JTextField(20);
    private final BGControlPanelPeriod period = new BGControlPanelPeriod();
    private final JButton search = new JButton("\u041f\u043e\u0438\u0441\u043a");
    private final JLabel recordCountLabel = new JLabel();
    private final BGControlPanelPages page = new BGControlPanelPages();
    private MegafonContractService megafonContractService;
    private MegafonContractProductHistoryTableModel tableModel;

    protected void jbInit() throws Exception {
        this.page.setKey(((Object)((Object)this)).getClass().getName());
        this.setLayout(new GridBagLayout());
        this.tableModel = new MegafonContractProductHistoryTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        this.search.addActionListener(e -> {
            this.page.setPageIndex(1);
            this.performAction("refresh");
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MegafonContractProductHistory entry;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (entry = (MegafonContractProductHistory)MegafonHistoryPanel.this.tableModel.getSelectedRow()) != null && entry.getContractId() > 0) {
                    BGClientBase.getFrame().getTabbedPane().addContractEditorTab(entry.getContractId());
                }
            }
        });
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addPropertyChangeListener(evt -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 0, 0.0, 1.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0);
        filterPanel.add((Component)new JLabel("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), constraints);
        filterPanel.add((Component)this.contractId, constraints);
        filterPanel.add((Component)new JLabel("MSISDN"), constraints);
        filterPanel.add((Component)this.msisdn, constraints);
        filterPanel.add((Component)new JLabel("ID \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430"), constraints);
        filterPanel.add((Component)this.productId, constraints);
        filterPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430"), constraints);
        filterPanel.add((Component)this.productTitle, constraints);
        filterPanel.add((Component)this.search, constraints);
        filterPanel.add((Component)this.recordCountLabel, constraints);
        filterPanel.add((Component)this.page, constraints);
        return filterPanel;
    }

    private MegafonContractService getMegafonContractService() {
        if (this.megafonContractService == null) {
            this.megafonContractService = (MegafonContractService)((ClientContext)this.getContext()).getPort(MegafonContractService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonContractService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                this.tableModel.setUserDirectory((Directory<UserInfo>)((ClientContext)this.getContext()).getDirectory(UserInfo.class));
                SearchResult searchResult = this.getMegafonContractService().getHistoryList(this.page.getPage(), Utils.parseInt((String)this.contractId.getText(), (int)0), this.msisdn.getText(), Utils.parseInt((String)this.productId.getText(), (int)0), this.productTitle.getText(), this.period.getPeriod());
                this.tableModel.setData(searchResult.getList());
                this.page.setPage(searchResult.getPage());
                this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }
}

