/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;

public class PhoneResourceDao
extends AbstractIdDao<PhoneResource> {
    public PhoneResourceDao(Connection con, int mid) {
        super(con, mid, "inv_phone_resource");
    }

    protected PhoneResource getFromRS(ResultSet rs) throws SQLException, BGException {
        PhoneResource result = new PhoneResource();
        result.setId(rs.getInt("id"));
        result.setPhoneFrom(rs.getLong("phoneFrom"));
        result.setPhoneTo(rs.getLong("phoneTo"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        result.setCategoryId(rs.getInt("categoryId"));
        return result;
    }

    protected void updateImpl(PhoneResource b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getPhoneTo() < 0L || b.getPhoneFrom() < 0L || b.getPhoneTo() < b.getPhoneFrom()) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " ( phoneFrom, phoneTo, dateFrom, dateTo, comment, categoryId ) VALUES (?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET phoneFrom=?, phoneTo=?, dateFrom=?, dateTo=?, comment=?, categoryId = ? WHERE id=?");
            ps.setInt(7, b.getId());
        }
        ps.setLong(1, b.getPhoneFrom());
        ps.setLong(2, b.getPhoneTo());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)b.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDateTo()));
        ps.setString(5, b.getComment());
        ps.setInt(6, b.getCategoryId());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<PhoneResource> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<PhoneResource> list(int categoryId) throws BGException {
        return this.list("categoryId=?", "phoneFrom", new Object[]{categoryId});
    }

    public List<PhoneResource> list(int categoryId, Date date) throws BGException {
        return this.list("categoryId=? and (dateFrom IS NULL OR dateFrom <= ?) and ( dateTo IS NULL OR dateTo >= ? ) ", "id", new Object[]{categoryId, date, date});
    }

    public List<PhoneResource> list(Date dateFrom, Date dateTo) throws BGException {
        return this.list("(dateFrom IS NULL OR dateFrom <= ?) and ( dateTo IS NULL OR dateTo >= ? ) ", "id", new Object[]{dateFrom, dateTo});
    }

    public List<PhoneResource> list(Set<Integer> categoryIds) throws BGException {
        if (categoryIds == null || categoryIds.size() == 0) {
            return new ArrayList<PhoneResource>();
        }
        return this.list("categoryId IN (" + Utils.toString(categoryIds) + ")", "id", new Object[0]);
    }

    public void importData(int categoryId, String importData) throws BGException {
        if (importData == null) {
            throw new BGMessageException("importData is null!!!");
        }
        if (categoryId < 1) {
            throw new BGMessageException("categoryId not set!!!");
        }
        for (String line : importData.split("\n")) {
            String[] resourceData = line.split("\t");
            PhoneResource phoneResource = new PhoneResource();
            phoneResource.setCategoryId(categoryId);
            phoneResource.setComment("");
            if (resourceData.length > 1) {
                phoneResource.setPhoneFrom(Utils.parseLong((String)resourceData[0]));
                phoneResource.setPhoneTo(Utils.parseLong((String)resourceData[1]));
            }
            if (resourceData.length > 3) {
                phoneResource.setDateFrom(TimeUtils.parseDate((String)resourceData[2], (String)"dd.MM.yyyy"));
                phoneResource.setDateTo(TimeUtils.parseDate((String)resourceData[3], (String)"dd.MM.yyyy"));
            }
            if (resourceData.length > 4) {
                phoneResource.setComment(resourceData[4]);
            }
            this.update(phoneResource);
        }
    }
}

