/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptUpdatedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.oss.systems.inventory.resource.common.DeviceManagerMethodType;
import ru.bitel.oss.systems.inventory.resource.server.DeviceManagerMethod;

public class DeviceManagerMethodMap
implements EventListener<ScriptUpdatedEvent> {
    private static final Logger logger = LogManager.getLogger();
    private static final DeviceManagerMethodMap instance = new DeviceManagerMethodMap();
    private final ConcurrentMap<String, List<ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod>> map = new ConcurrentHashMap<String, List<ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod>>();

    public static DeviceManagerMethodMap getInstance() {
        return instance;
    }

    public DeviceManagerMethodMap() {
        try {
            EventProcessor.getInstance().addListener(this, ScriptUpdatedEvent.class);
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod> getMethodList(String className) throws Exception {
        List<Object> result = (ArrayList<ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod>)this.map.get(className);
        if (result != null) {
            return result;
        }
        Class<?> clazz = DynamicClassManager.getInstance().loadClass(className);
        ArrayList<ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod> newResult = new ArrayList<ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod>();
        for (Method m : clazz.getMethods()) {
            DeviceManagerMethod a = m.getAnnotation(DeviceManagerMethod.class);
            if (a == null) continue;
            ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod method = new ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod();
            method.setTypes(new HashSet<DeviceManagerMethodType>(Arrays.asList(a.types())));
            method.setMethod(m.getName());
            method.setTitle(a.title());
            newResult.add(method);
        }
        result = this.map.putIfAbsent(className, newResult);
        if (result == null) {
            result = newResult;
        }
        return result;
    }

    @Override
    public void notify(ScriptUpdatedEvent e, EventListenerContext ctx) throws BGException {
        this.map.clear();
    }
}

