/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.database.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.database.common.service.DatabaseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class DatabaseMonitor
extends BGUTabPanel {
    public static final String TAB_ID = "dbMonitor";
    protected JPopupMenu popupMenu = null;
    private int recordIndex = 1;
    private int recordMax = 0;
    private BGUTable table = null;
    private JTabbedPane tabPanel = null;
    private RowData currentRowData = null;
    private BGTextField tableNameMask = null;
    private JLabel recordCount = new JLabel();
    private DatabaseService databaseService = null;
    private BGTextField recordInfo = new BGTextField(15);
    private BGUComboBox<ModulePluginItem> modulePlugins = null;
    private BGControlPanelPages pages = new BGControlPanelPages();
    private BGControlPanelPages dataPages = new BGControlPanelPages();
    private TableNameTableModel tableNameTableModel = new TableNameTableModel(TableNameTableModel.class.getName());
    private TableDataTableModel tableDataTableModel = new TableDataTableModel(TableDataTableModel.class.getName());
    private TableDataRecordTableModel tableDataRecordTableModel = new TableDataRecordTableModel(TableDataRecordTableModel.class.getName());
    private TableStatusTableModel tableInfoTableModel = new TableStatusTableModel(TableStatusTableModel.class.getName());

    public DatabaseMonitor() {
        this(new ClientContext("kernel.database", 0, 0, ""));
    }

    public DatabaseMonitor(ClientContext clientContext) {
        super(clientContext, TAB_ID, "\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
    }

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPaneNoBorder = new BGSplitPaneNoBorder(1, (Component)this.getTableNamePanel(), (Component)this.getDataPanel(), 800L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPaneNoBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.performAction("refresh");
    }

    private JPanel getTableNamePanel() {
        this.pages.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("to")) {
                this.performAction("refresh");
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTableNameFilterPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getPagePanel(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.getTableNameTable()), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getTableNameFilterPanel() {
        this.tableNameMask = new BGTextField();
        this.tableNameMask.setHorizontalAlignment(0);
        this.tableNameMask.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DatabaseMonitor.this.pages.setPageIndex(1);
                    DatabaseMonitor.this.performAction("refresh");
                }
            }
        });
        this.modulePlugins = new BGUComboBox();
        this.modulePlugins.addItemListener(this.comboBoxSelect(e1 -> {
            this.pages.setPageIndex(1);
            this.performAction("refresh");
        }));
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c/\u041f\u043b\u0430\u0433\u0438\u043d:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.modulePlugins, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        gridx = 0;
        panel.add((Component)new JLabel("\u041c\u0430\u0441\u043a\u0430 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b (REGEXP):"), new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.tableNameMask, new GridBagConstraints(gridx++, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPagePanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordCount, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private BGUTable getTableNameTable() {
        if (this.table == null) {
            this.table = new BGUTable((TableModel)((Object)this.tableNameTableModel));
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        RowData rowData = (RowData)DatabaseMonitor.this.tableNameTableModel.getSelectedRow();
                        if (rowData != null && rowData != DatabaseMonitor.this.currentRowData) {
                            DatabaseMonitor.this.currentRowData = rowData;
                            DatabaseMonitor.this.recordIndex = 1;
                            DatabaseMonitor.this.dataPages.reset();
                            for (Component component : DatabaseMonitor.this.tabPanel.getComponents()) {
                                ((DataTabPanel)component).setUpdate(false);
                            }
                        }
                        DatabaseMonitor.this.refreshDataTabs();
                    }
                    if (DatabaseMonitor.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(mouseEvent) && Arrays.stream(DatabaseMonitor.this.table.getSelectedRows()).anyMatch(i -> i == DatabaseMonitor.this.table.rowAtPoint(mouseEvent.getPoint()))) {
                        DatabaseMonitor.this.getPopupMenu().show((Component)DatabaseMonitor.this.table, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.table;
    }

    private void refreshDataTabs() {
        DataTabPanel dataTabPanel = (DataTabPanel)this.tabPanel.getSelectedComponent();
        if (!dataTabPanel.isUpdate()) {
            dataTabPanel.setUpdate(true);
            int tabIndex = this.tabPanel.getSelectedIndex();
            if (tabIndex == 0) {
                this.refreshInfoTab();
            } else if (tabIndex == 1) {
                this.refreshRecordTab();
            } else if (tabIndex == 2) {
                this.refreshDataTab();
            }
        }
    }

    private void refreshInfoTab() {
        this.tryCall(() -> {
            ArrayList list = new ArrayList();
            RowData rowData = (RowData)this.tableNameTableModel.getSelectedRow();
            if (rowData != null) {
                this.getDatabaseService().getTableInfo(rowData.getJson().getString("name")).forEach(e -> list.add(new RowData(e)));
            }
            this.tableInfoTableModel.setData(list);
            this.recordMax = Utils.parseInt((String)list.stream().filter(a -> a.getJson().optString("name").equals("TABLE_ROWS")).findFirst().map(a -> a.getJson().optString("value")).orElse("0"));
            this.dataPages.setPage(this.dataPages.getPage().setRecordCount(this.recordMax));
        });
    }

    private void refreshRecordTab() {
        this.tryCall(() -> {
            ArrayList list = new ArrayList();
            RowData rowData = (RowData)this.tableNameTableModel.getSelectedRow();
            if (rowData != null) {
                this.getDatabaseService().getTableDataRecord(rowData.getJson().getString("name"), this.recordIndex - 1).forEach(e -> list.add(new RowData(e)));
            }
            this.tableDataRecordTableModel.setData(list);
            this.recordInfo.setText(Utils.formatInteger((int)this.recordIndex) + " \u0438\u0437 " + Utils.formatInteger((int)this.recordMax));
        });
    }

    private void refreshDataTab() {
        this.tryCall(() -> {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList list = new ArrayList();
            RowData rowData = (RowData)this.tableNameTableModel.getSelectedRow();
            if (rowData != null) {
                headers.addAll(this.getDatabaseService().getTableDataHeaders(rowData.getJson().getString("name")));
                this.getDatabaseService().getTableData(rowData.getJson().getString("name"), this.dataPages.getPage()).forEach(e -> list.add(new RowData(e)));
            }
            this.tableDataTableModel.setHeaders(headers);
            this.tableDataTableModel.setData(list);
            this.tableDataTableModel.fireTableStructureChanged();
        });
    }

    private JTabbedPane getDataPanel() {
        this.tabPanel = new JTabbedPane();
        this.tabPanel.addChangeListener(e -> this.refreshDataTabs());
        this.tabPanel.add((Component)this.getDataInfoPanel(), "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        this.tabPanel.add((Component)this.getDataRecordPanel(), "\u0414\u0430\u043d\u043d\u044b\u0435 (\u0437\u0430\u043f\u0438\u0441\u0438)");
        this.tabPanel.add((Component)this.getDataTablePanel(), "\u0414\u0430\u043d\u043d\u044b\u0435 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430)");
        return this.tabPanel;
    }

    private DataTabPanel getDataInfoPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableInfoTableModel));
        int gridy = 0;
        DataTabPanel panel = new DataTabPanel();
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private DataTabPanel getDataRecordPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableDataRecordTableModel));
        DataTabPanel panel = new DataTabPanel();
        panel.add((Component)this.getRecordNavigationPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRecordNavigationPanel() {
        Color bgColor = this.recordInfo.getBackground();
        this.recordInfo.setHorizontalAlignment(0);
        this.recordInfo.setEditable(false);
        this.recordInfo.setBackground(bgColor);
        JButton firstButton = new JButton("<<");
        firstButton.setToolTipText("\u043a \u043f\u0435\u0440\u0432\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438");
        firstButton.addActionListener(e -> {
            this.recordIndex = 1;
            this.refreshRecordTab();
        });
        JButton prevButton = new JButton("<");
        prevButton.setToolTipText("\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c");
        prevButton.addActionListener(e -> {
            this.recordIndex = this.recordIndex > 1 ? this.recordIndex - 1 : 1;
            this.refreshRecordTab();
        });
        JButton nextButton = new JButton(">");
        nextButton.setToolTipText("\u0441\u043b\u0435\u0434\u0443\u0449\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c");
        nextButton.addActionListener(e -> {
            this.recordIndex = this.recordIndex < this.recordMax ? this.recordIndex + 1 : this.recordMax;
            this.refreshRecordTab();
        });
        JButton lastButton = new JButton(">>");
        lastButton.setToolTipText("\u043a \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0437\u0430\u043f\u0438\u0441\u0438");
        lastButton.addActionListener(e -> {
            this.recordIndex = this.recordMax;
            this.refreshRecordTab();
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)firstButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)prevButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.recordInfo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)nextButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)lastButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private DataTabPanel getDataTablePanel() {
        this.dataPages.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("to")) {
                this.refreshDataTab();
            }
        });
        BGUTable table = new BGUTable((TableModel)((Object)this.tableDataTableModel));
        DataTabPanel panel = new DataTabPanel();
        panel.add((Component)this.dataPages, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private DatabaseService getDatabaseService() {
        if (this.databaseService == null) {
            this.databaseService = (DatabaseService)((ClientContext)this.getContext()).getPort(DatabaseService.class);
        }
        return this.databaseService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.modulePlugins.getItemCount() == 0) {
                DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
                this.getDatabaseService().getModulePluginList().forEach(a -> comboBoxModel.addElement(new ModulePluginItem((String)a)));
                this.modulePlugins.setModel(comboBoxModel);
            }
            ArrayList list = new ArrayList();
            this.tryCall(() -> {
                SearchResult<String> searchResult = this.getDatabaseService().searchTableNames(((ModulePluginItem)this.modulePlugins.getSelectedItem()).json.optInt("id"), this.tableNameMask.getText(), this.getTableNameTable().getSort(), this.pages.getPage());
                searchResult.getList().forEach(a -> list.add(new RowData(a)));
                this.pages.setPage(searchResult.getPage());
                this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
            });
            this.tableNameTableModel.setData(list);
        });
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b"){
                {
                    this.addActionListener(e -> {
                        if (ClientUtils.confirm((String)"\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415!!! \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0431\u0435\u0437 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0432\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f?", (String)"\u0417\u0430\u043f\u0440\u043e\u0441")) {
                            try {
                                DatabaseMonitor.this.getDatabaseService().dropTables(DatabaseMonitor.this.tableNameTableModel.getSelectedRows().stream().map(i -> i.getJson().getString("name")).collect(Collectors.toList()));
                                DatabaseMonitor.this.performAction("refresh");
                                DatabaseMonitor.this.refreshDataTabs();
                            }
                            catch (Exception e1) {
                                ClientUtils.showErrorMessageDialog((Throwable)e1);
                            }
                        }
                    });
                }
            });
        }
        return this.popupMenu;
    }

    class TableNameTableModel
    extends BGTableModel<RowData> {
        public TableNameTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b", 100, 200, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c/\u041f\u043b\u0430\u0433\u0438\u043d", 200, 200, 200, "subsystem", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0430\u0437\u043c\u0435\u0440, \u0432 \u041c\u0431", 100, 100, 100, "size", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            return json.optString(identifier);
        }
    }

    class TableDataTableModel
    extends BGTableModel<RowData> {
        private List<String> headers;

        public TableDataTableModel(String name) {
            super(name);
            this.headers = new ArrayList<String>();
        }

        public void setHeaders(List<String> headers) {
            this.headers = headers;
            this.reinitColumns();
        }

        protected void initColumns() {
            if (this.headers != null) {
                for (String header : this.headers) {
                    this.addColumn(header, 100, 200, -1, header, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                }
            }
        }

        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            return json.optString(identifier);
        }
    }

    class TableDataRecordTableModel
    extends BGTableModel<RowData> {
        public TableDataRecordTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u043e\u043b\u0431\u0446\u0430", 100, 200, 300, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 100, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            return json.optString(identifier);
        }
    }

    class TableStatusTableModel
    extends BGTableModel<RowData> {
        public TableStatusTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 200, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 200, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            return json.optString(identifier);
        }
    }

    class DataTabPanel
    extends JPanel {
        private boolean update;

        public DataTabPanel() {
            super(new GridBagLayout());
            this.update = false;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public void setUpdate(boolean update) {
            this.update = update;
        }
    }

    class ModulePluginItem
    implements GuiTitlable {
        JSONObject json = null;

        public ModulePluginItem(String data) {
            this.json = new JSONObject(data);
        }

        public String getGuiTitle() {
            int id = this.json.optInt("id");
            return this.json.optString("title") + (String)(id != 0 ? " [#" + id + "]" : "");
        }
    }
}

