/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import jakarta.mail.internet.InternetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class LoaderParameterConvertUtil
extends LoaderBase {
    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int sourceParameterId = configJsonObject.optInt("sourceParameterId", 0);
        int targetParameterId = configJsonObject.optInt("targetParameterId", 0);
        try {
            String mode = configJsonObject.optString("mode", "append");
            if ("replace".equals(mode)) {
                this.deleteParameter(targetParameterId);
            }
            try (ContractDao contractDao = new ContractDao(this.con, 0);
                 ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.con);){
                ContractParameterGroupAttr contractParameterGroupAttr = (ContractParameterGroupAttr)contractParameterGroupAttrDao.get(targetParameterId);
                PreparedStatement psSelect = this.con.prepareStatement("SELECT id FROM contract");
                ResultSet resultSet = psSelect.executeQuery();
                block42: while (resultSet.next()) {
                    String val;
                    int contractId = resultSet.getInt(1);
                    EntityAttr entityAttr = contractDao.getContractParameter(contractId, sourceParameterId);
                    if (entityAttr == null || !Utils.notBlankString((String)(val = entityAttr.toString()))) continue;
                    switch (EntitySpecAttrType.getEntitySpecAttrType((int)contractParameterGroupAttr.getType())) {
                        case DATE: {
                            Date date = TimeUtils.parseDate((String)val, (String)"dd.MM.yyyy");
                            if (date == null) break;
                            contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrDate(contractId, targetParameterId, date));
                            break;
                        }
                        case EMAIL: {
                            List emails = Utils.toList((String)val, (String)"\n ;,");
                            if (emails.isEmpty()) break;
                            ArrayList<EntityAttrEmail.EmailContact> contacts = new ArrayList<EntityAttrEmail.EmailContact>();
                            for (String email : emails) {
                                InternetAddress[] addresses = InternetAddress.parse((String)email);
                                if (addresses == null) continue;
                                int size = addresses.length;
                                for (int index = 0; index < size; ++index) {
                                    contacts.add(new EntityAttrEmail.EmailContact(addresses[index].getPersonal(), addresses[index].getAddress()));
                                }
                            }
                            if (contacts.isEmpty()) continue block42;
                            EntityAttrEmail entityAttrEmail = (EntityAttrEmail)contractDao.getContractParameter(contractId, targetParameterId);
                            if (entityAttrEmail == null) {
                                entityAttrEmail = new EntityAttrEmail(contractId, targetParameterId);
                            }
                            entityAttrEmail.getContactList().addAll(contacts);
                            contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrEmail);
                            break;
                        }
                        case PHONE: {
                            if (!val.matches("^\\+\\d{11}$")) break;
                            EntityAttrPhone entityAttrPhone = (EntityAttrPhone)contractDao.getContractParameter(contractId, targetParameterId);
                            if (entityAttrPhone == null) {
                                entityAttrPhone = new EntityAttrPhone(contractId, targetParameterId);
                            }
                            entityAttrPhone.addContact(val, "");
                            contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrPhone);
                            break;
                        }
                        case ADDRESS: {
                            try {
                                CityDao cityDao = new CityDao(this.con);
                                try {
                                    HouseDao houseDao = new HouseDao(this.con);
                                    try {
                                        StreetDao streetDao = new StreetDao(this.con);
                                        try {
                                            CountryDao countryDao = new CountryDao(this.con);
                                            try {
                                                String houseFrac;
                                                House house;
                                                String streetTitle;
                                                Street street;
                                                String cityTitle;
                                                City city;
                                                JSONObject jsonObject = new JSONObject(val);
                                                String countryTitle = jsonObject.optString("country", "\u0420\u043e\u0441\u0441\u0438\u044f");
                                                Country country = countryDao.get(countryTitle);
                                                if (country == null) {
                                                    country = new Country();
                                                    country.setTitle(countryTitle);
                                                    countryDao.update(country);
                                                }
                                                if ((city = cityDao.get(cityTitle = jsonObject.optString("city"), country.getId())) == null) {
                                                    city = new City();
                                                    city.setCountryId(country.getId());
                                                    city.setTitle(cityTitle);
                                                    cityDao.update(city);
                                                }
                                                if ((street = (Street)streetDao.get(streetTitle = jsonObject.optString("street"), city.getId())) == null) {
                                                    street = new Street();
                                                    street.setCity(city);
                                                    street.setTitle(streetTitle);
                                                    streetDao.update(street);
                                                }
                                                if ((house = houseDao.get(houseFrac = jsonObject.optString("house"), street.getId())) == null) {
                                                    house = new House();
                                                    house.setStreetId(street.getId());
                                                    house.setHouseAndFrac(houseFrac);
                                                    house.setPostIndex(jsonObject.optString("postIndex"));
                                                    houseDao.update(house);
                                                }
                                                String flat = jsonObject.optString("flat");
                                                EntityAttrAddress entityAttrAddress = EntityAttrAddress.builder((int)contractId, (int)targetParameterId).setHouseId(house.getId()).setPod(0).setFloor(0).setFlat(flat).setRoom("").setComment("").setFormatKey(null).setTitle(val).build();
                                                contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrAddress);
                                                continue block42;
                                            }
                                            finally {
                                                countryDao.close();
                                                continue block42;
                                            }
                                        }
                                        finally {
                                            streetDao.close();
                                            continue block42;
                                        }
                                    }
                                    finally {
                                        houseDao.close();
                                        continue block42;
                                    }
                                }
                                finally {
                                    cityDao.close();
                                    continue block42;
                                }
                            }
                            catch (Exception e) {
                                this.getLogger().error((Object)e);
                                break;
                            }
                        }
                    }
                }
                resultSet.close();
                psSelect.close();
            }
            catch (Exception e) {
                this.getLogger().error((Object)e);
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
        return null;
    }
}

