/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccount;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.BalanceService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public abstract class ActionContractBalanceBase
extends ActionBase {
    protected void balance(Period period) throws SQLException {
        this.balance(this.rootNode, period);
    }

    protected void balance(Element rootNode, Period period) throws SQLException {
        Element table = this.createElement(rootNode, "table");
        Element data = this.createElement(table, "data");
        List<ContractBalance> list = new BalanceDao(this.con).getContractBalanceList(this.cid, period);
        for (ContractBalance balance : list) {
            int mm = balance.getMonth() - 1;
            String date = (mm >= 0 && mm < TimeUtils.monthNames.length ? TimeUtils.monthNames[mm] : "-") + " " + balance.getYear();
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", date);
            row.setAttribute("f1", "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430");
            row.setAttribute("f2", Utils.formatBigDecimalSumm((BigDecimal)balance.getIncomingSaldo()));
            row = this.createElement(data, "row");
            row.setAttribute("f0", date);
            row.setAttribute("f1", "\u041f\u0440\u0438\u0445\u043e\u0434 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446");
            row.setAttribute("f2", Utils.formatBigDecimalSumm((BigDecimal)balance.getPayments()));
            row = this.createElement(data, "row");
            row.setAttribute("f0", date);
            row.setAttribute("f1", "\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446");
            row.setAttribute("f2", Utils.formatBigDecimalSumm((BigDecimal)balance.getAccounts()));
            row = this.createElement(data, "row");
            row.setAttribute("f0", date);
            row.setAttribute("f1", "\u0420\u0430\u0441\u0445\u043e\u0434 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446");
            row.setAttribute("f2", Utils.formatBigDecimalSumm((BigDecimal)balance.getCharges()));
            row = this.createElement(data, "row");
            row.setAttribute("f0", date);
            row.setAttribute("f1", "\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u043a\u043e\u043d\u0435\u0446 \u043c\u0435\u0441\u044f\u0446\u0430");
            row.setAttribute("f2", Utils.formatBigDecimalSumm((BigDecimal)balance.toBalance()));
        }
        table.setAttribute("summa1", Utils.formatBigDecimalSumm((BigDecimal)(list.size() > 0 ? list.get(list.size() - 1).getIncomingSaldo() : BigDecimal.ZERO)));
        table.setAttribute("summa2", Utils.formatBigDecimalSumm((BigDecimal)(list.size() > 0 ? list.get(list.size() - 1).getCharges() : BigDecimal.ZERO)));
        table.setAttribute("summa3", Utils.formatBigDecimalSumm((BigDecimal)(list.size() > 0 ? list.get(list.size() - 1).getAccounts() : BigDecimal.ZERO)));
        table.setAttribute("summa4", Utils.formatBigDecimalSumm((BigDecimal)(list.size() > 0 ? list.get(list.size() - 1).getPayments() : BigDecimal.ZERO)));
        table.setAttribute("summa5", Utils.formatBigDecimalSumm((BigDecimal)(list.size() > 0 ? list.get(list.size() - 1).toBalance() : BigDecimal.ZERO)));
    }

    protected void balanceAccount(Period period, ContractDao contractDao) throws SQLException, BGException {
        this.balanceAccount(this.rootNode, period, contractDao);
    }

    protected void balanceAccount(Element rootNode, Period period, ContractDao contractDao) throws SQLException, BGException {
        Directory<Service> serviceDirectory = this.context.getDirectory(Service.class, 0);
        Element table = this.createElement(rootNode, "table");
        Element data = this.createElement(table, "data");
        BigDecimal summa = BigDecimal.ZERO;
        Calendar cal = Calendar.getInstance();
        BalanceService service = this.context.getService(BalanceService.class, 0);
        SearchResult<ContractAccount> contractAccountList = service.contractAccountList(this.cid, period, 1);
        for (ContractAccount account : contractAccountList.getList()) {
            int sid = account.getServiceId();
            String title = serviceDirectory.get(sid) != null ? serviceDirectory.get(sid).getTitle() : "";
            cal.setTime(account.getDate());
            String date = cal.get(1) + " " + TimeUtils.monthNames[cal.get(2)];
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", date);
            row.setAttribute("f1", title);
            row.setAttribute("f2", Utils.formatBigDecimalSumm((BigDecimal)account.getSum()));
            row.setAttribute("date", date);
            row.setAttribute("title", title);
            row.setAttribute("sid", String.valueOf(sid));
            row.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)account.getSum()));
        }
        summa = summa.add(contractAccountList.getSum());
        Contract contract = (Contract)contractDao.get(this.cid);
        ContractUtils contractUtils = new ContractUtils(this.con);
        if (Utils.notBlankString((String)contract.getDependSubList())) {
            Element subTable = this.createElement(rootNode, "sub_table");
            data = this.createElement(subTable, "data");
            contractAccountList = service.contractAccountList(this.cid, period, 3);
            for (ContractAccount account : contractAccountList.getList()) {
                String title = serviceDirectory.get(account.getServiceId()) != null ? serviceDirectory.get(account.getServiceId()).getTitle() : "";
                cal.setTime(account.getDate());
                String date = cal.get(1) + " " + TimeUtils.monthNames[cal.get(2)];
                Element row = this.createElement(data, "row");
                row.setAttribute("contract", contractUtils.getContractTitle(this.cid, false));
                row.setAttribute("date", date);
                row.setAttribute("service", title);
                row.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)account.getSum()));
                row.setAttribute("sid", String.valueOf(account.getServiceId()));
                row.setAttribute("cid", String.valueOf(account.getContractId()));
            }
            summa = summa.add(contractAccountList.getSum());
        }
        table.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)summa));
    }

    protected void balanceCharges(Period period, ContractDao contractDao) throws SQLException {
        this.balanceCharges(this.rootNode, period, contractDao);
    }

    protected void balanceCharges(Element rootNode, Period period, ContractDao contractDao) throws SQLException {
        Contract contract;
        Element table = this.createElement(rootNode, "table");
        Element data = this.createElement(table, "data");
        BigDecimal summa = BigDecimal.ZERO;
        Object query = "SELECT t1.id, IF(t2.title IS NULL, '<\u043f\u0443\u0441\u0442\u043e>', t2.title), comment, dt, summa, t2.flag, t1.uid, t1.lm FROM contract_charge AS t1 LEFT JOIN contract_charge_types as t2 ON t1.pt=t2.id WHERE cid=? AND dt>=? AND dt<=? ORDER BY dt, pt";
        PreparedStatement ps = this.con.prepareStatement((String)query);
        ps.setInt(1, this.cid);
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            summa = summa.add(rs.getBigDecimal(5));
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", rs.getString(1));
            row.setAttribute("f1", rs.getString(6));
            row.setAttribute("f2", TimeUtils.formatDate((Date)rs.getDate(4)));
            row.setAttribute("f3", Utils.formatBigDecimalSumm((BigDecimal)rs.getBigDecimal(5)));
            row.setAttribute("f4", rs.getString(2));
            row.setAttribute("f5", rs.getString(3));
            row.setAttribute("f6", TimeUtils.formatFullDate((Date)rs.getTimestamp(8)));
            User user = UserMap.getUser(rs.getInt(7));
            if (user == null) continue;
            row.setAttribute("f7", user.getName());
        }
        rs.close();
        ps.close();
        try {
            contract = (Contract)contractDao.get(this.cid);
        }
        catch (BGException e) {
            throw new SQLException(e);
        }
        if (Utils.notBlankString((String)contract.getDependSubList())) {
            Element subTable = this.createElement(rootNode, "sub_table");
            data = this.createElement(subTable, "data");
            query = "SELECT contract.title, dt, type.title, summa FROM contract_charge LEFT JOIN contract ON contract_charge.cid=contract.id LEFT JOIN contract_charge_types AS type ON contract_charge.pt=type.id WHERE cid IN ( " + contract.getDependSubList() + " ) AND dt>=? AND dt<=? ORDER BY cid, dt, pt";
            ps = this.con.prepareStatement((String)query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            rs = ps.executeQuery();
            while (rs.next()) {
                summa = summa.add(rs.getBigDecimal(4));
                Element row = this.createElement(data, "row");
                row.setAttribute("contract", rs.getString(1));
                row.setAttribute("date", TimeUtils.formatDate((Date)rs.getDate(2)));
                row.setAttribute("type", rs.getString(3));
                row.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)rs.getBigDecimal(4)));
            }
            rs.close();
            ps.close();
        }
        table.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)summa));
    }

    protected void balancePayments(Period period) throws SQLException {
        this.balancePayments(this.rootNode, period);
    }

    protected void balancePayments(Element rootNode, Period period) throws SQLException {
        Element table = this.createElement(rootNode, "table");
        Element data = this.createElement(table, "data");
        BigDecimal summa = BigDecimal.ZERO;
        try {
            PaymentDao paymentDao = new PaymentDao(this.con);
            SearchResult<Payment> paymentList = paymentDao.getPaymentList(this.cid, period, 1);
            Directory<PaymentType> paymentDirectory = this.context.getDirectory(PaymentType.class, this.mid);
            Directory<UserInfo> userDirectory = this.context.getDirectory(UserInfo.class, 0);
            for (Payment p : paymentList.getList()) {
                Element row = this.createElement(data, "row");
                row.setAttribute("f0", Integer.toString(p.getId()));
                row.setAttribute("f1", paymentDirectory.get(p.getTypeId()).getEditable() ? "0" : "1");
                row.setAttribute("f2", TimeUtils.formatDate((Date)p.getDate()));
                row.setAttribute("f3", Utils.formatBigDecimalSumm((BigDecimal)p.getSum()));
                row.setAttribute("f4", Utils.isBlankString((String)paymentDirectory.get(p.getTypeId()).getTitle()) ? "<\u043f\u0443\u0441\u0442\u043e>" : paymentDirectory.get(p.getTypeId()).getTitle());
                row.setAttribute("f5", p.getComment());
                row.setAttribute("f6", TimeUtils.formatFullDate((Date)p.getTimeChange()));
                row.setAttribute("f7", userDirectory.get(p.getUserId()).getName());
            }
            summa = summa.add(paymentList.getSum());
            ContractUtils contractUtils = new ContractUtils(this.con);
            SearchResult<Payment> subPaymentList = paymentDao.getPaymentList(this.cid, period, 3);
            if (subPaymentList.getList().size() > 0) {
                Element subTable = this.createElement(rootNode, "sub_table");
                data = this.createElement(subTable, "data");
                for (Payment p : subPaymentList.getList()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("contract", contractUtils.getContractTitle(p.getContractId(), false));
                    row.setAttribute("date", TimeUtils.formatDate((Date)p.getDate()));
                    row.setAttribute("type", paymentDirectory.get(p.getTypeId()).getTitle());
                    row.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)p.getSum()));
                }
                summa = summa.add(subPaymentList.getSum());
            }
        }
        catch (DOMException | BGException e) {
            e.printStackTrace();
        }
        table.setAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)summa));
        ServerUtils.prepareElementToSerialize(rootNode);
    }
}

