/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;
import ru.bitel.oss.kernel.directories.address.common.event.StreetModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=StreetModifiedEvent.class, serviceClass=AddressService.class)
public class Street
extends CityItem {
    private String postIndex;

    public Street() {
    }

    public Street(City city, int id, String title) {
        super(id, title);
        this.setCity(city);
    }

    @XmlAttribute
    public String getPostIndex() {
        return this.postIndex;
    }

    public void setPostIndex(String postIndex) {
        this.postIndex = postIndex;
    }

    public static Street from(Street street) {
        return Street.builder().setId(street.getId()).setTitle(street.getTitle()).setPostIndex(street.getPostIndex()).setCity(City.from(street.getCity())).setCityId(street.getCityId()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Street street = new Street();

        private Builder() {
        }

        public Builder setId(int id) {
            this.street.id = id;
            return this;
        }

        public Builder setCityId(int cityId) {
            this.street.cityId = cityId;
            return this;
        }

        public Builder setTitle(String title) {
            this.street.title = title;
            return this;
        }

        public Builder setPostIndex(String postIndex) {
            this.street.postIndex = postIndex;
            return this;
        }

        public Builder setCity(City city) {
            this.street.setCity(city);
            return this;
        }

        public Street build() {
            try {
                Street street = this.street;
                return street;
            }
            finally {
                this.street = null;
            }
        }
    }
}

