/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.Page;
import ru.bitel.oss.systems.inventory.resource.client.IPResourceSubcriptionPanel;
import ru.bitel.oss.systems.inventory.resource.client.InetIpCategoryTreePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class IpResourcePanel
extends BGUPanel {
    private ParamRowData paramGateway = new ParamRowData("gateway", "\u0420\u043e\u0443\u0442\u0435\u0440", "");
    private ParamRowData paramNetmask = new ParamRowData("netmask", "\u041c\u0430\u0441\u043a\u0430 \u043f\u043e\u0434\u0441\u0435\u0442\u0438", "");
    private ParamRowData paramDns = new ParamRowData("dns", "DNS", "");
    private ParamRowData paramIPv6PrefixLength = new ParamRowData("IPv6PrefixLength", "\u0414\u043b\u0438\u043d\u0430 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u0430 (IPv6)", "");
    private ParamRowData paramReserveStart = new ParamRowData("reserveStart", "\u0420\u0435\u0437\u0435\u0440\u0432. \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430", "");
    private ParamRowData paramReserveEnd = new ParamRowData("reserveEnd", "\u0420\u0435\u0437\u0435\u0440\u0432. \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430", "");
    private List<ParamRowData> params = Arrays.asList(this.paramIPv6PrefixLength, this.paramGateway, this.paramNetmask, this.paramDns, this.paramReserveStart, this.paramReserveEnd);
    private IpResourceTableModel model;
    private InetIpCategoryTreePanel categoryPanel;
    private ResourceService resourceService = null;
    AbstractBGUPanel.DefaultAction ipResourceLinkCheck = new AbstractBGUPanel.DefaultAction("ipResourceLinkCheck", "\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            String errorServs = ((ClientContext)IpResourcePanel.this.getContext()).getPort(InetServService.class).ipResourceLinkCheck();
            if (Utils.notBlankString(errorServs)) {
                ClientUtils.showErrorMessageDialog("\u041d\u0430\u0439\u0434\u0435\u043d\u044b \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043a IP-\u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c!\n" + errorServs);
            } else {
                ClientUtils.showMessageDialog("\u041e\u0448\u0438\u0431\u043e\u043a \u0432 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0435 IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
            }
        }
    };
    AbstractBGUPanel.DefaultAction ipResourceLinkSet = new AbstractBGUPanel.DefaultAction("ipResourceLinkSet", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 IP-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (BGSwingUtilites.confirm("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u043e\u043a \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043a IP-\u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c", null)) {
                ((ClientContext)IpResourcePanel.this.getContext()).getPort(InetServService.class).ipResourceLinkSet();
            }
        }
    };

    public IpResourcePanel() {
        super(new BorderLayout());
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.categoryPanel.performAction("refresh"));
        new AbstractBGUPanel.BGActionNew(e -> {
            IpCategory ipCategory = new IpCategory();
            IpCategory category = this.categoryPanel.getSelectedCategory();
            if (category != null) {
                ipCategory.setParentId(category.getId());
            }
            new IpCategoryEditorDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", ipCategory).open();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            IpCategory ipCategory = this.categoryPanel.getSelectedCategory();
            if (ipCategory == null) {
                ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                return;
            }
            new IpCategoryEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", ipCategory).open();
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            IpCategory category = this.categoryPanel.getSelectedCategory();
            if (category != null && ClientUtils.confirmDelete(category.getGuiTitle())) {
                this.getResourceService().ipCategoryDelete(category.getId());
                this.performAction("refresh");
            }
        });
    }

    @Override
    protected void jbInit() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        this.model = new IpResourceTableModel();
        BGUTable table = new BGUTable(this.model);
        IpResourceForm resourceForm = new IpResourceForm();
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        editor.addForm(resourceForm);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("table");
        panel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 3, 0), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        panel.add((Component)editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.buildToolBar(toolBar, resourceForm);
        toolBar.compact();
        BGSwingUtilites.handleEdit("resource", table, resourceForm);
        BGEditor mainEditor = new BGEditor("table");
        mainEditor.addForm(panel);
        mainEditor.addForm(new IPResourceSubcriptionPanel());
        BGSwingUtilites.buildPopupMenu(table, (Container)mainEditor, "ipResource");
        this.add((Component)new BGSplitPaneNoBorder(1, this.getLeftPanel(resourceForm), (Component)mainEditor, 400L), "Center");
        editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.categoryPanel.getTreeTable(), "enabled", "oldValue"));
        editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, table, "enabled", "oldValue"));
    }

    private JPanel getLeftPanel(IpResourceForm resourceForm) {
        this.categoryPanel = new InetIpCategoryTreePanel(e -> {
            if (e.getActionCommand().equals("ip.category.selected")) {
                resourceForm.performAction("refresh");
            } else if (e.getActionCommand().equals("ip.category.edit")) {
                this.performAction("edit");
            }
        }, true, (ClientContext)this.getContext());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.categoryPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new BGButton(this.ipResourceLinkCheck), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)new BGButton(this.ipResourceLinkSet), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = ((ClientContext)this.getContext()).getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    public class ParamRowData {
        String key;
        String title;
        String value;

        public ParamRowData(String key, String title, String value) {
            this.key = key;
            this.title = title;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class IpResourceTableModel
    extends BGTableModel<IpResource> {
        public IpResourceTableModel() {
            super(IpResourceTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d/\u0441\u0435\u0442\u044c", 200, 300, 400, null, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 150, 180, 200, null, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 300, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(IpResource val, int column) throws BGException {
            switch (column) {
                case 1: {
                    if (IPUtils.isRangeValidNet(val.getAddressFrom(), val.getAddressTo())) {
                        return IpAddress.toRFCString(val.getAddressFrom()) + "/" + IpNet.getMask(val.getAddressFrom(), val.getAddressTo());
                    }
                    return IpAddress.toString(val.getAddressFrom()) + "-" + IpAddress.toString(val.getAddressTo());
                }
                case 2: {
                    return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                }
            }
            return super.getValue(val, column);
        }
    }

    class IpResourceForm
    extends BGUPanel {
        private JPanel addressPanel;
        private BGTextField addressFrom;
        private JLabel addressDash;
        private JLabel netSlash;
        private BGTextField addressTo;
        private BGTextField mask;
        private KeyValue[] modeValues;
        private JComboBox<KeyValue> mode;
        private BGControlPanelPeriodNoB period;
        private BGConfigEditorPane config;
        private JTextArea comment;
        private IpResource current;
        private IpResourceParamTableModel ipResourceParamTableModel;

        public IpResourceForm() {
            super(new BorderLayout());
            this.modeValues = new KeyValue[]{new KeyValue("range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"), new KeyValue("net", "\u0421\u0435\u0442\u044c")};
            this.mode = new JComboBox<KeyValue>(this.modeValues);
            this.ipResourceParamTableModel = new IpResourceParamTableModel();
        }

        @Override
        protected void jbInit() {
            BGSwingUtilites.wrapBorder(this, " \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0435\u0441\u0443\u0440\u0441\u0430 ");
            this.addressFrom = new BGTextField(20);
            this.addressFrom.setHorizontalAlignment(0);
            this.addressTo = new BGTextField(20);
            this.addressTo.setHorizontalAlignment(0);
            this.config = new BGConfigEditorPane();
            this.addressDash = new JLabel("-");
            this.netSlash = new JLabel("/");
            this.mask = new BGTextField();
            this.mask.setPreferredSize(new Dimension(100, (int)this.mask.getPreferredSize().getHeight()));
            this.addressPanel = new JPanel(new GridBagLayout());
            this.addressPanel.add((Component)this.addressFrom, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.addressPanel.add((Component)this.addressDash, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.addressPanel.add((Component)this.netSlash, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.addressPanel.add((Component)this.addressTo, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.addressPanel.add((Component)this.mask, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getParamPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.config), "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f"), new GridBagConstraints(-1, 0, 1, 6, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            JTabbedPane pane = new JTabbedPane();
            pane.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", panel);
            this.comment = new JTextArea();
            pane.addTab("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", BGSwingUtilites.wrapEmptyBorder(new JScrollPane(this.comment)));
            this.add((Component)pane, "Center");
            this.mode.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.ipResourceParamTableModel.getRows().remove(IpResourcePanel.this.paramReserveStart);
                    this.ipResourceParamTableModel.getRows().remove(IpResourcePanel.this.paramReserveEnd);
                    if (e.getItem().equals(this.modeValues[0])) {
                        this.addressFrom.setColumns(20);
                        this.addressPanel.setVisible(true);
                        this.addressDash.setVisible(true);
                        this.netSlash.setVisible(false);
                        this.addressTo.setVisible(true);
                        this.mask.setVisible(false);
                    } else {
                        this.addressFrom.setColumns(0);
                        this.addressPanel.setVisible(true);
                        this.addressDash.setVisible(false);
                        this.netSlash.setVisible(true);
                        this.addressTo.setVisible(false);
                        this.mask.setVisible(true);
                        this.ipResourceParamTableModel.getRows().add(IpResourcePanel.this.paramReserveStart);
                        this.ipResourceParamTableModel.getRows().add(IpResourcePanel.this.paramReserveEnd);
                        try {
                            byte[] from = InetAddress.getByName(this.addressFrom.getText()).getAddress();
                            byte[] to = InetAddress.getByName(this.addressTo.getText()).getAddress();
                            if (IPUtils.isRangeValidNet(from, to)) {
                                this.mask.setText(String.valueOf(IpNet.getMask(from, to)));
                            } else {
                                this.mask.setText("");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.ipResourceParamTableModel.fireTableDataChanged();
                }
            });
        }

        private JPanel getParamPanel() {
            JPanel rangePanel = BGSwingUtilites.wrapBorder(new JPanel(new GridBagLayout()), "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 / \u0441\u0435\u0442\u044c");
            rangePanel.add(this.mode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            rangePanel.add((Component)this.addressPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            final BGUTable table = new BGUTable(this.ipResourceParamTableModel);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ParamRowData paramRowData;
                    int row = table.convertRowIndexToModel(table.rowAtPoint(e.getPoint()));
                    int column = table.convertColumnIndexToModel(table.columnAtPoint(e.getPoint()));
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && column == 1 && (IpResourcePanel.this.paramReserveStart == (paramRowData = (ParamRowData)IpResourceForm.this.ipResourceParamTableModel.getSelectedRow()) || IpResourcePanel.this.paramReserveEnd == paramRowData)) {
                        paramRowData.value = "true".equals(paramRowData.value) ? "false" : "true";
                        IpResourceForm.this.ipResourceParamTableModel.fireTableCellUpdated(row, column);
                    }
                }
            });
            this.ipResourceParamTableModel.setData(IpResourcePanel.this.params);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)rangePanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.period = new BGControlPanelPeriod();
            panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 0, 0, 3), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 700, 200), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 0, 0, 3), 0, 0));
            return panel;
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh(e -> {
                IpCategory category = IpResourcePanel.this.categoryPanel.getSelectedCategory();
                IpResourcePanel.this.model.setData(IpResourcePanel.this.getResourceService().ipResourceList(Collections.singleton(category != null ? category.getId() : -1)));
            });
            new AbstractBGUPanel.DefaultAction("resource.new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_add")){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    IpCategory category = IpResourcePanel.this.categoryPanel.getSelectedCategory();
                    if (category == null || category.getId() <= 0) {
                        return;
                    }
                    IpResourceForm.this.current = IpResource.builder().setCategoryId(category.getId()).build();
                    IpResourceForm.this.addressFrom.setText("");
                    IpResourceForm.this.addressTo.setText("");
                    IpResourcePanel.this.paramIPv6PrefixLength.setValue("");
                    IpResourcePanel.this.paramGateway.setValue("");
                    IpResourcePanel.this.paramNetmask.setValue("");
                    IpResourcePanel.this.paramDns.setValue("");
                    IpResourcePanel.this.paramReserveStart.setValue("false");
                    IpResourcePanel.this.paramReserveEnd.setValue("false");
                    IpResourceForm.this.config.setText("");
                    IpResourceForm.this.period.setDateString1("");
                    IpResourceForm.this.period.setDateString2("");
                    IpResourceForm.this.comment.setText("");
                    IpResourceForm.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("resource.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("item_edit")){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    IpResourceForm.this.current = (IpResource)IpResourcePanel.this.model.getSelectedRow();
                    if (IpResourceForm.this.current != null) {
                        IpResourceForm.this.addressPanel.setEnabled(false);
                        IpResourceForm.this.addressFrom.setText(IpAddress.toRFCString(IpResourceForm.this.current.getAddressFrom()));
                        IpResourceForm.this.addressTo.setText(IpAddress.toRFCString(IpResourceForm.this.current.getAddressTo()));
                        IpResourcePanel.this.paramIPv6PrefixLength.setValue(IpResourceForm.this.current.getPrefixLength() > 0 ? String.valueOf(IpResourceForm.this.current.getPrefixLength()) : "");
                        IpResourcePanel.this.paramGateway.setValue(IpResourceForm.this.current.getRouter());
                        IpResourcePanel.this.paramNetmask.setValue(IpResourceForm.this.current.getSubnetMask());
                        IpResourcePanel.this.paramDns.setValue(IpResourceForm.this.current.getDns());
                        IpResourcePanel.this.paramReserveStart.setValue(String.valueOf(IpResourceForm.this.current.isReserveStart()));
                        IpResourcePanel.this.paramReserveEnd.setValue(String.valueOf(IpResourceForm.this.current.isReserveEnd()));
                        IpResourceForm.this.config.setText(IpResourceForm.this.current.getConfig());
                        IpResourceForm.this.period.setDateCalendar1(TimeUtils.convertDateToCalendar(IpResourceForm.this.current.getDateFrom()));
                        IpResourceForm.this.period.setDateCalendar2(TimeUtils.convertDateToCalendar(IpResourceForm.this.current.getDateTo()));
                        IpResourceForm.this.comment.setText(IpResourceForm.this.current.getComment());
                        if (IPUtils.isRangeValidNet(IpResourceForm.this.current.getAddressFrom(), IpResourceForm.this.current.getAddressTo())) {
                            IpResourceForm.this.mode.setSelectedItem(IpResourceForm.this.modeValues[1]);
                        } else {
                            IpResourceForm.this.mode.setSelectedItem(IpResourceForm.this.modeValues[0]);
                        }
                        IpResourceForm.this.performActionOpen();
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    try {
                        IpResourceForm.this.current.setAddressFrom(InetAddress.getByName(IpResourceForm.this.addressFrom.getText()).getAddress());
                        if (IpResourceForm.this.mode.getSelectedItem().equals(IpResourceForm.this.modeValues[0])) {
                            IpResourceForm.this.current.setAddressTo(InetAddress.getByName(IpResourceForm.this.addressTo.getText()).getAddress());
                        } else {
                            IpNet net = new IpNet(IpResourceForm.this.current.getAddressFrom(), Utils.parseInt(IpResourceForm.this.mask.getText(), IpResourceForm.this.current.getAddressFrom().length * 8));
                            IpResourceForm.this.current.setAddressTo(net.getBroadcast());
                        }
                        IpResourceForm.this.current.setDateFrom(IpResourceForm.this.period.getDateFrom());
                        IpResourceForm.this.current.setDateTo(IpResourceForm.this.period.getDateTo());
                        IpResourceForm.this.current.setRouter(IpResourcePanel.this.paramGateway.getValue());
                        IpResourceForm.this.current.setSubnetMask(IpResourcePanel.this.paramNetmask.getValue());
                        IpResourceForm.this.current.setDns(IpResourcePanel.this.paramDns.getValue());
                        IpResourceForm.this.current.setReserveStart(Boolean.valueOf(IpResourcePanel.this.paramReserveStart.getValue()).booleanValue());
                        IpResourceForm.this.current.setReserveEnd(Boolean.valueOf(IpResourcePanel.this.paramReserveEnd.getValue()).booleanValue());
                        IpResourceForm.this.current.setConfig(IpResourceForm.this.config.getText());
                        IpResourceForm.this.current.setComment(IpResourceForm.this.comment.getText());
                        IpResourceForm.this.current.setPrefixLength((short)Utils.parseInt(IpResourcePanel.this.paramIPv6PrefixLength.getValue(), 0));
                        if (IpResourceForm.this.current.getId() > 0 && IpResourcePanel.this.getResourceService().ipSubscriptionList(IpResourceForm.this.current.getId(), null, null, new Page(1, 1)).getList().size() > 0) {
                            if (!BGSwingUtilites.confirm("\u041d\u0430 IP-\u0440\u0435\u0441\u0443\u0440\u0441 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c", null)) {
                                return;
                            }
                            int id = IpResourcePanel.this.getResourceService().ipResourceUpdate(IpResourceForm.this.current, true);
                            IpResourceForm.this.performAction("refresh");
                            IpResourcePanel.this.model.setSelectedRow(id);
                            IpResourceForm.this.performActionClose();
                            IpResourcePanel.this.ipResourceLinkCheck.actionPerformed(e);
                        } else {
                            int id = IpResourcePanel.this.getResourceService().ipResourceUpdate(IpResourceForm.this.current, true);
                            IpResourceForm.this.performAction("refresh");
                            IpResourcePanel.this.model.setSelectedRow(id);
                            IpResourceForm.this.performActionClose();
                        }
                    }
                    catch (UnknownHostException ex) {
                        throw new BGException(ex);
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("resource.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("item_delete")){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    IpResource resource = (IpResource)IpResourcePanel.this.model.getSelectedRow();
                    if (resource == null || !BGSwingUtilites.confirmDelete("IP-\u0440\u0435\u0441\u0443\u0440\u0441", resource)) {
                        return;
                    }
                    if (IpResourcePanel.this.getResourceService().ipSubscriptionList(resource.getId(), null, null, new Page(1, 1)).getList().size() > 0 && !BGSwingUtilites.confirm("\u041d\u0430 IP-\u0440\u0435\u0441\u0443\u0440\u0441 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c", null)) {
                        return;
                    }
                    IpResourcePanel.this.getResourceService().ipResourceDelete(resource.getId(), true);
                    IpResourceForm.this.performAction("refresh");
                    IpResourceForm.this.performActionClose();
                    IpResourcePanel.this.ipResourceLinkCheck.actionPerformed(e);
                }
            };
        }
    }

    class IpCategoryEditorDialog
    extends BGEditorDialog<IpCategory> {
        private BGTextField title;
        private BGTextField comment;

        public IpCategoryEditorDialog(String title, IpCategory data) {
            super(title, data);
            this.title = new BGTextField(30);
            this.comment = new BGTextField(30);
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.title.setText(((IpCategory)this.data).getTitle());
            this.comment.setText(((IpCategory)this.data).getComment());
        }

        @Override
        public boolean doApply() throws Exception {
            ((IpCategory)this.data).setTitle(this.title.getText());
            ((IpCategory)this.data).setComment(this.comment.getText());
            try {
                int id = IpResourcePanel.this.getResourceService().ipCategoryUpdate((IpCategory)this.data);
                IpResourcePanel.this.performAction("refresh");
                IpResourcePanel.this.categoryPanel.getTreeModel().setSelectedRow(id);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
                return false;
            }
            return true;
        }
    }

    class IpResourceParamTableCellRenderer
    extends DefaultTableCellRenderer {
        IpResourceParamTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                Boolean val = (Boolean)value;
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(val);
                Color fg = null;
                Color bg = null;
                if (isSelected) {
                    checkBox.setForeground(fg == null ? table.getSelectionForeground() : fg);
                    checkBox.setBackground(bg == null ? table.getSelectionBackground() : bg);
                } else {
                    checkBox.setForeground(table.getForeground());
                    checkBox.setBackground(table.getBackground());
                }
                return checkBox;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class IpResourceParamTableModel
    extends BGTableModel<ParamRowData> {
        public IpResourceParamTableModel() {
            super(IpResourceParamTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 400, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 400, -1, "value", false, new IpResourceParamTableCellRenderer());
        }

        @Override
        public Object getValue(ParamRowData paramRowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("value".equals(identifier) && (paramRowData == IpResourcePanel.this.paramReserveStart || paramRowData == IpResourcePanel.this.paramReserveEnd)) {
                return Boolean.valueOf(paramRowData.getValue());
            }
            return super.getValue(paramRowData, column);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ParamRowData paramRowData = (ParamRowData)this.getRows().get(this.table.convertRowIndexToModel(rowIndex));
            if ("value".equals(this.getIdentifier(columnIndex))) {
                paramRowData.setValue(String.valueOf(value));
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParamRowData paramRowData = (ParamRowData)this.getRows().get(rowIndex);
            return columnIndex == 1 && paramRowData != IpResourcePanel.this.paramReserveEnd && paramRowData != IpResourcePanel.this.paramReserveStart;
        }
    }
}

