/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.modules.tv.common.service.TvService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecActivationModePanel;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecPanel;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecServiceLinkPanel;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

class ProductSpecForm
extends BGUPanel {
    private final ProductSpecPanel productSpecPanel;
    private JTabbedPane pane;
    private List<BGUPanel> panels;
    private AtomicReference<ProductSpec> currentRef = new AtomicReference();
    private JLabel productCostLabel = new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:");
    private JLabel priorityLabel = new JLabel("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442:");
    private JLabel realtimeLabel = new JLabel("\u041f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435:");
    private JLabel npayServiceLabel = new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430 \u043c\u043e\u0434\u0443\u043b\u044f \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442:");
    private JTextArea comment = new JTextArea();
    private JTextArea description = new JTextArea();
    private BGTextField title = new BGTextField();
    private BGTextField identifier = new BGTextField();
    private BGTextField productCost = new BGTextField();
    private IntTextField priority = new IntTextField();
    private BGUComboBox<IdTitle> periodic = new BGUComboBox();
    private BGUComboBox<IdTitle> realtime = new BGUComboBox();
    private BGUComboBox<IdTitle> mode = new BGUComboBox();
    private BGUComboBox<IdTitle> npayService = new BGUComboBox();
    private BGUComboBox<IdTitle> activationByCustomerGroup = new BGUComboBox();
    private BGUComboBox<IdTitle> deactivationByCustomerGroup = new BGUComboBox();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGControlPanelListSelect tariffPlans;
    private ContractLabelTree contractLabels;
    private DepensTableModel depensTableModel;
    private JPopupMenu depensPopupMenu;
    private List<String[]> incompatibleItems;
    private JCheckBox hide;
    private JRadioButton hideForGroupsModeOr;
    private JRadioButton hideForGroupsModeAnd;
    private ContractLabelTree hideForContractLabels;
    private ProductSpecActivationModePanel activationModePanel;
    private ProductSpecServiceLinkPanel serviceLinkPanel;
    private List<IdTitle> onOffItems = Arrays.asList(new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e"), new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e"));
    private List<IdTitle> modeItems = Arrays.asList(new IdTitle(0, "\u0431\u0430\u0437\u043e\u0432\u044b\u0439"), new IdTitle(1, "\u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044f \u0441 \u043c\u043e\u0434\u0443\u043b\u0435\u043c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442"));
    private List<IdTitle> periodicItems = Arrays.asList(new IdTitle(1, "\u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439"), new IdTitle(0, "\u0435\u0434\u0438\u043d\u043e\u0440\u0430\u0437\u043e\u0432\u044b\u0439"));
    private List<IdTitle> realtimeItems = Arrays.asList(new IdTitle(0, "\u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438"), new IdTitle(1, "\u043f\u043e \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0443"));
    final Set<Integer> cutSet = new HashSet<Integer>();
    final Set<Integer> copySet = new HashSet<Integer>();
    AbstractBGUPanel.MenuAction copy = new AbstractBGUPanel.MenuAction("ProductSpec.copy", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("copy")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecForm.this.copySet.clear();
            ProductSpecForm.this.cutSet.clear();
            List selectedRows = ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            for (ProductSpec d : selectedRows) {
                ProductSpecForm.this.copySet.add(d.getId());
            }
        }
    };
    AbstractBGUPanel.MenuAction cut = new AbstractBGUPanel.MenuAction("ProductSpec.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("cut")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecForm.this.copySet.clear();
            ProductSpecForm.this.cutSet.clear();
            List selectedRows = ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRows();
            if (selectedRows == null) {
                return;
            }
            for (ProductSpec d : selectedRows) {
                ProductSpecForm.this.cutSet.add(d.getId());
            }
        }
    };
    AbstractBGUPanel.MenuAction paste = new AbstractBGUPanel.MenuAction("ProductSpec.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("paste")){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpec parent = (ProductSpec)ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
            if (parent != null) {
                ProductService productService = ((ClientContext)ProductSpecForm.this.getContext()).getPort(ProductService.class, 0);
                if (ProductSpecForm.this.copySet.size() > 0) {
                    for (Integer productSpecId : ProductSpecForm.this.copySet) {
                        ProductSpec productSpec = productService.productSpecGet(productSpecId.intValue());
                        productSpec.setParentId(parent.getId());
                        productSpec.setId(0);
                        for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                            activationMode.setId(0);
                        }
                        int newProductSpecId = productService.productSpecUpdate(productSpec);
                        List serviceLinkList = productService.serviceLinkList(productSpecId.intValue(), null);
                        for (ProductSpecServiceLink link : serviceLinkList) {
                            link.setId(0);
                        }
                        productService.serviceLinkUpdate(newProductSpecId, serviceLinkList);
                    }
                    ProductSpecForm.this.productSpecPanel.performAction("refresh");
                } else if (ProductSpecForm.this.cutSet.size() > 0) {
                    productService.productSpecMove(parent.getId(), ProductSpecForm.this.cutSet);
                    ProductSpecForm.this.cutSet.clear();
                    ProductSpecForm.this.productSpecPanel.performAction("refresh");
                }
            }
        }
    };

    public ProductSpecForm(ProductSpecPanel productSpecPanel, ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.productSpecPanel = productSpecPanel;
        this.setName("ProductSpecForm");
    }

    @Override
    protected void jbInit() throws Exception {
        BGSwingUtilites.wrapBorder(this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 5), 0, 0));
        titlePanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 10, 0), 0, 0));
        this.pane = new JTabbedPane();
        this.panels = new ArrayList<BGUPanel>();
        this.pane.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getBasePanel());
        EntityAttributesForm bguPanel = new EntityAttributesForm(this.currentRef, (ClientContext)this.getContext());
        this.pane.addTab("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b", bguPanel);
        this.panels.add(bguPanel);
        this.serviceLinkPanel = new ProductSpecServiceLinkPanel(this, this.currentRef);
        this.pane.addTab("\u0421\u0435\u0440\u0432\u0438\u0441\u044b", this.serviceLinkPanel);
        this.panels.add(this.serviceLinkPanel);
        this.activationModePanel = new ProductSpecActivationModePanel();
        this.pane.addTab("\u0420\u0435\u0436\u0438\u043c\u044b \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", this.activationModePanel);
        this.tariffPlans = new BGControlPanelListSelect(0);
        this.contractLabels = new ContractLabelTree((ClientContext)this.getContext());
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b", this.tariffPlans);
        tabPane.addTab("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", this.contractLabels);
        JPanel availablePanel = new JPanel(new GridLayout(0, 2));
        this.tariffPlans.setBorder(new BGTitleBorder("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b:"));
        availablePanel.add(this.tariffPlans);
        this.contractLabels.setBorder(new BGTitleBorder("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:"));
        availablePanel.add(new JScrollPane(this.contractLabels));
        this.pane.addTab("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u044c", availablePanel);
        this.pane.addTab("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", this.getDependPanel());
        this.hide = new JCheckBox("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435");
        this.hideForGroupsModeOr = new JRadioButton("\u0418\u041b\u0418");
        this.hideForGroupsModeAnd = new JRadioButton("\u0418");
        this.hideForContractLabels = new ContractLabelTree((ClientContext)this.getContext());
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel hideForGroups = new JPanel(new GridBagLayout());
        panel.add((Component)this.hide, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        hideForGroups.setBorder(BorderFactory.createTitledBorder("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"));
        panel.add((Component)hideForGroups, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        hideForGroups.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 5), 0, 0));
        hideForGroups.add((Component)this.hideForGroupsModeOr, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
        hideForGroups.add((Component)this.hideForGroupsModeAnd, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
        hideForGroups.add((Component)new JScrollPane(this.hideForContractLabels), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.hideForGroupsModeOr);
        group.add(this.hideForGroupsModeAnd);
        this.pane.addTab("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c", panel);
        this.incompatibleItems = this.productSpecPanel.getProductService().getIncompatibleItems(((ClientContext)this.getContext()).getModuleId());
        this.add((Component)this.pane, "Center");
        this.add((Component)titlePanel, "North");
    }

    private JPanel getBasePanel() {
        this.identifier.setHorizontalAlignment(0);
        this.productCost.setHorizontalAlignment(0);
        this.priority.setMaxValue(999999999L);
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setMargin(new Insets(3, 3, 3, 3));
        this.periodic.setData(this.periodicItems);
        this.realtime.setData(this.realtimeItems);
        this.mode.setData(this.modeItems);
        this.mode.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setVisible();
            }
        });
        this.activationByCustomerGroup.setData(this.onOffItems);
        this.deactivationByCustomerGroup.setData(this.onOffItems);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.mode, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.periodic, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.realtimeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.realtime, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.activationByCustomerGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.deactivationByCustomerGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.npayServiceLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add(this.npayService, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.identifier, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.priorityLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.priority, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.productCostLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 3, 0, 5), 0, 0));
        leftPanel.add((Component)this.productCost, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapEmptyBorder(leftPanel);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane(this.description), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapEmptyBorder(rightPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new BGSplitPaneNoBorder(1, leftPanel, (Component)rightPanel, 800L), "Center");
        return panel;
    }

    private JPanel getDependPanel() {
        this.depensTableModel = new DepensTableModel(DepensTableModel.class.getName());
        final BGUTable dependsTable = new BGUTable(this.depensTableModel);
        dependsTable.setSelectionMode(0);
        dependsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int column;
                if (mouseEvent.getClickCount() == 2 && (column = dependsTable.convertColumnIndexToModel(dependsTable.columnAtPoint(mouseEvent.getPoint()))) < 2) {
                    JSONObject json = ((RowData)ProductSpecForm.this.depensTableModel.getSelectedRow()).getJson();
                    if (column == 1) {
                        Rectangle cell = dependsTable.getCellRect(dependsTable.rowAtPoint(mouseEvent.getPoint()), dependsTable.columnAtPoint(mouseEvent.getPoint()), true);
                        ProductSpecForm.this.getDepensPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX() - 50, cell.y + cell.height);
                    } else {
                        String key = column == 0 ? "d" : "i";
                        json.put(key, !json.getBoolean(key));
                    }
                    dependsTable.repaint();
                }
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(dependsTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPopupMenu getDepensPopupMenu() {
        if (this.depensPopupMenu == null) {
            this.depensPopupMenu = new JPopupMenu();
            ActionListener actionListener = e -> {
                JSONObject json = ((RowData)this.depensTableModel.getSelectedRow()).getJson();
                json.put("i", (Object)e.getActionCommand());
            };
            for (String[] item : this.incompatibleItems) {
                JMenuItem menuItem = new JMenuItem();
                menuItem.setActionCommand(item[0]);
                menuItem.setText(item[1]);
                menuItem.addActionListener(actionListener);
                this.depensPopupMenu.add(menuItem);
            }
            JMenuItem menuItem = new JMenuItem();
            menuItem.setActionCommand("");
            menuItem.setText("<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e>");
            menuItem.addActionListener(actionListener);
            this.depensPopupMenu.add(menuItem);
        }
        return this.depensPopupMenu;
    }

    private void setVisible() {
        boolean visible = ((IdTitle)this.mode.getSelectedItem()).getId() == 0;
        this.priorityLabel.setVisible(visible);
        this.priority.setVisible(visible);
        this.realtimeLabel.setVisible(visible);
        this.realtime.setVisible(visible);
        this.productCostLabel.setVisible(visible);
        this.productCost.setVisible(visible);
        this.npayServiceLabel.setVisible(!visible);
        this.npayService.setVisible(!visible);
    }

    private void initTariffPlansList() {
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("ListTariffPlans");
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.tariffPlans.getList(), this.tariffPlans.getListModel(), XMLUtils.selectNode(doc, "//tariffPlans"));
        }
    }

    private void getDependRowData(List<RowData> rowDatas, ProductSpec productSpec, Set<Integer> depenIds, Set<Integer> incompIds, JSONObject incompData, int level) {
        JSONObject json = new JSONObject();
        json.put("id", productSpec.getId());
        json.put("title", (Object)(String.join((CharSequence)"", Collections.nCopies(level, "     ")) + productSpec.getTitle()));
        json.put("d", depenIds != null ? depenIds.contains(productSpec.getId()) : false);
        String value = "";
        if (incompIds != null && !incompIds.isEmpty()) {
            value = String.valueOf(incompIds.contains(productSpec.getId()));
        } else if (incompData != null && !incompData.keySet().isEmpty()) {
            value = incompData.optString(String.valueOf(productSpec.getId()), "");
        }
        json.put("i", (Object)value);
        rowDatas.add(new RowData(json));
        if (productSpec.getChildren() != null) {
            for (ProductSpec productSpecChild : productSpec.getChildren()) {
                this.getDependRowData(rowDatas, productSpecChild, depenIds, incompIds, incompData, level + 1);
            }
        }
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> {
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442.");
                return;
            }
            this.initNpayService();
            this.initTariffPlansList();
            ProductSpec parent = (ProductSpec)this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
            ProductSpec current = ProductSpec.builder().setId(-1).setEntitySpecId(this.productSpecPanel.getEntitySpecId()).setEntityAttributes(new HashMap()).setParentId(parent != null ? parent.getId() : 0).build();
            this.mode.setSelectedItem(this.modeItems.get(0));
            this.title.setText("");
            this.identifier.setText("");
            this.productCost.setText(Utils.formatCost(BigDecimal.ZERO));
            this.periodic.setSelectedItem(1);
            this.realtime.setSelectedItem(0);
            this.priority.setValue(0L);
            this.period.setDateCalendar1(null);
            this.period.setDateCalendar2(null);
            this.activationByCustomerGroup.setSelectedIndex(0);
            this.deactivationByCustomerGroup.setSelectedIndex(0);
            this.comment.setText("");
            this.description.setText("");
            this.tariffPlans.setListValues("");
            this.contractLabels.loadLabels(((ClientContext)this.getContext()).getWebService(ContractLabelService.class, 0));
            this.contractLabels.setSelectedIds(Collections.emptyList());
            ProductSpec root = this.productSpecPanel.getProductService().productSpecRoot(Integer.valueOf(((ClientContext)this.getContext()).getModuleId()), null, null, null, null);
            ArrayList<RowData> rowDatas = new ArrayList<RowData>();
            this.getDependRowData(rowDatas, root, current.getDepends(), current.getIncompatible(), new JSONObject(current.getData()).optJSONObject("incompatible"), 0);
            this.depensTableModel.setData(rowDatas);
            this.hide.setSelected(false);
            this.hideForGroupsModeOr.setSelected(true);
            this.hideForContractLabels.loadLabels(((ClientContext)this.getContext()).getWebService(ContractLabelService.class, 0));
            this.hideForContractLabels.setSelectedIds(Collections.emptyList());
            ProductSpecActivationMode defaultActivationMode = ProductSpecActivationMode.builder().setDateFrom(new Date()).setPeriodAmount(0).setPeriodMode(111).setDeactivationMode(10).setReactivationMode(0).setTitle("").build();
            ArrayList<ProductSpecActivationMode> activationModeList = new ArrayList<ProductSpecActivationMode>();
            activationModeList.add(defaultActivationMode);
            this.activationModePanel.setData(activationModeList);
            this.setVisible();
            this.currentRef.set(current);
            for (BGUPanel panel : this.panels) {
                panel.performAction("new");
            }
            this.performActionOpen();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442");
                return;
            }
            if (this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow() != this.productSpecPanel.getProductSpecTreeTableModel().getRoot()) {
                ProductSpec current = (ProductSpec)this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
                current = this.productSpecPanel.getProductService().productSpecGet(current.getId());
                if (current != null) {
                    this.initNpayService();
                    this.initTariffPlansList();
                    JSONObject data = new JSONObject(current.getData());
                    int modeId = data.optInt("modeId", 0);
                    int npayServiceId = data.optInt("npayServiceId", -1);
                    this.title.setText(current.getTitle());
                    this.mode.setSelectedItem(this.modeItems.stream().filter(a -> a.getId() == modeId).findFirst().orElse(this.modeItems.get(0)));
                    this.identifier.setText(current.getIdentifier());
                    this.productCost.setText(Utils.formatCost(data.optBigDecimal("cost", BigDecimal.ZERO)));
                    this.npayService.setSelectedItem(this.npayService.getData().stream().filter(a -> a.getId() == npayServiceId).findFirst().orElse(this.npayService.getData().get(0)));
                    this.periodic.setSelectedItem(current.isPeriodic() ? 1 : 0);
                    this.realtime.setSelectedItem(current.isNotRealtime() ? 1 : 0);
                    this.priority.setValue(current.getPriority());
                    this.period.setDateCalendar1(TimeUtils.convertDateToCalendar(current.getDateFrom()));
                    this.period.setDateCalendar2(TimeUtils.convertDateToCalendar(current.getDateTo()));
                    int activationByCustomerId = current.isActivationByCustomer() ? 1 : 0;
                    this.activationByCustomerGroup.setSelectedItem(this.onOffItems.stream().filter(a -> a.getId() == activationByCustomerId).findAny().orElse(this.onOffItems.get(0)));
                    int deactivationByCustomerId = current.isDeactivationByCustomer() ? 1 : 0;
                    this.deactivationByCustomerGroup.setSelectedItem(this.onOffItems.stream().filter(a -> a.getId() == deactivationByCustomerId).findAny().orElse(this.onOffItems.get(0)));
                    this.comment.setText(current.getComment());
                    this.description.setText(current.getDescription());
                    this.tariffPlans.setListValues(Utils.toString(current.getTariffIds()));
                    this.contractLabels.setSelectedIds(current.getContractLabels());
                    ProductSpec root = this.productSpecPanel.getProductService().productSpecRoot(Integer.valueOf(((ClientContext)this.getContext()).getModuleId()), null, null, null, null);
                    ArrayList<RowData> rowDatas = new ArrayList<RowData>();
                    this.getDependRowData(rowDatas, root, current.getDepends(), current.getIncompatible(), data.optJSONObject("incompatible"), 0);
                    this.depensTableModel.setData(rowDatas);
                    this.hide.setSelected(current.isHideForCustomer());
                    if (current.getHideForContractGroupsMode() == 0) {
                        this.hideForGroupsModeOr.setSelected(true);
                    } else {
                        this.hideForGroupsModeAnd.setSelected(true);
                    }
                    this.hideForContractLabels.setSelectedIds(current.getHideForContractLabels());
                    this.activationModePanel.setData(current.getActivationModeList());
                    current.setEntitySpecId(this.productSpecPanel.getEntitySpecId());
                }
                this.setVisible();
                this.currentRef.set(current);
                for (BGUPanel panel : this.panels) {
                    panel.performAction("edit");
                }
                this.performActionOpen();
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (!this.isEnabled()) {
                ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                return;
            }
            if (this.isShowing()) {
                ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442");
                return;
            }
            ProductSpec selected = (ProductSpec)this.productSpecPanel.getProductSpecTreeTableModel().getSelectedRow();
            if (selected == null || selected == this.productSpecPanel.getProductSpecTreeTableModel().getRoot()) {
                ClientUtils.showMessageDialog("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
                return;
            }
            if (selected.getChildren() != null) {
                ClientUtils.showErrorMessageDialog("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0440\u043e\u0434\u0443\u043a\u0442?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                this.productSpecPanel.getProductService().productSpecDelete(selected.getId());
                this.productSpecPanel.getProductSpecTreeTableModel().setSelectedRow(selected.getParentId());
                this.productSpecPanel.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                BigDecimal cost = BigDecimal.ZERO;
                try {
                    cost = new BigDecimal(ProductSpecForm.this.productCost.getText());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                    return;
                }
                int modeId = ((IdTitle)ProductSpecForm.this.mode.getSelectedItem()).getId();
                JSONObject data = new JSONObject(ProductSpecForm.this.currentRef.get().getData());
                data.put("incompatible", (Object)ProductSpecForm.this.depensTableModel.getIncompatibleData());
                data.put("cost", (Object)cost);
                data.put("modeId", modeId);
                if (modeId == 1) {
                    IdTitle npayServiceItem = (IdTitle)ProductSpecForm.this.npayService.getSelectedItem();
                    if (npayServiceItem == null || npayServiceItem.getId() == 0) {
                        ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0430 \u043c\u043e\u0434\u0443\u043b\u044f \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442");
                        return;
                    }
                    data.put("npayServiceId", npayServiceItem.getId());
                } else {
                    data.remove("npayServiceId");
                }
                JSONArray activationModes = new JSONArray();
                for (ProductSpecActivationMode activationMode : ProductSpecForm.this.activationModePanel.getData()) {
                    JSONObject modeItem = new JSONObject();
                    modeItem.put("modeId", activationMode.getId());
                    modeItem.put("dateFrom", (Object)TimeUtils.format(activationMode.getDateFrom(), "dd.MM.yyyy"));
                    modeItem.put("dateTo", (Object)TimeUtils.format(activationMode.getDateTo(), "dd.MM.yyyy"));
                    activationModes.put((Object)modeItem);
                }
                data.put("activationModes", (Object)activationModes);
                ProductSpec.builder((ProductSpec)ProductSpecForm.this.currentRef.get()).setModuleId(((ClientContext)ProductSpecForm.this.getContext()).getModuleId()).setTitle(ProductSpecForm.this.title.getText()).setIdentifier(ProductSpecForm.this.identifier.getText()).setPeriodic(((IdTitle)ProductSpecForm.this.periodic.getSelectedItem()).getId() == 1).setNotRealtime(((IdTitle)ProductSpecForm.this.realtime.getSelectedItem()).getId() == 1).setPriority((int)ProductSpecForm.this.priority.getValue()).setDateFrom(TimeUtils.convertCalendarToDate(ProductSpecForm.this.period.getDateCalendar1())).setDateTo(TimeUtils.convertCalendarToDate(ProductSpecForm.this.period.getDateCalendar2())).setActivationByCustomer(((IdTitle)ProductSpecForm.this.activationByCustomerGroup.getSelectedItem()).getId() == 1).setDeactivationByCustomer(((IdTitle)ProductSpecForm.this.deactivationByCustomerGroup.getSelectedItem()).getId() == 1).setComment(ProductSpecForm.this.comment.getText()).setDescription(ProductSpecForm.this.description.getText()).setTariffIds(Utils.toIntegerSet(ProductSpecForm.this.tariffPlans.getListValues())).setContractLabels(new HashSet<Integer>(ProductSpecForm.this.contractLabels.getSelectedIds())).setDepends(ProductSpecForm.this.depensTableModel.getDependIds()).setIncompatible(ProductSpecForm.this.depensTableModel.getIncompatibleIds()).setData(data.toString()).setHideForCustomer(ProductSpecForm.this.hide.isSelected()).setHideForContractGroupsMode(ProductSpecForm.this.hideForGroupsModeAnd.isSelected() ? 1 : 0).setHideForContractLabels(new HashSet<Integer>(ProductSpecForm.this.hideForContractLabels.getSelectedIds())).setActivationModeList(ProductSpecForm.this.activationModePanel.getData());
                for (BGUPanel panel : ProductSpecForm.this.panels) {
                    if (panel.performAction("ok")) continue;
                    return;
                }
                int id = ProductSpecForm.this.productSpecPanel.getProductService().productSpecUpdate(ProductSpecForm.this.currentRef.get());
                ProductSpecForm.this.productSpecPanel.performAction("refresh");
                ProductSpecForm.this.productSpecPanel.getProductSpecTreeTableModel().setSelectedRow(id);
                ProductSpecForm.this.performActionClose();
            }
        };
    }

    private void initNpayService() {
        try {
            List data = ((ClientContext)this.getContext()).getWebService(TvService.class).npayServiceList();
            data.add(0, new IdTitle(0, "---"));
            this.npayService.setData(data);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    class DepensTableModel
    extends BGTableModel<RowData> {
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_D = "d";
        public static final String COLUMN_I = "i";

        public DepensTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", 120, 200, 250, COLUMN_D, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c", 120, 300, 400, COLUMN_I, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", 200, 400, -1, COLUMN_TITLE, true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            String i;
            JSONObject json = rowData.getJson();
            switch (i = this.getIdentifier(column)) {
                case "title": {
                    return json.optString(i);
                }
                case "d": {
                    return json.optBoolean(i) ? "\u0437\u0430\u0432\u0438\u0441\u0438\u0442" : "\u043d\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u0442";
                }
                case "i": {
                    String val = json.optString(COLUMN_I, "");
                    for (String[] item : ProductSpecForm.this.incompatibleItems) {
                        if (val.equals(item[0])) {
                            return item[1];
                        }
                        if ("true".equals(val)) {
                            return "\u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c";
                        }
                        if (!"false".equals(val)) continue;
                        return "\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c";
                    }
                    return val;
                }
            }
            return super.getValueAt(rowData, column);
        }

        public Set<Integer> getDependIds() {
            return this.getIds(COLUMN_D);
        }

        public Set<Integer> getIncompatibleIds() {
            return this.getIds(COLUMN_I);
        }

        public JSONObject getIncompatibleData() {
            JSONObject incompatibleData = new JSONObject();
            for (RowData rowData : this.getRows()) {
                String val = rowData.getJson().optString(COLUMN_I, "false");
                if ("true".equals(val) || "false".equals(val) || "".equals(val)) continue;
                incompatibleData.put(String.valueOf(rowData.getJson().getInt("id")), (Object)val);
            }
            return incompatibleData;
        }

        private Set<Integer> getIds(String key) {
            HashSet<Integer> ids = new HashSet<Integer>();
            for (RowData rowData : this.getRows()) {
                if (!"true".equals(rowData.getJson().optString(key, "false"))) continue;
                ids.add(rowData.getJson().getInt("id"));
            }
            return ids;
        }
    }
}

