/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.client.table.EntityAttributesTable;
import ru.bitel.oss.kernel.entity.client.table.EntityAttributesTableModel;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntityAttributesForm
extends BGUPanel {
    private EntityAttributesTable table;
    private EntityAttributesTableModel model;
    private final AtomicReference<? extends Entity> currentRef;

    public EntityAttributesForm(AtomicReference<? extends Entity> currentRef, ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
        this.currentRef = currentRef;
        this.model = new EntityAttributesTableModel(context);
    }

    @Override
    protected void jbInit() {
        this.table = new EntityAttributesTable(this.model, () -> (ClientContext)this.getContext());
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setSelectionMode(0);
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.addHierarchyListener(e -> {
            if (e.getChanged() == this && e.getChangeFlags() == 4L && this.isVisible()) {
                this.refresh();
            }
        });
        BGSwingUtilites.handleEdit(this.table, this, "attribute.edit");
    }

    public void reset() {
        this.model.setData(new ArrayList());
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> this.refresh());
        new AbstractBGUPanel.BGActionEdit(e -> {
            Entity entity;
            this.model.setData(entity, (entity = this.currentRef.get()) != null ? ((ClientContext)this.getContext()).getPort(EntityService.class, 0).entitySpecGet(entity.getEntitySpecId()) : null);
        });
        new AbstractBGUPanel.DefaultAction("ok", "Ok"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                HashMap entityAttributes = new HashMap();
                EntityAttributesForm.this.model.getRows().stream().map(a -> a.getAttr()).filter(a -> a != null).forEach(a -> entityAttributes.put(a.getEntitySpecAttrId(), a));
                if (EntityAttributesForm.this.currentRef.get() != null) {
                    EntityAttributesForm.this.currentRef.get().setEntityAttributes(entityAttributes);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("attribute.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                AbstractSpecAttr sa;
                EntityAttrEntry entityAttrEntry = (EntityAttrEntry)EntityAttributesForm.this.model.getSelectedRow();
                if (entityAttrEntry != null && (sa = entityAttrEntry.getSpecAttr()) != null && sa.getType() == EntitySpecAttrType.ADDRESS.getCode()) {
                    ContractParamEditorData data = new ContractParamEditorData();
                    data.setClientContext((ClientContext)EntityAttributesForm.this.getContext());
                    data.setContractId(entityAttrEntry.getEntity().getId());
                    data.setParameterId(sa.getId());
                    data.setParameterTitle(entityAttrEntry.getTitle());
                    data.setEntityType(EntityType.ATTRIBUTE_PARAMETER);
                    data.setValue(entityAttrEntry.attr);
                    new ContractParamAddressEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \u0442\u0438\u043f\u0430 \"\u0410\u0434\u0440\u0435\u0441\"", data).open();
                    entityAttrEntry.setAttr(data.getValue());
                    EntityAttributesForm.this.model.fireTableDataChanged();
                }
            }
        };
    }

    public void refresh() {
        if (this.currentRef.get() == null) {
            return;
        }
        new SwingWorker<EntitySpec, Void>(){

            @Override
            protected EntitySpec doInBackground() throws Exception {
                return ((ClientContext)EntityAttributesForm.this.getContext()).getPort(EntityService.class, 0).entitySpecGet(EntityAttributesForm.this.currentRef.get().getEntitySpecId());
            }

            @Override
            protected void done() {
                try {
                    if (EntityAttributesForm.this.model.getRows().size() == 0) {
                        EntityAttributesForm.this.model.setData(EntityAttributesForm.this.currentRef.get(), (EntitySpec)this.get());
                    } else {
                        HashMap<Integer, EntityAttr> entityAttributes = new HashMap<Integer, EntityAttr>();
                        for (EntityAttrEntry entry : EntityAttributesForm.this.model.getRows()) {
                            EntityAttr a = entry.getAttr();
                            if (a == null) continue;
                            entityAttributes.put(a.getEntitySpecAttrId(), a);
                        }
                        ArrayList<EntityAttrEntry> list = new ArrayList<EntityAttrEntry>();
                        if (this.get() != null) {
                            for (AbstractSpecAttr specAttr : ((EntitySpec)this.get()).getAttributeList()) {
                                list.add(new EntityAttrEntry(EntityAttributesForm.this.currentRef.get(), specAttr, (EntityAttr)entityAttributes.get(specAttr.getId())));
                            }
                        }
                        EntityAttributesForm.this.model.setData(list);
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }.execute();
    }
}

