/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.pc.server;

import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebServlet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.scan.StandardJarScanner;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.pc.server.BGPCFilter;
import ru.bitel.bgbilling.kernel.pc.server.BGPCServlet;
import ru.bitel.bgbilling.kernel.pc.server.BGServerUtils;
import ru.bitel.bgbilling.kernel.pc.server.MyAccessLogValve;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.Log4j2;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

public class BGPersonal\u0421abinetServer
extends Tomcat
implements Lifecycle,
BGServerUtils {
    public static final String CONTEXT_PATH_BGBILLING = "/bgbilling";

    public BGPersonal\u0421abinetServer() throws BGException {
        Log4j2.init("data");
        BGNestedContext.push("server");
        Setup setup = Setup.getSetup();
        Logger logger = LogManager.getLogger();
        Application.getInstance().getCommandPortListener().setApplicationBean(this);
        String catalinaHome = ServerUtils.getServerHome();
        this.setBaseDir(catalinaHome);
        logger.info("catalina.base = " + catalinaHome);
        this.checkFiles(new String[]{"custom.css"});
        this.checkFiles(new String[]{"js", "custom.js"});
        try {
            logger.info("Starting BGPersonalCabinetServer...");
            System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
            String hostname = setup.get("server.host.name", "localhost.localdomain");
            this.getEngine().setDefaultHost(hostname);
            this.getHost().setName(hostname);
            this.getHost().setAppBase(catalinaHome + "/webroot");
            StandardContext rootContext = this.addContext(catalinaHome, setup.get("context.path", CONTEXT_PATH_BGBILLING), "webroot");
            this.initConnectors(this.getService(), this.getConnector());
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, true);){
                DomainRuntimeMap.getInstance((ConnectionSet)connectionSet);
            }
            this.initKernel(rootContext, setup);
            this.initModules(rootContext, setup);
            System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            logger.info("Start BGServerPC OK");
        }
        catch (Exception ex) {
            logger.error("HTTP server start alarm: " + ex.getMessage() + " exiting...");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private StandardContext addContext(String catalinaHome, String contextPath, String name) {
        Setup setup = Setup.getSetup();
        StandardContext context = (StandardContext)this.addWebapp(contextPath, catalinaHome + "/" + name);
        context.setDefaultWebXml(catalinaHome + "/data/default.web.xml");
        context.setReloadable(false);
        context.setWorkDir("tmp");
        context.setUseNaming(false);
        context.setSessionTimeout(setup.getInt("context.session.timeout", 30));
        context.setIgnoreAnnotations(true);
        context.setSessionCookiePath("/");
        this.addResources(context);
        StandardJarScanner standardJarScanner = (StandardJarScanner)context.getJarScanner();
        standardJarScanner.setScanManifest(false);
        standardJarScanner.setScanClassPath(false);
        standardJarScanner.setJarScanFilter((type, jarName) -> jarName.endsWith("-server.jar"));
        ParameterMap errorPages = setup.sub(name + ".server.error.");
        for (Map.Entry<String, String> me : errorPages.entrySet()) {
            ErrorPage errorPage = new ErrorPage();
            errorPage.setErrorCode(Utils.parseInt(me.getKey()));
            errorPage.setLocation(me.getValue());
            context.addErrorPage(errorPage);
        }
        context.addValve((Valve)new MyAccessLogValve(name));
        return context;
    }

    private void addResources(StandardContext context) {
        StandardRoot resourceRoot = new StandardRoot((Context)context);
        context.setResources((WebResourceRoot)resourceRoot);
        resourceRoot.setCachingAllowed(true);
        context.setDelegate(true);
    }

    private void initKernel(StandardContext rootContext, Setup setup) {
        Logger logger = LogManager.getLogger();
        this.setServletAndFilters(rootContext, "ru.bitel.bgbilling.kernel.base.server.servlet");
        List<String> customServletPackages = Utils.toList(setup.get("custom.servlet.package"));
        if (customServletPackages != null && !customServletPackages.isEmpty()) {
            customServletPackages.forEach(a -> {
                logger.info("Add custom servlet from " + a);
                this.setServletAndFilters(rootContext, (String)a);
            });
        }
    }

    private void initModules(StandardContext rootContext, Setup setup) {
        Logger logger = LogManager.getLogger();
        logger.info("Browsing installed modules... and Creating installed modules map...");
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (BGInstalledModule module : ModuleCache.getInstance().getInstalledModulesList()) {
            if (module.getType() != ComponentType.MODULE) continue;
            map2.put(module.getName(), module.getPackageServer());
        }
        rootContext.getServletContext().setAttribute("installed_modules_map", map2);
    }

    private void setServletAndFilters(StandardContext context, String packageName) {
        Logger logger = LogManager.getLogger();
        HashMap<String, WebFilter> filtersMap = new HashMap<String, WebFilter>();
        for (Class<?> clazz : Utils.getClassList(packageName)) {
            String className = clazz.getName();
            if (clazz.isAnnotationPresent(WebServlet.class)) {
                if (clazz.isAnnotationPresent(BGPCServlet.class)) {
                    WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
                    this.addServlet(context, webServlet.name(), className, webServlet.urlPatterns());
                    continue;
                }
                logger.trace("skip class={}", clazz);
                continue;
            }
            if (!clazz.isAnnotationPresent(WebFilter.class)) continue;
            if (clazz.isAnnotationPresent(BGPCFilter.class)) {
                filtersMap.put(className, clazz.getAnnotation(WebFilter.class));
                continue;
            }
            logger.trace("skip class={}", clazz);
        }
        this.setServletFilter(context, filtersMap);
    }

    public String executeCommand(String command, String param) {
        String result = "";
        if (command.equals("status")) {
            result = this.getStatusString();
        }
        return result;
    }

    public String getStatusString() {
        StringBuffer result = new StringBuffer();
        return result.toString();
    }
}

