/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RecordAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.SearchResult;

public class RequestRecordLogDao
extends AbstractIdDao<RequestRecordLog> {
    public RequestRecordLogDao(Connection con) {
        super(con, 0, "bgs_request_record");
    }

    @Override
    protected RequestRecordLog getFromRS(ResultSet rs) throws SQLException, BGException {
        RequestRecordLog log = new RequestRecordLog();
        log.setStartRecordingTime(TimeUtils.convertTimestampToDate(rs.getTimestamp("start_record_time")));
        Timestamp stopTime = rs.getTimestamp("stop_record_time");
        log.setEndRecordingTime(stopTime != null ? TimeUtils.convertTimestampToDate(stopTime) : null);
        log.setUserId(rs.getInt("user_id"));
        log.setId(rs.getInt("id"));
        log.setTitle(rs.getString("title"));
        log.setAllActionsCount(rs.getInt("all_actions_count"));
        log.setActions(this.actionsFromJsonArray(rs.getString("actions")));
        return log;
    }

    @Override
    protected void updateImpl(RequestRecordLog requestRecordLog) throws BGException, SQLException {
        String set = " SET start_record_time=?, stop_record_time=?, all_actions_count=?, actions=?, title=?, user_id=?";
        String query = requestRecordLog.getId() > 0 ? "UPDATE " + this.tableName + set + " WHERE id=?" : "INSERT INTO " + this.tableName + set;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp(requestRecordLog.getStartRecordingTime()));
            ps.setTimestamp(2, requestRecordLog.getEndRecordingTime() != null ? TimeUtils.convertDateToTimestamp(requestRecordLog.getEndRecordingTime()) : null);
            ps.setInt(3, requestRecordLog.getAllActionsCount());
            ps.setString(4, this.actionsToJsonArray(requestRecordLog.getActions()));
            ps.setString(5, requestRecordLog.getTitle());
            ps.setInt(6, requestRecordLog.getUserId());
            if (requestRecordLog.getId() > 0) {
                ps.setInt(7, requestRecordLog.getId());
            }
            ps.executeUpdate();
            requestRecordLog.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private String actionsToJsonArray(Set<RecordAction> actions) {
        if (Utils.isEmptyCollection(actions)) {
            return "";
        }
        JSONArray arr = new JSONArray();
        for (RecordAction action : actions) {
            JSONObject json = new JSONObject();
            json.put("moduleId", (Object)action.getModuleId());
            json.put("operation", (Object)action.getOperation());
            json.put("description", (Object)action.getDescription());
            json.put("service", (Object)action.getService());
            json.put("actionId", (Object)action.getActionId());
            arr.put((Object)json);
        }
        return arr.toString();
    }

    private Set<RecordAction> actionsFromJsonArray(String jsonArray) {
        if (Utils.isBlankString(jsonArray)) {
            return new HashSet<RecordAction>();
        }
        HashSet<RecordAction> result = new HashSet<RecordAction>();
        JSONArray arr = new JSONArray(jsonArray);
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject json = arr.getJSONObject(i);
            RecordAction action = new RecordAction();
            action.setOperation(json.optString("operation"));
            action.setService(json.optString("service"));
            action.setModuleId(json.optString("moduleId"));
            action.setDescription(json.optString("description"));
            action.setActionId(json.optString("actionId"));
            result.add(action);
        }
        return result;
    }

    public void searchRequestRecordLogList(SearchResult<RequestRecordLog> searchResult) throws BGException {
        Objects.requireNonNull(searchResult);
        try {
            searchResult.getList().addAll(this.list(null, "id", new Object[0]));
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }
}

