/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.BGUTableColumnVisibility;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.treetable.AbstractBGUTreeTable;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.TreeNode;

public class BGUTreeTable
extends AbstractBGUTreeTable<ClientContext> {
    public <N extends TreeNode<N>> BGUTreeTable(BGTreeTableModel<N> model) {
        super(model);
    }

    public void initDnDMove() {
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new TreeTableTransferHandler());
    }

    @Override
    protected void initHeaderMenu() {
        if (this.tableHeaderButton == null) {
            return;
        }
        JPopupMenu popupMenu = this.tableHeaderButton.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            this.tableHeaderButton.setComponentPopupMenu(popupMenu);
        }
        final JCheckBoxMenuItem resizeMenu = new JCheckBoxMenuItem(new BGUAction("table.columns.resize", "\u0420\u0430\u0441\u0442\u044f\u0433\u0438\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BGUTreeTable.this.getAutoResizeMode() == 0) {
                    BGUTreeTable.this.setAutoResizeMode(3);
                } else {
                    BGUTreeTable.this.setAutoResizeMode(0);
                }
            }
        });
        resizeMenu.setSelected(this.getAutoResizeMode() != 0);
        this.tableHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resizeMenu.setSelected(BGUTreeTable.this.getAutoResizeMode() != 0);
                BGUTreeTable.this.tableHeaderButton.getComponentPopupMenu().show(BGUTreeTable.this.tableHeaderButton, 0, BGUTreeTable.this.tableHeaderButton.getHeight());
            }
        });
        popupMenu.add(resizeMenu);
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.saveColumnProperties(BGUTreeTable.this, false);
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new BGUTableColumnVisibility(BGUTreeTable.this, (Window)SwingUtilities.getRoot(BGUTreeTable.this));
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.resetColumnProperties(BGUTreeTable.this);
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.saveColumnProperties(BGUTreeTable.this, true);
            }
        }));
    }

    @Override
    protected final ClientContext innerGetContext(Container parent) {
        if (parent instanceof BGPanel) {
            return ((BGPanel)parent).getContext();
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        BGUTable.loadColumnProperties(this);
    }

    private <D extends TreeNode<D>> int count(D root, int max) {
        int count = 0;
        List<D> children = root.getChildren();
        if (children != null) {
            int size = children.size();
            if ((count += size) >= max) {
                return count;
            }
            for (int i = 0; i < size; ++i) {
                count += this.count((TreeNode)children.get(i), max);
            }
        }
        return count;
    }

    public void expandAfterUpdate() {
        BGTreeTableModel model = (BGTreeTableModel)this.getModel();
        int count = this.count((TreeNode)model.getRoot(), 25);
        if (count <= 25) {
            this.expand();
        } else {
            int moduleId = ((ClientContext)this.getContext()).getModuleId();
            ClientSetup clientSetup = ClientSetup.getInstance();
            boolean isNeedExpand = (moduleId > 0 ? clientSetup.getModuleParameterPreferences(moduleId) : clientSetup).getBoolean("client.gui.expand.device.tree", false);
            if (isNeedExpand) {
                int depth = (moduleId > 0 ? clientSetup.getModuleParameterPreferences(moduleId) : clientSetup).getInt("client.gui.expand.device.tree.depth", 2);
                this.expand(depth);
            }
        }
    }

    protected boolean reorderNode(int srcId, int dstId, byte step) {
        ClientUtils.showErrorMessageDialog("\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f [" + srcId + ", " + dstId + ", " + step + "]");
        return false;
    }

    class TreeTableTransferHandler
    extends TransferHandler {
        TreeTableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent component) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            BGTreeTableModel tableModel;
            Object rowObject;
            Transferable transferable = null;
            TableModel object = ((BGUTreeTable)component).getModel();
            if (object instanceof BGTreeTableModel && (rowObject = (tableModel = (BGTreeTableModel)object).getSelectedRow()) instanceof Transferable) {
                transferable = (Transferable)rowObject;
            }
            return transferable;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            try {
                Transferable transferable = support.getTransferable();
                Object object = transferable.getTransferData(support.getDataFlavors()[0]);
                if (object instanceof Id) {
                    BGUTreeTable treeTable;
                    TableModel tableModel;
                    Id nodeId1 = (Id)object;
                    Component component = support.getComponent();
                    if (component instanceof BGUTreeTable && (tableModel = (treeTable = (BGUTreeTable)component).getModel()) instanceof BGTreeTableModel) {
                        JTable.DropLocation dropLocation;
                        Object n;
                        BGTreeTableModel tableModel2 = (BGTreeTableModel)tableModel;
                        TransferHandler.DropLocation dropLocation2 = support.getDropLocation();
                        if (dropLocation2 instanceof JTable.DropLocation && (n = tableModel2.nodeForRow((dropLocation = (JTable.DropLocation)dropLocation2).getRow())) instanceof Id) {
                            Id nodeId2 = (Id)n;
                            if (!dropLocation.isInsertRow()) {
                                return BGUTreeTable.this.reorderNode(nodeId1.getId(), nodeId2.getId(), (byte)0);
                            }
                            return BGUTreeTable.this.reorderNode(nodeId1.getId(), nodeId2.getId(), (byte)0);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            Transferable transferable = support.getTransferable();
            try {
                List childrens;
                Object object = transferable.getTransferData(support.getDataFlavors()[0]);
                if (object instanceof Id && ((Id)object).getId() == 0) {
                    return false;
                }
                if (object instanceof TreeNode && (childrens = ((TreeNode)object).getChildren()) != null && !childrens.isEmpty()) {
                    return false;
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
                return false;
            }
            JTable.DropLocation dropLocation = (JTable.DropLocation)support.getDropLocation();
            return dropLocation.getRow() != 0 || !dropLocation.isInsertRow();
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
        }
    }
}

