/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGToggleButton;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGServiceConfigModulePatternPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigDataDto;
import ru.bitel.bgbilling.kernel.config.common.service.ConfigService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class BGServiceConfigModule
extends BGUTabPanel
implements GroupParent {
    private static final String BUTTON_SAVE = "save";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_SET = "set";
    private static final String BUTTON_PATTERN = "pattern";
    private boolean edited = false;
    private String module = "service";
    private ConfigData configData = null;
    private Map<String, AbstractButton> buttonMap = new HashMap<String, AbstractButton>();
    private CardLayout tableCardLayout = new CardLayout();
    private BGConfigEditorPane configEditorPane = new BGConfigEditorPane();
    protected ConfigTableModel configTableModel = new ConfigTableModel();
    private JPanel tablePanel = new JPanel(this.tableCardLayout);
    private BGServiceConfigModulePatternPanel patternPanel = new BGServiceConfigModulePatternPanel();
    private JTextField configTitle = new JTextField();
    private ConfigService configService = null;
    private static int defaultView = 0;

    @Override
    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getMainPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getMainPanel() {
        this.tablePanel.add((Component)this.getInfoPanel(), "table");
        this.tablePanel.add((Component)this.patternPanel, BUTTON_PATTERN);
        this.tablePanel.add((Component)this.getNotePanel(), "editor");
        ActionListener actionListener = event -> {
            switch (event.getActionCommand()) {
                case "save": {
                    this.saveConfigButton_actionPerformed();
                    break;
                }
                case "set": {
                    this.setConfigButton_actionPerformed();
                    break;
                }
                case "cancel": {
                    this.cancelConfigButton_actionPerformed();
                    break;
                }
                case "pattern": {
                    this.patternConfigButton_actionPerformed();
                }
            }
        };
        ConfigButton saveConfigButton = new ConfigButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", false, BUTTON_SAVE, actionListener);
        ConfigButton cancelConfigButton = new ConfigButton("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", false, BUTTON_CANCEL, actionListener);
        ConfigButton setConfigButton = new ConfigButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c", BUTTON_SET, actionListener);
        BGToggleButton patternConfigButton = new BGToggleButton();
        patternConfigButton.setMargin(new Insets(2, 4, 2, 2));
        patternConfigButton.setText("\u0428\u0430\u0431\u043b\u043e\u043d");
        patternConfigButton.setEnabled(false);
        patternConfigButton.setActionCommand(BUTTON_PATTERN);
        patternConfigButton.addActionListener(actionListener);
        this.buttonMap.put(BUTTON_PATTERN, patternConfigButton);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)saveConfigButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)cancelConfigButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        buttonPanel.add((Component)setConfigButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        buttonPanel.add((Component)patternConfigButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f "));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.tablePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getInfoPanel() {
        BGUTable table = new BGUTable(this.configTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    BGServiceConfigModule.this.performAction("edit");
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                BGServiceConfigModule.this.performAction("init");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getNotePanel() {
        this.configEditorPane.setText("");
        this.configTitle.setMinimumSize(new Dimension(4, 24));
        this.configTitle.setPreferredSize(new Dimension(67, 24));
        this.configTitle.setText("");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.configEditorPane), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.configTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getFindPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 4, 3), 0, 0));
        return panel;
    }

    private JPanel getFindPanel() {
        JTextField findText = new JTextField();
        BGButton find = new BGButton("\u041d\u0430\u0439\u0442\u0438", "find", e -> this.find(findText.getText(), 0));
        ActionListener findListener = e -> this.find(findText.getText(), this.configEditorPane.getSelectionEnd());
        BGButton findNext = new BGButton("\u041d\u0430\u0439\u0442\u0438 \u0434\u0430\u043b\u0435\u0435", "findNext", findListener);
        findText.addActionListener(findListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0435 "));
        panel.add((Component)findText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)find, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)findNext, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void find(String str, int offset) {
        int index;
        String data = this.configEditorPane.getText().toLowerCase();
        str = str.toLowerCase();
        if (offset == data.length()) {
            offset = 0;
        }
        if ((index = data.indexOf(str, offset)) != -1) {
            this.configEditorPane.select(index, index + str.length());
            this.configEditorPane.getCaret().setSelectionVisible(true);
        } else if (offset > 0 && (index = data.indexOf(str)) != -1) {
            this.configEditorPane.select(index, index + str.length());
            this.configEditorPane.getCaret().setSelectionVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.startsWith("new")) {
            this.performAction("new");
        } else if (actionCommand.startsWith("edit")) {
            this.performAction("edit");
        } else if (actionCommand.startsWith("delete")) {
            this.performAction("delete");
        } else if ("refresh".equals(actionCommand)) {
            this.performAction("refresh");
        }
    }

    private void setConfigTableModelData() {
        int moduleId = ((ClientContext)this.getContext()).getModuleId();
        if (moduleId < 0) {
            moduleId = 0;
        }
        int configModuleId = moduleId;
        Async.ofWithTry(() -> {
            this.configTableModel.setData(this.getConfigService().moduleConfigList(configModuleId));
            this.edited = false;
        });
        this.patternPanel.init(this.module, moduleId);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionInit(e -> this.setConfigTableModelData());
        new AbstractBGUPanel.BGActionRefresh(e -> this.setConfigTableModelData());
        new AbstractBGUPanel.BGActionNew(e -> {
            if (!this.edited) {
                this.edited = true;
                this.buttonMap.get(BUTTON_SAVE).setEnabled(true);
                this.buttonMap.get(BUTTON_CANCEL).setEnabled(true);
                this.buttonMap.get(BUTTON_SET).setEnabled(false);
                this.buttonMap.get(BUTTON_PATTERN).setEnabled(true);
                this.configData = new ConfigData();
                this.configTitle.setText("");
                this.configEditorPane.setText("");
                this.tableCardLayout.show(this.tablePanel, "editor");
            }
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (!this.edited) {
                ConfigDataDto configDataDto = (ConfigDataDto)this.configTableModel.getSelectedRow();
                if (configDataDto == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433");
                } else {
                    try {
                        this.configData = this.getConfigService().moduleConfigGet(configDataDto.getId());
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                        this.configData = new ConfigData();
                    }
                    this.configTitle.setText(this.configData.getTitle());
                    this.configEditorPane.setText(this.configData.getConfig());
                    this.edited = true;
                    this.buttonMap.get(BUTTON_SAVE).setEnabled(true);
                    this.buttonMap.get(BUTTON_CANCEL).setEnabled(true);
                    this.buttonMap.get(BUTTON_SET).setEnabled(false);
                    this.buttonMap.get(BUTTON_PATTERN).setEnabled(true);
                    this.patternPanel.setDataPatternTable(this.configEditorPane.getText());
                    switch (ClientSetup.getInstance().getUserConfig().getInt("isPattern", defaultView)) {
                        case 1: {
                            this.tableCardLayout.show(this.tablePanel, BUTTON_PATTERN);
                            this.buttonMap.get(BUTTON_PATTERN).setSelected(true);
                            break;
                        }
                        case 0: {
                            this.tableCardLayout.show(this.tablePanel, "editor");
                        }
                    }
                }
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (!this.edited) {
                ConfigDataDto configDataDto = (ConfigDataDto)this.configTableModel.getSelectedRow();
                if (configDataDto == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433");
                } else if (configDataDto.isActive()) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433");
                } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    try {
                        this.getConfigService().moduleConfigDelete(((ClientContext)this.getContext()).getModuleId(), configDataDto.getId());
                        this.configTableModel.deleteRow((ConfigDataDto)this.configTableModel.getSelectedRow());
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        });
    }

    void saveConfigButton_actionPerformed() {
        int moduleId;
        if (this.configTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            return;
        }
        if (this.buttonMap.get(BUTTON_PATTERN).isSelected()) {
            this.configEditorPane.setText(this.patternPanel.getTextConfig());
        }
        if ((moduleId = ((ClientContext)this.getContext()).getModuleId()) < 0) {
            moduleId = 0;
        }
        this.configData.setModuleId(moduleId);
        this.configData.setLastEdited(new Date());
        this.configData.setTitle(this.configTitle.getText().trim());
        this.configData.setConfig(this.configEditorPane.getText().trim());
        try {
            this.getConfigService().moduleConfigUpdate(moduleId, this.configData);
            this.performAction("refresh");
            this.edited = false;
            this.buttonMap.get(BUTTON_SAVE).setEnabled(false);
            this.buttonMap.get(BUTTON_CANCEL).setEnabled(false);
            this.buttonMap.get(BUTTON_SET).setEnabled(true);
            this.buttonMap.get(BUTTON_PATTERN).setEnabled(false);
            this.saveLastUsedView();
            this.tableCardLayout.show(this.tablePanel, "table");
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    void cancelConfigButton_actionPerformed() {
        this.edited = false;
        this.buttonMap.get(BUTTON_SAVE).setEnabled(false);
        this.buttonMap.get(BUTTON_CANCEL).setEnabled(false);
        this.buttonMap.get(BUTTON_SET).setEnabled(true);
        this.buttonMap.get(BUTTON_PATTERN).setEnabled(false);
        this.tableCardLayout.show(this.tablePanel, "table");
        this.saveLastUsedView();
    }

    void setConfigButton_actionPerformed() {
        this.configTableModel.optSelectedRow().ifPresentOrElse(configDataDto -> {
            try {
                this.getConfigService().moduleConfigActiveSet(Math.max(((ClientContext)this.getContext()).getModuleId(), 0), configDataDto.getId());
                this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433"));
    }

    void patternConfigButton_actionPerformed() {
        if (this.buttonMap.get(BUTTON_PATTERN).isSelected()) {
            this.patternPanel.setDataPatternTable(this.configEditorPane.getText());
            this.tableCardLayout.show(this.tablePanel, BUTTON_PATTERN);
        } else {
            this.configEditorPane.setText(this.patternPanel.getTextConfig());
            this.tableCardLayout.show(this.tablePanel, "editor");
        }
    }

    private void saveLastUsedView() {
        int sel;
        int n = sel = this.buttonMap.get(BUTTON_PATTERN).isSelected() ? 1 : 0;
        if (sel != defaultView) {
            ClientSetup.getInstance().getUserConfig().set("isPattern", String.valueOf(sel));
        } else {
            ClientSetup.getInstance().getUserConfig().set("isPattern", "default");
        }
        this.buttonMap.get(BUTTON_PATTERN).setSelected(false);
    }

    private ConfigService getConfigService() {
        if (this.configService == null) {
            this.configService = ((ClientContext)this.getContext()).getPort(ConfigService.class);
        }
        return this.configService;
    }

    class ConfigTableModel
    extends BGTableModel<ConfigDataDto> {
        public ConfigTableModel() {
            super(ConfigTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430\u044f", 80, 80, 80, "active", true);
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 160, 170, "lastEdited", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 200, 250, 300, "userName", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    class ConfigButton
    extends BGButton {
        ConfigButton(String text, String actionCommand, ActionListener actionListener) {
            this(text, true, actionCommand, actionListener);
        }

        ConfigButton(String text, boolean enabled, String actionCommand, ActionListener actionListener) {
            this.setText(text);
            this.setEnabled(enabled);
            this.setActionCommand(actionCommand);
            this.setMargin(new Insets(2, 4, 2, 4));
            this.addActionListener(actionListener);
            BGServiceConfigModule.this.buttonMap.put(actionCommand, this);
        }
    }
}

