/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.services.ServiceConfig;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGMenuBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;

public abstract class AbstractActionServiceConfig
implements ActionListener {
    protected final String title;
    protected final String prefix;

    public AbstractActionServiceConfig(String title) {
        this(title, "module");
    }

    public AbstractActionServiceConfig(String title, String prefix) {
        this.title = title;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String rb_name = this.getClass().getPackage().getName() + ".setup";
        int moduleId = 0;
        Object source = actionEvent.getSource();
        if (source instanceof BGMenuBar.MenuAction) {
            moduleId = ((BGMenuBar.MenuAction)source).moduleId;
        }
        String module = ClientUtils.getValueFromResourceBundle(rb_name, "module.id");
        ClientContext ctx = new ClientContext(module, moduleId, -1, rb_name);
        ClientContext.push(ctx);
        try {
            final JPanel panel = this.newPanel(actionEvent, ctx);
            if (panel instanceof AbstractBGUPanel) {
                String tabId = this.getTabId(actionEvent, panel.getClass(), moduleId);
                BGUTabPanel tab = new BGUTabPanel(ctx, tabId, this.getTitle(actionEvent)){

                    @Override
                    protected void jbInit() {
                        this.setLayout(new BorderLayout());
                        this.add((Component)panel, "Center");
                    }
                };
                tab = BGClientBase.getFrame().getTabbedPane().addTab(tabId, tab);
                tab.performAction("refresh");
            } else {
                String tabId = this.getTabId(actionEvent, panel.getClass(), moduleId);
                BGTabPanel tab = new BGTabPanel(tabId, this.getTitle(actionEvent)){

                    @Override
                    public void setData() {
                        Component component = this.getComponent(0);
                        if (component instanceof AbstractBGUPanel) {
                            AbstractBGUPanel panel = (AbstractBGUPanel)component;
                            panel.performAction("refresh");
                        } else if (component instanceof ServiceConfig.ServiceConfigPane) {
                            JPanel panel = ((ServiceConfig.ServiceConfigPane)component).get();
                            if (panel instanceof ServiceConfigTabbedPanel) {
                                ((ServiceConfigTabbedPanel)panel).setData();
                            } else {
                                Action a = panel.getActionMap().get("refresh");
                                if (a != null) {
                                    a.actionPerformed(new ActionEvent(this, 0, "refresh"));
                                }
                            }
                        } else if (component instanceof BGTabPanel) {
                            ((BGPanel)component).setData();
                        }
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Component component = this.getComponent(0);
                        if (component instanceof ServiceConfig.ServiceConfigPane && ((ServiceConfig.ServiceConfigPane)component).get() instanceof BGUPanel) {
                            component = ((ServiceConfig.ServiceConfigPane)component).get();
                        }
                        if (component instanceof BGUPanel) {
                            String command = actionEvent.getActionCommand();
                            if ("newItem".equals(command)) {
                                command = "new";
                            } else if ("editItem".equals(command)) {
                                command = "edit";
                            } else if ("deleteItem".equals(command)) {
                                command = "delete";
                            }
                            ((BGUPanel)component).performAction(command);
                        } else if (component instanceof ServiceConfigTabbedPanel) {
                            ((ServiceConfigTabbedPanel)component).actionPerformed(actionEvent);
                        } else if (component instanceof BGUPanel) {
                            ((BGUPanel)component).performAction(actionEvent.getActionCommand());
                        }
                    }
                };
                tab.setLayout(new BorderLayout());
                tab.add((Component)panel, "Center");
                tab.setData();
                BGClientBase.getFrame().getTabbedPane().addTab(tabId, tab);
            }
        }
        finally {
            ClientContext.pop();
        }
    }

    protected String getTitle(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source instanceof BGMenuBar.MenuAction && Utils.notBlankString(((BGMenuBar.MenuAction)source).name)) {
            return ((BGMenuBar.MenuAction)source).name;
        }
        return this.title;
    }

    protected String getTabId(ActionEvent e, Class<?> clazz, int mid) {
        if (mid > 0) {
            return clazz.getName() + "_" + mid;
        }
        return clazz.getName();
    }

    public abstract JPanel newPanel(ActionEvent var1, ClientContext var2);
}

