/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterMultiListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;

public class ListParamValuesEditor
extends BGPanel
implements ActionListener {
    private DefaultListModel<BGUListItem> valuesModel = new DefaultListModel();
    private JList<BGUListItem> valuesList = new JList<BGUListItem>(this.valuesModel);
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    protected String action = "ListValue";

    public ListParamValuesEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toolBar.setDefaultButtons(this);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.toolBar.setFloatable(false);
        this.valuesList.setCellRenderer(new ItemCellRenderer());
        this.valuesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListParamValuesEditor.this.editItem();
                }
            }
        });
        this.valuesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                BGUListItem li;
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (li = ListParamValuesEditor.this.valuesList.getSelectedValue()) != null) {
                    ClientUtils.showMessageDialog("\u041a\u043e\u0434 = " + li.getId(), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.valuesList.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder(" \u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"));
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)BGSwingUtilites.wrapScrollPane(this.valuesList, 50, 150), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        try {
            ArrayList<ItemData> items = new ArrayList<ItemData>();
            if ("ListValue".equals(this.action)) {
                items.addAll(this.getContext().getWebService(ContractParameterService.class, 0).contractParameterListItemList(Utils.parseInt(this.getId())).stream().map(a -> ItemData.of(a)).toList());
            } else {
                items.addAll(this.getContext().getWebService(ContractParameterService.class, 0).contractParameterMultiListItemList(Utils.parseInt(this.getId())).stream().map(a -> ItemData.of(a)).toList());
            }
            this.valuesModel.clear();
            Collections.sort(items, (o1, o2) -> o1.title.compareToIgnoreCase(o2.title));
            items.forEach(a -> this.valuesModel.addElement(new BGUListItem(a.id, a.title, a.inUse)));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void deleteItem() {
        String id = this.getSelectedId();
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                int parameterTypeId = Utils.parseInt(this.getId());
                if (parameterTypeId > 0) {
                    if ("ListValue".equals(this.action)) {
                        this.getContext().getWebService(ContractParameterService.class, 0).contractParameterListItemDelete(parameterTypeId, Utils.parseInt(id));
                    } else {
                        this.getContext().getWebService(ContractParameterService.class, 0).contractParameterMultiListItemDelete(parameterTypeId, Utils.parseInt(id));
                    }
                }
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    @Override
    public void editItem() {
        String id = this.getSelectedId();
        if (id != null) {
            BGUListItem item = this.valuesList.getSelectedValue();
            new ItemEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", new ItemData(Utils.parseInt(id), item.getTitle(), item.isSelected())).open();
        }
    }

    @Override
    public void newItem() {
        new ItemEditorDialog("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", new ItemData()).open();
    }

    private String getSelectedId() {
        String id = null;
        BGUListItem li = this.valuesList.getSelectedValue();
        if (li != null) {
            id = li.getIdStr();
        }
        return id;
    }

    private void stopEdit(ItemData itemData) {
        try {
            int parameterTypeId = Utils.parseInt(this.getId());
            if (parameterTypeId > 0) {
                if ("ListValue".equals(this.action)) {
                    this.getContext().getWebService(ContractParameterService.class, 0).contractParameterListItemUpdate(parameterTypeId, new ContractParameterListItem(itemData.id, parameterTypeId, itemData.title, itemData.inUse));
                } else {
                    this.getContext().getWebService(ContractParameterService.class, 0).contractParameterMultiListItemUpdate(parameterTypeId, new ContractParameterMultiListItem(itemData.id, parameterTypeId, itemData.title, itemData.inUse));
                }
                this.setData();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void reset() {
        this.id = "0";
        this.valuesModel.clear();
    }

    class ItemCellRenderer
    extends DefaultListCellRenderer {
        private Color color = UIManager.getColor("TextField.inactiveForeground");

        ItemCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            BGUListItem listItem = (BGUListItem)value;
            JLabel label = new JLabel(listItem.isSelected() ? "" : " [\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f]");
            label.setForeground(this.color);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.add((Component)new JLabel(listItem.getGuiTitle()), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 3, 2, 0), 0, 0));
            panel.add((Component)label, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 0, 2, 3), 0, 0));
            return panel;
        }
    }

    class ItemEditorDialog
    extends BGEditorDialog<ItemData> {
        private JTextField title;
        private JCheckBox notInUseCheckBox;

        public ItemEditorDialog(String title, ItemData data) {
            super(title, data);
            this.title = new JTextField(30);
            this.notInUseCheckBox = new JCheckBox("\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.notInUseCheckBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.title.setText(((ItemData)this.data).title);
            this.notInUseCheckBox.setSelected(!((ItemData)this.data).inUse);
        }

        @Override
        public boolean doApply() throws Exception {
            ((ItemData)this.data).title = this.title.getText();
            ((ItemData)this.data).inUse = !this.notInUseCheckBox.isSelected();
            ListParamValuesEditor.this.stopEdit((ItemData)this.data);
            return true;
        }
    }

    static class ItemData {
        public int id = 0;
        public String title;
        public boolean inUse = true;

        public ItemData() {
        }

        public ItemData(int id, String title, boolean inUse) {
            this.id = id;
            this.title = title;
            this.inUse = inUse;
        }

        public static ItemData of(ContractParameterListItem item) {
            return new ItemData(item.getId(), item.getTitle(), item.isInUse());
        }

        public static ItemData of(ContractParameterMultiListItem item) {
            return new ItemData(item.getId(), item.getTitle(), item.isInUse());
        }
    }
}

