/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.ipn.client.GateSelectPanel;
import ru.bitel.bgbilling.modules.ipn.client.editor.ContractRuleEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class ContactGatePanel
extends ServicePanel {
    private CardLayout cardLayout = new CardLayout();
    private BGTable tableStatus = new BGTable();
    private JComboBox<ComboBoxItem> gateStatus = new JComboBox();
    private DefaultListModel<BGUListItem> gatesModel = new DefaultListModel();
    private JList<BGUListItem> gatesList = new JList<BGUListItem>(this.gatesModel);
    private GateSelectPanel gateSelectPanel = new GateSelectPanel("GateInfo");
    private ContractRuleEditorPanel ruleEditor;

    public ContactGatePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tableStatus.setHeader(this.rb_name, "contract_status");
        this.gateStatus.setModel(new DefaultComboBoxModel());
        this.gateStatus.addItem(new ComboBoxItem((Object)String.valueOf(0), "\u041e\u0442\u043a\u0440\u044b\u0442"));
        this.gateStatus.addItem(new ComboBoxItem((Object)String.valueOf(1), "\u0417\u0430\u043a\u0440\u044b\u0442"));
        this.gateStatus.addItem(new ComboBoxItem((Object)String.valueOf(2), "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.gateStatus.addItem(new ComboBoxItem((Object)String.valueOf(4), "\u0416\u0435\u0441\u0442\u043a\u0430\u044f \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430"));
        this.gateStatus.addItem(new ComboBoxItem((Object)String.valueOf(3), "\u0423\u0434\u0430\u043b\u0435\u043d"));
        this.gateStatus.setSelectedIndex(0);
        this.gatesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ContactGatePanel.this.gatesList_mouseClicked(e);
            }
        });
        this.gateStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContactGatePanel.this.gateStatusChanged();
            }
        });
        this.cardLayout.show((Container)((Object)this), "view");
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout);
        JPanel gateStatusPanel = new JPanel();
        JPanel gateListPanel = new JPanel();
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        JScrollPane tableStatusScroll = new JScrollPane();
        JScrollPane gateListScroll = new JScrollPane();
        rightPanel.setLayout(new GridBagLayout());
        leftPanel.setLayout(new GridBagLayout());
        gateStatusPanel.setLayout(new GridBagLayout());
        gateStatusPanel.setBorder((Border)new BGTitleBorder("\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0448\u043b\u044e\u0437\u043e\u0432"));
        gateListPanel.setLayout(new GridBagLayout());
        gateListPanel.setBorder((Border)new BGTitleBorder(" \u0428\u043b\u044e\u0437\u044b "));
        JSplitPane jSplitPane1 = new JSplitPane();
        jSplitPane1.setDividerSize(5);
        jSplitPane1.setLastDividerLocation(200);
        rightPanel.setBorder((Border)new BGTitleBorder(" \u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0448\u043b\u044e\u0437\u0430 "));
        this.gatesList.setSelectionMode(0);
        jSplitPane1.add((Component)leftPanel, "left");
        leftPanel.add((Component)gateStatusPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jSplitPane1.add((Component)rightPanel, "right");
        rightPanel.add((Component)tableStatusScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        tableStatusScroll.setViewportView((Component)this.tableStatus);
        leftPanel.add((Component)gateListPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        gateListPanel.add((Component)gateListScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        gateListScroll.setViewportView(this.gatesList);
        gateStatusPanel.add(this.gateStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(jSplitPane1, "view");
        this.add((Component)((Object)this.gateSelectPanel), "select");
        this.gateSelectPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ok")) {
                    ContactGatePanel.this.gateEdit(ContactGatePanel.this.gateSelectPanel.getRuleId(), ContactGatePanel.this.gateSelectPanel.getGateId(), ContactGatePanel.this.gateSelectPanel.getGateTypeId());
                } else {
                    ContactGatePanel.this.cancelPressed();
                }
            }
        });
    }

    private void cancelPressed() {
        this.cardLayout.show((Container)((Object)this), "view");
    }

    public void setData() {
        if (this.getContractId() == -1 || this.getModuleId() == -1) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setContractId(this.getContractId());
        request.setModuleId(this.getModuleId());
        request.setAction("GateContractInfo");
        Document doc = this.getDocument(request);
        if (!ClientUtils.checkStatus((Document)doc)) {
            return;
        }
        this.tableStatus.updateData(XMLUtils.selectNode((Node)doc, (String)"//table"));
        this.showGateStatus(XMLUtils.getAttribute((Element)XMLUtils.selectElement((Node)doc, (String)"//gate"), (String)"status", (String)"0"));
        ClientUtils.buildList(this.gatesList, this.gatesModel, (Node)XMLUtils.selectNode((Node)doc, (String)"//gates"));
    }

    public void newItem() {
        this.gateSelectPanel.init(this.module, this.getModuleId());
        this.gateSelectPanel.setContractId(this.getContractId());
        this.gateSelectPanel.setData();
        this.cardLayout.show((Container)((Object)this), "select");
    }

    public void editItem() {
        if (this.gatesList.getSelectedIndex() < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u043b\u044e\u0437 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        BGUListItem gate = this.gatesList.getSelectedValue();
        String id = String.valueOf(gate.getId());
        String gateId = (String)gate.getAttribute("gid");
        String gateTypeId = (String)gate.getAttribute("gtid");
        this.gateEdit(id, gateId, gateTypeId);
    }

    public void deleteItem() {
        if (this.gatesList.getSelectedIndex() < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u043b\u044e\u0437 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u043b\u044e\u0437?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            String id = (String)this.gatesList.getSelectedValue().getAttribute("id");
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("DeleteContractRule");
            request.setAttribute("id", id);
            request.setContractId(this.getContractId());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void showGateStatus(String status) {
        this.fl = false;
        ClientUtils.setComboBoxSelection(this.gateStatus, (Object)status);
        this.fl = true;
    }

    private void gateStatusChanged() {
        if (this.fl) {
            Request request = new Request();
            request.setModule(this.module);
            request.setContractId(this.getContractId());
            request.setModuleId(this.getModuleId());
            request.setAction("SetContractStatus");
            request.setAttribute("status", ((ComboBoxItem)this.gateStatus.getSelectedItem()).getObject());
            Document doc = this.getDocument(request);
            if (!ClientUtils.checkStatus((Document)doc)) {
                return;
            }
            Element gate = XMLUtils.selectElement((Node)doc, (String)"//gate");
            this.showGateStatus(XMLUtils.getAttribute((Element)gate, (String)"status", (String)"0"));
            this.setData();
        }
    }

    private void gatesList_mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        this.editItem();
    }

    public void gateEdit(String ruleId, String gateId, String gateTypeId) {
        if (this.ruleEditor != null) {
            this.remove((Component)((Object)this.ruleEditor));
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GateTypeClasses");
        request.setModuleId(this.getModuleId());
        request.setAttribute("gtid", gateTypeId);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element classes = XMLUtils.selectElement((Node)doc, (String)"//classes");
            String className = classes.getAttribute("user_rule");
            try {
                this.ruleEditor = (ContractRuleEditorPanel)((Object)Utils.newInstance((String)className, ContractRuleEditorPanel.class));
            }
            catch (BGException e) {
                e.printStackTrace();
                BGSwingUtilites.error((String)e.getMessage());
                return;
            }
            this.ruleEditor.setContractGates(this);
            this.ruleEditor.init(this.module, this.getModuleId());
            this.ruleEditor.setContractId(this.getContractId());
            this.ruleEditor.setId(ruleId);
            this.ruleEditor.setGateId(gateId);
            this.ruleEditor.setGateTypeId(gateTypeId);
            this.ruleEditor.setData();
            this.add((Component)((Object)this.ruleEditor), "editor");
            this.cardLayout.show((Container)((Object)this), "editor");
        }
    }

    public void showGates() {
        this.cardLayout.show((Container)((Object)this), "view");
        this.setData();
    }
}

