/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.load.DefaultDataProcess;
import bitel.billing.server.load.ProcessIn;
import bitel.billing.server.load.bean.Source;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.modules.ipn.server.CalculateAddressRange;
import ru.bitel.bgbilling.modules.ipn.server.DBProcessIn;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeFinder;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceFinder;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLink;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLinkManager;
import ru.bitel.bgbilling.modules.ipn.server.mail.MailDataProcess;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.WorkerTask;

public class DataProcess
extends DefaultDataProcess {
    private Date _date;
    private int _hh = -1;
    private int _source_id = -1;
    private int moduleId = -1;
    private String _ipnContractDataTable;
    private PreparedStatement _psInsertError;
    private AtomicInteger errorCnt = new AtomicInteger();
    private StringBuffer errorLogText = new StringBuffer();
    private String errorLogTitle = "";
    private ServiceAmountCache amountCache;
    private AddressRangeFinder addressRangeFinder;
    private boolean ignoreByZeroDestIface;
    private Auditer auditer;

    public bitel.billing.server.load.DBProcessIn getDBProcessIn(Setup setup, Source source, Calendar hour, Connection con) {
        return new DBProcessIn(setup, source, hour, con);
    }

    @Deprecated
    public void proccess(ProcessIn processIn, Connection con) {
        throw new UnsupportedOperationException();
    }

    public void proccess(Connection con, Setup setup, final IPHourlyDataLog dataLog, Source source, Calendar hour) {
        this.setup = setup;
        this.con = con;
        int mid = source.getMid();
        Timestamp time = TimeUtils.convertCalendarToTimestamp((Calendar)hour);
        int param = source.getId();
        if (mid < 0 || time == null || param < 0 || con == null) {
            return;
        }
        StringBuffer report = new StringBuffer("proccess [ " + TimeUtils.format((java.util.Date)new java.util.Date(time.getTime()), (String)"dd-MM-yyyy HH:00:00") + "; mid => " + mid + "; param => " + param + " ] ");
        long startTime = System.currentTimeMillis();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        String query = null;
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(mid));
        if (moduleSetup.getInt("audit", 0) > 0) {
            logger.info("Audit is on..");
            this.auditer = new Auditer(setup, (Preferences)moduleSetup);
        }
        this._date = new Date(time.getTime());
        this._hh = cal.get(11);
        this._ipnContractDataTable = ServerUtils.getModuleMonthTableName((String)"ipn_contract_data", (java.util.Date)cal.getTime(), (int)mid);
        this._source_id = param;
        this.moduleId = mid;
        this.errorLogTitle = "(IPN) \u041e\u0448\u0438\u0431\u043a\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430 " + TimeUtils.formatDate((java.util.Date)this._date) + " (\u0447\u0430\u0441 " + this._hh + "). \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f=" + this.moduleId + ". \u041a\u043e\u0434 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430=" + this._source_id + ".";
        boolean bl = this.ignoreByZeroDestIface = new Preferences(source.getConfig(), "\r\n").getInt("ignore.by.zero.dst.iface", 0) == 1;
        if (con != null) {
            try {
                this.clearErrorLog(con, this._date, this._hh, this.moduleId, this._source_id);
                this._psInsertError = this.getInsertErrorLog(con, this._date, this._hh, this.moduleId, this._source_id);
                long time1 = System.currentTimeMillis();
                this.amountCache = new ServiceAmountCache();
                Map<Integer, ServiceFinder> serviceFinderMap = this.getFinderMap(this.moduleId, cal, this._source_id);
                ServiceFinder defaultFinder = serviceFinderMap.get(0);
                if (defaultFinder == null) {
                    defaultFinder = new ServiceFinder(0, Collections.emptyList());
                }
                this.addressRangeFinder = new AddressRangeFinder(defaultFinder, serviceFinderMap, this._source_id, con, this.moduleId, cal);
                long time2 = System.currentTimeMillis();
                report.append(" Bean create => " + (time2 - time1));
                final AtomicInteger count = new AtomicInteger();
                Callable<Void> worker = new Callable<Void>(){

                    @Override
                    public Void call() {
                        FlowReader reader;
                        while ((reader = (FlowReader)dataLog.nextReader(null, true)) != null) {
                            FlowArray f;
                            while ((f = reader.readChunk()) != null) {
                                DataProcess.this.processFlows((FlowArray<? extends Data>)f, count);
                                count.addAndGet(f.size);
                            }
                        }
                        return null;
                    }
                };
                int threadCount = setup.getInt("process.datalog.thread.count", 1);
                if (source.getType() == 5 || threadCount <= 1) {
                    worker.call();
                } else {
                    ExecutorService executorService = WorkerTask.newFixedThreadPool((String)"data-process-log", null, null, (int)threadCount);
                    executorService.invokeAll(Collections.nCopies(threadCount, worker));
                    executorService.shutdown();
                }
                this.insertErrorsIntoDB();
                this.deleteProcessingSessions(setup);
                int updateCount = 0;
                query = "INSERT INTO " + this._ipnContractDataTable + " ( dt, hh, source_id, cid, aid, sid, amount ) VALUES  ( ?, ?, ?, ?, ?, ?, ? ) ";
                PreparedStatement psInsertIPNContractData = con.prepareStatement(query);
                psInsertIPNContractData.setDate(1, this._date);
                psInsertIPNContractData.setInt(2, this._hh);
                psInsertIPNContractData.setInt(3, this._source_id);
                Iterator<ServiceAmount> it = this.amountCache.getAmounts();
                while (it.hasNext()) {
                    ServiceAmount amount = it.next();
                    psInsertIPNContractData.setInt(4, amount.key.cid);
                    psInsertIPNContractData.setInt(5, amount.key.aid);
                    psInsertIPNContractData.setInt(6, amount.key.sid);
                    psInsertIPNContractData.setLong(7, amount.amount.get());
                    psInsertIPNContractData.executeUpdate();
                    ++updateCount;
                }
                psInsertIPNContractData.close();
                long stopTime = System.currentTimeMillis();
                report.append(" Processed lines => " + count + "; inserts => " + updateCount + "; errors => " + this.errorCnt + "; time => " + (stopTime - startTime) + " ms.");
                this.markProcessed(time, param, con);
                if (this.auditer != null) {
                    this.auditer.sendReport(source, hour);
                }
                logger.info(report.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Map<Integer, ServiceFinder> getFinderMap(int mid, Calendar date, int sourceId) {
        HashMap result = new HashMap();
        ArrayList<ServiceLink> finder = null;
        int planId = Integer.MIN_VALUE;
        List<ServiceLink> serviceLinkList = new ServiceLinkManager(this.con, mid).getServiceLinkList(date, sourceId);
        for (ServiceLink link : serviceLinkList) {
            if (finder == null || planId != link.getPlanId()) {
                planId = link.getPlanId();
                finder = new ArrayList<ServiceLink>();
                result.put(link.getPlanId(), finder);
            }
            finder.add(link);
        }
        HashMap<Integer, ServiceFinder> finderMap = new HashMap<Integer, ServiceFinder>();
        for (Map.Entry e : result.entrySet()) {
            finderMap.put((Integer)e.getKey(), new ServiceFinder((Integer)e.getKey(), (List)e.getValue()));
        }
        return finderMap;
    }

    private void deleteProcessingSessions(Setup setup) throws Exception {
        if (ServerUtils.tableExists((Connection)this.con, (String)this._ipnContractDataTable)) {
            String query = "DELETE FROM " + this._ipnContractDataTable + " WHERE dt=? AND hh=? AND source_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, this._date);
            ps.setInt(2, this._hh);
            ps.setInt(3, this._source_id);
            ps.executeUpdate();
            ps.close();
        } else {
            String query = "CREATE TABLE " + this._ipnContractDataTable + "(id int PRIMARY KEY AUTO_INCREMENT NOT NULL,dt date,hh int NOT NULL,source_id int NOT NULL,cid int NOT NULL,aid int NOT NULL,sid int NOT NULL,amount bigint NOT NULL,KEY dt ( dt, hh, source_id ),KEY cid ( cid ),KEY aid ( aid ) )";
            ServerUtils.checkAndCreatePeriodicTableName((Connection)this.con, (String)this._ipnContractDataTable, (String)query);
        }
    }

    private void addError(String message) {
        if (this.errorCnt.getAndIncrement() < 30) {
            this.errorLogText.append(message + "\n\n--------------------------------------------\n\n");
        }
    }

    private void insertErrorsIntoDB() {
        try {
            if (this.errorCnt.get() <= 0) {
                return;
            }
            this._psInsertError.setString(4, this.errorLogTitle);
            this._psInsertError.setString(5, this.errorLogText.toString());
            this._psInsertError.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void processFlows(FlowArray<? extends Data> f, AtomicInteger count) {
        int size = f.size;
        for (int i = 0; i < size; ++i) {
            ServiceLink sid;
            Data record = f.array[i];
            boolean processed = false;
            long srcAddress = record.getSrcAddress();
            int srcPort = record.getSrcPort();
            int inputInterface = record.getInputInterface();
            long dstAddress = record.getDstAddress();
            int dstPort = record.getDstPort();
            int outputInterface = record.getOutputInterface();
            long octets = record.getOctets();
            int diffServ = record.getDiffServ();
            if (logger.isDebugEnabled()) {
                logger.debug("Process line " + record.toString());
            }
            if (this.ignoreByZeroDestIface && record.getOutputInterface() == 0 && logger.isDebugEnabled()) {
                logger.debug("Ignored becouse dst iface=0");
                continue;
            }
            CalculateAddressRange ar = this.addressRangeFinder.findAddressRange(srcAddress, srcPort, inputInterface);
            if (ar != null) {
                processed = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("Found send client");
                }
                sid = null;
                if (ar.personalServiceFinder != null) {
                    sid = ar.personalServiceFinder.getServiceLink(1, dstAddress, dstPort, outputInterface, diffServ);
                }
                if (sid == null) {
                    sid = ar.serviceFinder.getServiceLink(1, dstAddress, dstPort, outputInterface, diffServ);
                }
                if (sid == null) {
                    this.addError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0430!\n\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043f\u0430\u043a\u0435\u0442: " + record.toString() + "; \u043a\u043e\u0434 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 " + this._source_id);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("LINE " + count + ";" + sid.getPos() + ";" + sid.serviceId + ";" + octets);
                    }
                    this.amountCache.addAmount(new ServiceAmountKey(ar.cid, ar.id, sid.serviceId), octets);
                }
            }
            if ((ar = this.addressRangeFinder.findAddressRange(dstAddress, dstPort, outputInterface)) != null) {
                processed = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("Found receive client");
                }
                sid = null;
                if (ar.personalServiceFinder != null) {
                    sid = ar.personalServiceFinder.getServiceLink(2, srcAddress, srcPort, inputInterface, diffServ);
                }
                if (sid == null) {
                    sid = ar.serviceFinder.getServiceLink(2, srcAddress, srcPort, inputInterface, diffServ);
                }
                if (sid == null) {
                    this.addError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0430!\n\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043f\u0430\u043a\u0435\u0442: " + record.toString() + "; \u043a\u043e\u0434 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 " + this._source_id);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("LINE " + count + ";" + sid.getPos() + ";" + sid.serviceId + ";" + octets);
                    }
                    this.amountCache.addAmount(new ServiceAmountKey(ar.cid, ar.id, sid.serviceId), octets);
                }
            }
            if (processed) continue;
            if (this.auditer != null) {
                this.auditer.processAddress(srcAddress, octets);
                this.auditer.processAddress(dstAddress, octets);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Ignoring: sourceId:" + this._source_id + " " + record.toString());
        }
    }

    class Auditer {
        private Setup setup;
        private List<Range> ranges = new ArrayList<Range>();
        private String email;

        public Auditer(Setup setup, Preferences moduleSetup) {
            this.setup = setup;
            this.email = moduleSetup.get("audit.email", null);
            if (Utils.isBlankString((String)this.email)) {
                logger.error("Audit email is blank!");
            }
            ParameterMap ranges = moduleSetup.sub("audit.range.");
            for (Map.Entry it : ranges.entrySet()) {
                String[] from_to = ((String)it.getValue()).split("\\s*-\\s*");
                if (from_to.length != 2) continue;
                Range range = new Range();
                range.fromAddr = IPUtils.convertStringIPtoLong((String)from_to[0], (long)0L);
                range.toAddr = IPUtils.convertStringIPtoLong((String)from_to[1], (long)0L);
                this.ranges.add(range);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Audit range " + IPUtils.convertLongIpToString((long)range.fromAddr) + "-" + IPUtils.convertLongIpToString((long)range.toAddr));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Audit email: " + this.email);
            }
        }

        public void processAddress(long address, long bytes) {
            for (Range range : this.ranges) {
                if (range.fromAddr > address || address > range.toAddr) continue;
                range.count.incrementAndGet();
                range.bytes.addAndGet(bytes);
                AddressInfo ai = range.addresses.get(address);
                if (ai == null) {
                    ai = new AddressInfo();
                    range.addresses.put(address, ai);
                }
                ai.count.incrementAndGet();
                ai.bytes.addAndGet(bytes);
                break;
            }
        }

        public void sendReport(Source source, Calendar hour) {
            StringBuffer report = new StringBuffer();
            for (Range range : this.ranges) {
                if (range.count.get() <= 0) continue;
                report.append("\n");
                report.append("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d: ");
                report.append(IPUtils.convertLongIpToString((long)range.fromAddr));
                report.append("-");
                report.append(IPUtils.convertLongIpToString((long)range.toAddr));
                report.append(" => ");
                report.append(range.count);
                report.append("/");
                report.append(range.bytes);
                report.append("\n\u0432 \u0442\u043e\u043c \u0447\u0438\u0441\u043b\u0435: \n");
                TreeSet<Long> keySet = new TreeSet<Long>(range.addresses.keySet());
                for (Long address : keySet) {
                    AddressInfo ai = range.addresses.get(address);
                    report.append(" - ");
                    report.append(IPUtils.convertLongIpToString((long)address));
                    report.append(" => ");
                    report.append(ai.count);
                    report.append("/");
                    report.append(ai.bytes);
                    report.append("\n");
                }
            }
            if (report.length() > 0 && Utils.notBlankString((String)this.email)) {
                logger.info("Sending audit report..");
                StringBuffer txt = new StringBuffer().append(source.getTitle()).append("@").append(TimeUtils.format((Calendar)hour, (String)"dd.MM.yyyy HH")).append(report);
                try {
                    new MailMsg((Preferences)this.setup).sendMessage(new MailDataProcess().setModuleId(DataProcess.this.moduleId).setRecipients(this.email).setSubject("\u041e\u0442\u0447\u0435\u0442 \u0430\u0443\u0434\u0438\u0442\u0430 IPN").addTextPart("text", txt.toString()));
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            } else {
                logger.info("Audit check is ok..");
            }
        }
    }

    class ServiceAmountCache {
        private ConcurrentMap<ServiceAmountKey, ServiceAmount> amounts = new ConcurrentHashMap<ServiceAmountKey, ServiceAmount>(200);

        ServiceAmountCache() {
        }

        public void addAmount(ServiceAmountKey key, long amount) {
            ServiceAmount am;
            if (logger.isDebugEnabled()) {
                logger.debug("addAmount " + key + " => " + amount);
            }
            if ((am = (ServiceAmount)this.amounts.get(key)) == null) {
                ServiceAmount newValue = new ServiceAmount(key, amount);
                am = this.amounts.putIfAbsent(key, newValue);
                if (am != null) {
                    am.amount.addAndGet(amount);
                }
            } else {
                am.amount.addAndGet(amount);
            }
        }

        public Iterator<ServiceAmount> getAmounts() {
            return this.amounts.values().iterator();
        }
    }

    static class ServiceAmount {
        public final ServiceAmountKey key;
        public final AtomicLong amount;

        public ServiceAmount(ServiceAmountKey key, long amount) {
            this.key = key;
            this.amount = new AtomicLong(amount);
        }
    }

    static class ServiceAmountKey {
        public final int cid;
        public final int aid;
        public final int sid;

        public ServiceAmountKey(int cid, int aid, int sid) {
            this.cid = cid;
            this.aid = aid;
            this.sid = sid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.aid;
            result = 31 * result + this.cid;
            result = 31 * result + this.sid;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            ServiceAmountKey other = (ServiceAmountKey)obj;
            if (this.cid != other.cid) {
                return false;
            }
            if (this.aid != other.aid) {
                return false;
            }
            return this.sid == other.sid;
        }

        public String toString() {
            StringBuffer key = new StringBuffer(10);
            key.append(this.cid);
            key.append("_");
            key.append(this.aid);
            key.append("_");
            key.append(this.sid);
            return key.toString();
        }
    }

    static class AddressInfo {
        public AtomicLong bytes = new AtomicLong();
        public AtomicInteger count = new AtomicInteger();

        AddressInfo() {
        }
    }

    static class Range {
        public long fromAddr;
        public long toAddr;
        public AtomicLong bytes = new AtomicLong();
        public AtomicInteger count = new AtomicInteger();
        public Map<Long, AddressInfo> addresses = new HashMap<Long, AddressInfo>();

        Range() {
        }
    }
}

