/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetInterface;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;

public class InetDeviceTypeDao
extends DeviceTypeDao<InetDeviceType> {
    private String interfaceTable;

    public InetDeviceTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "inet_device_type");
        this.interfaceTable = "inet_interface_" + moduleId;
    }

    protected InetDeviceType newDeviceType() {
        return new InetDeviceType();
    }

    protected InetDeviceType getFromRS(ResultSet rs) throws SQLException, BGException {
        InetDeviceType result = new InetDeviceType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setDeviceEntitySpecId(rs.getInt("entitySpecId"));
        result.setComment(rs.getString("comment"));
        result.setSaHandlerClass(rs.getString("saHandlerClass"));
        result.setProtocolHandlerClass(rs.getString("protocolHandlerClass"));
        result.setDeviceManagerClass(rs.getString("deviceManagerClass"));
        result.setConfigId(rs.getInt("configId"));
        result.setConfig(rs.getString("config"));
        result.setScriptId(rs.getInt("scriptId"));
        result.setSource(rs.getBoolean("source"));
        result.setUniqueInterfaces(rs.getBoolean("uniqueInterfaces"));
        ArrayList<InetInterface> ifaceList = new ArrayList<InetInterface>();
        String query = "SELECT id, title FROM " + this.interfaceTable + " WHERE deviceTypeId=? ORDER BY id";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, result.getId());
        rs = ps.executeQuery();
        while (rs.next()) {
            InetInterface iface = new InetInterface();
            iface.setDeviceTypeId(result.getId());
            iface.setId(rs.getInt(1));
            iface.setTitle(rs.getString(2));
            ifaceList.add(iface);
        }
        rs.close();
        ps.close();
        result.setInterfaceList(ifaceList);
        return result;
    }

    protected void updateImpl(InetDeviceType b) throws BGException, SQLException {
        boolean insert = b.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET entitySpecId=?, configId=?, config=?, saHandlerClass=?, protocolHandlerClass=?, deviceManagerClass=?, scriptId=?, title=?, comment=?, source=?, uniqueInterfaces=? " + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, b.getDeviceEntitySpecId());
            ps.setInt(2, b.getConfigId());
            ps.setString(3, b.getConfig());
            ps.setString(4, b.getSaHandlerClass());
            ps.setString(5, b.getProtocolHandlerClass());
            ps.setString(6, b.getDeviceManagerClass());
            ps.setInt(7, b.getScriptId());
            ps.setString(8, b.getTitle());
            ps.setString(9, b.getComment());
            ps.setBoolean(10, b.isSource());
            ps.setBoolean(11, b.isUniqueInterfaces());
            if (!insert) {
                ps.setInt(12, b.getId());
            }
            ps.executeUpdate();
            if (insert) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        ps = this.con.prepareStatement("DELETE FROM " + this.interfaceTable + " WHERE deviceTypeId=?");
        try {
            ps.setInt(1, b.getId());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        ps = this.con.prepareStatement("INSERT INTO " + this.interfaceTable + " SET deviceTypeId=?, id=?, title=?");
        try {
            ps.setInt(1, b.getId());
            for (InetInterface iface : b.getInterfaceList()) {
                ps.setInt(2, iface.getId());
                ps.setString(3, iface.getTitle());
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public int delete(int id) throws BGException {
        try {
            String query = "DELETE FROM " + this.interfaceTable + " WHERE deviceTypeId=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            return super.delete(id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

