/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.server.bean.InvDeviceDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.InetDeviceEntityAttrDaoSupport;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

class InetDeviceDao0
extends AbstractEntityDao<InetDevice> {
    private static final String ENTITY_TABLE_NAME = "invDevice";
    private Directory<InetDeviceType> deviceTypeDir;
    private InetDeviceType folderType = new InetDeviceType(0, "\u041f\u0430\u043f\u043a\u0430");
    private boolean loadDeviceGroupLink = true;
    private PreparedStatement getGroupsPS = null;
    private PreparedStatement getInetGroupsPS = null;

    public InetDeviceDao0(Connection con, int moduleId, int userId) throws BGException {
        super(con, moduleId, userId, "inet_device_tree", "inet_device", (EntityAttrDaoSupport)new InetDeviceEntityAttrDaoSupport());
        this.deviceTypeDir = ServerDirectoryFactory.newUnmodifiableDirectory(InetDeviceType.class, (Connection)con, (int)moduleId, (boolean)false);
    }

    protected void updateImpl(InetDevice b) throws BGException, SQLException {
        throw new UnsupportedOperationException();
    }

    protected InetDevice getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        if (this.loadDeviceGroupLink) {
            if (this.getGroupsPS == null) {
                this.getGroupsPS = this.con.prepareStatement("SELECT deviceGroupId FROM inv_device_group_link_" + this.moduleId + " WHERE deviceId=?");
            }
            if (this.getInetGroupsPS == null) {
                this.getInetGroupsPS = this.con.prepareStatement("SELECT deviceGroupId FROM inet_device_group_link_" + this.moduleId + " WHERE deviceId=?");
            }
        }
        InetDevice result = new InetDevice();
        InvDeviceDao.getFromRS((ResultSet)rs, this.deviceTypeDir, (DeviceType)this.folderType, (PreparedStatement)(this.loadDeviceGroupLink ? this.getGroupsPS : null), (Device)result);
        result.setInvDeviceId(result.getId());
        result.setInvDeviceTypeId(result.getDeviceTypeId());
        result.setInvTitle(result.getTitle());
        result.setInvIdentifier(result.getIdentifier());
        result.setInvHost(result.getHost());
        result.setInvConfig(result.getConfig());
        result.setInvDeviceGroupIds(result.getDeviceGroupIds());
        result.setId(rs.getInt("customId"));
        result.setSort(rs.getInt("customSort"));
        result.setParentId(rs.getInt("customParentId"));
        result.setDeviceTypeId(rs.getInt("customDeviceTypeId"));
        InetDeviceType deviceType = (InetDeviceType)this.deviceTypeDir.get(result.getDeviceTypeId());
        if (deviceType != null) {
            result.setEntitySpecId(deviceType.getDeviceEntitySpecId());
        }
        result.setIdentifier(rs.getString("customIdentifier"));
        result.setHost(rs.getString("customHost"));
        result.setConfig(rs.getString("customConfig"));
        result.setTitle(rs.getString("customTitle"));
        if (result.getTitle().equals(result.getInvTitle())) {
            result.setTitle(result.getInvTitle());
        }
        result.setSvlan((int)rs.getShort("svlan"));
        if (this.loadDeviceGroupLink) {
            HashSet<Integer> deviceGroupIds = new HashSet<Integer>();
            this.getInetGroupsPS.setInt(1, result.getId());
            ResultSet getGroupsRS = this.getInetGroupsPS.executeQuery();
            while (getGroupsRS.next()) {
                deviceGroupIds.add(getGroupsRS.getInt(1));
            }
            getGroupsRS.close();
            result.setDeviceGroupIds(deviceGroupIds);
        }
        return result;
    }

    protected InetDevice getTreeFromList(List<InetDevice> deviceList, int deviceId) {
        InetDevice root;
        HashMap<Integer, InetDevice> deviceMap = new HashMap<Integer, InetDevice>();
        if (deviceId > 0) {
            root = null;
        } else {
            root = new InetDevice();
            root.setId(0);
            deviceMap.put(root.getId(), root);
            root.setChildren(new ArrayList());
        }
        for (InetDevice d : deviceList) {
            deviceMap.put(d.getId(), d);
            d.setChildren(new ArrayList());
        }
        if (deviceId > 0) {
            for (InetDevice d : deviceList) {
                InetDevice parent;
                if (d.getId() == deviceId) {
                    root = d;
                }
                if ((parent = (InetDevice)deviceMap.get(d.getParentId())) == null) continue;
                parent.getChildren().add(d);
            }
        } else {
            for (InetDevice d : deviceList) {
                InetDevice parent = (InetDevice)deviceMap.get(d.getParentId());
                if (parent != null) {
                    parent.getChildren().add(d);
                    continue;
                }
                root.getChildren().add(d);
            }
        }
        return root;
    }

    private List<InetDevice> list0(DeviceTreeFilter deviceTreeFilter) throws BGException {
        ArrayList<CallSite> filter = new ArrayList<CallSite>();
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        if (!Utils.isBlankString((String)deviceTreeFilter.getIdentifier())) {
            filter.add((CallSite)((Object)("(invDevice.identifier LIKE ? OR " + this.tableName + ".identifier LIKE ?)")));
            params.add((CallSite)((Object)(deviceTreeFilter.getIdentifier() + "%")));
            params.add((CallSite)((Object)(deviceTreeFilter.getIdentifier() + "%")));
        }
        if (!Utils.isBlankString((String)deviceTreeFilter.getHost())) {
            filter.add((CallSite)((Object)("(invDevice.host LIKE ? OR " + this.tableName + ".host LIKE ?)")));
            params.add((CallSite)((Object)(deviceTreeFilter.getHost() + "%")));
            params.add((CallSite)((Object)(deviceTreeFilter.getHost() + "%")));
        }
        deviceTreeFilter.optDateFrom().ifPresent(a -> {
            filter.add((CallSite)((Object)"(invDevice.dateFrom IS NOT NULL AND invDevice.dateFrom>=?)"));
            params.add((CallSite)((Object)TimeUtils.convertDateToSqlDate((Date)a)));
        });
        deviceTreeFilter.optDateTo().ifPresent(a -> {
            filter.add((CallSite)((Object)"(invDevice.dateTo IS NOT NULL AND invDevice.dateTo<=?)"));
            params.add((CallSite)((Object)TimeUtils.convertDateToSqlDate((Date)a)));
        });
        deviceTreeFilter.optIntersectDateTo().ifPresent(a -> {
            filter.add((CallSite)((Object)"(invDevice.dateFrom IS NULL OR invDevice.dateFrom<=?)"));
            params.add((CallSite)((Object)TimeUtils.convertDateToSqlDate((Date)a)));
        });
        deviceTreeFilter.optIntersectDateFrom().ifPresent(a -> {
            filter.add((CallSite)((Object)"(invDevice.dateTo IS NULL OR invDevice.dateTo>=?)"));
            params.add((CallSite)((Object)TimeUtils.convertDateToSqlDate((Date)a)));
        });
        deviceTreeFilter.optDeviceTypeIds().filter(a -> a.size() != 1 || !a.contains(-1)).ifPresent(a -> filter.add((CallSite)((Object)("((" + this.tableName + ".deviceTypeId<=0 AND invDevice.deviceTypeId IN (" + Utils.toString((Iterable)a) + ")) OR (" + this.tableName + ".deviceTypeId>0 AND " + this.tableName + ".deviceTypeId IN (" + Utils.toString((Iterable)a) + ")))"))));
        deviceTreeFilter.optDeviceGroupIds().ifPresent(a -> filter.add((CallSite)((Object)("(deviceGroups.deviceGroupId IN (" + Utils.toString((Iterable)a) + ") OR customDeviceGroups.deviceGroupId IN (" + Utils.toString((Iterable)a) + "))"))));
        return this.list(true, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", " LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId" + (String)(deviceTreeFilter.getDeviceGroupIds() == null || deviceTreeFilter.getDeviceGroupIds().size() == 0 ? "" : " LEFT JOIN inv_device_group_link_" + this.moduleId + " as deviceGroups ON deviceGroups.deviceId=invDevice.id LEFT JOIN inet_device_group_link_" + this.moduleId + " as customDeviceGroups ON customDeviceGroups.deviceId=" + this.tableName + ".id"), deviceTreeFilter.getEntityFilter(), filter.stream().collect(Collectors.joining(" AND ")), this.tableName + ".id", "customSort, customId", params.toArray());
    }

    protected List<InetDevice> list(boolean loadAttributes, Page page, String what, String join, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        try {
            what = "SQL_CALC_FOUND_ROWS " + (String)(what == null ? this.tableName + ".*" : what) + ", entity.entitySpecId, entity.title as entityTitle";
            List result = this.listImpl(loadAttributes, page, (String)what, null, join, entityFilter, filter, groupBy, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    protected String getEntityTableName() {
        return this.tableName;
    }

    public InetDevice root(DeviceTreeFilter deviceTreeFilter, boolean loadAncestors) throws BGException {
        this.loadDeviceGroupLink = deviceTreeFilter.isLoadDeviceGroupLink();
        List<InetDevice> deviceList = this.list0(deviceTreeFilter);
        if (!(!Utils.isBlankString((String)deviceTreeFilter.getIdentifier()) || !Utils.isBlankString((String)deviceTreeFilter.getHost()) || deviceTreeFilter.getDeviceTypeIds() != null && deviceTreeFilter.getDeviceTypeIds().size() != 0 || deviceTreeFilter.getDeviceGroupIds() != null && deviceTreeFilter.getDeviceGroupIds().size() != 0 || deviceTreeFilter.getDateFrom() != null || deviceTreeFilter.getDateTo() != null || deviceTreeFilter.getIntersectDateFrom() != null || deviceTreeFilter.getIntersectDateTo() != null || deviceTreeFilter.getEntityFilter() != null && deviceTreeFilter.getEntityFilter().size() != 0)) {
            loadAncestors = false;
        }
        if (loadAncestors) {
            this.addParents(Id.newMap(deviceList), deviceList, deviceList, true);
        }
        InetDevice root = this.getTreeFromList(deviceList, -1);
        this.loadDeviceGroupLink = true;
        return root;
    }

    public InetDevice node(List<FilterEntityAttr> entityFilter, int deviceId, boolean loadDeviceGroupIds) throws BGException {
        this.loadDeviceGroupLink = loadDeviceGroupIds;
        List<InetDevice> deviceList = this.list0(new DeviceTreeFilter());
        InetDevice root = this.getTreeFromList(deviceList, deviceId);
        this.loadDeviceGroupLink = true;
        return root;
    }

    public InetDevice get(int id) throws BGException {
        List<InetDevice> result = this.list(true, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", "LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId", null, this.tableName + ".id=?", null, null, id);
        if (result.size() > 0) {
            InetDevice inetDevice = result.get(0);
            inetDevice.setEntityAttributes(this.getEntityAttributes(inetDevice.getEntitySpecId(), inetDevice.getId(), false));
            return inetDevice;
        }
        return null;
    }

    public InetDevice rootSource() throws BGException {
        return this.getTreeFromList(this.listSource(), -1);
    }

    public List<InetDevice> listSource() throws BGException {
        ArrayList<InetDevice> result = new ArrayList();
        this.loadDeviceGroupLink = false;
        result = this.list(false, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", "LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId LEFT JOIN inet_device_type_" + this.moduleId + " as type ON type.id=invDevice.deviceTypeId", null, "type.source=1", null, null, new Object[0]);
        this.addParents(Id.newMap(result), result, result, false);
        this.loadDeviceGroupLink = true;
        return result;
    }

    private void addParents(Map<Integer, InetDevice> map, List<InetDevice> list, List<InetDevice> result, boolean check) throws BGException {
        if (list.size() == 0) {
            return;
        }
        StringBuilder ids = new StringBuilder();
        ArrayList<InetDevice> newList = new ArrayList<InetDevice>();
        for (InetDevice inetDevice : list) {
            if (inetDevice.getParentId() <= 0) continue;
            InetDevice mapInetDevice = map.get(inetDevice.getParentId());
            if (mapInetDevice != null) {
                newList.add(mapInetDevice);
                continue;
            }
            if (map.containsKey(inetDevice.getParentId())) continue;
            ids.append(inetDevice.getParentId());
            ids.append(',');
        }
        if (ids.length() == 0) {
            this.addParents(map, newList, result, check);
            return;
        }
        ids.setLength(ids.length() - 1);
        List<InetDevice> parentList = this.list(true, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", "LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId", null, this.tableName + ".id IN (" + ids.toString() + ")", null, null, new Object[0]);
        for (InetDevice parent : parentList) {
            if (check) {
                parent.setEntityId(-100);
            }
            map.put(parent.getId(), parent);
        }
        newList.addAll(parentList);
        result.addAll(parentList);
        this.addParents(map, newList, result, check);
    }

    public List<InetDevice> listByInvDeviceId(int id) throws BGException {
        return this.list(true, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", "LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId", null, this.tableName + ".invDeviceId=?", null, null, id);
    }

    public List<InetDevice> inetDeviceList(int deviceTypeId) throws BGException {
        return this.list(true, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", "LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId", null, "IF(" + this.tableName + ".deviceTypeId>=0," + this.tableName + ".deviceTypeId,invDevice.deviceTypeId)=?", null, null, deviceTypeId);
    }

    public List<InetDevice> inetDeviceList() throws BGException {
        return this.list(true, null, "invDevice.*, " + this.tableName + ".id as customId, " + this.tableName + ".sort as customSort, " + this.tableName + ".parentId as customParentId, " + this.tableName + ".deviceTypeId as customDeviceTypeId, " + this.tableName + ".identifier as customIdentifier, " + this.tableName + ".host as customHost, " + this.tableName + ".config as customConfig, " + this.tableName + ".title as customTitle, " + this.tableName + ".svlan as svlan", "LEFT JOIN inv_device_" + this.moduleId + " as invDevice ON invDevice.id=" + this.tableName + ".invDeviceId LEFT JOIN entity ON entity.id=invDevice.entityId", null, null, null, "customSort, customId", new Object[0]);
    }
}

