/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSetRealmMap;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuleRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.MacrosFormat;
import ru.bitel.common.util.StringCache;

public class InetUtils {
    private static final Logger logger = LogManager.getLogger();
    private static final StringCache REALM_CACHE = new StringCache(32, new String[]{"", "default", "local", "inet"});
    private static final StringCache SERVICE_NAME_CACHE = new StringCache(128);
    private static final byte BYTE_FF = -1;
    private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-]+");

    public static long dateFrom(Date dateFrom, Calendar utilCalendar) {
        if (dateFrom == null) {
            return 0L;
        }
        utilCalendar.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
        return utilCalendar.getTimeInMillis();
    }

    public static long dateTo(Date dateTo, Calendar utilCalendar) {
        if (dateTo == null) {
            return 0L;
        }
        utilCalendar.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
        utilCalendar.add(5, 1);
        utilCalendar.add(14, -1);
        return utilCalendar.getTimeInMillis();
    }

    public static long dateFrom(Calendar dateFrom) {
        if (dateFrom == null) {
            return 0L;
        }
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)dateFrom);
        return dateFrom.getTimeInMillis();
    }

    public static long dateTo(Calendar dateTo) {
        if (dateTo == null) {
            return 0L;
        }
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)dateTo);
        dateTo.add(5, 1);
        dateTo.add(14, -1);
        return dateTo.getTimeInMillis();
    }

    public static final Long getHour(long millis) {
        return millis / 3600000L * 3600000L;
    }

    public static boolean awaitTermination(ScheduledExecutorService scheduledExecutorService, String name, long seconds) throws InterruptedException {
        while (seconds > 0L) {
            if (scheduledExecutorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                return true;
            }
            logger.info("Await termination for task \"" + name + "\" (" + seconds + " sec)");
            --seconds;
        }
        return false;
    }

    public static String getRealm(String username) {
        if (username == null) {
            return null;
        }
        int pos = username.indexOf(64);
        if (pos > 0) {
            return REALM_CACHE.intern(username.substring(pos + 1));
        }
        return "default";
    }

    public static String internRealm(String realm) {
        return REALM_CACHE.intern(realm);
    }

    public static String internServiceName(String realm) {
        return SERVICE_NAME_CACHE.intern(realm);
    }

    public static Map<Integer, AccountingTrafficAmount> getCounterTraffics(InetServRuntime inetServRuntime, InetConnectionCallRuntime parentConnectionCallRuntime, InetConnection connection, RadiusPacket request) {
        String acctService;
        String realm;
        logger.trace("getCounterTraffics( InetServRuntime, InetConnectionCallRuntime, InetConnection, RadiusPacket )");
        InetServTypeRuntime inetServType = inetServRuntime.inetServTypeRef.get();
        TrafficTypeLinkRuntime trafficTypeLink = inetServType.trafficTypeLinkRuntimeRef.get();
        if (logger.isTraceEnabled()) {
            logger.trace("inetServTypeRuntime.inetServType.getId() = " + inetServType.inetServType.getId());
            if (trafficTypeLink != null) {
                logger.trace("trafficTypeLinkRuntime.counterTrafficTypes = " + Utils.toString(trafficTypeLink.counterTrafficTypes));
            }
        }
        if (parentConnectionCallRuntime != null) {
            realm = parentConnectionCallRuntime.realm;
            acctService = connection.getUsername();
        } else {
            realm = InetUtils.getRealm(connection.getUsername());
            acctService = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("parentConnectionCallRuntime = " + parentConnectionCallRuntime);
            logger.trace("realm = " + realm + "; acctService = " + acctService);
        }
        Map<Integer, AccountingTrafficAmount> result = InetUtils.getCounterTraffics(trafficTypeLink, request, realm, acctService);
        int sessionTimeInt = request.getIntAttribute(-1, 46, Integer.valueOf(-1));
        if (sessionTimeInt != -1) {
            long sessionTime = (long)sessionTimeInt & 0xFFFFFFFFL;
            result.put(TrafficType.TIME_ID, new AccountingTrafficAmount(sessionTime));
        }
        if (logger.isTraceEnabled()) {
            for (Map.Entry<Integer, AccountingTrafficAmount> entry : result.entrySet()) {
                logger.trace("\t" + entry.getKey() + " = " + entry.getValue());
            }
        }
        return result;
    }

    public static Map<Integer, AccountingTrafficAmount> getCounterTraffics(InetConnectionCallRuntime connectionCallRuntime, RadiusPacket request) {
        String acctService;
        String realm;
        logger.trace("getCounterTraffics( InetConnectionCallRuntime, RadiusPacket )");
        InetServTypeRuntime inetServType = connectionCallRuntime.inetServRuntime.inetServTypeRef.get();
        TrafficTypeLinkRuntime trafficTypeLink = inetServType.trafficTypeLinkRuntimeRef.get();
        if (connectionCallRuntime.isServiceSession()) {
            realm = connectionCallRuntime.getParentConnectionCallRuntime().realm;
            acctService = connectionCallRuntime.getUserName();
        } else {
            realm = connectionCallRuntime.realm;
            acctService = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("connectionCallRuntime.isServiceSession() = " + connectionCallRuntime.isServiceSession());
            logger.trace("realm = " + realm + "; acctService = " + acctService);
        }
        Map<Integer, AccountingTrafficAmount> result = InetUtils.getCounterTraffics(trafficTypeLink, request, realm, acctService);
        int sessionTimeInt = request.getIntAttribute(-1, 46, Integer.valueOf(-1));
        if (sessionTimeInt != -1) {
            long sessionTime = (long)sessionTimeInt & 0xFFFFFFFFL;
            result.put(TrafficType.TIME_ID, new AccountingTrafficAmount(sessionTime));
        }
        if (logger.isTraceEnabled()) {
            for (Map.Entry<Integer, AccountingTrafficAmount> entry : result.entrySet()) {
                logger.trace("\tTrafficType(ID#{}) = {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return result;
    }

    private static void addTrafficAmount(Map<Integer, AccountingTrafficAmount> result, Integer trafficTypeId, long amount) {
        AccountingTrafficAmount trafficAmount = result.get(trafficTypeId);
        if (trafficAmount != null) {
            trafficAmount.amount += amount;
        } else {
            result.put(trafficTypeId, new AccountingTrafficAmount(amount));
        }
    }

    public static Map<Integer, AccountingTrafficAmount> getCounterTraffics(TrafficTypeLinkRuntime link, RadiusPacket packet, String realm, String acctService) {
        logger.trace("getCounterTraffics( {}, {}, {}, {} )", (Object)link, (Object)packet, (Object)realm, (Object)acctService);
        HashMap<Integer, AccountingTrafficAmount> result = new HashMap<Integer, AccountingTrafficAmount>();
        TrafficTypeLinkRuleRuntime[] rules = link.trafficTypeLinkRulesCounter;
        int lastVendor = -100;
        int lastType = -100;
        List lastRaList = null;
        if ("".equals(acctService)) {
            acctService = null;
        }
        if (Utils.isEmptyString((String)realm)) {
            realm = "default";
        }
        for (TrafficTypeLinkRuleRuntime rule : rules) {
            List raList;
            if (rule.counterRealmPattern == null ? !rule.counterRealm.contains(realm) : !rule.counterRealmPattern.matcher(realm).matches()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("acctService = " + acctService);
            }
            if (acctService != null ? (rule.counterService == null || !rule.counterService.contains(acctService)) && (rule.counterServicePattern == null || !rule.counterServicePattern.matcher(acctService).matches()) : rule.counterService != null || rule.counterServicePattern != null) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("rule.counterVendor = " + rule.counterVendor);
                logger.trace("rule.trafficTypeId = " + rule.trafficTypeId);
            }
            if (rule.counterVendor == -2) {
                switch (rule.counterType) {
                    case 1: {
                        long outputOctets = InetUtils.getOutputOctets(packet);
                        if (logger.isTraceEnabled()) {
                            logger.trace("outputOctets = " + outputOctets);
                        }
                        InetUtils.addTrafficAmount(result, rule.trafficTypeId, outputOctets);
                        break;
                    }
                    case 2: {
                        long inputOctets = InetUtils.getInputOctets(packet);
                        if (logger.isTraceEnabled()) {
                            logger.trace("inputOctets = " + inputOctets);
                        }
                        InetUtils.addTrafficAmount(result, rule.trafficTypeId, inputOctets);
                        break;
                    }
                }
                continue;
            }
            if (lastVendor == rule.counterVendor && lastType == rule.counterType) {
                raList = lastRaList;
            } else {
                lastVendor = rule.counterVendor;
                lastType = rule.counterType;
                lastRaList = raList = packet.getAttributes(rule.counterVendor, rule.counterType);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("raList = " + raList);
            }
            if (raList == null) continue;
            int jsize = raList.size();
            block10: for (int j = 0; j < jsize; ++j) {
                RadiusAttribute ra = (RadiusAttribute)raList.get(j);
                if (logger.isTraceEnabled()) {
                    logger.trace("ra.info.valueType = " + ((RadiusAttributeInfo)ra.info).valueType);
                }
                switch (((RadiusAttributeInfo)ra.info).valueType) {
                    case 4: {
                        long trafficAmount = ((Integer)ra.getValue()).intValue();
                        if (logger.isTraceEnabled()) {
                            logger.trace("trafficAmount(int) = " + trafficAmount);
                        }
                        if (trafficAmount <= 0L) continue block10;
                        InetUtils.addTrafficAmount(result, rule.trafficTypeId, trafficAmount);
                        continue block10;
                    }
                    case 3: {
                        long trafficAmount = (Long)ra.getValue();
                        if (logger.isTraceEnabled()) {
                            logger.trace("trafficAmount(long) = " + trafficAmount);
                        }
                        if (trafficAmount <= 0L) continue block10;
                        InetUtils.addTrafficAmount(result, rule.trafficTypeId, trafficAmount);
                        continue block10;
                    }
                    case 2: {
                        String value = (String)ra.getValue();
                        if (logger.isTraceEnabled()) {
                            logger.trace("value = " + value);
                        }
                        if (rule.counterPrefix != null && !value.startsWith(rule.counterPrefix)) continue block10;
                        value = value.substring(rule.counterPrefix.length() + 1).trim();
                        long trafficAmount = Utils.parseLong((String)value);
                        if (logger.isTraceEnabled()) {
                            logger.trace("trafficAmount(string) = " + trafficAmount);
                        }
                        if (trafficAmount <= 0L) continue block10;
                        InetUtils.addTrafficAmount(result, rule.trafficTypeId, trafficAmount);
                        continue block10;
                    }
                    default: {
                        logger.error("Radius attribute " + rule.counterVendor + ":" + rule.counterType + " not int or string attribute!");
                    }
                }
            }
        }
        return result;
    }

    public static final long getInputOctets(RadiusPacket packet) {
        long inputOctets = packet.getIntAttribute(-1, 52, Integer.valueOf(0)).intValue();
        inputOctets = (inputOctets << 32) + ((long)packet.getIntAttribute(-1, 42, Integer.valueOf(0)).intValue() & 0xFFFFFFFFL);
        return inputOctets;
    }

    public static final long getOutputOctets(RadiusPacket packet) {
        long outputOctets = packet.getIntAttribute(-1, 53, Integer.valueOf(0)).intValue();
        outputOctets = (outputOctets << 32) + ((long)packet.getIntAttribute(-1, 43, Integer.valueOf(0)).intValue() & 0xFFFFFFFFL);
        return outputOctets;
    }

    public static int getSessionCountLimit(InetServType inetServType, InetServ inetServ) {
        if (inetServType.isSessionCountLimitLock()) {
            return inetServType.getSessionCountLimit();
        }
        return inetServ.getSessionCountLimit();
    }

    public static <A> boolean checkSessionCountLimit(List<A> connectionList, Function<A, InetConnection> converter, boolean alive, int sessionCountLimit) {
        if (connectionList == null) {
            return true;
        }
        int count = !alive ? 1 : 0;
        int size = connectionList.size();
        for (int i = 0; i < size; ++i) {
            InetConnection connection = converter.apply(connectionList.get(i));
            if (connection.getConnectionStatus() != 1 || connection.getDeviceState() != InetServState.STATE_ENABLE.getCode() || connection.getParentConnectionId() > 0L || ++count <= sessionCountLimit) continue;
            logger.info("Alive session count " + count + ">" + sessionCountLimit);
            return false;
        }
        return true;
    }

    public static InetConnection getConnection(Connection con, int moduleId, long connectionId, Date connectionStart) throws BGException {
        Object[] result = InetUtils.getConnectionAndLastSessionLog(con, moduleId, connectionId, connectionStart);
        if (result != null) {
            return (InetConnection)result[0];
        }
        return null;
    }

    public static Object[] getConnectionAndLastSessionLog(Connection con, int moduleId, long connectionId, Date connectionStart) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(connectionStart);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        calendar.set(5, 1);
        InetConnection result = null;
        Date timeFrom = null;
        Date timeTo = null;
        InetSessionLog lastSessionLog = null;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)calendar.getTime());
            }
            InetSessionLogDao inetSessionDao = new InetSessionLogDao(con, moduleId, calendar.getTime());
            try {
                List<InetSessionLog> sessionList = inetSessionDao.list(connectionId);
                if (sessionList.size() == 0) break;
                for (InetSessionLog session : sessionList) {
                    if (result == null) {
                        result = new InetConnection(session);
                        result.setConnectionStop(session.getSessionStop());
                    }
                    if (timeFrom == null || timeFrom.after(session.getSessionStart())) {
                        timeFrom = session.getSessionStart();
                    }
                    if (timeTo == null || timeTo.before(session.getSessionStop())) {
                        timeTo = session.getSessionStop();
                    }
                    lastSessionLog = session;
                }
                ((Calendar)calendar).add(2, 1);
                if (timeTo == null || calendar.getTimeInMillis() - 1000L <= timeTo.getTime()) continue;
            }
            finally {
                inetSessionDao.close();
                continue;
            }
            break;
        }
        InetConnectionDao connectionDao = new InetConnectionDao(con, moduleId);
        InetConnection connection = connectionDao.get(connectionId);
        if (connection != null) {
            if (result == null) {
                result = connection;
            }
            Date date = timeTo = connection.getConnectionStop() != null ? connection.getConnectionStop() : new Date();
        }
        if (result != null && timeFrom != null) {
            result.setConnectionStart(timeFrom);
        }
        if (result != null && timeTo != null) {
            result.setConnectionStop(timeTo);
        }
        if (result != null) {
            return new Object[]{result, lastSessionLog};
        }
        return null;
    }

    public static long roundToSeconds(long millis) {
        return millis / 1000L * 1000L;
    }

    public static int parseInt(byte[] data, int pos, int length) {
        int maxLength = data.length - pos;
        if (length > maxLength) {
            length = maxLength;
        }
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                return data[pos] & 0xFF;
            }
            case 2: {
                return (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
            }
            case 3: {
                return (data[pos] & 0xFF) << 16 | (data[pos + 1] & 0xFF) << 8 | data[pos + 2] & 0xFF;
            }
        }
        return (data[pos] & 0xFF) << 24 | (data[pos + 1] & 0xFF) << 16 | (data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF;
    }

    private static boolean isFF(byte[] servMacAddress) {
        int size = servMacAddress.length;
        for (int i = 0; i < size; ++i) {
            if (servMacAddress[i] == -1) continue;
            return false;
        }
        return true;
    }

    public static Boolean checkMacAddress(InetServ inetServ, byte[] macAddress) {
        List servMacAddressList = inetServ.getMacAddressList();
        if (servMacAddressList != null && servMacAddressList.size() > 0) {
            int size = servMacAddressList.size();
            for (int i = 0; i < size; ++i) {
                byte[] servMacAddress = (byte[])servMacAddressList.get(i);
                if (!Arrays.equals(macAddress, servMacAddress) && !InetUtils.isFF(servMacAddress)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean checkIdentifier(InetServ inetServ, String identifier) {
        List servIdentifierList = inetServ.getIdentifierList();
        if (servIdentifierList != null && servIdentifierList.size() > 0) {
            int size = servIdentifierList.size();
            for (int i = 0; i < size; ++i) {
                String servIdentifier = (String)servIdentifierList.get(i);
                if (!identifier.equals(servIdentifier) && !"*".equals(servIdentifier)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public static RadiusAttributeSetRealmMap newRadiusAttributeSetRealmMap(ConnectionSet connectionSet, int moduleId, ParameterMap deviceConfig, String prefix) throws BGException {
        InetOptionRuntimeMap optionRuntimeMap = InetOptionRuntimeMap.getInstance(connectionSet, moduleId);
        return InetUtils.newRadiusAttributeSetRealmMap(optionRuntimeMap, deviceConfig, prefix);
    }

    public static RadiusAttributeSetRealmMap newRadiusAttributeSetRealmMap(int moduleId, ParameterMap deviceConfig, String prefix) throws BGException {
        InetOptionRuntimeMap optionRuntimeMap = InetOptionRuntimeMap.getInstance(moduleId);
        return InetUtils.newRadiusAttributeSetRealmMap(optionRuntimeMap, deviceConfig, prefix);
    }

    @Deprecated
    public static RadiusAttributeSetRealmMap newRadiusAttributeSetRealmMap(ParameterMap deviceConfig, String prefix) throws BGException {
        InetOptionRuntimeMap optionRuntimeMap = InetOptionRuntimeMap.getInstance();
        return InetUtils.newRadiusAttributeSetRealmMap(optionRuntimeMap, deviceConfig, prefix);
    }

    private static RadiusAttributeSetRealmMap newRadiusAttributeSetRealmMap(InetOptionRuntimeMap optionRuntimeMap, ParameterMap deviceConfig, String prefix) throws BGException {
        RadiusAttributeSetRealmMap result = new RadiusAttributeSetRealmMap(new HashMap());
        for (Map.Entry<Integer, InetOptionRuntime> entry : optionRuntimeMap.getMap().entrySet()) {
            Map.Entry templateEntry22;
            int option = entry.getKey();
            InetOptionRuntime optionRuntime = entry.getValue();
            HashMap<String, String> templateMap = new HashMap<String, String>();
            InetUtils.templates(templateMap, deviceConfig, optionRuntime, prefix, "template");
            for (Map.Entry templateEntry22 : templateMap.entrySet()) {
                String optionRadiusAttributes = new Macros((String)templateEntry22.getValue()).format(new StringBuffer(30), optionRuntime.inheritedConfig).toString();
                if (!Utils.notBlankString((String)optionRadiusAttributes)) continue;
                result.add((String)templateEntry22.getKey(), Integer.valueOf(option), RadiusAttributeSet.getRadiusAttributeSet((String)optionRadiusAttributes), false);
            }
            Map realmMap = RadiusAttributeSet.newRadiusAttributeRealmMap((ParameterMap)optionRuntime.inheritedConfig, (String)"radius.realm", (String)"attributes");
            templateEntry22 = realmMap.entrySet().iterator();
            while (templateEntry22.hasNext()) {
                Map.Entry realmEntry = (Map.Entry)templateEntry22.next();
                result.add((String)realmEntry.getKey(), Integer.valueOf(option), (RadiusAttributeSet)realmEntry.getValue(), false);
            }
            String disableRadiusAttributesString = deviceConfig.get("radius.disable.attributes", null);
            if (!Utils.notBlankString((String)disableRadiusAttributesString)) continue;
            result.add("disable", Integer.valueOf(option), RadiusAttributeSet.getRadiusAttributeSet((String)disableRadiusAttributesString), false);
        }
        for (Map.Entry<Integer, InetOptionRuntime> entry : deviceConfig.subIndexed(prefix).entrySet()) {
            Integer option = entry.getKey();
            for (Map.Entry ee : ((ParameterMap)entry.getValue()).subKeyed("").entrySet()) {
                String key2 = (String)ee.getKey();
                if ("template".equals(key2) || "ipPool".equals(key2)) continue;
                if ("attributes".equals(key2)) {
                    result.add("default", option, RadiusAttributeSet.getRadiusAttributeSet((String)((ParameterMap)ee.getValue()).get("", null)), true);
                    continue;
                }
                result.add(key2, option, RadiusAttributeSet.getRadiusAttributeSet((String)((ParameterMap)ee.getValue()).get("attributes", null)), true);
            }
        }
        return result;
    }

    private static void templates(Map<String, String> result, ParameterMap deviceConfig, InetOptionRuntime optionRuntime, String prefix, String param) {
        for (Map.Entry ee : deviceConfig.subKeyed(prefix + (String)(optionRuntime.id > 0 ? optionRuntime.id + "." : "")).entrySet()) {
            String value;
            String key2 = (String)ee.getKey();
            if (param.equals(key2)) {
                if (result.containsKey("default")) continue;
                result.put("default", ((ParameterMap)ee.getValue()).get("", null));
                continue;
            }
            if (result.containsKey(key2) || Utils.isBlankString((String)(value = ((ParameterMap)ee.getValue()).get(param, null)))) continue;
            result.put(key2, value);
        }
        if (optionRuntime.getParent() != null) {
            InetUtils.templates(result, deviceConfig, optionRuntime.getParent(), prefix, param);
        }
    }

    public static int[][] parseSearchModes(String value) {
        List servSearchModeList = Utils.toList((String)value);
        int[][] result = new int[servSearchModeList.size()][];
        int size = servSearchModeList.size();
        for (int i = 0; i < size; ++i) {
            result[i] = new int[2];
            String[] params = ((String)servSearchModeList.get(i)).split("\\s*\\-\\s*");
            if (params.length > 1) {
                result[i][1] = Utils.parseInt((String)params[1], (int)0);
            }
            result[i][0] = Utils.parseInt((String)params[0], (int)0);
        }
        return result;
    }

    public static int getAccountingRootDeviceId(int moduleId, Set<Integer> accountingDeviceTypeIds, int deviceId) throws BGException {
        if (accountingDeviceTypeIds.size() == 0) {
            return -1;
        }
        InetDeviceMap deviceMap = InetDeviceMap.getInstance(moduleId);
        InetDeviceMap.InetDeviceMapItem device = deviceMap.get(deviceId);
        if (device == null) {
            return 0;
        }
        if ((device = device.findRoot(accountingDeviceTypeIds)) == null) {
            return 0;
        }
        return device.getDevice().getId();
    }

    public static int getAccountingRootDeviceId(Setup setup, int moduleId, int deviceId) throws BGException {
        String accountingDeviceTypeIdsString = setup.get("accounting.deviceTypeIds", "");
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup != null) {
            accountingDeviceTypeIdsString = moduleSetup.get("accounting.deviceTypeIds", accountingDeviceTypeIdsString);
        }
        return InetUtils.getAccountingRootDeviceId(moduleId, Utils.toIntegerSet((String)accountingDeviceTypeIdsString), deviceId);
    }

    public static boolean checkAccountingRootDeviceId(Setup setup, int moduleId) {
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup == null) {
            return false;
        }
        String accountingDeviceTypeIdsString = moduleSetup.get("accounting.deviceTypeIds", "");
        Set accountingDeviceTypeIds = Utils.toIntegerSet((String)accountingDeviceTypeIdsString);
        return accountingDeviceTypeIds.size() != 0;
    }

    public static int getConnectionType(InetConnection connection) {
        int type = connection.getType();
        if ((type & 0xC00) == 3072) {
            return 3072;
        }
        if ((type & 0x400) != 0) {
            return 1024;
        }
        if ((type & 0x800) != 0) {
            return 2048;
        }
        if ((type & 0x6200) == 25088) {
            return 25088;
        }
        if ((type & 0x2000) != 0) {
            return 8704;
        }
        if ((type & 0x4000) != 0) {
            return 16896;
        }
        String username = connection.getUsername();
        if (Utils.notEmptyString((String)username)) {
            if (Character.isDigit(username.charAt(0)) && username.length() <= 15 && username.indexOf(46) > 0 && IPUtils.convertStringIPtoLong((String)username) > 0L) {
                return 4608;
            }
            return 512;
        }
        if (Utils.isEmptyString((String)connection.getAcctSessionId())) {
            return 256;
        }
        byte[] address = connection.getInetAddressBytes();
        if (address != null) {
            if (address.length == 4) {
                return 1024;
            }
            return 2048;
        }
        return 512;
    }

    public static boolean checkAliveAndType(InetConnection connection, boolean checkDeviceState, int type) {
        if (connection.getConnectionStatus() != 1 || connection.getParentConnectionId() > 0L) {
            return false;
        }
        if (checkDeviceState && connection.getDeviceState() != InetServState.STATE_ENABLE.getCode()) {
            return false;
        }
        int connectionType = InetUtils.getConnectionType(connection);
        if ((connectionType & type) == 0) {
            return false;
        }
        if ((connectionType & 0x2000) != 0 && (type & 0x2000) == 0) {
            return false;
        }
        return (connectionType & 0x4000) == 0 || (type & 0x4000) != 0;
    }

    public static long macAddressToLong(byte[] mac) {
        if (mac == null) {
            return 0L;
        }
        return 0xFFL & (long)mac[5] | 0xFF00L & (long)(mac[4] << 8) | 0xFF0000L & (long)(mac[3] << 16) | (0xFFL & (long)mac[2]) << 24 | (0xFFL & (long)mac[1]) << 32 | (0xFFL & (long)mac[0]) << 40;
    }

    public static long macAddressToLong(String macAddress) {
        if (Utils.isBlankString((String)macAddress)) {
            return 0L;
        }
        macAddress = macClearPattern.matcher(macAddress).replaceAll("");
        try {
            return Long.parseLong(macAddress, 16);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static byte[] parseMacAddress(String macAddress) {
        if (Utils.isBlankString((String)macAddress)) {
            return null;
        }
        if (macAddress.charAt(1) == ':' || macAddress.charAt(2) == ':') {
            return InetUtils.semicolonedMacToBytes(macAddress);
        }
        macAddress = macClearPattern.matcher(macAddress).replaceAll("");
        return InetUtils.toBytes(macAddress);
    }

    public static String macAddressToString(byte[] macAddress) {
        if (macAddress == null || macAddress.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(macAddress.length * 3);
        int size = macAddress.length;
        for (int i = 0; i < size; ++i) {
            sb.append(Utils.HEX[(macAddress[i] & 0xF0) >> 4]);
            sb.append(Utils.HEX[macAddress[i] & 0xF]);
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static byte[] toBytes(String s) {
        byte[] result;
        int i;
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        if (size % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size / 2 + 1];
            int digit2 = Character.digit(s.charAt(0), 16);
            result[0] = (byte)digit2;
        }
        while (i < size) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    private static byte[] semicolonedMacToBytes(String s) {
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        int i = 0;
        int j = 0;
        byte[] result = new byte[6];
        while (i < size && j < 6) {
            if (s.charAt(i) == ':') {
                ++i;
                continue;
            }
            int digit1 = Character.digit(s.charAt(i++), 16);
            if (i >= size || s.charAt(i) == ':') {
                result[j++] = (byte)digit1;
                continue;
            }
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    static final class Macros
    extends MacrosFormat {
        private final String patternString;

        Macros(String pattern) {
            this.patternString = pattern;
        }

        public StringBuffer format(StringBuffer appendable, Object ... globalArgs) {
            try {
                return super.format(appendable, this.patternString, globalArgs);
            }
            catch (Exception ex) {
                return appendable.append(ex.getMessage());
            }
        }

        protected Object invoke(String macros, Object[] args, Object[] globalArgs) {
            ParameterMap conf = (ParameterMap)globalArgs[0];
            return conf.get(macros, "");
        }
    }
}

