/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import bitel.billing.server.util.ConsoleTable;
import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.naming.NamingException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.AccountingCommands;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionMapAuto;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionMapCall;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceMap;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.apps.inet.accounting.InetAccountingManageWorker;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionCleanWorker;
import ru.bitel.bgbilling.apps.inet.accounting.SessionFlushingManager;
import ru.bitel.bgbilling.apps.inet.accounting.SessionTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.bean.SessionState;
import ru.bitel.bgbilling.apps.inet.accounting.detail.FlowExport;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManageEvent;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetAccountingManagePoolEvent;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.InetLogProccessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.InetLogProcessListener;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.RequestLogInfoEventProcessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.InetCreateSessionProcessor;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.InetRecalculateEventProcessor;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerSet;
import ru.bitel.bgbilling.apps.inet.accounting.worker.SessionFlushingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.ExecutorEventWorker;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetConnectionCommandEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaAccountingEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetDeviceStateAndOptionsDatabaseWorker;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.ConcurrentUtils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanOperation;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.AverageCounter;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDynSubscriptionDao;

public class Accounting
extends InetApplication
implements EventListener<Event>,
CommandListener,
ExtendedLifecycle {
    private static final Logger logger = LogManager.getLogger();
    private final EventProcessor eventProcessor = EventProcessor.getInstance();
    public final ContractRuntimeMap contractRuntimeMap;
    public final InetServRuntimeMap inetServRuntimeMap;
    public final PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;
    public final PoolEventPublisher<TrafficRangeEvent> trafficRangeEP;
    public final PoolEventPublisher<TrafficMaxEvent> trafficMaxEP;
    public final FlowAgentInterfaceMap ifaceMap;
    public ConnectionMapCall connectionMapCall;
    public ConnectionMapAuto connectionMapAuto;
    public volatile boolean servCheckOptions = true;
    public volatile boolean flushAtStop = false;
    private AccountingWorkerSet accountingWorkerSet;
    private boolean logProccessStopped = true;
    private boolean workersStopped = true;
    private boolean needServRuntimeMapLoad = true;
    private boolean startedForLogProcessing = false;
    private boolean processLogs = true;
    public volatile boolean skipFlushZeroCostAccount;
    private final FrequencyCounter connectionAutoStartPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final FrequencyCounter connectionAutoStopPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter connectionCallStartSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter connectionCallStartMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter connectionCallStopSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter connectionCallStopMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter connectionCallServiceStartSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter connectionCallServiceStartMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter connectionCallServiceStopSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter connectionCallServiceStopMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    private SessionCleanWorker sessionCleanWorker;
    private ExecutorEventWorker.ContractExecutorEventWorker accountingManageWorker;
    private volatile InetLogProccessor logProcessor;
    private volatile InetCreateSessionProcessor logSessionCreateProcessor;

    @ConstructorProperties(value={"setup"})
    public Accounting(Setup setup) throws BGException {
        this(setup, -1, true, false, new Date(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConstructorProperties(value={"setup"})
    public Accounting(Setup setup, int rootDeviceId, boolean realtime, boolean startedForLogProcessing, Date dateFrom, InetServRuntimeMap inetServRuntimeMap, Set<Integer> contractIds) throws BGException {
        super(realtime, setup, SetupParam.getApplicationId((ParameterMap)setup), SetupParam.getModuleId((ParameterMap)setup), false, rootDeviceId, dateFrom);
        this.startedForLogProcessing = startedForLogProcessing;
        this.processLogs = setup.getBoolean("processLogs", true);
        this.accountingWorkerSet = new AccountingWorkerSet(this);
        if (realtime || startedForLogProcessing) {
            if (realtime) {
                EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, this.moduleId, null);
            }
            this.ifaceMap = new FlowAgentInterfaceMap(this);
        } else {
            this.ifaceMap = null;
        }
        Connection con = setup.getDBConnectionFromPool();
        try {
            this.balanceEP = EventProcessor.getInstance().newPoolEventPublisher(ContractBalanceChangedEvent.class, 0, 500, 1000L);
            this.trafficRangeEP = EventProcessor.getInstance().newPoolEventPublisher(TrafficRangeEvent.class, this.moduleId, 2000, 2000L);
            this.trafficMaxEP = EventProcessor.getInstance().newPoolEventPublisher(TrafficMaxEvent.class, this.moduleId, 2000, 2000L);
            this.contractRuntimeMap = new ContractRuntimeMap(this.initialDate, realtime);
            if (inetServRuntimeMap == null) {
                this.inetServRuntimeMap = new InetServRuntimeMap(this, this.contractRuntimeMap, con, dateFrom, contractIds);
            } else {
                this.needServRuntimeMapLoad = false;
                this.inetServRuntimeMap = inetServRuntimeMap;
            }
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        this.initConnectionMaps(realtime);
    }

    protected void initConnectionMaps(boolean realtime) throws BGException {
        if (realtime) {
            this.connectionMapCall = new ConnectionMapCall(this);
            this.connectionMapAuto = new ConnectionMapAuto(this);
        } else {
            this.connectionMapCall = null;
            this.connectionMapAuto = null;
        }
    }

    @Override
    public ContractRuntimeMap getContractRuntimeMap() {
        return this.contractRuntimeMap;
    }

    @Override
    public InetServRuntimeMap getInetServRuntimeMap() {
        return this.inetServRuntimeMap;
    }

    SessionCleanWorker getSessionCleanWorker() {
        return this.sessionCleanWorker;
    }

    @Override
    public void init() throws Exception {
        if (this.realtime) {
            try {
                this.fixSequence();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.initImpl();
        } else {
            ServerContext context = new ServerContext(this.setup, this.moduleId, 0);
            ThreadContext parent = ThreadContext.push((ThreadContext)context);
            try {
                this.initImpl();
                context.commit();
            }
            finally {
                ThreadContext.pop((ThreadContext)context, (ThreadContext)parent);
            }
        }
    }

    @Override
    public void start() throws Exception {
        if (!this.realtime) {
            this.init();
        }
        super.start();
        if (this.realtime) {
            if (this.accountingManageWorker != null) {
                this.accountingManageWorker.start();
            }
            if (this.setup.getModuleSetup(Integer.valueOf(this.moduleId)).getBoolean("accounting.accountingEventFix", true)) {
                EventProcessor.getInstance().addListener((EventListener)this, InetAccountingEvent.class, this.moduleId, null);
            }
        }
    }

    private void fixSequence() throws SQLException {
        ServerContext ctx = (ServerContext)ThreadContext.get();
        Connection con = ctx.getConnection();
        InetSessionLogDao.fixSequence(con, this.moduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImpl() throws Exception {
        InetDeviceRuntime rootDevice;
        super.init();
        HashSet<Integer> accountingDeviceIds = new HashSet<Integer>();
        for (InetDeviceRuntime instance : this.deviceMap.values()) {
            accountingDeviceIds.add(instance.inetDevice.getId());
        }
        this.childrenDeviceIds = accountingDeviceIds;
        if (this.needServRuntimeMapLoad) {
            this.inetServRuntimeMap.load();
        }
        this.servCheckOptions = (rootDevice = this.deviceMap.get(this.rootDeviceId)) != null && rootDevice.config.getInt("serv.checkOptions", 1) > 0;
        this.flushAtStop = rootDevice != null && rootDevice.config.getInt("connection.flush.onApplicationStop", 1) > 0;
        boolean bl = this.skipFlushZeroCostAccount = rootDevice != null && rootDevice.config.getInt("connection.flush.skipZeroAccount", 0) > 0;
        if (this.realtime) {
            context = (ServerContext)ThreadContext.get();
            this.ifaceMap.load(context.getConnectionSet(), this.deviceMap.getMap());
            this.initRealTime(rootDevice);
            try {
                InetDeviceDao.checkTables(context.getConnection(), this.moduleId, this.initialDate);
                InetSessionLogDao.checkTables(context.getConnection(), this.moduleId, this.initialDate);
                IpResourceDynSubscriptionDao.checkTables((Connection)context.getConnection(), (int)this.moduleId);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.sessionCleanWorker = new SessionCleanWorker(this.setup, this.moduleId, 100000, 300L);
            this.loadConnectionMaps(context);
            try {
                this.loadState();
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
            }
            this.disableServIds = Accounting.loadDisableServIds(this.deviceMap);
        } else if (this.startedForLogProcessing) {
            context = new ServerContext(this.setup, ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true), this.moduleId, 0);
            context.init();
            ThreadContext parent = ThreadContext.get();
            ThreadContext.set((ThreadContext)context);
            try {
                this.ifaceMap.load(context.getConnectionSet(), this.deviceMap.getMap());
                this.loadConnectionMaps(context);
            }
            finally {
                ThreadContext.set((ThreadContext)parent);
                context.destroy();
            }
        }
    }

    protected void loadConnectionMaps(ServerContext context) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading connection maps");
        }
        long start = System.currentTimeMillis();
        this.connectionMapAuto.init(context.getConnectionSet());
        RadiusProcessor processor = null;
        try {
            processor = (RadiusProcessor)Setup.getEnvironment().lookup("radiusProcessor");
        }
        catch (NamingException e) {
            try {
                processor = (RadiusProcessor)Setup.getEnvironment().lookup("processor");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (processor == null) {
            logger.info("Radius processor is null");
        } else if (processor instanceof InetRadiusProcessor) {
            processor.getNasList().load((DefaultServerSetup)this.setup, processor, context.getConnection(), this.moduleId);
        }
        this.connectionMapCall.init(context.getConnectionSet(), (NasList<InetNasConnection, InetNas>)(processor != null ? processor.getNasList() : null));
        if (logger.isDebugEnabled()) {
            logger.debug("Loading of the connection maps completed for " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.realtime) {
            try {
                this.stopWorkes(true);
                this.saveState();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void destroy() throws Exception {
    }

    private synchronized void initWorkers() throws BGException {
        this.accountingWorkerSet.start();
        this.workersStopped = false;
        if (this.logProccessStopped && this.processLogs) {
            this.logProcessor = new InetLogProccessor(this.setup, 1, 10L, 20L, this);
            this.logProcessor.start();
            this.logProccessStopped = false;
        }
        this.logSessionCreateProcessor = new InetCreateSessionProcessor(this.setup, 1, 10L, 20L, this.moduleId, this);
        this.logSessionCreateProcessor.start();
    }

    public synchronized void stopWorkes(boolean logProccessStopped) throws BGException {
        try {
            if (!this.workersStopped) {
                this.workersStopped = true;
                this.accountingWorkerSet.stop();
            }
            if (logProccessStopped) {
                this.logProccessStopped = true;
                this.logProcessor.shutdown();
            }
            this.logSessionCreateProcessor.shutdown();
            try {
                this.flushSessions();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            throw new BGException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWorkers(boolean reloadCounters, boolean reloadMaxTraffsAndRanges) throws BGException {
        if (!this.workersStopped) {
            return;
        }
        ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        try {
            if (reloadMaxTraffsAndRanges) {
                this.tariffContext.maxTrafficManager.updateCache(connectionSet, false);
                this.tariffContext.rangedTrafficManager.updateCache(connectionSet, false);
            }
            RadiusProcessor processor = null;
            try {
                processor = (RadiusProcessor)Setup.getEnvironment().lookup("radiusProcessor");
            }
            catch (NamingException e) {
                try {
                    processor = (RadiusProcessor)Setup.getEnvironment().lookup("processor");
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (processor == null) {
                logger.info("Radius processor is null");
            }
            if (reloadCounters) {
                this.connectionMapCall.loadCounters(connectionSet);
                this.connectionMapAuto.loadCounters(connectionSet);
            }
        }
        finally {
            connectionSet.recycle();
        }
        this.initWorkers();
    }

    @PostConstruct
    private void initRealTime(InetDeviceRuntime rootDevice) throws BGException {
        int accountingManageThreads;
        boolean accountingManageMode = rootDevice != null && rootDevice.config.getInt("accounting.manage.mode", 0) > 0;
        int n = accountingManageThreads = rootDevice != null ? rootDevice.config.getInt("accounting.manage.threads", 0) : 0;
        if (accountingManageThreads <= 0 && accountingManageMode) {
            accountingManageThreads = 8;
        }
        if (accountingManageThreads > 0) {
            this.accountingManageWorker = InetAccountingManageWorker.newWorker(this.setup, this, accountingManageThreads);
        } else {
            EventProcessor.getInstance().addListener((EventListener)this, InetAccountingManageEvent.class, this.moduleId, "accountingRootDeviceId=" + this.rootDeviceId);
            EventProcessor.getInstance().addListener((EventListener)this, InetAccountingManagePoolEvent.class, this.moduleId, "accountingRootDeviceId=" + this.rootDeviceId);
        }
        if (InetUtils.checkAccountingRootDeviceId(this.setup, this.moduleId)) {
            EventProcessor.getInstance().addListener((EventListener)this, InetConnectionCommandEvent.class, this.moduleId, "accountingRootDeviceId=" + this.rootDeviceId);
        } else {
            StringBuilder sb = new StringBuilder(20).append('(');
            for (Integer id : this.childrenDeviceIds) {
                sb.append("deviceId=").append(id).append(" OR ");
            }
            sb.setLength(sb.length() - 4);
            sb.append(')');
            String childrenDeviceIdsQuery = sb.toString();
            EventProcessor.getInstance().addListener((EventListener)this, InetConnectionCommandEvent.class, this.moduleId, childrenDeviceIdsQuery);
        }
        this.initWorkers();
        ServerContextThreadFactory threadContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, null, null);
        new InetDeviceStateAndOptionsDatabaseWorker(this, Executors.newScheduledThreadPool(1, (ThreadFactory)new WorkerThreadFactory("dev-state-opt-dbwrkr", null, (ThreadContextFactory)threadContextFactory)));
        new RequestLogInfoEventProcessor(this.setup, this);
        new InetRecalculateEventProcessor(this);
        new InetLogProcessListener(this);
    }

    private void saveState() throws JAXBException, IOException, XMLStreamException, InterruptedException {
        boolean gzip = this.deviceMap.get((Integer)Integer.valueOf((int)this.rootDeviceId)).config.getInt("accounting.state.gzip", 0) > 0;
        AccountingCommands.saveState(this, "state.xml", gzip, this.flushAtStop);
    }

    @MBeanOperation(description="save state (state.xml) to String fileName, boolean gzip")
    public void saveState(String fileName, boolean gzip) throws JAXBException, IOException, XMLStreamException, InterruptedException {
        AccountingCommands.saveState(this, fileName, gzip, false);
    }

    @MBeanOperation(description="flush all sessions to DB")
    public void flushSessions() throws InterruptedException {
        logger.debug("Flushing session to DB");
        ConcurrentUtils.invokeAll(Arrays.asList(new SessionFlushingWorker(this, Integer.MAX_VALUE, Long.MIN_VALUE, BigDecimal.ZERO, this.connectionMapAuto.iterable()), new SessionFlushingWorker(this, Integer.MAX_VALUE, Long.MIN_VALUE, BigDecimal.ZERO, this.connectionMapCall.values())), (int)2);
    }

    private void loadState() throws JAXBException, IOException, XMLStreamException {
        logger.debug("Loading state from state.xml");
        File directory = new File("data/state");
        directory.mkdirs();
        File stateFile = new File(directory, "state.xml");
        try {
            InputStream in;
            if (!stateFile.exists()) {
                stateFile = new File(directory, "state.xml.gzip");
                if (!stateFile.exists()) {
                    return;
                }
                in = new FileInputStream(stateFile);
                in = new GZIPInputStream(in);
            } else {
                in = new FileInputStream(stateFile);
            }
            XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SessionState.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            xmlReader.nextTag();
            xmlReader.nextTag();
            while (xmlReader.getEventType() != 8) {
                block10: {
                    InetConnectionRuntime connectionRuntime;
                    SessionState sessionState;
                    block12: {
                        block11: {
                            if (xmlReader.getEventType() != 1 || !"sessionState".equals(xmlReader.getName().getLocalPart())) break block10;
                            sessionState = (SessionState)unmarshaller.unmarshal(xmlReader);
                            connectionRuntime = this.connectionMapCall.get(sessionState.connectionId);
                            if (connectionRuntime == null) break block11;
                            logger.debug("Load state for connection:" + connectionRuntime.connection.getId());
                            break block12;
                        }
                        ConcurrentMap<Integer, InetConnectionAutoRuntime> deviceMap = this.connectionMapAuto.getDeviceMap(sessionState.deviceId);
                        if (deviceMap == null || (connectionRuntime = (InetConnectionRuntime)deviceMap.get(sessionState.servId)) == null) break block10;
                        logger.debug("Load state for inetServ:" + connectionRuntime.inetServId);
                    }
                    if (sessionState.trafficsDelta != null) {
                        connectionRuntime.trafficsDelta.putAll(sessionState.trafficsDelta);
                    }
                    connectionRuntime.trafficDeltaCalculateAmount = sessionState.trafficDeltaCalculateAmount;
                    connectionRuntime.trafficDeltaFlushAmount = sessionState.trafficDeltaFlushAmount;
                    connectionRuntime.accountDelta.putAll(sessionState.accountDelta);
                    connectionRuntime.sessionCostDelta = sessionState.sessionCostDelta;
                }
                xmlReader.next();
            }
            xmlReader.close();
            in.close();
            stateFile.renameTo(new File(stateFile.getParentFile(), stateFile.getName() + ".bak"));
            logger.debug("Loading state completed");
        }
        catch (Exception ex) {
            logger.debug("Error load state [{}]", (Object)ex.getMessage());
            stateFile.delete();
        }
    }

    private InetConnectionCallRuntime newConnectionCallRuntime(ConnectionSet connectionSet, InetConnection connection, InetSession session, NasList<InetNasConnection, InetNas> nasList, int nasId, int nasPort, InetServRuntime inetServRuntime, boolean system, InetConnectionCallRuntime parentConnectionCallRuntime) throws BGException {
        String realm = parentConnectionCallRuntime == null ? InetUtils.getRealm(connection.getUsername()) : parentConnectionCallRuntime.realm;
        if (connection.getDeviceOptions() == null) {
            if (connection.getDeviceState() == InetServState.STATE_ENABLE.getCode()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Load deviceOptions from serv and tariff");
                }
                Set<Integer> inetOptions = super.inetServOptionSet(connectionSet, connection.getConnectionStart().getTime(), inetServRuntime, realm);
                connection.setDeviceOptions(inetOptions);
            } else {
                connection.setDeviceOptions(Collections.emptySet());
            }
        }
        if (system) {
            if (connection.getId() <= 0L) {
                logger.info("Write new connection to DB");
                new InetConnectionDao(connectionSet.getConnection(), this.moduleId).insert(connection);
                logger.info("New connection id=" + connection.getId());
            } else {
                logger.info("Update connection in DB");
                new InetConnectionDao(connectionSet.getConnection(), this.moduleId).update(connection);
            }
            session.setConnectionId(connection.getId());
            logger.info("Write new session to DB");
            new InetSessionDao(connectionSet.getConnection(), this.moduleId).insert(session);
            logger.info("New session's id=" + session.getId());
        } else {
            session.setConnectionId(connection.getId());
        }
        assert (session.getConnectionId() != 0L);
        InetConnectionCallRuntime connectionRuntime = this.connectionMapCall.get(session.getConnectionId());
        if (connectionRuntime != null) {
            logger.debug("InetConnection already exists.");
            return connectionRuntime;
        }
        InetConnectionCallRuntime newAccountingSession = new InetConnectionCallRuntime(this, inetServRuntime, connection, session, realm, nasList, nasId, nasPort, parentConnectionCallRuntime != null, parentConnectionCallRuntime);
        newAccountingSession.setInetOptions(connection.getDeviceOptions());
        connectionRuntime = this.connectionMapCall.putIfAbsent(session.getConnectionId(), newAccountingSession);
        if (logger.isDebugEnabled()) {
            logger.debug("Created new AccountingSession.");
        }
        connectionRuntime.setAccountingPeriod(this, connectionSet, connectionRuntime.sessionStartTime, true);
        this.checkServTypeSessionInitiation(inetServRuntime);
        return connectionRuntime;
    }

    private void checkServTypeSessionInitiation(InetServRuntime inetServRuntime) {
        try {
            if (inetServRuntime.getInetServTypeRuntime().getInetServType().getSessionInitiationType() == 1) {
                int inetServTypeId = inetServRuntime.getInetServTypeRuntime().getInetServType().getId();
                logger.error("Wrong sessionInitiationType in servType: " + inetServTypeId + ", inetServId: " + inetServRuntime.inetServId + ", contractId: " + inetServRuntime.contractRuntime.contractId);
                String key = "inetServType.sessionInitiationType.error";
                AlarmSender.sendAlarm((String)"inetServType.sessionInitiationType.error", (long)600000L, (String)"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0422\u0438\u043f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u0441\u0435\u0441\u0441\u0438\u0438", (String)("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"\u0422\u0438\u043f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u0441\u0435\u0441\u0441\u0438\u0438\" \u0432 \u0442\u0438\u043f\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430" + inetServTypeId + " (contractId: " + inetServRuntime.contractRuntime.contractId + "). \u0423\u043a\u0430\u0437\u0430\u043d \"\u043f\u043e \u0442\u0440\u0430\u0444\u0438\u043a\u0443\", \u0432 \u0442\u043e \u0432\u0440\u0435\u043c\u044f \u043a\u0430\u043a \u043f\u0440\u0438\u0445\u043e\u0434\u0438\u0442 RADIUS/DHCP-\u043f\u0430\u043a\u0435\u0442\u044b \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0430, \u044d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442\u044c \u043a \u043e\u0448\u0438\u0431\u043a\u0430\u043c \u0438 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0430\u043c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438."));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public InetConnection connectionAutoStart(InetConnectionAutoRuntime connectionRuntime, long millis) throws BGException {
        this.connectionAutoStartPerMinute.add(millis, 1L);
        InetServ inetServ = connectionRuntime.inetServRuntime.getInetServ();
        Date connectionStart = new Date(InetUtils.roundToSeconds(millis));
        InetConnection connection = new InetConnection();
        ConnectionSet connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet();
        connectionRuntime.setAccountingPeriod(this, connectionSet, connectionStart.getTime(), true);
        connection.setAcctSessionId(null);
        connection.setCalledStationId(null);
        connection.setCallingStationId(null);
        connection.setUsername(null);
        connection.setDeviceId(inetServ.getDeviceId());
        connection.setDevicePort(inetServ.getInterfaceId());
        connection.setInetAddressBytes(null);
        connection.setContractId(inetServ.getContractId());
        connection.setServId(inetServ.getId());
        connection.setConnectionStart(connectionStart);
        InetConnection.setType((InetConnection)connection, (int)256, (boolean)true);
        connection.setDeviceState(connectionRuntime.inetServRuntime.getParentInetServ(this).getDeviceState());
        connection.setConnectionStatus(1);
        logger.info("Write new connection to DB");
        InetConnectionDao connectionDao = new InetConnectionDao(connectionSet.getConnection(), this.moduleId);
        connectionDao.insert(connection);
        connectionDao.recycle();
        logger.info("New connection id=" + connection.getId());
        InetSession session = new InetSession(connection);
        session.setSessionStart(connectionStart);
        session.setLastActive(connectionStart);
        session.setSessionTime(0L);
        session.setSessionStop(null);
        session.setSessionCost(BigDecimal.ZERO);
        session.setDeviceState(connection.getDeviceState());
        session.setStatus(1);
        logger.info("Write new session to DB");
        new InetSessionDao(connectionSet.getConnection(), this.moduleId).insert(session);
        logger.info("New session's id=" + connection.getId());
        connectionRuntime.setConnection(connection);
        connectionRuntime.setSession(this, session);
        connectionSet.commit();
        if (connectionRuntime.inetServRuntime.getInetServTypeRuntime().isSaAutoAccountingEvent()) {
            this.publishSaAccountingStart(inetServ.getContractId(), inetServ.getDeviceId(), connection, false);
        }
        return connection;
    }

    private void publishSaAccountingStart(int contractId, int deviceId, InetConnection connection, boolean serviceSession) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Publishing accounting-START event for contractId: %d; deviceId: %d; con: %d", contractId, deviceId, connection != null ? connection.getId() : -1L));
        }
        if (!serviceSession) {
            this.eventProcessor.publish((Event)new InetSaAccountingEvent(this.moduleId, contractId, connection, 1));
        } else {
            InetDeviceRuntime deviceRuntime = this.deviceMap.get(deviceId);
            if (deviceRuntime != null && deviceRuntime.saServiceAccountingEvent) {
                this.eventProcessor.publish((Event)new InetSaAccountingEvent(this.moduleId, contractId, connection, 1));
            }
        }
    }

    private void publishSaAccountingStop(int contractId, int deviceId, InetConnection connection, boolean serviceSession) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Publishing accounting-STOP event for contractId: %d; deviceId: %d; con: %d", contractId, deviceId, connection != null ? connection.getId() : -1L));
        }
        if (serviceSession) {
            InetDeviceRuntime deviceRuntime = this.deviceMap.get(deviceId);
            if (deviceRuntime != null && deviceRuntime.saServiceAccountingEvent) {
                this.eventProcessor.publish((Event)new InetSaAccountingEvent(this.moduleId, contractId, connection, 2));
            }
        } else {
            this.eventProcessor.publish((Event)new InetSaAccountingEvent(this.moduleId, contractId, connection, 2));
        }
    }

    public InetConnectionCallRuntime connectionCallStart(ConnectionSet connectionSet, boolean system, InetConnection connection, InetSession session, long sessionId, Date sessionStart, NasList<InetNasConnection, InetNas> nasList, InetServRuntime inetServRuntime, InetConnectionCallRuntime parentConnectionCallRuntime, Map<Integer, AccountingTrafficAmount> counterTraffics) throws BGException {
        InetConnectionCallRuntime result;
        assert (inetServRuntime.isHeldByCurrentThread());
        int deviceId = connection.getDeviceId();
        int nasPort = connection.getDevicePort();
        if (parentConnectionCallRuntime == null) {
            millis = System.currentTimeMillis();
            this.connectionCallStartSecondCounter.add(millis, 1L);
            this.connectionCallStartMinuteCounter.add(millis, 1L);
        } else {
            millis = System.currentTimeMillis();
            this.connectionCallServiceStartSecondCounter.add(millis, 1L);
            this.connectionCallServiceStartMinuteCounter.add(millis, 1L);
        }
        connection.setConnectionStatus(1);
        connection.setConnectionStart(new Date(InetUtils.roundToSeconds(connection.getConnectionStart().getTime())));
        if (inetServRuntime.accountingPeriodCheck(this, connectionSet, connection.getConnectionStart().getTime(), false, false) == null) {
            this.setAccountingPeriod(connectionSet, inetServRuntime, connection.getConnectionStart().getTime());
        }
        if (parentConnectionCallRuntime == null) {
            if (session == null) {
                session = new InetSession(connection);
                session.setId(sessionId);
                if (sessionStart != null) {
                    session.setSessionStart(sessionStart);
                } else {
                    session.setSessionStart(connection.getConnectionStart());
                }
                session.setLastActive(connection.getConnectionStart());
                session.setSessionStop(null);
                session.setSessionCost(BigDecimal.ZERO);
                session.setDeviceState(connection.getDeviceState());
                session.setStatus(1);
            }
            result = this.newConnectionCallRuntime(connectionSet, connection, session, nasList, deviceId, nasPort, inetServRuntime, system, null);
            if (result.connection.getInetAddressBytes() != null) {
                this.registerInetAddress(deviceId, result);
                if (system) {
                    this.ipResourceSubscribe(connectionSet.getConnection(), inetServRuntime, connection);
                }
            } else if (inetServRuntime.isAddressAllInterface(this)) {
                this.registerInetAddress(deviceId, result);
            } else {
                logger.debug("Ip address not set for connection. Skip register");
            }
        } else {
            connection.setParentConnectionId(parentConnectionCallRuntime.connection.getId());
            if (session == null) {
                session = new InetSession(connection);
                session.setId(sessionId);
                session.setParentId(parentConnectionCallRuntime.sessionId);
                if (sessionStart != null) {
                    session.setSessionStart(sessionStart);
                } else {
                    session.setSessionStart(connection.getConnectionStart());
                }
                session.setLastActive(connection.getConnectionStart());
                session.setSessionStop(null);
                session.setSessionCost(BigDecimal.ZERO);
            }
            result = this.newConnectionCallRuntime(connectionSet, connection, session, nasList, deviceId, nasPort, inetServRuntime, true, parentConnectionCallRuntime);
        }
        assert (sessionStart == null || sessionStart.equals(session.getSessionStart()));
        if (counterTraffics != null && counterTraffics.size() > 0) {
            for (Map.Entry<Integer, AccountingTrafficAmount> entry : counterTraffics.entrySet()) {
                result.initCounterTraffic(entry.getKey(), entry.getValue().amount);
            }
        }
        if (system && counterTraffics != null && counterTraffics.size() > 0) {
            logger.info("Start from update - flushing counter traffics");
            result.flushInitialTraffics(connectionSet.getConnection(), this.moduleId, result.sessionId);
        }
        this.onConnectionStart(result);
        if (system) {
            this.sessionAccountingEP.publish((Event)new InetAccountingEvent(this.sessionAccountingEP, result.contractId, result.connection, result.sessionId, 1, counterTraffics, sessionStart));
            this.publishSaAccountingStart(result.contractId, deviceId, result.connection, result.isServiceSession());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)connection);
        }
        return result;
    }

    protected void setAccountingPeriod(ConnectionSet connectionSet, InetServRuntime inetServRuntime, long millis) throws BGException {
        InetServ inetServ = inetServRuntime.getInetServ();
        if (inetServ.getStatus() != InetServStatus.STATUS_ON) {
            logger.info("inetServ[id=" + inetServ.getId() + "] status not active (accessCode=" + inetServ.getAccessCode() + ").");
            return;
        }
        if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, inetServRuntime.contractRuntime.getStatus())) {
            logger.info("inetServ[id=" + inetServ.getId() + "] contract status not active.");
            return;
        }
        inetServRuntime.accountingPeriodCheck(this, connectionSet, millis, true, true);
    }

    private boolean needIpResourceSubscription(InetServRuntime servRuntime, InetConnection connection, byte[] address) {
        if (address != null) {
            return servRuntime.ipInRange(this.inetServRuntimeMap, connection.getConnectionStart(), address) <= 0;
        }
        return false;
    }

    private boolean isWorkingAutoIface(FlowAgentInterface flowAgentInterface, int deviceId, InetConnectionRuntime connectionRuntime) {
        if (flowAgentInterface.iface == -1 || flowAgentInterface.agentDeviceId != deviceId) {
            return true;
        }
        return Accounting.isWorkingAutoIface(this, flowAgentInterface, deviceId, connectionRuntime);
    }

    public static boolean isWorkingAutoIface(Accounting accounting, FlowAgentInterface flowAgentInterface, int deviceId, InetConnectionRuntime connectionRuntime) {
        assert (deviceId == flowAgentInterface.agentDeviceId && flowAgentInterface.iface != -1);
        try {
            InetServ inetServ = connectionRuntime.inetServRuntime.getInetServ();
            InetServ rootInetServ = connectionRuntime.inetServRuntime.getRootInetServRuntime(accounting).getInetServ();
            int servIface = inetServ.getInterfaceId();
            if (inetServ == rootInetServ) {
                return servIface < 0 || servIface == flowAgentInterface.iface;
            }
            int servDeviceId = inetServ.getDeviceId();
            int rootServDeviceId = rootInetServ.getDeviceId();
            if (servDeviceId > 0 && servDeviceId != rootServDeviceId && servIface >= 0 && servDeviceId == deviceId) {
                return servIface == flowAgentInterface.iface;
            }
            servIface = rootInetServ.getInterfaceId();
            return servIface < 0 || servIface == flowAgentInterface.iface;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean isWorkingCallIface(FlowAgentInterface flowAgentInterface, InetConnectionRuntime connectionRuntime) {
        if (flowAgentInterface.iface == -1) {
            return true;
        }
        InetServ rootInetServ = connectionRuntime.inetServRuntime.getRootInetServRuntime(this).getInetServ();
        if (flowAgentInterface.agentDeviceId != rootInetServ.getDeviceId()) {
            return true;
        }
        int servIface = rootInetServ.getInterfaceId();
        return servIface == -1 || servIface == flowAgentInterface.iface;
    }

    public void registerAutoInetAddress(int deviceId, InetConnectionAutoRuntime connectionRuntime) throws BGException {
        FlowAgentInterface[] flowAgentInterfaces = this.ifaceMap.getFlowAgentInterfaces(deviceId);
        if (flowAgentInterfaces != null) {
            for (FlowAgentInterface flowAgentInterface : flowAgentInterfaces) {
                int i;
                if (!this.isWorkingAutoIface(flowAgentInterface, deviceId, connectionRuntime)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Register " + connectionRuntime.inetServRuntime.getInetServ() + " on " + flowAgentInterface.agentDeviceId + ":" + flowAgentInterface.iface);
                }
                flowAgentInterfaces[i].sessionSetAuto.add(connectionRuntime);
            }
        }
    }

    public void unregisterAutoInetAddress(int deviceId, InetConnectionAutoRuntime connectionRuntime, InetServ inetServ) throws BGException {
        FlowAgentInterface[] flowAgentInterfaces = this.ifaceMap.getFlowAgentInterfaces(deviceId);
        if (flowAgentInterfaces != null) {
            for (FlowAgentInterface flowAgentInterface : flowAgentInterfaces) {
                if (!this.isWorkingAutoIface(flowAgentInterface, deviceId, connectionRuntime)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unregister " + connectionRuntime.inetServRuntime.getInetServ() + " from " + flowAgentInterface.agentDeviceId + ":" + flowAgentInterface.iface);
                }
                flowAgentInterface.sessionSetAuto.remove(connectionRuntime, inetServ);
            }
        }
    }

    public void registerInetAddress(int deviceId, InetConnectionRuntime connectionRuntime) throws BGException {
        FlowAgentInterface[] flowAgentInterfaces = this.ifaceMap.getFlowAgentInterfaces(deviceId);
        if (flowAgentInterfaces == null) {
            return;
        }
        for (FlowAgentInterface flowAgentInterface : flowAgentInterfaces) {
            if (!this.isWorkingCallIface(flowAgentInterface, connectionRuntime)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Register " + connectionRuntime.inetServRuntime.getInetServ() + " on " + flowAgentInterface.agentDeviceId + ":" + flowAgentInterface.iface);
            }
            flowAgentInterface.sessionSetCall.add(connectionRuntime);
        }
    }

    public void unregisterInetAddress(int deviceId, InetConnectionRuntime connectionRuntime) throws BGException {
        FlowAgentInterface[] flowAgentInterfaces = this.ifaceMap.getFlowAgentInterfaces(deviceId);
        if (flowAgentInterfaces == null) {
            return;
        }
        for (FlowAgentInterface flowAgentInterface : flowAgentInterfaces) {
            if (!this.isWorkingCallIface(flowAgentInterface, connectionRuntime)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Unregister " + connectionRuntime.inetServRuntime.getInetServ() + " from " + flowAgentInterface.agentDeviceId + ":" + flowAgentInterface.iface);
            }
            flowAgentInterface.sessionSetCall.remove(connectionRuntime);
        }
    }

    public boolean connectionStop(Connection con, boolean system, InetConnectionRuntime connectionRuntime, Date sessionStop, long finishTimeout) throws BGException {
        assert (connectionRuntime.inetServRuntime.isHeldByCurrentThread());
        if (connectionRuntime.isCall()) {
            if (connectionRuntime.isServiceSession()) {
                millis = System.currentTimeMillis();
                this.connectionCallServiceStopSecondCounter.add(millis, 1L);
                this.connectionCallServiceStopMinuteCounter.add(millis, 1L);
            } else {
                millis = System.currentTimeMillis();
                this.connectionCallStopSecondCounter.add(millis, 1L);
                this.connectionCallStopMinuteCounter.add(millis, 1L);
            }
        } else {
            this.connectionAutoStopPerMinute.add(System.currentTimeMillis(), 1L);
        }
        InetConnection connection = connectionRuntime.connection;
        boolean result = new InetConnectionDao(con, this.moduleId).closeConnection(connection.getDeviceId(), connection.getId(), sessionStop, connection.getType());
        new InetSessionDao(con, this.moduleId).closeSession(connection.getId(), connectionRuntime.sessionId, sessionStop);
        if (!result) {
            connectionRuntime.connectionStop(sessionStop, finishTimeout);
            logger.debug("Connection already stopped");
            return false;
        }
        try {
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        connectionRuntime.connectionStop(sessionStop, finishTimeout);
        this.onConnectionStop(connectionRuntime);
        if (system) {
            this.sessionAccountingEP.publish((Event)new InetAccountingEvent(this.sessionAccountingEP, connectionRuntime.contractId, connectionRuntime.connection, connectionRuntime.sessionId, 2, sessionStop));
            this.publishSaAccountingStop(connectionRuntime.contractId, connectionRuntime.connection.getDeviceId(), connectionRuntime.connection, connectionRuntime.isServiceSession());
            if (!connectionRuntime.isServiceSession() && connectionRuntime.isCall()) {
                this.ipResourceUnsubscribe(con, connectionRuntime, sessionStop);
            }
        }
        return true;
    }

    public void ipResourceSubscribe(Connection con, InetServRuntime inetServRuntime, InetConnection connection) throws BGException {
        int contractId;
        if (this.needIpResourceSubscription(inetServRuntime, connection, connection.getInetAddressBytes())) {
            contractId = inetServRuntime.contractRuntime.contractId;
            this.ipResourceManager.subscribe(con, contractId, String.valueOf(contractId), connection.getIpResourceId(), connection.getInetAddressBytes(), connection.getConnectionStart(), connection.getId());
        }
        if (this.needIpResourceSubscription(inetServRuntime, connection, connection.getPrefix())) {
            contractId = inetServRuntime.contractRuntime.contractId;
            this.ipResourceManager.subscribe(con, contractId, String.valueOf(contractId), connection.getPrefixResourceId(), connection.getPrefix(), connection.getConnectionStart(), connection.getId());
        }
        if (this.needIpResourceSubscription(inetServRuntime, connection, connection.getDelegatedPrefix())) {
            contractId = inetServRuntime.contractRuntime.contractId;
            this.ipResourceManager.subscribe(con, contractId, String.valueOf(contractId), connection.getDelegatedPrefixResourceId(), connection.getDelegatedPrefix(), connection.getConnectionStart(), connection.getId());
        }
    }

    public void ipResourceUnsubscribe(Connection con, InetConnectionRuntime connectionRuntime, Date sessionStop) throws BGException {
        InetConnection connection = connectionRuntime.connection;
        if (this.needIpResourceSubscription(connectionRuntime.inetServRuntime, connection, connection.getInetAddressBytes())) {
            this.ipResourceManager.unsubscribe(con, connectionRuntime.contractId, connection.getIpResourceId(), connection.getInetAddressBytes(), sessionStop, connection.getId());
        }
        if (this.needIpResourceSubscription(connectionRuntime.inetServRuntime, connection, connection.getPrefix())) {
            this.ipResourceManager.unsubscribe(con, connectionRuntime.contractId, connection.getPrefixResourceId(), connection.getPrefix(), sessionStop, connection.getId());
        }
        if (this.needIpResourceSubscription(connectionRuntime.inetServRuntime, connection, connection.getDelegatedPrefix())) {
            this.ipResourceManager.unsubscribe(con, connectionRuntime.contractId, connection.getDelegatedPrefixResourceId(), connection.getDelegatedPrefix(), sessionStop, connection.getId());
        }
    }

    boolean sessionFinish(ConnectionSet connectionSet, BalanceDao balanceDao, InetConnectionRuntime connectionRuntime, boolean connectionFinish, boolean withCheck, boolean force) throws BGException {
        assert (connectionRuntime.inetServRuntime.isHeldByCurrentThread());
        try {
            Connection con = connectionSet.getConnection();
            logger.info("Finishing session " + connectionRuntime.sessionId);
            GregorianCalendar calendar = new GregorianCalendar();
            InetConnection connection = connectionRuntime.connection;
            if (connectionRuntime.sessionStop == null) {
                logger.warn("Finishing with sessionStop=null!");
                connectionRuntime.sessionStop = new Date();
            }
            connectionRuntime.updateTime(connectionRuntime.sessionStop.getTime() + (long)(force ? 0 : 1000));
            SessionTarifficationManager.calculate(this, connectionSet, connectionRuntime, calendar, 0, null, BigDecimal.ZERO, false);
            boolean skipData = !force && this.getDisableServIds().contains(connectionRuntime.inetServId);
            SessionFlushingManager sessionFlushingManager = new SessionFlushingManager(this, true);
            if (withCheck) {
                logger.debug("Finishing with check.");
                if (!sessionFlushingManager.flush(con, balanceDao, connectionRuntime, true, connectionFinish, true, false, 0L, skipData)) {
                    logger.debug("Check error. Try later.");
                    sessionFlushingManager.recycle();
                    return false;
                }
            } else {
                logger.debug("Finishing without check.");
                sessionFlushingManager.flush(con, balanceDao, connectionRuntime, true, connectionFinish, false, false, 0L, skipData);
            }
            if (connectionFinish) {
                connection.setConnectionStatus(4);
            }
            if (connectionRuntime.isCall()) {
                if (connectionFinish) {
                    if (connectionRuntime.connection.getInetAddressBytes() != null) {
                        this.unregisterInetAddress(connection.getDeviceId(), connectionRuntime);
                    } else if (connectionRuntime.inetServRuntime.isAddressAllInterface(this)) {
                        this.unregisterInetAddress(connection.getDeviceId(), connectionRuntime);
                    }
                    if (this.connectionMapCall.remove(connection.getId(), (InetConnectionCallRuntime)connectionRuntime)) {
                        connectionRuntime.destroy();
                    }
                }
            } else if (connectionFinish) {
                if (connectionRuntime.inetServRuntime.getInetServTypeRuntime().isSaAutoAccountingEvent()) {
                    this.publishSaAccountingStop(connectionRuntime.contractId, connectionRuntime.connection.getDeviceId(), connectionRuntime.connection, false);
                }
                connectionRuntime.setSession(this, null);
            }
            sessionFlushingManager.recycle();
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return true;
    }

    public boolean processRadiusPacket(int agentDeviceId, Long hour, long millis, InetConnectionCallRuntime connectionCallRuntime, RadiusPacket packet, Map<Integer, AccountingTrafficAmount> counterTraffics) throws BGException {
        InetConnectionCallRuntime parentConnectionCallRuntime;
        assert (connectionCallRuntime.inetServRuntime.isHeldByCurrentThread());
        boolean result = connectionCallRuntime.trySplitSession(this, hour, millis);
        for (Map.Entry<Integer, AccountingTrafficAmount> e : counterTraffics.entrySet()) {
            long delta;
            Integer trafficTypeId = e.getKey();
            AccountingTrafficAmount currentAmount = (AccountingTrafficAmount)connectionCallRuntime.counterTraffics.get(trafficTypeId);
            if (trafficTypeId == TrafficType.TIME_ID) {
                if (currentAmount == null) {
                    connectionCallRuntime.counterTraffics.put(trafficTypeId, e.getValue());
                    continue;
                }
                delta = e.getValue().amount - currentAmount.amount;
                currentAmount.amount = e.getValue().amount;
                e.getValue().amount = delta;
                continue;
            }
            if (currentAmount == null || currentAmount.amount > e.getValue().amount) {
                connectionCallRuntime.counterTraffics.put(trafficTypeId, e.getValue());
                continue;
            }
            delta = e.getValue().amount - currentAmount.amount;
            currentAmount.amount = e.getValue().amount;
            e.getValue().amount = delta;
        }
        connectionCallRuntime.addTraffics(agentDeviceId, hour, counterTraffics);
        long lastAccountTime = millis / 1000L;
        if (connectionCallRuntime.lastAccountTime < lastAccountTime) {
            connectionCallRuntime.lastAccountTime = lastAccountTime;
        }
        if ((parentConnectionCallRuntime = connectionCallRuntime.getParentConnectionCallRuntime()) != null && parentConnectionCallRuntime.lastAccountTime < lastAccountTime) {
            parentConnectionCallRuntime.lastAccountTime = lastAccountTime;
        }
        return result;
    }

    InetConnection findExistConnection(InetConnection connection) {
        List<InetConnectionCallRuntime> sessionList = this.connectionMapCall.getByServId(connection.getServId());
        if (sessionList != null) {
            int size = sessionList.size();
            for (int i = 0; i < size; ++i) {
                InetConnection existConnnection = sessionList.get((int)i).connection;
                if (existConnnection.getDeviceId() != connection.getDeviceId() || existConnnection.getDevicePort() != connection.getDevicePort() || existConnnection.getCallingStationId() != connection.getCallingStationId() && (existConnnection.getCallingStationId() == null || !existConnnection.getCallingStationId().equals(connection.getCallingStationId())) || existConnnection.getInetAddressBytes() != connection.getInetAddressBytes() && (existConnnection.getInetAddressBytes() == null || !Arrays.equals(existConnnection.getInetAddressBytes(), connection.getInetAddressBytes())) || existConnnection.getType() != connection.getType() || existConnnection.getConnectionStatus() != connection.getConnectionStatus()) continue;
                return existConnnection;
            }
        }
        return null;
    }

    public void notify(Event _e, EventListenerContext ctx) throws BGException {
        if (_e instanceof InetAccountingManageEvent) {
            InetAccountingManageWorker.notify(this, _e, ctx);
        } else if (_e instanceof InetAccountingManagePoolEvent) {
            InetAccountingManageWorker.notify(this, _e, ctx);
        } else if (_e instanceof InetAccountingEvent) {
            InetConnection connection;
            InetConnectionCallRuntime connectionRuntime;
            InetAccountingEvent e = (InetAccountingEvent)_e;
            if (e.getType() == 3 && (connectionRuntime = this.connectionMapCall.get((connection = e.getConnection()).getId())) != null) {
                try {
                    this.onAccountingUpdate(connectionRuntime, e);
                }
                catch (InterruptedException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        } else if (_e instanceof InetConnectionCommandEvent) {
            this.onConnectionCommand(ctx, (InetConnectionCommandEvent)_e);
        } else if (_e instanceof InetReloadLocalEvent) {
            HashSet<Integer> accountingDeviceIds = new HashSet<Integer>();
            for (InetDeviceRuntime instance : this.deviceMap.values()) {
                accountingDeviceIds.add(instance.inetDevice.getId());
            }
            this.childrenDeviceIds = accountingDeviceIds;
            InetDeviceRuntime rootDevice = this.deviceMap.get(this.rootDeviceId);
            this.servCheckOptions = rootDevice.config.getInt("serv.checkOptions", 1) > 0;
            this.flushAtStop = rootDevice != null && rootDevice.config.getInt("connection.flush.onApplicationStop", 1) > 0;
            HashSet<String> singlesignonRealmSet = new HashSet<String>();
            for (Map.Entry e : rootDevice.config.subKeyed("radius.realm.").entrySet()) {
                if (((ParameterMap)e.getValue()).getInt("singlesignon", 0) <= 0) continue;
                singlesignonRealmSet.add(InetUtils.internRealm((String)e.getKey()));
            }
            this.singlesignonRealmSet = singlesignonRealmSet.size() > 0 ? singlesignonRealmSet : null;
            this.disableServIds = Accounting.loadDisableServIds(this.deviceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAccountingUpdate(InetConnectionRuntime connectionRuntime, InetAccountingEvent e) throws BGException, InterruptedException {
        logger.debug("Recieve connection update");
        if (connectionRuntime.inetServRuntime.tryLock(8L, TimeUnit.SECONDS)) {
            try {
                long lastAccountTime = System.currentTimeMillis() / 1000L;
                if (connectionRuntime.lastAccountTime < lastAccountTime) {
                    connectionRuntime.lastAccountTime = lastAccountTime;
                }
                for (Map.Entry<Integer, AccountingTrafficAmount> entry : e.getCounterTraffics().entrySet()) {
                    AccountingTrafficAmount amount = connectionRuntime.counterTraffics.get(entry.getKey());
                    if (amount != null) {
                        if (amount.amount <= entry.getValue().amount) {
                            amount.amount = entry.getValue().amount;
                            continue;
                        }
                        logger.info("Accounting desync detected");
                        continue;
                    }
                    connectionRuntime.counterTraffics.put(entry.getKey(), new AccountingTrafficAmount(entry.getValue().amount));
                }
                this.onConnectionUpdate(connectionRuntime);
            }
            finally {
                connectionRuntime.inetServRuntime.unlock();
            }
        } else {
            logger.warn("Lock timeout 8 sec to " + connectionRuntime.inetServRuntime.contractRuntime);
        }
    }

    private void onConnectionCommand(EventListenerContext ctx, InetConnectionCommandEvent e) throws BGException {
        String command = e.getCommand();
        if (command == null) {
            logger.info("Empty connection command");
            return;
        }
        if (command.startsWith("stopAllForDeviceId")) {
            int deviceId = e.getDeviceId();
            new Thread(() -> {
                Preferences params = new Preferences(Utils.maskNull((String)e.getParams()), "\n");
                long timeout = params.getLong("timeout", 10L);
                ServerContext context = new ServerContext(this.setup, this.moduleId, 0);
                ThreadContext.push((ThreadContext)context);
                try {
                    AccountingCommands.stopConnectionsForDeviceId(this, context, e, deviceId, timeout);
                }
                finally {
                    ThreadContext.pop((ThreadContext)context, null);
                }
            }, "stopAllForDeviceId-" + deviceId).start();
        } else {
            AccountingCommands.onSingleConnectionCommand(this, ctx, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MBeanOperation(description="rebind connection to new inetServ")
    public void rebindConnection(long connectionId, int newServId, Short deviceState, Set<Integer> deviceOptions) throws BGException {
        ServerContext context = new ServerContext(this.setup, this.moduleId, 0);
        ThreadContext parentContext = ServerContext.push((ThreadContext)context);
        try {
            InetConnectionCallRuntime connectionRuntime = this.connectionMapCall.get(connectionId);
            AccountingCommands.rebindConnection(this, context.getConnectionSet(), connectionRuntime, newServId, deviceState, deviceOptions);
            context.commit();
        }
        finally {
            ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MBeanOperation(description="split session")
    public void splitSession(long connectionId) throws BGException {
        ServerContext context = new ServerContext(this.setup, this.moduleId, 0);
        ThreadContext parentContext = ServerContext.push((ThreadContext)context);
        try {
            InetConnectionCallRuntime connectionRuntime = this.connectionMapCall.get(connectionId);
            long millis = System.currentTimeMillis();
            Long hour = InetUtils.getHour(millis);
            ((InetConnectionRuntime)connectionRuntime).splitSession(this, hour, (long)((double)millis / 1000.0) * 1000L, false);
            context.commit();
        }
        finally {
            ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    @Override
    public String executeCommand(String cmd, String param) {
        Object result;
        if ("sesslist".equals(cmd)) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("Call sessions:\n");
            String[] columns = new String[]{"ID", "ContractId", "ServId", "Session", "Start", "Stop", "AccLastTime", "AccPerFrom", "AccPerTo", "OptionSet", "Status"};
            int[] widths = new int[]{15, 15, 15, 20, 20, 21, 21, 21, 21, 21, 10};
            ConsoleTable table = new ConsoleTable(columns, widths);
            for (Map.Entry<Long, InetConnectionCallRuntime> me : this.connectionMapCall.getSessionMap().entrySet()) {
                Long connectionId = me.getKey();
                InetConnectionRuntime session = me.getValue();
                String[] row = new String[]{String.valueOf(connectionId), String.valueOf(session.contractId), String.valueOf(session.inetServId), session.connection.getAcctSessionId(), TimeUtils.format((Date)session.sessionStart, (String)"dd.MM.yyyy HH:mm:ss"), TimeUtils.format((Date)session.sessionStop, (String)"dd.MM.yyyy HH:mm:ss"), TimeUtils.format((Date)new Date(session.lastAccountTime * 1000L), (String)"dd.MM.yyyy HH:mm:ss"), TimeUtils.format((Date)new Date(session.accountingPeriodMillisFrom), (String)"dd.MM.yyyy HH:mm:ss"), TimeUtils.format((Date)new Date(session.accountingPeriodMillisTo), (String)"dd.MM.yyyy HH:mm:ss"), Utils.toString(session.getInetOptions()), String.valueOf(session.connection.getConnectionStatus())};
                table.addRow(row);
            }
            sb.append(table.toString());
            result = sb.toString();
        } else if ("flowExport".equals(cmd)) {
            try {
                new FlowExport().export((ParameterMap)this.setup, param);
                result = "Ok";
            }
            catch (Exception ex) {
                result = "Error: " + ex.toString();
                logger.error("error flowExport", (Throwable)ex);
            }
        } else if ("natLogExport".equals(cmd)) {
            try {
                NatLogProcessor.export((ParameterMap)this.setup, (String)param);
                result = "Ok";
            }
            catch (Exception ex) {
                result = "Error: " + ex.toString();
                logger.error("error natLogExport", (Throwable)ex);
            }
        } else if ("status".equals(cmd)) {
            result = Utils.maskNull((String)super.executeCommand(cmd, param));
            result = this.getStatus((String)result);
        } else {
            result = super.executeCommand(cmd, param);
            if (result != null) {
                return result;
            }
        }
        return result;
    }

    private String getStatus(String result) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(result);
            sb.append("Connections:\n");
            sb.append("  [signal] count: ").append(this.getActiveCallConnectionCount()).append("; ");
            sb.append(" start per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getCallConnectionStartPerMinute())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.connectionCallStartMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES))).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.connectionCallStartMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES))).append("; ");
            sb.append(" stop per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getCallConnectionStopPerMinute())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.connectionCallStopMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES))).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.connectionCallStopMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES))).append('\n');
            sb.append("  [traffic] count: ").append(this.getActiveAutoConnectionCount()).append("; ");
            sb.append(" start per minute: ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getAutoConnectionStartPerMinute())).append("; ");
            sb.append(" stop per minute: ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getAutoConnectionStopPerMinute())).append('\n');
            result = sb.toString();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    @Override
    public String getCommandsHelp() {
        return super.getCommandsHelp() + "sesslist - show session list\nflowExport - export flows to file (with filter by interfaces and IP-range)\n\tflowExport -s 1 -h 2012-06-13-15 -f flows.csv\n\tflowExport -s 1 -tFrom 2012-06-13T15:30:00 -tTo 2012-06-13T15:31:00 -f flows.csv\n\tflowExport -s 1 -h 2012-06-13-15 -i 1,2,3 -r 91.24.35.60-91.24.35.69 -f flows.csv\nnatLogExport - export NAT log to file (with filters by ext address, ports)\n\tnatLogExport -s 1 -tFrom 2014-02-25T17:00:00 -tTo 2014-02-25T19:00:00 -a 185.18.4.96 -p 4096 -f nat.csv -tFmt \"dd.MM.yyyy HH:mm:ss.SSS\"\n";
    }

    private void onConnectionStart(InetConnectionRuntime connectionRuntime) throws BGException {
        EventProcessor.getInstance().request((QueueEvent)new ConnectionAddEvent(connectionRuntime.connection));
    }

    private void onConnectionStop(InetConnectionRuntime connectionRuntime) throws BGException {
        EventProcessor.getInstance().request((QueueEvent)new ConnectionRemoveEvent(connectionRuntime.connection));
    }

    public void onConnectionUpdate(InetConnectionRuntime connectionRuntime) throws BGException {
        EventProcessor.getInstance().request((QueueEvent)new ConnectionUpdateEvent(connectionRuntime.connection));
    }

    @MBeanAttribute(description="active auto (flow) connection count")
    public int getActiveAutoConnectionCount() {
        int result = 0;
        for (InetConnectionAutoRuntime connectionAutoRuntime : this.connectionMapAuto.iterable()) {
            if (connectionAutoRuntime.connection == null) continue;
            ++result;
        }
        return result;
    }

    private long getCount(int status, boolean service) {
        long count = 0L;
        for (InetConnectionCallRuntime connectionCallRuntime : this.connectionMapCall.getSessionMap().values()) {
            if (connectionCallRuntime.connection.getConnectionStatus() != status || connectionCallRuntime.isServiceSession() != service) continue;
            ++count;
        }
        return count;
    }

    @MBeanAttribute(description="active call (radius/dhcp) connection count")
    public long getActiveCallConnectionCount() {
        return this.getCount(1, false);
    }

    @MBeanAttribute(description="suspended call (radius/dhcp) connection count")
    public long getSuspendedCallConnectionCount() {
        return this.getCount(2, false);
    }

    @MBeanAttribute(description="closed call (radius/dhcp) connection count")
    public long getClosedCallConnectionCount() {
        return this.getCount(3, false);
    }

    @MBeanAttribute(description="active call (radius) service connection count")
    public long getActiveCallServiceConnectionCount() {
        return this.getCount(1, true);
    }

    @MBeanAttribute(description="suspended call (radius) service connection count")
    public long getSuspendedCallServiceConnectionCount() {
        return this.getCount(2, true);
    }

    @MBeanAttribute(description="closed call (radius) service connection count")
    public long getClosedCallServiceConnectionCount() {
        return this.getCount(3, true);
    }

    @MBeanAttribute
    public long getAutoConnectionStartPerMinute() {
        return this.connectionAutoStartPerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getAutoConnectionStopPerMinute() {
        return this.connectionAutoStopPerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getCallConnectionStartPerMinute() {
        return this.connectionCallStartSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public long getCallConnectionStopPerMinute() {
        return this.connectionCallStopSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @Override
    protected BigDecimal getSessionCostDelta(InetServRuntime servRuntime) throws BGException {
        BigDecimal summa = BigDecimal.ZERO;
        List<InetConnectionRuntime> list = servRuntime.getConnectionList();
        summa = this.addDeltaAccount(list, summa);
        List<InetServRuntime> childrenList = this.getInetServRuntimeMap().listChildren(servRuntime.inetServId);
        if (childrenList != null) {
            for (InetServRuntime childServRuntime : this.getInetServRuntimeMap().listChildren(servRuntime.inetServId)) {
                list = childServRuntime.getConnectionList();
                summa = this.addDeltaAccount(list, summa);
            }
        }
        return summa;
    }

    private BigDecimal addDeltaAccount(List<InetConnectionRuntime> list, BigDecimal summa) {
        if (list != null) {
            for (InetConnectionRuntime connectionRuntime : list) {
                BigDecimal delta = connectionRuntime.sessionCostDelta;
                if (delta == null || delta == BigDecimal.ZERO) continue;
                summa = summa.add(delta);
            }
        }
        return summa;
    }

    public boolean checkSessionCount(InetServRuntime parentInetServRuntime, InetServRuntime inetServRuntime, InetConnection connection, String realm, boolean wantToAdd) {
        List<InetServRuntime> children;
        Set singlesignonRealmSet;
        boolean singlesignonRealm;
        int limit = parentInetServRuntime != inetServRuntime ? InetUtils.getSessionCountLimit(inetServRuntime.inetServTypeRef.get().inetServType, inetServRuntime.getInetServ()) : 0;
        if (limit <= 0) {
            limit = InetUtils.getSessionCountLimit(parentInetServRuntime.inetServTypeRef.get().inetServType, parentInetServRuntime.getInetServ());
            inetServRuntime = parentInetServRuntime;
        }
        boolean bl = singlesignonRealm = (singlesignonRealmSet = this.singlesignonRealmSet) != null && singlesignonRealmSet.contains(realm);
        if (!singlesignonRealm && limit <= 0) {
            return true;
        }
        int connectionType = InetUtils.getConnectionType(connection);
        ArrayList<InetConnectionCallRuntime> allConnectionList = new ArrayList<InetConnectionCallRuntime>();
        boolean singlesignonRealmConnectionExist = wantToAdd;
        List<InetConnectionCallRuntime> connectionList = this.connectionMapCall.getByServId(inetServRuntime.inetServId);
        if (connectionList != null) {
            for (InetConnectionCallRuntime connectionRuntime : connectionList) {
                if (!InetUtils.checkAliveAndType(connectionRuntime.connection, true, connectionType)) continue;
                if (singlesignonRealm && realm.equals(connectionRuntime.getRealm())) {
                    if (singlesignonRealmConnectionExist) {
                        logger.info("Session count >1 for this realm.");
                        return false;
                    }
                    singlesignonRealmConnectionExist = true;
                }
                allConnectionList.add(connectionRuntime);
            }
        }
        if ((children = this.inetServRuntimeMap.listChildren(inetServRuntime.inetServId)) != null && children.size() > 0) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                List<InetConnectionCallRuntime> childConnectionList;
                InetServRuntime child = children.get(i);
                if (child.inetServTypeRef.get().inetServType.getSessionCountLimit() > 0 || (childConnectionList = this.connectionMapCall.getByServId(child.inetServId)) == null || childConnectionList.size() == 0) continue;
                for (InetConnectionCallRuntime connectionRuntime : childConnectionList) {
                    if (!InetUtils.checkAliveAndType(connectionRuntime.connection, true, connectionType)) continue;
                    if (singlesignonRealm && realm.equals(connectionRuntime.getRealm())) {
                        if (singlesignonRealmConnectionExist) {
                            logger.info("Session count >1 for this realm.");
                            return false;
                        }
                        singlesignonRealmConnectionExist = true;
                    }
                    allConnectionList.add(connectionRuntime);
                }
            }
        }
        if (limit <= 0) {
            return true;
        }
        if (wantToAdd) {
            int count = allConnectionList.size();
            if (count + 1 > limit) {
                logger.info("Session count (" + count + "+1)>" + limit + ".");
                return false;
            }
        } else {
            int count = allConnectionList.size();
            if (count > limit) {
                logger.info("Session count " + count + ">" + limit + ".");
                return false;
            }
        }
        return true;
    }

    public Set<Integer> getFlowDevices(int deviceId) throws BGException {
        HashSet<Integer> agentDeviceIds = new HashSet<Integer>();
        agentDeviceIds.add(deviceId);
        FlowAgentInterfaceSelector ifaceSelector = new FlowAgentInterfaceSelector(this, agentDeviceIds, 1, 2, 5, 3, 4);
        FlowAgent flowAgent = ifaceSelector.getAgentIdMap().get(deviceId);
        HashSet<Integer> deviceIds = new HashSet<Integer>();
        if (flowAgent != null) {
            for (Map.Entry<Integer, FlowAgentInterface> entry : flowAgent.getIfaceMap().entrySet()) {
                FlowAgentInterface iface = entry.getValue();
                for (Integer devId : iface.deviceIds) {
                    deviceIds.add(devId);
                }
            }
        }
        deviceIds.add(deviceId);
        return deviceIds;
    }

    public static class ConnectionAddEvent
    extends LocalEvent {
        private final InetConnection connection;

        public ConnectionAddEvent(InetConnection connection) {
            this.connection = connection;
        }

        public InetConnection getConnection() {
            return this.connection;
        }
    }

    public static final class ConnectionRemoveEvent
    extends ConnectionAddEvent {
        public ConnectionRemoveEvent(InetConnection connection) {
            super(connection);
        }
    }

    public static final class ConnectionUpdateEvent
    extends ConnectionAddEvent {
        public ConnectionUpdateEvent(InetConnection connection) {
            super(connection);
        }
    }
}

