/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.manage.DeviceManageWorker;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorDeviceWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.event.InetDeviceUptimeEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public class AccessDeviceManager
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final Access access;
    private final PoolEventPublisher<InetDeviceUptimeEvent> uptimePublisher;
    private final ScheduledExecutorService saScheduledExecutorService;
    private final ScheduledExecutorService manageScheduledExecutorService;
    private final ConcurrentMap<Integer, ServiceActivatorDeviceWorker> saDeviceWorkerMap;
    private final ConcurrentMap<Integer, DeviceManageWorker> deviceManageWorkerMap;
    private volatile boolean started = false;

    public AccessDeviceManager(final Access access) throws BGException {
        InetDeviceRuntime rootDeviceRuntime;
        this.access = access;
        this.saDeviceWorkerMap = new ConcurrentHashMap<Integer, ServiceActivatorDeviceWorker>(access.childrenDeviceIds.size());
        this.deviceManageWorkerMap = new ConcurrentHashMap<Integer, DeviceManageWorker>(access.childrenDeviceIds.size());
        this.uptimePublisher = EventProcessor.getInstance().newPoolEventPublisher(InetDeviceUptimeEvent.class, access.moduleId, 500, 10000L);
        int saThreadCount = 100;
        int manageThreadCount = 80;
        int rootFetchDelay = 200;
        int rootFetchTimeout = 200;
        if (access.childrenDeviceIds != null && access.childrenDeviceIds.size() > 500) {
            saThreadCount = 200;
            manageThreadCount = 160;
            rootFetchTimeout = 100;
        }
        if ((rootDeviceRuntime = access.deviceMap.get(access.rootDeviceId)) != null) {
            saThreadCount = rootDeviceRuntime.config.getInt("sa.thread.count", saThreadCount);
            rootFetchDelay = rootDeviceRuntime.config.getInt("sa.fetchDelay", rootFetchDelay);
            rootFetchTimeout = rootDeviceRuntime.config.getInt("sa.fetchTimeout", rootFetchTimeout);
            manageThreadCount = rootDeviceRuntime.config.getInt("manage.thread.count", manageThreadCount);
        }
        this.saScheduledExecutorService = WorkerTask.newScheduledThreadPool((String)"sa", (String)"connection", (ThreadContextFactory)new ThreadContextFactory<EventListenerContext>(){

            public EventListenerContext newThreadContext() {
                return new EventListenerContext(access.setup, access.moduleId, SetupParam.getApplicationName());
            }
        }, (int)saThreadCount);
        this.manageScheduledExecutorService = manageThreadCount > 0 ? WorkerTask.newScheduledThreadPool((String)"dm", (String)"access", (ThreadContextFactory)new ThreadContextFactory<EventListenerContext>(){

            public EventListenerContext newThreadContext() {
                return new EventListenerContext(access.setup, access.moduleId, SetupParam.getApplicationName());
            }
        }, (int)manageThreadCount) : this.saScheduledExecutorService;
        logger.info("Create ServiceActivatorDeviceWorkers and DeviceManageWorkers and add listeners");
        int count = 0;
        HashMap<Integer, Object> invDeviceMap = new HashMap<Integer, Object>();
        for (Integer deviceId : access.childrenDeviceIds) {
            InetDeviceRuntime deviceRuntime = access.deviceMap.get(deviceId);
            if (deviceRuntime == null) continue;
            invDeviceMap.merge(deviceId, deviceRuntime, (o, n) -> {
                if (o == null) {
                    return n;
                }
                if (o instanceof InetDeviceRuntime) {
                    ArrayList<InetDeviceRuntime> list = new ArrayList<InetDeviceRuntime>();
                    list.add((InetDeviceRuntime)o);
                    list.add((InetDeviceRuntime)n);
                    return list;
                }
                List list = (List)o;
                list.add((InetDeviceRuntime)n);
                return list;
            });
        }
        for (Integer deviceId : access.childrenDeviceIds) {
            if (++count % 100 == 0) {
                logger.info("Created " + count + " SA and DM.");
            }
            int fetchDelay = rootFetchDelay;
            int fetchTimeout = rootFetchTimeout;
            InetDeviceRuntime deviceRuntime = access.deviceMap.get(deviceId);
            if (deviceRuntime != null) {
                fetchDelay = rootDeviceRuntime.config.getInt("sa.fetchDelay", fetchDelay);
                fetchTimeout = rootDeviceRuntime.config.getInt("sa.fetchTimeout", fetchTimeout);
            }
            this.saDeviceWorkerMap.put(deviceId, new ServiceActivatorDeviceWorker(access, this.saScheduledExecutorService, deviceId, fetchDelay, fetchTimeout));
            if (deviceRuntime == null || this.deviceManageWorkerMap.containsKey(deviceRuntime.inetDevice.getInvDeviceId())) continue;
            Object o2 = invDeviceMap.get(deviceId);
            Set<Integer> inetDeviceIds = o2 instanceof List ? ((List)o2).stream().map(a -> (InetDeviceRuntime)a).map(a -> a.inetDeviceId).collect(Collectors.toSet()) : Collections.singleton(deviceRuntime.inetDeviceId);
            this.deviceManageWorkerMap.put(deviceRuntime.inetDevice.getInvDeviceId(), new DeviceManageWorker(access, this, this.manageScheduledExecutorService, deviceRuntime.inetDevice.getInvDeviceId(), deviceId, inetDeviceIds, this.uptimePublisher));
        }
        logger.info("Create SA and DM finished (" + count + ").");
    }

    public void start() throws BGException {
        if (this.started) {
            logger.error("Already started!");
            return;
        }
        this.started = true;
        logger.info("Starting SA and DM listeners...");
        for (ServiceActivatorDeviceWorker sa : this.saDeviceWorkerMap.values()) {
            sa.start();
        }
        for (DeviceManageWorker dw : this.deviceManageWorkerMap.values()) {
            dw.start();
        }
        logger.info("SA and DM listeners started.");
        Shutdown.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ServiceActivatorDeviceWorker worker : AccessDeviceManager.this.saDeviceWorkerMap.values()) {
                    try {
                        worker.shutdown();
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    AccessDeviceManager.this.saScheduledExecutorService.shutdown();
                    InetUtils.awaitTermination(AccessDeviceManager.this.saScheduledExecutorService, "ServiceActivators", 20L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                AccessDeviceManager.this.uptimePublisher.close();
            }
        });
        EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, this.access.moduleId, null);
    }

    public synchronized void notify(Event e, EventListenerContext ctx) throws BGException {
        InetDeviceRuntime rootDeviceRuntime;
        int rootFetchDelay = 200;
        int rootFetchTimeout = 200;
        if (this.access.childrenDeviceIds != null && this.access.childrenDeviceIds.size() > 500) {
            rootFetchTimeout = 100;
        }
        if ((rootDeviceRuntime = this.access.deviceMap.get(this.access.rootDeviceId)) != null) {
            rootFetchDelay = rootDeviceRuntime.config.getInt("sa.fetchDelay", rootFetchDelay);
            rootFetchTimeout = rootDeviceRuntime.config.getInt("sa.fetchTimeout", rootFetchTimeout);
        }
        for (Integer deviceId : this.access.childrenDeviceIds) {
            InetDeviceRuntime deviceRuntime = this.access.deviceMap.get(deviceId);
            if (this.saDeviceWorkerMap.get(deviceId) == null) {
                logger.info("Add new SA for deviceId:" + deviceId);
                int fetchDelay = rootFetchDelay;
                int fetchTimeout = rootFetchTimeout;
                if (deviceRuntime != null) {
                    fetchDelay = rootDeviceRuntime.config.getInt("sa.fetchDelay", fetchDelay);
                    fetchTimeout = rootDeviceRuntime.config.getInt("sa.fetchTimeout", fetchTimeout);
                }
                ServiceActivatorDeviceWorker sa = new ServiceActivatorDeviceWorker(this.access, this.saScheduledExecutorService, deviceId, fetchDelay, fetchTimeout);
                this.saDeviceWorkerMap.put(deviceId, sa);
                sa.start();
            }
            if (deviceRuntime == null) continue;
            this.registerDeviceManager(deviceId, deviceRuntime);
        }
    }

    private void registerDeviceManager(Integer deviceId, InetDeviceRuntime deviceRuntime) throws BGException {
        DeviceManageWorker dw = (DeviceManageWorker)((Object)this.deviceManageWorkerMap.get(deviceRuntime.inetDevice.getInvDeviceId()));
        if (dw == null) {
            logger.info("Add new DM for deviceId:" + deviceId);
            dw = new DeviceManageWorker(this.access, this, this.manageScheduledExecutorService, deviceRuntime.inetDevice.getInvDeviceId(), deviceId, Collections.singleton(deviceId), this.uptimePublisher);
            this.deviceManageWorkerMap.put(deviceRuntime.inetDevice.getInvDeviceId(), dw);
            dw.start();
        } else if (!dw.getInetDeviceIds().contains(deviceId)) {
            logger.info("Replace DM for deviceId:" + deviceId);
            this.deviceManageWorkerMap.remove(deviceRuntime.inetDevice.getInvDeviceId(), (Object)dw);
            dw.shutdown();
            HashSet<Integer> inetDeviceIds = new HashSet<Integer>(dw.getInetDeviceIds());
            inetDeviceIds.add(deviceId);
            dw = new DeviceManageWorker(this.access, this, this.manageScheduledExecutorService, deviceRuntime.inetDevice.getInvDeviceId(), deviceId, inetDeviceIds, this.uptimePublisher);
            this.deviceManageWorkerMap.put(deviceRuntime.inetDevice.getInvDeviceId(), dw);
            dw.start();
        }
    }

    public ServiceActivatorDeviceWorker getServiceActivatorDeviceWorker(int deviceId) {
        return (ServiceActivatorDeviceWorker)((Object)this.saDeviceWorkerMap.get(deviceId));
    }
}

