/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.common.model.IdTitle;

public abstract class WebActionBase
extends ActionBase {
    protected void setMessage(Element element, String messageId) {
        this.createElement(element, "message_custom").setAttribute("id", messageId);
    }

    protected void setCommData(Element element, Properties properties, String prefix) {
        element.setAttribute(prefix + "comm.mode", properties.getProperty("comm.mode"));
        element.setAttribute(prefix + "comm.phone.value", properties.getProperty("comm.phone.value", ""));
        element.setAttribute(prefix + "comm.email.value", properties.getProperty("comm.email.value", ""));
        element.setAttribute(prefix + "comm.sms.value", properties.getProperty("comm.sms.value", ""));
        element.setAttribute(prefix + "comm.telegram.value", properties.getProperty("comm.telegram.value", ""));
        element.setAttribute(prefix + "comm.phone.enable", this.plugin.getSetup().get("default.comm.phone.enable", "true"));
        element.setAttribute(prefix + "comm.email.enable", this.plugin.getSetup().get("default.comm.email.enable", "true"));
        element.setAttribute(prefix + "comm.sms.enable", this.plugin.getSetup().get("default.comm.sms.enable", "true"));
        element.setAttribute(prefix + "comm.telegram.enable", this.plugin.getSetup().get("default.comm.telegram.enable", "true"));
    }

    protected Properties getCommData(String prefix) {
        Properties properties = new Properties();
        properties.setProperty("comm.mode", this.getParameter(prefix + "comm.mode"));
        String value = this.getParameter(prefix + "comm.phone.value", null);
        if (value != null && value.trim().length() > 0) {
            properties.setProperty("comm.phone.value", value);
        }
        if ((value = this.getParameter(prefix + "comm.email.value", null)) != null && value.trim().length() > 0) {
            properties.setProperty("comm.email.value", value);
        }
        return properties;
    }

    protected void setError(String id) {
        Element error = this.createElement(this.rootNode, "error_custom");
        error.setAttribute("id", id);
    }

    protected void setCategoryData() throws BGException {
        HelpDeskDirectoryManager helpDeskDirectoryManager = new HelpDeskDirectoryManager(this.con, this.plugin);
        ArrayList<IdTitle> catList = new ArrayList<IdTitle>();
        int groupId = helpDeskDirectoryManager.getContractGroupId(this.cid);
        if (groupId > 0) {
            Map<Integer, List<Integer>> map = helpDeskDirectoryManager.getSubCategoryIds(groupId);
            HashMap<Integer, List<Object>> rMap = new HashMap<Integer, List<Object>>();
            for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
                int idCategory = entry.getKey();
                catList.add(new IdTitle(idCategory, helpDeskDirectoryManager.getCategoryTitle(idCategory)));
                List<IdTitle> subList = helpDeskDirectoryManager.getSubcategory((Collection<Integer>)entry.getValue());
                subList.add(0, new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                rMap.put(idCategory, subList);
            }
            if (catList.size() > 0) {
                catList.add(0, new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                ArrayList<IdTitle> subList = new ArrayList<IdTitle>();
                subList.add(new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                rMap.put(-1, subList);
                this.request.setAttribute("categoryList", catList);
                this.request.setAttribute("subCategoryMap", rMap);
            }
            ArrayList<String[]> catAllList = new ArrayList<String[]>();
            catAllList.add(new String[]{"-1", "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"});
            for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
                int categoryId = entry.getKey();
                String categoryTitle = helpDeskDirectoryManager.getCategoryTitle(categoryId);
                helpDeskDirectoryManager.getSubcategory((Collection<Integer>)entry.getValue()).forEach(a -> catAllList.add(new String[]{categoryId + "_" + a.getId(), categoryTitle + " / " + a.getTitle()}));
            }
            this.request.setAttribute("categorys", catAllList);
        }
    }

    public static class ListItem {
        private int id = 0;
        private String title = "";
        private String value = "";
        private boolean selected = false;

        public ListItem(int id, String title, String value) {
            this(id, title, value, false);
        }

        public ListItem(int id, String title, String value, boolean selected) {
            this.id = id;
            this.title = title;
            this.value = value;
            this.selected = selected;
        }

        public int getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

