/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGControlPanelPluginControls;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.contract.PaymentAndChargeEditor;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.cashcheck.client.ManagerQueue;
import ru.bitel.bgbilling.plugins.cashcheck.client.PosLoginDialog;
import ru.bitel.bgbilling.plugins.cashcheck.common.BGPrinterNotloggedMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.CashcheckService;
import ru.bitel.bgbilling.plugins.cashcheck.common.PrintCheckData;
import ru.bitel.common.Utils;

public class ContractPaymentCheckbox
extends BGUPanel
implements BGControlPanelPluginControls.IPluginControls {
    private JCheckBox cb = new JCheckBox("\u041f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
    private JLabel kkmTitle = new JLabel("?");
    private int _checkmode = -1;

    public ContractPaymentCheckbox() {
        super((LayoutManager)new GridLayout(0, 2), new ClientContext("ru.bitel.bgbilling.plugins.cashcheck", 0, 0, ""));
        this.add(this.cb);
        this.add(this.kkmTitle);
        this.cb.setSelected(false);
    }

    protected void jbInit() throws Exception {
    }

    public void doAction(Component owner, Object ... data) {
        if (this.cb.isSelected()) {
            try {
                String id = (String)data[0];
                String clientSumma = (String)data[1];
                BigDecimal fsumma = ManagerQueue.getClientSumma("", new BigDecimal(clientSumma));
                if (fsumma != null && this._checkmode != -1) {
                    List ids = Utils.toIntegerList((String)id);
                    this.printCheckFromDialogPayment(ids, fsumma, this._checkmode);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "CashCheck: \u0432 \u043a\u043b\u0438\u0435\u043d\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e);
                e.printStackTrace();
            }
        }
    }

    private void printCheckFromDialogPayment(List<Integer> ids, BigDecimal clientSumma, int checkmode) {
        try {
            if (checkmode == 0) {
                PrintCheckData result = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).printCheck(ids, clientSumma);
                String summaRet = result.summa;
                String submitRet = result.submit;
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0447\u0435\u043a \u043d\u0430 \u0441\u0443\u043c\u043c\u0443: " + summaRet + "\n\n\u0421\u0434\u0430\u0447\u0430: " + submitRet);
            } else if (checkmode == 1) {
                PrintCheckData result = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).returnCheckCharge(ids.get(0).intValue());
                String summaRet = result.summa;
                String submitRet = result.submit;
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443: " + summaRet + "\n\n\u0421\u0434\u0430\u0447\u0430: " + submitRet);
            }
        }
        catch (BGPrinterNotloggedMessageException e) {
            PosLoginDialog posLoginDialog = new PosLoginDialog();
            if ("1".equals(posLoginDialog.showDialog())) {
                this.printCheckFromDialogPayment(ids, clientSumma, checkmode);
                return;
            }
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0427\u0435\u043a \u043d\u0435 \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d.");
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
        }
    }

    public boolean beforeAdd(Component owner, Object ... data) {
        return true;
    }

    public void doSetData(Component owner, Object ... data) {
        boolean isVis = false;
        if (owner instanceof PaymentAndChargeEditor) {
            PaymentAndChargeEditor dialogPACE = (PaymentAndChargeEditor)owner;
            if (dialogPACE.getMode() == 0) {
                isVis = true;
                this.cb.setText("\u041f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                this._checkmode = 0;
            } else if (dialogPACE.getMode() == 1 || dialogPACE.getMode() == 2) {
                isVis = true;
                this.cb.setText("\u041f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430");
                this._checkmode = 1;
            }
        }
        this.setVisible(isVis);
        if (isVis) {
            ClientSetup setup = ClientSetup.getInstance();
            DBInfo dbinfo = DBInfoManager.getManager().getActiveDBInfo();
            String defaultcheckboxmode = setup.get("dbinfo.cashcheck.default.checkbox" + (this._checkmode == 1 ? ".refund" : "") + ".mode", "defaultoff");
            String checkboxmode = setup.get("dbinfo.cashcheck.user." + dbinfo.getUser() + ".checkbox" + (this._checkmode == 1 ? ".refund" : "") + ".mode", defaultcheckboxmode);
            boolean isEnabled = false;
            boolean isSelected = false;
            if ("defaultoff".equals(checkboxmode)) {
                isSelected = false;
                isEnabled = true;
            } else if ("defaulton".equals(checkboxmode)) {
                isSelected = true;
                isEnabled = true;
            } else if ("off".equals(checkboxmode)) {
                isSelected = false;
                isEnabled = false;
            } else if ("on".equals(checkboxmode)) {
                isSelected = true;
                isEnabled = false;
            }
            this.cb.setEnabled(isEnabled);
            this.cb.setSelected(isSelected);
            String registratorName = null;
            try {
                registratorName = ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).getCurrentPrinter();
            }
            catch (BGException e) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            }
            this.kkmTitle.setText("<html><i>\u041a\u041a\u041c: " + registratorName + "</i></html>");
        }
    }

    public boolean beforeAction(Component owner, Object ... data) {
        if (this.cb.isSelected()) {
            try {
                String summa = (String)data[1];
                Integer type = (Integer)data[3];
                new BigDecimal(summa);
                return this.beforeCheckDialogPayment(type, this._checkmode);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "CashCheck: \u0432 \u043a\u043b\u0438\u0435\u043d\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e);
                return false;
            }
        }
        return true;
    }

    private boolean beforeCheckDialogPayment(Integer type, int checkmode) {
        try {
            ((CashcheckService)((ClientContext)this.getContext()).getPort(CashcheckService.class)).checkManualPrint(checkmode, type.intValue());
            return true;
        }
        catch (BGPrinterNotloggedMessageException e) {
            PosLoginDialog posLoginDialog = new PosLoginDialog();
            if ("1".equals(posLoginDialog.showDialog())) {
                return this.beforeCheckDialogPayment(type, checkmode);
            }
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412\u0445\u043e\u0434 \u043d\u0430 \u041a\u041a\u0422 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d!");
            return false;
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            return false;
        }
    }
}

