/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots.message;

import com.vk.api.sdk.objects.messages.Message;
import java.util.Optional;
import org.json.JSONObject;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotManagment;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.common.Utils;

public abstract class MessageBuilder {
    protected final RuntimeBot runtimeBot;
    protected final BotDialog errorDialog;

    public MessageBuilder(RuntimeBot runtimeBot) throws BGException {
        this.runtimeBot = runtimeBot;
        int errorDialogId = runtimeBot.getBotConfig().getInt("error.dialog.id", -1);
        this.errorDialog = errorDialogId > 0 ? runtimeBot.getBotManagerService().getDialogById(errorDialogId) : null;
    }

    protected <T> T buildMessage(long chatId, int messageId, BotDialog dialog, Class<T> responseMessageType) throws BGException {
        Message instance = null;
        if (responseMessageType.isAssignableFrom(SendMessage.class)) {
            instance = this.buildMessage((Long)chatId, messageId, dialog);
        } else if (responseMessageType.isAssignableFrom(Message.class)) {
            instance = this.buildMessage((Integer)((int)chatId), dialog);
        }
        return (T)instance;
    }

    protected <T> T buildMessage(long chatId, String text, Class<T> responseMessageType) {
        Message resultInstance = null;
        if (responseMessageType.isAssignableFrom(SendMessage.class)) {
            resultInstance = this.buildMessage(chatId, text);
        } else if (responseMessageType.isAssignableFrom(Message.class)) {
            resultInstance = this.buildMessage((Integer)((int)chatId), text);
        }
        return (T)resultInstance;
    }

    protected BotApiMethod<?> buildMessage(Long chatId, String messageText) {
        return null;
    }

    protected BotApiMethod<?> buildMessage(Long chatId, int messageId, BotDialog dialog) throws BGException {
        return null;
    }

    protected BotApiMethod<?> buildErrorMessage(Long chatId, String messageText, boolean useCustomErrorDialog) throws BGException {
        return null;
    }

    protected BotApiMethod<?> buildErrorMessage(Long chatId) {
        return null;
    }

    protected BotApiMethod<?> buildErrorMessage(Long chatId, String text) {
        return null;
    }

    protected Message buildMessage(Integer chatId, String messageText) {
        return null;
    }

    protected Message buildMessage(Integer chatId, BotDialog dialog) throws BGException {
        return null;
    }

    protected Message buildErrorMessage(Integer chatId, String text, boolean useCustomErrorDialog) throws BGException {
        return null;
    }

    protected Message buildErrorMessage(Integer chatId, String text) throws BGException {
        return null;
    }

    protected Message buildErrorMessage(Integer chatId) throws BGException {
        return null;
    }

    protected Optional<DialogProcessing> getDialogProcessingImplementation(BotDialog dialog) {
        String pathToImplementation = dialog.getProcessingClass();
        if (Utils.isBlankString((String)pathToImplementation)) {
            return Optional.empty();
        }
        return Optional.ofNullable(BotManagment.getOrInitAndGet(this.runtimeBot.getModuleId()).getDialogProcessingClasses().get(pathToImplementation));
    }

    public void processMacros(BotDialog botDialog, JSONObject chatData) {
        if (!chatData.has("macros")) {
            return;
        }
        JSONObject macrosValues = chatData.optJSONObject("macros");
        for (BotDialogElement element : botDialog.getDialogElements()) {
            String[] wordsArray;
            if (!element.getElementType().equals((Object)BotDialogElementType.TEXT)) continue;
            String text = element.getJSONConfig().optString("text");
            StringBuilder stringBuilder = new StringBuilder();
            for (String word : wordsArray = text.split("[\n|\t|\\\\A|\\s]")) {
                if (word.contains("${") && word.contains("}")) {
                    String key = word.replace("${", "").replace("}", "");
                    String value = macrosValues.optString(key);
                    if (value == null || value.length() <= 0) continue;
                    String wordResult = word.replace("${" + key + "}", value);
                    stringBuilder.append(wordResult.trim()).append(" ");
                    continue;
                }
                if (word.length() == 0) {
                    stringBuilder.append("\n");
                    continue;
                }
                stringBuilder.append(word).append(" ");
            }
            JSONObject configElement = element.getJSONConfig().put("text", (Object)stringBuilder.toString().trim());
            element.setConfigElement(configElement.toString());
        }
    }

    protected BotDialog getDialogByPressedButton(BotDialog dialogWithButton, String buttonText) throws BGException {
        Optional<BotDialogElement> pressedButton = this.getPressedButton(dialogWithButton, buttonText);
        if (pressedButton.isEmpty()) {
            return null;
        }
        return this.runtimeBot.getBotManagerService().getDialogById(pressedButton.get().getJSONConfig().optInt("dialogProcessingClassPath", -1));
    }

    protected Optional<BotDialogElement> getPressedButton(BotDialog dialogWithButton, String buttonText) {
        return dialogWithButton.getDialogElements().stream().filter(element -> element.getElementType().equals((Object)BotDialogElementType.BUTTON) && element.getJSONConfig().optString("text", "").equals(buttonText)).findFirst();
    }
}

