/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogGroup;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class DialogGroupPanel
extends BGUTabPanel {
    private BGTableModel<BotDialogGroup> tableModel;
    private GroupEditor editor;
    private BotManagerService botManagerService = null;

    protected void jbInit() throws Exception {
        this.editor = new GroupEditor();
        this.tableModel = new GroupsTableModel();
        BGUTable groupsTable = new BGUTable(this.tableModel);
        groupsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BotDialogGroup selectedGroup;
                if (e.getButton() == 1 && e.getClickCount() == 2 && (selectedGroup = (BotDialogGroup)DialogGroupPanel.this.tableModel.getSelectedRow()) != null) {
                    DialogGroupPanel.this.editor.editGroup(selectedGroup);
                }
            }
        });
        groupsTable.enableSearchField();
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)groupsTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.tableModel.setData(this.getService().getDialogGroups())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.editor.editGroup(null));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            BotDialogGroup selectedGroup = (BotDialogGroup)this.tableModel.getSelectedRow();
            if (selectedGroup == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            this.editor.editGroup(selectedGroup);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            BotDialogGroup selectedGroup = (BotDialogGroup)this.tableModel.getSelectedRow();
            if (selectedGroup == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)selectedGroup.getTitle())) {
                this.getService().deleteDialogGroup(selectedGroup);
                this.performAction("refresh");
            }
        });
    }

    private BotManagerService getService() {
        if (this.botManagerService == null) {
            this.botManagerService = (BotManagerService)((ClientContext)this.getContext()).getPort(BotManagerService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.botManagerService;
    }

    private class GroupEditor
    extends JPanel {
        private JTextField title = new JTextField();
        private JTextArea comment = new JTextArea();
        private BotDialogGroup currentGroup;

        GroupEditor() {
            this.setLayout(new GridBagLayout());
            this.setVisible(false);
            BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432");
            JScrollPane commentScrollPane = new JScrollPane();
            commentScrollPane.getViewport().add((Component)this.comment, "Center");
            this.comment.setLineWrap(true);
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    String groupTitle = this.title.getText();
                    if (Utils.isBlankString((String)groupTitle)) {
                        ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0438\u043c\u044f \u0433\u0440\u0443\u043f\u043f\u044b");
                        return;
                    }
                    if (this.currentGroup == null) {
                        this.currentGroup = new BotDialogGroup();
                    }
                    this.currentGroup.setTitle(groupTitle);
                    this.currentGroup.setComment(this.comment.getText());
                    try {
                        DialogGroupPanel.this.getService().updateDialogGroup(this.currentGroup);
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.setVisible(false);
                DialogGroupPanel.this.performAction("refresh");
            });
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)commentScrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
            this.add((Component)okCancel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 14, 2, new Insets(3, 3, 0, 0), 0, 0));
        }

        private void editGroup(BotDialogGroup group) {
            this.currentGroup = group;
            if (this.currentGroup == null) {
                this.title.setText("");
                this.comment.setText("");
            } else {
                this.title.setText(this.currentGroup.getTitle());
                this.comment.setText(this.currentGroup.getComment());
            }
            this.setVisible(true);
        }
    }

    private class GroupsTableModel
    extends BGTableModel<BotDialogGroup> {
        public GroupsTableModel() {
            this("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432");
        }

        public GroupsTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

