/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.common.service;

import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusBalance;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPaymentType;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Period;

@WebService
@XmlSeeAlso(value={BonusPaymentType.class})
public interface BonusService {
    public List<BonusPaymentType> paymentTypeList(@WebParam(name="usedOnly") boolean var1) throws BGException;

    public void paymentTypeUpdate(@WebParam(name="paymentType") BonusPaymentType var1) throws BGException;

    public boolean paymentTypeDelete(@WebParam(name="paymentId") int var1) throws BGException;

    public List<BonusPayment> paymentList(@WebParam(name="contractId") int var1, @WebParam(name="dateFrom") Date var2, @WebParam(name="dateTo") Date var3) throws BGException;

    public List<BonusPayment> paymentsNotActiveNow(@WebParam(name="contractId") int var1) throws BGException;

    public List<BonusCharge> chargeList(@WebParam(name="cid") int var1, @WebParam(name="dateFrom") Date var2, @WebParam(name="dateTo") Date var3) throws BGException;

    public BonusCharge chargeBonus(@WebParam(name="contractChargeId") int var1) throws BGException;

    public void paymentUpdate(@WebParam(name="contractId") int var1, @WebParam(name="payment") BonusPayment var2) throws BGException;

    public boolean chargeUpdate(@WebParam(name="contractId") int var1, @WebParam(name="charge") BonusCharge var2) throws BGException;

    public int activateTO(@WebParam(name="contractId") int var1, @WebParam(name="tariffOptionId") int var2, @WebParam(name="modeId") int var3) throws BGException;

    public boolean paymentDelete(@WebParam(name="paymentId") int var1) throws BGException;

    public void chargeDeleteByContractChargeId(@WebParam(name="contractChargeId") int var1) throws BGException;

    public List<BonusPayment> paymentDetailsList(@WebParam(name="chargeId") int var1) throws BGException;

    public List<BonusCharge> chargeDetailsList(@WebParam(name="paymentId") int var1) throws BGException;

    public List<BonusBalance> balanceList(@WebParam(name="contractId") int var1, @WebParam(name="date") Date var2) throws BGException;

    public BigDecimal balance(@WebParam(name="contractId") int var1, @WebParam(name="date") Date var2) throws BGException;

    public BigDecimal balanceAdvanced(@WebParam(name="contractId") int var1, @WebParam(name="date") Date var2, @WebParam(name="chargeId") Integer var3, @WebParam(name="withFutureCharge") boolean var4) throws BGException;

    public BigDecimal balanceNotActive(@WebParam(name="contractId") int var1, @WebParam(name="date") Date var2) throws BGException;

    public boolean pluginInclude(@WebParam(name="contractId") int var1) throws BGException;

    public void updatePluginInclude(@WebParam(name="contractId") int var1, @WebParam(name="include") boolean var2) throws BGException;

    public int percentOfBonus(@WebParam(name="contractChargeId") int var1) throws BGException;

    public int rate();

    public BigDecimal bonusSummaMax(@WebParam(name="contractId") int var1, @WebParam(name="contractChargeId") int var2, @WebParam(name="chargeSum") BigDecimal var3, @WebParam(name="bonusSum") boolean var4) throws BGException;

    public BigDecimal bonusSummaMaxAdvanced(@WebParam(name="contractId") int var1, @WebParam(name="contractChargeId") int var2, @WebParam(name="chargeSum") BigDecimal var3, @WebParam(name="bonusSum") boolean var4, @WebParam(name="MaxSum") BigDecimal var5) throws BGException;

    public String treeNodeTitle(@WebParam(name="contractId") int var1) throws BGException;

    public MapHolder<String, String> programTypeMap() throws BGException;

    public List<BonusProgram> programList(@WebParam(name="date") Date var1) throws BGException;

    public void programUpdate(@WebParam(name="program") BonusProgram var1) throws BGException;

    public List<BonusContractProgram> programContractList(@WebParam(name="contractId") int var1) throws BGException;

    public void programContractUpdate(@WebParam(name="bonusContractProgram") BonusContractProgram var1) throws BGException, BGMessageException;

    public boolean checkProgramPeriodOnCrossing(@WebParam(name="bonusProgram") BonusProgram var1) throws BGException;

    public List<Integer> programInContractList(@WebParam(name="idProgram") int var1, @WebParam(name="date") Date var2) throws BGException;

    public void programDelete(@WebParam(name="programId") int var1) throws BGException;

    public void updateProgramAndPluginIncludeGroupOperation(@WebParam(name="programs") List<BonusProgram> var1, @WebParam(name="cids") String var2, @WebParam(name="period") Period var3, @WebParam(name="include") boolean var4) throws BGException;

    public void extendPaymentsGroupOperation(@WebParam(name="cids") String var1, @WebParam(name="paymentPeriod") Period var2, @WebParam(name="paymentTypeSet") Set<Integer> var3, @WebParam(name="typeExtend") int var4, @WebParam(name="valueExtend") String var5, @WebParam(name="onlyActive") boolean var6) throws BGException;

    public String getDataProgramOfContract(@WebParam(name="programId") int var1, @WebParam(name="contractId") int var2) throws BGException, BGMessageException;
}

