<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#151;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:utils="ru.bitel.bgbilling.server.util.ServerUtils"
	xmlns:counter="bitel.billing.server.util.exslt.Counter"	>

	<xalan:component prefix="counter" functions="add set get">
		<xalan:script lang="javaclass" src="xalan://bitel.billing.server.util.exslt.Counter" />
	</xalan:component>

	<xsl:output encoding="UTF-8" method='xml' indent='yes' />
	
	<xsl:variable name="text_8" select="concat('Всего оказано по договору №',/data/bill/@contract,' от ',/data/bill/@contract_date1,' услуг на сумму ','10',', в том числе НДС ',number(/data/bill/params/@nds),'% ','20',', вышеперечисленные услуги оказаны полностью и в срок, заказчик претензий по объему, качеству и и сроком оказания услуг не имеет')" />
	<xsl:variable name="text_10_post" select="/data/bill/params/param[@key='10.post']/text()"/>
	<!-- <xsl:variable name="text_10_post" select="/data/inline_params/@dolz" /> -->
 	<xsl:variable name="text_10_fio" select="/data/bill/params/param[@key='10.fio']/text()"/>
	<!-- <xsl:variable name="text_10_post" select="/data/inline_params/@name" /> -->
	<xsl:variable name="text_11">
		<xsl:choose>
			<xsl:when test="/data/bill/params/param[@key='11'] = 'docDate'"><xsl:value-of select="utils:dateToString( /data/bill/@date, 'dd.MM.yyyy', 'dd MMMM yyyy г.')"/></xsl:when>
			<xsl:otherwise>"______"&nbsp;&nbsp;______________________&nbsp;&nbsp;20____&nbsp;г.</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:attribute-set name="text">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_01">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">dashed</xsl:attribute>
		<xsl:attribute name="border-bottom-color">#E0E0E0</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_02">
		<xsl:attribute name="padding">1mm</xsl:attribute>
	</xsl:attribute-set>

 	<xsl:template match="data">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:apply-templates select="bill" />
		</fo:root>
	</xsl:template>

	<xsl:template name="post"><xsl:param name="value"/><xsl:call-template name="element1"><xsl:with-param name="value" select="$value"/><xsl:with-param name="text" select="'должность'"/><xsl:with-param name="width" select="'36mm'"/></xsl:call-template></xsl:template>
	<xsl:template name="sign"><xsl:call-template name="element1"><xsl:with-param name="value" select="''"/><xsl:with-param name="text" select="'подпись'"/><xsl:with-param name="width" select="'36mm'"/></xsl:call-template></xsl:template>
	<xsl:template name="fio"><xsl:param name="value"/><xsl:call-template name="element1"><xsl:with-param name="value" select="$value"/><xsl:with-param name="text" select="'ф.и.о.'"/><xsl:with-param name="width" select="'36mm'"/></xsl:call-template></xsl:template>
	<xsl:template name="responsible">
		<xsl:param name="post" />
		<xsl:param name="fio" />
		<xsl:param name="num" />
		<xsl:call-template name="element4">
			<xsl:with-param name="post" select="$post"/>
			<xsl:with-param name="fio" select="$fio"/>
			<xsl:with-param name="num" select="$num"/>
			<xsl:with-param name="text" select="'Ответственный за правильность оформления факта хозяйственной жизни'"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="element1">
		<xsl:param name="value" />
		<xsl:param name="text" />
		<xsl:param name="width" />
		<fo:table table-layout="fixed">
			<fo:table-column><xsl:attribute name="column-width"><xsl:value-of select="$width"/></xsl:attribute></fo:table-column>
			<fo:table-body>
				<fo:table-row text-align="center" display-align="after" height="5mm"><fo:table-cell border-width="0.8pt" border-bottom-style="solid"><fo:block><xsl:value-of select="$value"/></fo:block></fo:table-cell></fo:table-row>
				<fo:table-row text-align="center" display-align="center"><fo:table-cell><fo:block font-size="4pt">(<xsl:value-of select="$text" />)</fo:block></fo:table-cell></fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="element2">
		<fo:table table-layout="fixed">
			<fo:table-column column-width="125mm"/>
			<fo:table-column column-width="8mm"/>
			<fo:table-body>
				<xsl:call-template name="element4"><xsl:with-param name="post" select="$text_10_post"/><xsl:with-param name="fio" select="$text_10_fio"/><xsl:with-param name="num" select="'[10]'"/><xsl:with-param name="text" select="'Товар(груз) передал/услуги, результаты работ, права сдал'"/></xsl:call-template>
				<xsl:call-template name="element6"><xsl:with-param name="num" select="'[11]'"/><xsl:with-param name="text" select="'Дата отгрузки, передачи(сдачи)'"/><xsl:with-param name="date" select="$text_11"/></xsl:call-template>
				<xsl:call-template name="element5"><xsl:with-param name="num" select="'[12]'"/><xsl:with-param name="textTitle" select="'Иные сведения об отгрузке, передаче'"/><xsl:with-param name="textTip" select="'ссылки на неотъемлемые приложения, сопутствующие документы, иные документы и т.п.'"/></xsl:call-template>
				<xsl:call-template name="responsible"><xsl:with-param name="post" select="params/param[@key='13.post']/text()"/><xsl:with-param name="fio" select="params/param[@key='13.fio']/text()"/><xsl:with-param name="num" select="'[13]'"/></xsl:call-template>
				<xsl:call-template name="element5"><xsl:with-param name="num" select="'[14]'"/><xsl:with-param name="textTitle" select="'Наименование экономического субъекта - составителя документа (в т.ч. комиссионера /агента)'"/><xsl:with-param name="textTip" select="'может не заполняться при проставлении печати в М.П., может быть указан ИНН / КПП'"/></xsl:call-template>
				<xsl:call-template name="element7"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="element3">
		<fo:table table-layout="fixed">
			<fo:table-column column-width="125mm"/>
			<fo:table-column column-width="8mm"/>
			<fo:table-body>
				<xsl:call-template name="element4"><xsl:with-param name="post" select="''"/><xsl:with-param name="fio" select="''"/><xsl:with-param name="num" select="'[15]'"/><xsl:with-param name="text" select="'Товар(груз) получил/услуги, результаты работ, права принял'"/></xsl:call-template>
				<xsl:call-template name="element6"><xsl:with-param name="num" select="'[16]'"/><xsl:with-param name="text" select="'Дата получения(приемки)'"/><xsl:with-param name="date" select="''"/></xsl:call-template>
				<xsl:call-template name="element5"><xsl:with-param name="num" select="'[17]'"/><xsl:with-param name="textTitle" select="'Иные сведения о получении, приёмке'"/><xsl:with-param name="textTip" select="'информация о наличии/отсутствии претензий, ссылки на неотъемлемые приложения, и другие документы и т.п.'"/></xsl:call-template>
				<xsl:call-template name="responsible"><xsl:with-param name="post" select="''"/><xsl:with-param name="fio" select="''"/><xsl:with-param name="num" select="'[18]'"/></xsl:call-template>
				<xsl:call-template name="element5"><xsl:with-param name="num" select="'[19]'"/><xsl:with-param name="textTitle" select="'Наименование экономического субъекта - составителя документа'"/><xsl:with-param name="textTip" select="'может не заполняться при проставлении печати в М.П., может быть указан ИНН / КПП'"/></xsl:call-template>
				<xsl:call-template name="element7"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	
	<xsl:template name="element4">
		<xsl:param name="post" />
		<xsl:param name="fio" />
		<xsl:param name="num" />
		<xsl:param name="text" />
		<fo:table-row text-align="left" display-align="center">
			<fo:table-cell><fo:block padding-top="1mm"><xsl:value-of select="$text"/></fo:block></fo:table-cell>
			<fo:table-cell number-rows-spanned="2"><fo:block padding-top="1mm"><xsl:value-of select="$num"/></fo:block></fo:table-cell>
		</fo:table-row>
		<fo:table-row text-align="left" display-align="center">
			<fo:table-cell>
				<fo:table table-layout="fixed"> 
					<fo:table-column column-width="40mm"/>
					<fo:table-column column-width="40mm"/>
					<fo:table-column column-width="40mm"/>
					<fo:table-body>
						<fo:table-row text-align="left" display-align="center">
							<fo:table-cell><xsl:call-template name="post"><xsl:with-param name="value" select="$post"/></xsl:call-template></fo:table-cell>
							<fo:table-cell><xsl:call-template name="sign"/></fo:table-cell>
							<fo:table-cell><xsl:call-template name="fio"><xsl:with-param name="value" select="$fio"/></xsl:call-template></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template name="element5">
		<xsl:param name="num" />
		<xsl:param name="textTitle" />
		<xsl:param name="textTip" />
		<fo:table-row text-align="left" display-align="center">
			<fo:table-cell><fo:block padding-top="1mm"><xsl:value-of select="$textTitle"/></fo:block></fo:table-cell>
			<fo:table-cell number-rows-spanned="2"><fo:block padding-top="1mm"><xsl:value-of select="$num"/></fo:block></fo:table-cell>
		</fo:table-row>
		<fo:table-row text-align="left" display-align="center">
			<fo:table-cell><xsl:call-template name="element1"><xsl:with-param name="value" select="''"/><xsl:with-param name="text" select="$textTip"/><xsl:with-param name="width" select="'120mm'"/></xsl:call-template></fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<xsl:template name="element6">
		<xsl:param name="num" />
		<xsl:param name="text" />
		<xsl:param name="date" />
		<xsl:variable name="dd">
		<xsl:choose>
			<xsl:when test="$date"><xsl:value-of select="$date"/></xsl:when>
			<xsl:otherwise>"______"&nbsp;&nbsp;______________________&nbsp;&nbsp;20____&nbsp;г.</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		
		<fo:table-row text-align="left" display-align="center" line-height="6mm">
			<fo:table-cell><fo:block><xsl:value-of select="$text"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<xsl:value-of select="$dd"/></fo:block></fo:table-cell>
			<fo:table-cell><fo:block><xsl:value-of select="$num"/></fo:block></fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<xsl:template name="element7">
		<fo:table-row><fo:table-cell padding-left="20mm"><fo:block font-size="7pt">М.П.</fo:block></fo:table-cell></fo:table-row>
	</xsl:template>
	
	
	<xsl:template match="bill">
		<xsl:variable name="nds_rate" select="number(params/@nds)" />

		<fo:layout-master-set>
			<fo:simple-page-master master-name="first"
				margin-right="10mm" margin-left="20mm" margin-bottom="8mm" margin-top="8mm" 
				page-width="29.7cm" page-height="21cm">
				<fo:region-body margin-top="0cm" margin-bottom="0cm" />
				<fo:region-before extent="0cm" />
				<fo:region-after extent="0.5cm" />
			</fo:simple-page-master>
<!--
			<fo:simple-page-master master-name="second"
				margin-right="2cm" margin-left="2cm" margin-bottom="1cm" margin-top="0.5cm"
				page-width="21cm" page-height="29.7cm">
				<fo:region-body margin-top="0cm" margin-bottom="0.0cm" />
				<fo:region-before extent="0cm" />
				<fo:region-after extent="0.5cm" />
			</fo:simple-page-master>
			 
-->
		</fo:layout-master-set>
		
		<fo:page-sequence master-reference="first">
			<fo:flow flow-name="xsl-region-body" font-family="sans-serif">

			    <fo:block-container width="50mm" top="0cm" left="0cm" position="absolute">
        			<fo:block text-align="left" line-height="10pt" font-size="8pt" linefeed-treatment="preserve">Универсальный
        				 передаточный
        				 документ</fo:block>
				</fo:block-container>

			    <fo:block-container top="17mm" left="0cm" position="absolute" font-size="7pt">
			    	<fo:table table-layout="fixed">
						<fo:table-column column-width="12mm"/>
						<fo:table-column column-width="5mm"/>
						<fo:table-body line-height="10pt">
							<fo:table-row>
								<fo:table-cell><fo:block>Статус:</fo:block></fo:table-cell>
								<fo:table-cell border-width="1pt" border-style="solid"><fo:block text-align="center"><xsl:value-of select="params/param[@key='status']/text()" /></fo:block></fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block-container>

			    <fo:block-container width="25mm" top="25mm" left="0cm" position="absolute">
        			<fo:block text-align="left" line-height="7pt" font-size="5pt" linefeed-treatment="preserve">1 - счёт-фактура и передаточный документ (акт)
        				 2 - передаточный документ (акт)</fo:block>
				</fo:block-container>
			
			    <fo:block-container width="13cm" top="0cm" left="13.7cm" position="absolute" text-align="right" line-height="8pt" font-size="6pt">
        			<fo:block>Приложение №1 к постановлению Правительства Российской Федерации от 26 декабря 2011г № 1137</fo:block>
        			<fo:block>(в редакции постановления Правительства Российской Федерации от 19 августа 2017г № 981)</fo:block>
				</fo:block-container>

				<xsl:variable name="numberIspravlenia">
					<xsl:choose>
						<xsl:when test="@correction=0">-</xsl:when>
						<xsl:when test="@correction"><xsl:value-of select="@correction" /></xsl:when>
						<xsl:otherwise>&mdash;</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
			    <fo:block-container width="15cm" top="0cm" left="3cm" position="absolute">
			    	<fo:table table-layout="fixed" font-size="8pt" font-weight="bold">
						<fo:table-column column-width="25mm"/>
						<fo:table-column column-width="20mm"/>
						<fo:table-column column-width="5mm"/>
						<fo:table-column column-width="30mm"/>
						<fo:table-column column-width="10mm"/>
						<fo:table-body line-height="9pt">
							<fo:table-row>
								<fo:table-cell><fo:block>Счет-фактура</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>№ <xsl:value-of select="@bill_number" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>от</fo:block></fo:table-cell>
								<fo:table-cell><fo:block><xsl:value-of select="@date" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block font-weight="normal" font-size="7pt">(1)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>Исправление</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>№ <xsl:value-of select="$numberIspravlenia"/></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>от</fo:block></fo:table-cell>
								<fo:table-cell><fo:block><xsl:value-of select="@correction_date" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block font-weight="normal" font-size="7pt">(1a)</fo:block></fo:table-cell>
							</fo:table-row>
       					</fo:table-body>
       				</fo:table>
				</fo:block-container>
				
			    <fo:block-container width="15cm" top="9mm" left="27mm" position="absolute" font-size="7pt">
			    	<fo:table table-layout="fixed">
						<fo:table-column column-width="50mm"/>
						<fo:table-column column-width="184mm"/>
						<fo:table-column column-width="6mm"/>
						<fo:table-body line-height="9pt">
							<fo:table-row>
								<fo:table-cell><fo:block font-weight="bold">Продавец</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="params/param[@key='title']/text()" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(2)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>Адрес</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="params/param[@key='address']/text()" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(2a)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>ИНН / КПП продавца</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="params/param[@key='inn']/text()" /> / <xsl:value-of select="params/param[@key='kpp']/text()" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(2б)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>Грузоотправитель и его адрес</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="params/param[@key='3']/text()" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(3)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>Грузополучатель и его адрес</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="/data/bill/attributes/@pol_org_name" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(4)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>К платежно-расчетному документу</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="utils:upd5(@paymentDocument,@payDoc,@paymentDocumentFromDate,@payDocDate)" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(5)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block font-weight="bold">Покупатель</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="/data/bill/attributes/@org_name" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(6)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>Адрес</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="/data/bill/attributes/@address" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(6a)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>ИНН / КПП покупателя</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block><xsl:value-of select="/data/bill/attributes/@inn" /> / <xsl:value-of select="/data/bill/attributes/@kpp" /></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(6б)</fo:block></fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell><fo:block>Валюта: наименование, код</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block>Российский рубль, 643</fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(7)</fo:block></fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
			    	<fo:table table-layout="fixed">
						<fo:table-column column-width="114mm"/>
						<fo:table-column column-width="120mm"/>
						<fo:table-column column-width="6mm"/>
						<fo:table-body line-height="9pt">
							<fo:table-row>
								<fo:table-cell><fo:block>Идентификатор государственного контракта, договора(соглашения) (при наличии):</fo:block></fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell_01"><fo:block></fo:block></fo:table-cell>
								<fo:table-cell><fo:block>(8)</fo:block></fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block-container>
				
				<fo:table table-layout="fixed">
					<fo:table-column column-width="25mm" />
					<fo:table-body><fo:table-row height="47mm"><fo:table-cell border-width="1.5pt" border-right-style="solid"><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-body>
				</fo:table>			

				<fo:table table-layout="fixed" border-collapse="collapse" font-size="6pt" border-width="0.7pt">
					<fo:table-column column-width="5mm"  border-width="0.7pt" border-style="solid" /> <!-- А -->
					<fo:table-column column-width="20mm" border-width="0.7pt" border-right-width="1.5pt" border-right-style="solid" /> <!-- Б -->
					<fo:table-column column-width="53mm" border-width="0.7pt" border-style="solid" /> <!-- 1 -->
					<fo:table-column column-width="10mm" border-width="0.7pt" border-style="solid" /> <!-- 1а -->
					<fo:table-column column-width="10mm" border-width="0.7pt" border-style="solid" /> <!-- 2 -->
					<fo:table-column column-width="15mm" border-width="0.7pt" border-style="solid" /> <!-- 2а -->
					<fo:table-column column-width="10mm" border-width="0.7pt" border-style="solid" /> <!-- 3 -->
					<fo:table-column column-width="17mm" border-width="0.7pt" border-style="solid" /> <!-- 4 -->
					<fo:table-column column-width="20mm" border-width="0.7pt" border-style="solid" /> <!-- 5 -->
					<fo:table-column column-width="13mm" border-width="0.7pt" border-style="solid" /> <!-- 6 -->
					<fo:table-column column-width="9mm"  border-width="0.7pt" border-style="solid" />  <!-- 7 -->
					<fo:table-column column-width="18mm" border-width="0.7pt" border-style="solid" /> <!-- 8 -->
					<fo:table-column column-width="22mm" border-width="0.7pt" border-style="solid" /> <!-- 9 -->
					<fo:table-column column-width="8mm"  border-width="0.7pt" border-style="solid" />  <!-- 10 -->
					<fo:table-column column-width="17mm" border-width="0.7pt" border-style="solid" /> <!-- 10а -->
					<fo:table-column column-width="20mm" border-width="0.7pt" border-style="solid" /> <!-- 11 -->
					<fo:table-body>
						<fo:table-row text-align="center" display-align="center" border-bottom-width="0.7pt" border-style="solid" font-size="7pt">
							<fo:table-cell number-rows-spanned="2"><fo:block>№ п/п</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Код товара / работ, услуг</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Наименование товара (описание выполненых работ, оказанных услуг), имущественного права</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Код вида товара</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2"><fo:block>Единица измерения</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Коли-чество (объ-ем)</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Цена (тариф) за единицу измерения</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Стоимость товаров (работ, услуг), имуществен-ных прав без налога - всего</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>В том числе сумма акциза</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Нало-говая став-ка</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Сумма налога, предъяв-ляемая покупателю</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Стоимость товаров (работ, услуг), имуществен-ных прав с налогом - всего</fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="2"><fo:block>Страна проис-хождения товара</fo:block></fo:table-cell>
							<fo:table-cell number-rows-spanned="2"><fo:block>Регистра-ционный номер таможенной декларации</fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row text-align="center" display-align="center" border-bottom-width="0.7pt" border-style="solid">
							<fo:table-cell><fo:block>код</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>условное обозначе-ние (нацио-нальное)</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Циф-ровой код</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Краткое наимено-вание</fo:block></fo:table-cell>
						</fo:table-row>
						<fo:table-row text-align="center" display-align="center" border-bottom-width="0.7pt" border-style="solid" >
							<fo:table-cell><fo:block>А</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>Б</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>1</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>1а</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>2</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>2а</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>3</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>4</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>5</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>6</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>7</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>8</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>9</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>10</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>10а</fo:block></fo:table-cell>
							<fo:table-cell><fo:block>11</fo:block></fo:table-cell>
						</fo:table-row>
						<xsl:for-each select="pos">
						<xsl:variable name="nds" select="number((@summ * ($nds_rate div 100))div($nds_rate div 100 + 1))" />
						<xsl:value-of select="counter:add( 'total_nds', format-number($nds, '0.00') )" />
						<fo:table-row text-align="right" display-align="center" border-bottom-width="0.7pt" border-style="solid" >
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="position()"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>-</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block text-align="left"><xsl:value-of select="@name" /></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>-</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:valueOrDefault(@unitCode,'796')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:valueOrDefault(@unit,'шт')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:valueOrDefault(@quantity,'1')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber(@summ - $nds, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber(@summ - $nds, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>-</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber($nds_rate div 100, '###,###,##0%')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber($nds, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber(@summ + 0, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>-</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>-</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>-</fo:block></fo:table-cell>
						</fo:table-row>
						</xsl:for-each>
						<fo:table-row text-align="right" font-weight="bold">
							<fo:table-cell number-columns-spanned="2" border-bottom-style="hidden" border-left-style="hidden"><fo:block/></fo:table-cell>
							<fo:table-cell number-columns-spanned="4" border-bottom-style="hidden"><fo:block/></fo:table-cell>
							<fo:table-cell number-columns-spanned="2" border-bottom-style="hidden" border-left-style="hidden" xsl:use-attribute-sets="cell_02"><fo:block>Всего к оплате</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber(@total_sum - counter:get( 'total_nds') + 0, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>X</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block>X</fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber(counter:get( 'total_nds' ) + 0, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell xsl:use-attribute-sets="cell_02"><fo:block><xsl:value-of select="utils:formatNumber(@total_sum + 0, '###,###,##0.00')"/></fo:block></fo:table-cell>
							<fo:table-cell number-columns-spanned="3" border-bottom-style="hidden" border-right-style="hidden"><fo:block/></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<fo:table table-layout="fixed" font-size="6pt">
					<fo:table-column column-width="25mm" />
					<fo:table-column column-width="240mm" />
					<fo:table-body>
						<fo:table-row text-align="left" display-align="center">
							<fo:table-cell border-width="1.5pt" border-right-style="solid" padding="2mm"><fo:block>Документ составлен на <fo:page-number/> листах</fo:block></fo:table-cell>
							<fo:table-cell border-width="1.5pt" border-bottom-style="solid">
								<fo:table table-layout="fixed" font-size="6pt">
									<fo:table-column column-width="40mm" />
									<fo:table-column column-width="40mm" />
									<fo:table-column column-width="40mm" />
									<fo:table-column column-width="40mm" />
									<fo:table-column column-width="40mm" />
									<fo:table-column column-width="40mm" />
									<fo:table-body>
										<fo:table-row text-align="left">
											<fo:table-cell padding-left="2mm"><fo:block>Руководитель организации или иное уполномоченное лицо</fo:block></fo:table-cell>
											<fo:table-cell><xsl:call-template name="sign"/></fo:table-cell>
											<fo:table-cell><xsl:call-template name="fio"><xsl:with-param name="value" select="params/param[@key='fioRO']/text()"/></xsl:call-template></fo:table-cell>
											<fo:table-cell padding-left="2mm"><fo:block>Главный бухгалтер или иное уполномоченное лицо</fo:block></fo:table-cell>
											<fo:table-cell><xsl:call-template name="sign"/></fo:table-cell>
											<fo:table-cell><xsl:call-template name="fio"><xsl:with-param name="value" select="params/param[@key='fioGB']/text()"/></xsl:call-template></fo:table-cell>
										</fo:table-row>
										<fo:table-row text-align="left">
											<fo:table-cell padding-left="2mm"><fo:block>Индивидуальный предприниматель или иное уполномоченное лицо</fo:block></fo:table-cell>
											<fo:table-cell><xsl:call-template name="sign" /></fo:table-cell>
											<fo:table-cell><xsl:call-template name="fio"><xsl:with-param name="value" select="params/param[@key='fioIP']/text()"/></xsl:call-template></fo:table-cell>
											<fo:table-cell number-columns-spanned="3" padding-left="2mm"><xsl:call-template name="element1"><xsl:with-param name="value" select="params/param[@key='ogrnIP']/text()"/><xsl:with-param name="text" select="'реквизиты свидетельства о государственной регистрации индивидуального предпринимателя'"/><xsl:with-param name="width" select="'115mm'"/></xsl:call-template></fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				
				<xsl:variable name="text_8" select="concat('Всего оказано по договору №',/data/bill/@contract,' от ',/data/bill/@contract_date1,' услуг на сумму ',utils:formatNumber(@total_sum + 0, '###,###,##0.00'),' руб., в том числе НДС ',number(/data/bill/params/@nds),'% ',utils:formatNumber(counter:get( 'total_nds' ) + 0, '###,###,##0.00'),' руб., вышеперечисленные услуги оказаны полностью и в срок, заказчик претензий по объему, качеству и и сроком оказания услуг не имеет')" />
				
				<fo:table table-layout="fixed" font-size="6pt">
					<fo:table-column column-width="60mm" />
					<fo:table-column column-width="200mm" />
					<fo:table-column column-width="7mm" />
					<fo:table-body>
						<fo:table-row text-align="left" display-align="after" height="6mm">
							<fo:table-cell padding-bottom="2mm"><fo:block>Основание передачи(сдачи)/получения(приемки)</fo:block></fo:table-cell>
							<fo:table-cell padding-left="2mm"><xsl:call-template name="element1"><xsl:with-param name="value" select="$text_8"/><xsl:with-param name="text" select="'договор, доверенность и др.'"/><xsl:with-param name="width" select="'195mm'"/></xsl:call-template></fo:table-cell>
							<fo:table-cell padding-bottom="2mm"><fo:block>[8]</fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<fo:table table-layout="fixed" font-size="6pt">
					<fo:table-column column-width="40mm" />
					<fo:table-column column-width="220mm" />
					<fo:table-column column-width="7mm" />
					<fo:table-body>
						<fo:table-row text-align="left" display-align="after">
							<fo:table-cell padding-bottom="2mm"><fo:block>Данные о транспортировке и грузе</fo:block></fo:table-cell>
							<fo:table-cell padding-left="2mm"><xsl:call-template name="element1"><xsl:with-param name="value" select="''"/><xsl:with-param name="text" select="'транспортная накладная, поручение экспедитору, экспедиторская/складская расписка и др. / масса нетто и брутто груза, если не приведены ссылки на транспортные документы, содержащие эти сведения'"/><xsl:with-param name="width" select="'215mm'"/></xsl:call-template></fo:table-cell>
							<fo:table-cell padding-bottom="2mm"><fo:block>[9]</fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<fo:table table-layout="fixed" font-size="6pt" space-before="1mm">
					<fo:table-column column-width="133mm" />
					<fo:table-column column-width="133mm" />
					<fo:table-body>
						<fo:table-row text-align="left" display-align="before">
							<fo:table-cell padding-right="2mm" border-width="1.5pt" border-right-style="solid"><xsl:call-template name="element2"/></fo:table-cell>
							<fo:table-cell padding-left="2mm"><xsl:call-template name="element3"/></fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>

			</fo:flow>
		</fo:page-sequence>
		
<!-- 
		<fo:page-sequence master-reference="second">
			<fo:flow flow-name="xsl-region-body">
				<fo:block xsl:use-attribute-sets="text">&#160;</fo:block>
			</fo:flow>
		</fo:page-sequence>		
-->				
	</xsl:template>
	
</xsl:stylesheet>
	