#!/bin/bash

cd ${0%${0##*/}}.

. ./setenv.sh

cd ..

PARAMS="-Dboot.info=1 -Dfile.encoding=UTF-8 -Dapp.name=BGBillingServer -Dlog.dir.path=log/ -Dlog.prefix=server ${BGBILLING_SYSTEM_PROPERTIES}"
MEMORY="-Xmx512m"

if [ -n "$BGBILLING_MEMORY" ]; then
  MEMORY=$BGBILLING_MEMORY
fi

COMPAT_PARAMS="--add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED"
COMMON_PARAMS="-Dnetworkaddress.cache.ttl=3600 -Djava.net.preferIPv4Stack=true ${COMPAT_PARAMS}"
CLASSPATH=${BGBILLING_SERVER_DIR}:${BGBILLING_SERVER_DIR}/lib/custom/*:${BGBILLING_SERVER_DIR}/lib/server/*:${BGBILLING_SERVER_DIR}/lib/common/*:${BGBILLING_SERVER_DIR}/lib/ext/server/*:${BGBILLING_SERVER_DIR}/lib/ext/common/*

if [ ! -d "${BGBILLING_SERVER_DIR}/.run" ] ; then
    mkdir ${BGBILLING_SERVER_DIR}/.run
fi

CMD=$1

if [ "$CMD" = "debug" ]; then
    DEBUG="-enableassertions -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=5589,server=y,suspend=n"
    CMD="start"
fi

ALL_ARGS="${COMMON_PARAMS} ${PARAMS} ${MEMORY} -cp ${CLASSPATH} ${DEBUG} bitel.billing.server.Server $@"

if [ "$CMD" != "start" ]; then
    #execute command
    ${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH} bitel.billing.server.Server $@
else

    #starting
    if [ "$BGBILLING_DOCKER" != "yes" ]; then
        nohup ${JAVA_HOME}/bin/java ${ALL_ARGS} > log/server.out 2>&1 & echo $! > .run/bgbilling.pid &
    else
        ${JAVA_HOME}/bin/java ${ALL_ARGS} | tee log/server.out
    fi
fi