/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;

public class VoiceSearchPanel
extends BGUPanel {
    private VoiceAccountTableModel model = new VoiceAccountTableModel(VoiceAccountTableModel.class.getName());
    private BGTextField login = new BGTextField();
    private BGTextField phone = new BGTextField();
    private JTextField title = new JTextField();
    private IntTextField accountId = new IntTextField();
    private BGUComboBox<VoiceAccountType> accountType = new BGUComboBox();
    private VoiceAccountService wsAccount = (VoiceAccountService)((ClientContext)this.getContext()).getPort(VoiceAccountService.class);
    BGControlPanelPages pagePanel = new BGControlPanelPages();
    BGControlPanelPeriod period = new BGControlPanelPeriod();
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            List typeList = VoiceSearchPanel.this.wsAccount.voiceAccountTypeList();
            VoiceAccountType anyType = new VoiceAccountType();
            anyType.setTitle("\u041b\u044e\u0431\u043e\u0439");
            anyType.setId(0);
            typeList.add(0, anyType);
            VoiceSearchPanel.this.accountType.setData(typeList);
        }
    };
    AbstractBGUPanel.DefaultAction find = new AbstractBGUPanel.DefaultAction("find", "\u041d\u0430\u0439\u0442\u0438"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceAccountType selectedType = (VoiceAccountType)VoiceSearchPanel.this.accountType.getSelectedItem();
            long number = Utils.parseLong((String)VoiceSearchPanel.this.phone.getText(), (long)-1L);
            if (!Utils.isEmptyString((String)VoiceSearchPanel.this.phone.getText()) && number < 0L) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d \u041d\u043e\u043c\u0435\u0440!");
                return;
            }
            Result result = VoiceSearchPanel.this.wsAccount.voiceSearchAccount(VoiceSearchPanel.this.accountId.getValue(), VoiceSearchPanel.this.login.getText(), number, selectedType.getId(), VoiceSearchPanel.this.title.getText(), VoiceSearchPanel.this.period.getPeriod(), VoiceSearchPanel.this.pagePanel.getPage());
            VoiceSearchPanel.this.pagePanel.setPage(result.getPage());
            VoiceSearchPanel.this.model.setData(result.getList());
        }
    };

    public VoiceSearchPanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VoiceSearchPanel.this.openContract(((VoiceAccount)VoiceSearchPanel.this.model.getSelectedRow()).getContractId());
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.createTopSearchPanel(), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pagePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.find.perform();
            }
        });
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel createTopSearchPanel() {
        JPanel loginPanel = this.createSearchPanel("\u041b\u043e\u0433\u0438\u043d", (JComponent)this.login);
        JPanel phonePanel = this.createSearchPanel("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", (JComponent)this.phone);
        JPanel titlePanel = this.createSearchPanel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.title);
        JPanel accountIdPanel = this.createSearchPanel("ID \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", (JComponent)this.accountId);
        JPanel typePanel = this.createSearchPanel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", (JComponent)this.accountType);
        JButton searchButton = new JButton((Action)this.find);
        this.accountId.setAction((Action)this.find);
        this.login.setAction((Action)this.find);
        this.phone.setAction((Action)this.find);
        this.title.setAction((Action)this.find);
        JPanel topSearchPanel = new JPanel(new GridBagLayout());
        topSearchPanel.add((Component)accountIdPanel, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)loginPanel, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)phonePanel, new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)titlePanel, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)typePanel, new GridBagConstraints(4, 0, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)this.period, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topSearchPanel.add((Component)searchButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        return topSearchPanel;
    }

    private JPanel createSearchPanel(String titleText, JComponent component) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(titleText));
        panel.add((Component)component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        if (component instanceof JTextField) {
            ((JTextField)component).setHorizontalAlignment(0);
            panel.add((Component)new BGButton("X", "clear", (ActionListener)new ClearActionListener((JTextField)component)), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        return panel;
    }

    class VoiceAccountTableModel
    extends BGTableModel<VoiceAccount> {
        public VoiceAccountTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 300, 300, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 200, 200, 200, "contractTitle", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "contractComment", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(VoiceAccount voiceAccount, int column) throws BGException {
            String i;
            switch (i = this.getIdentifier(column)) {
                case "contractTitle": {
                    return voiceAccount.getContractTitle();
                }
                case "contractComment": {
                    return voiceAccount.getContractComment();
                }
                case "period": {
                    return TimeUtils.formatPeriod((Date)voiceAccount.getDateFrom(), (Date)voiceAccount.getDateTo());
                }
            }
            return super.getValue((Object)voiceAccount, column);
        }
    }

    class ClearActionListener
    implements ActionListener {
        private JTextField field;

        public ClearActionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.field.setText("");
        }
    }
}

