/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDestinationService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDestinationDao;
import ru.bitel.common.model.Page;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceDestinationService")
public class VoiceDestinationServiceImpl
extends AbstractService
implements VoiceDestinationService {
    private VoiceDestinationDao destinationDao;

    @PostConstruct
    private void init() {
        this.destinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);
    }

    public void voiceDestinationList(int operator, String title, Holder<Page> pageHolder, Holder<DataHandler> destinations) throws BGException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            List<VoiceDestination> result = this.destinationDao.list(operator, title, (Page)pageHolder.value);
            oos.writeObject(result);
            oos.flush();
            final byte[] resultBytes = baos.toByteArray();
            destinations.value = new DataHandler(new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(resultBytes);
                }

                public String getContentType() {
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public VoiceDestination voiceDestinationGet(int id) throws BGException {
        return (VoiceDestination)this.destinationDao.get(id);
    }

    public int voiceDestinationUpdate(VoiceDestination destination) throws BGException {
        this.destinationDao.update(destination);
        return destination.getId();
    }

    public int voiceDestinationDelete(List<Integer> idSet) throws BGException {
        return this.destinationDao.delete(idSet);
    }
}

