/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.radius;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.VoiceSessionRuntimeFlushingManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.om.ProtocolHandler;
import ru.bitel.bgbilling.modules.voice.server.radius.AvPairAttr;
import ru.bitel.bgbilling.modules.voice.server.radius.RadiusSearchPattrernManager;
import ru.bitel.bgbilling.modules.voice.server.radius.VendorAttr;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnection;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnectionResult;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusProcessor;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchMode;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchModePattern;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.worker.WorkerThreadFactory;

public class VoiceNas
extends Nas<VoiceNasConnection, Preferences, VoiceRadiusProcessor> {
    private static final Logger logger = LogManager.getLogger();
    public static final RadiusPacket.RadiusPacketOption<Short> CALL_TYPE = new RadiusPacket.RadiusPacketOption("call.type");
    public static final RadiusPacket.RadiusPacketOption<Integer> OPERATOR = new RadiusPacket.RadiusPacketOption("operator");
    public static final RadiusPacket.RadiusPacketOption<Integer> OPERATOR_ACCOUNT = new RadiusPacket.RadiusPacketOption("operator.account");
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, (ThreadFactory)new WorkerThreadFactory("nas-ex-service", null, null));
    private Set<String> incAuthCallTypes = new HashSet<String>();
    private Set<String> incAccCallTypes = new HashSet<String>();
    private Set<String> outAuthCallTypes = new HashSet<String>();
    private Set<String> outAccCallTypes = new HashSet<String>();
    private List<VoiceSearchMode> authSearchModes = new ArrayList<VoiceSearchMode>();
    private List<VoiceSearchMode> accSearchModes = new ArrayList<VoiceSearchMode>();
    private TarifMode incomingTariffMode;
    private TarifMode outgoingTariffMode;
    private VendorAttr creditTimeAttr;
    private VendorAttr errorAttr;
    private VendorAttr creditAmountAttr;
    private VendorAttr connectTime;
    private VendorAttr identifierAttr;
    private VendorAttr callingStattionIdAttr;
    private VendorAttr calledStattionIdAttr;
    private AvPairAttr toPortAttr = null;
    private AvPairAttr fromPortAttr = null;
    private VendorAttr callTypeAttr;
    private VendorAttr callOriginAttr;
    private final ProtocolHandler protocolHandler;
    boolean deepDeviceSearch = false;
    private final TimeoutMap<String, Boolean> stoppedAcctSessionIds;
    private final long connectionStartStopTimeout;

    public VoiceNas(Preferences setup, int moduleId, VoiceRadiusProcessor processor, int id, Nas<VoiceNasConnection, Preferences, VoiceRadiusProcessor> oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, VoiceNasConnection> connections, VoiceDeviceRuntime deviceRuntime) {
        super(setup, moduleId, (RadiusProcessor)processor, id, oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, "", null);
        this.initCallTypes();
        ModuleSetup moduleSetup = ((Setup)setup).getModuleSetup(Integer.valueOf(processor.moduleId));
        RadiusSearchPattrernManager patManager = new RadiusSearchPattrernManager((Preferences)moduleSetup);
        this.initSeachModes("radius.auth.search.mode.order", this.authSearchModes, patManager.getPatternMap());
        this.initSeachModes("radius.acct.search.mode.order", this.accSearchModes, patManager.getPatternMap());
        this.deepDeviceSearch = conf.getBoolean("radius.search.mode.device.deep", false);
        this.initTariffModes();
        this.protocolHandler = deviceRuntime.getProtocolHandler();
        this.creditTimeAttr = new VendorAttr(this.getConfParameter("credit.time.vendor", conf, vendorCode), this.getConfParameter("credit.time.code", conf, 102));
        this.errorAttr = new VendorAttr(this.getConfParameter("error.vendor", conf, vendorCode), this.getConfParameter("error.code", conf, 103));
        this.creditAmountAttr = new VendorAttr(this.getConfParameter("credit.amount.vendor", conf, vendorCode), this.getConfParameter("credit.amount.code", conf, 101));
        if (this.getConfParameter("connect.time.code", conf, 0) > 0) {
            this.connectTime = new VendorAttr(this.getConfParameter("connect.time.vendor", conf, vendorCode), this.getConfParameter("connect.time.code", conf, 0));
        }
        this.identifierAttr = new VendorAttr(this.getConfParameter("identifier.vendor", conf, -1), this.getConfParameter("identifier.code", conf, 44));
        this.callingStattionIdAttr = new VendorAttr(this.getConfParameter("calling.station.id.vendor", conf, -1), this.getConfParameter("calling.station.id.code", conf, 31));
        this.calledStattionIdAttr = new VendorAttr(this.getConfParameter("called.station.id.vendor", conf, -1), this.getConfParameter("called.station.id.code", conf, 30));
        try {
            this.toPortAttr = this.getAvPairAttr("to.port", conf);
            logger.debug("toPortAttr =" + this.toPortAttr);
            this.fromPortAttr = this.getAvPairAttr("from.port", conf);
            logger.debug("fromPortAttr =" + this.fromPortAttr);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.callTypeAttr = new VendorAttr(this.getConfParameter("call.type.vendor", conf, vendorCode), this.getConfParameter("call.type.code", conf, 27));
        this.callOriginAttr = new VendorAttr(this.getConfParameter("call.origin.vendor", conf, vendorCode), this.getConfParameter("call.origin.code", conf, 26));
        this.connectionStartStopTimeout = conf.getLong("radius.start.stopTimeout", 300L) * 1000L;
        this.stoppedAcctSessionIds = new TimeoutMap(SCHEDULED_EXECUTOR_SERVICE, 180L, 30L, TimeUnit.SECONDS);
    }

    private AvPairAttr getAvPairAttr(String param, ParameterMap conf) {
        int vendor = this.getConfParameter(param + ".vendor", conf, -1);
        int code = this.getConfParameter(param + ".code", conf, -1);
        String key = this.getConfParameter(param + ".key", conf, null);
        if (vendor > 0 && code > 0 && !Utils.isEmptyString((String)key)) {
            return new AvPairAttr(vendor, code, key);
        }
        return null;
    }

    private int getConfParameter(String param, ParameterMap conf, int defaultValue) {
        String prefix = "radius.attr.";
        return conf.getInt(prefix + param, defaultValue);
    }

    private String getConfParameter(String param, ParameterMap conf, String defaultValue) {
        String prefix = "radius.attr.";
        return conf.get(prefix + param, defaultValue);
    }

    private void initTariffModes() {
        ParameterMap conf = this.getConf();
        this.incomingTariffMode = this.parseTariffMode(conf.get("radius.tariff.mode.in", "Calling-Station-Id"));
        this.outgoingTariffMode = this.parseTariffMode(conf.get("radius.tariff.mode.out", "Called-Station-Id"));
    }

    TarifMode parseTariffMode(String value) {
        TarifMode mode = TarifMode.NONE;
        if (value.equalsIgnoreCase("Calling-Station-Id")) {
            mode = TarifMode.CALLING_STATION_ID;
        } else if (value.equalsIgnoreCase("Called-Station-Id")) {
            mode = TarifMode.CALLED_STATION_ID;
        } else if (value.equalsIgnoreCase("None")) {
            mode = TarifMode.NONE;
        } else {
            logger.error("unknown tariff.mode " + value);
        }
        return mode;
    }

    private void initSeachModes(String prefix, List<VoiceSearchMode> modes, Map<Integer, VoiceSearchModePattern> patternMap) {
        ParameterMap conf = this.getConf();
        String modesOrdered = conf.get(prefix);
        for (String str : Utils.toList((String)modesOrdered)) {
            int modeId;
            String[] parts = str.split(":");
            VoiceSearchModePattern pattern = null;
            short callType = -1;
            if (parts.length >= 1 && (modeId = Utils.parseInt((String)parts[0], (int)-1)) > 0) {
                pattern = patternMap.get(modeId);
            }
            if (parts.length >= 2) {
                callType = (short)Utils.parseInt((String)parts[1], (int)-1);
            }
            if (pattern == null) {
                logger.error("search pattern is null for " + str);
                continue;
            }
            VoiceSearchMode mode = new VoiceSearchMode();
            mode.setPattern(pattern);
            mode.setCallType(callType);
            modes.add(mode);
        }
    }

    private void initCallTypes() {
        this.parseCallType("radius.auth.in", "voip/originate", this.incAuthCallTypes);
        this.parseCallType("radius.acct.in", "voip/originate", this.incAccCallTypes);
        this.parseCallType("radius.auth.out", "voip/answer", this.outAuthCallTypes);
        this.parseCallType("radius.acct.out", "voip/answer", this.outAccCallTypes);
    }

    public void parseCallType(String name, String defaut, Set<String> callTypes) {
        ParameterMap conf = this.getConf();
        String inCallAuth = conf.get(name, defaut);
        String[] inCallAuthArray = inCallAuth.split(";");
        for (int i = 0; i < inCallAuthArray.length; ++i) {
            callTypes.add(inCallAuthArray[i].trim());
        }
    }

    public void setCallTypeToRequest(RadiusPacket request) {
        Set<String> outCallTypes;
        Set<String> inCallTypes = request.getCode() == 1 ? this.incAuthCallTypes : this.incAccCallTypes;
        Set<String> set = outCallTypes = request.getCode() == 1 ? this.outAuthCallTypes : this.outAccCallTypes;
        if (outCallTypes.contains("all/all")) {
            request.setOption(CALL_TYPE, (Object)1);
        } else if (inCallTypes.contains("all/all")) {
            request.setOption(CALL_TYPE, (Object)2);
        } else {
            RadiusAttribute.RadiusAttributeString callType = (RadiusAttribute.RadiusAttributeString)request.getAttribute(this.callTypeAttr.vendor, this.callTypeAttr.attr);
            RadiusAttribute.RadiusAttributeString callOrigin = (RadiusAttribute.RadiusAttributeString)request.getAttribute(this.callOriginAttr.vendor, this.callOriginAttr.attr);
            if (callType != null || callOrigin != null) {
                String callRef = (callType != null ? ((String)callType.getValue()).toLowerCase() : "") + "/" + (callOrigin != null ? ((String)callOrigin.getValue()).toLowerCase() : "");
                if (outCallTypes.contains(callRef)) {
                    request.setOption(CALL_TYPE, (Object)1);
                } else if (inCallTypes.contains(callRef)) {
                    request.setOption(CALL_TYPE, (Object)2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VoiceNasConnection startConnection(RadiusListenerWorker<?> worker, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        VoiceNasConnection connection = null;
        try {
            worker.setConnectionModified(true);
            try {
                VoiceNasConnectionResult result = this.getNasConnectionLocked(request, connectionSet, time);
                connection = result.connection;
                if (connection == null) {
                    VoiceNasConnection voiceNasConnection = null;
                    return voiceNasConnection;
                }
                if (connection.isSessionStarted()) {
                    logger.warn("connection is already started. skipping");
                    VoiceNasConnection voiceNasConnection = connection;
                    return voiceNasConnection;
                }
                this.startSession(connectionSet, (VoiceSessionRuntime)connection.getSession());
                connectionSet.commit();
                if (connection.getAdditinalSession() != null) {
                    this.startSession(connectionSet, connection.getAdditinalSession());
                }
                connectionSet.commit();
                if (!((VoiceSessionRuntime)connection.getSession()).isOperSession()) {
                    this.startOperator(request, connection, connectionSet);
                }
                connection.setSessionStarted(true);
                return connection;
            }
            finally {
                if (connection != null) {
                    connection.unlock();
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        return connection;
    }

    private void startSession(ConnectionSet connectionSet, VoiceSessionRuntime sessionRuntime) throws BGException {
        int result = ((VoiceRadiusProcessor)this.processor).calculateSession(sessionRuntime, connectionSet, false);
        if (result > 0) {
            logger.error("Calculate session return error:" + result);
            return;
        }
        if (Utils.isEmptyString((String)sessionRuntime.getTarifficationNumber())) {
            logger.error("Tariffication number is empty. Skip session ");
            return;
        }
        this.saveSessionRuntime(sessionRuntime, connectionSet);
    }

    private void startOperator(RadiusPacket request, VoiceNasConnection connection, ConnectionSet connectionSet) throws BGException {
        try {
            VoiceSessionRuntime operSessionRuntime = this.getOperSessionRuntime(request, connection, connectionSet);
            if (operSessionRuntime == null) {
                return;
            }
            this.startSession(connectionSet, operSessionRuntime);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private boolean stopOperator(RadiusPacket request, VoiceNasConnection connection, ConnectionSet connectionSet, Date time) throws BGException {
        try {
            VoiceSessionRuntime operSessionRuntime;
            if (connection == null) {
                // empty if block
            }
            if ((operSessionRuntime = this.getOperSessionRuntime(request, connection, connectionSet)) == null) {
                return false;
            }
            return this.stopSession(connectionSet, operSessionRuntime, request, time);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private void updateOperator(RadiusPacket request, VoiceNasConnection connection, ConnectionSet connectionSet, Date time) throws BGException {
        try {
            VoiceSessionRuntime operSessionRuntime;
            if (connection == null) {
                // empty if block
            }
            if ((operSessionRuntime = this.getOperSessionRuntime(request, connection, connectionSet)) == null) {
                return;
            }
            this.updateSession(connectionSet, operSessionRuntime, request, time);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected VoiceSessionRuntime getOperSessionRuntime(RadiusPacket request, VoiceNasConnection connection, ConnectionSet connectionSet) throws BGException, CloneNotSupportedException {
        VoiceSessionRuntime operSessionRuntime = null;
        VoiceAccountRuntime operAccountRuntime = ((VoiceRadiusProcessor)this.processor).searchOperAccount(request);
        if (operAccountRuntime == null) {
            return null;
        }
        if (connection.getOperSession() != null) {
            operSessionRuntime = connection.getOperSession();
        }
        if (operSessionRuntime == null) {
            VoiceSession operSession = new VoiceSession(((VoiceSessionRuntime)connection.getSession()).getSession());
            operSession.setContractId(((VoiceAccount)operAccountRuntime.getAccount()).getContractId());
            operSession.setAccountId(((VoiceAccount)operAccountRuntime.getAccount()).getId());
            operSessionRuntime = new VoiceSessionRuntime(operSession, operAccountRuntime);
            connection.setOperSession(operSessionRuntime);
        }
        return operSessionRuntime;
    }

    private VoiceNasConnectionResult getNasConnectionLocked(RadiusPacket request, ConnectionSet connectionSet, Date time) throws BGException {
        VoiceNasConnectionResult result = new VoiceNasConnectionResult();
        result.existed = true;
        result.connection = null;
        String acctSessionId = request.getStringAttribute(-1, 44, null);
        if (acctSessionId == null) {
            logger.error("Attribute Acct_Session_Id not found in packet!");
            return result;
        }
        String identifier = this.getIdentifier(request);
        if (identifier == null) {
            logger.error("Attribute indentifier (" + this.identifierAttr + ")  not found in packet!");
            return result;
        }
        logger.debug("identifier=" + identifier);
        VoiceNasConnection connection = (VoiceNasConnection)((Object)this.connections.get(identifier));
        if (connection == null) {
            connection = this.createNasConnectionLocked(request, connectionSet, acctSessionId, identifier, time);
            result.existed = false;
        } else {
            connection.lock();
        }
        result.connection = connection;
        return result;
    }

    private VoiceNasConnection createNasConnectionLocked(RadiusPacket request, ConnectionSet connectionSet, String acctSessionId, String identifier, Date time) throws BGException {
        List<VoiceSessionRuntime> sessions = ((VoiceRadiusProcessor)this.processor).createSessionRuntimes(connectionSet, request, acctSessionId, identifier, this, time);
        if (sessions.size() == 0) {
            logger.error("couldn't create session ");
            return null;
        }
        VoiceSessionRuntime sessionRuntime = sessions.get(0);
        VoiceNasConnection nasConnection = new VoiceNasConnection(sessionRuntime, ((VoiceRadiusProcessor)this.processor).getNasList(), this.getId());
        if (sessions.size() > 1) {
            nasConnection.setAdditinalSession(sessions.get(1));
        }
        nasConnection.lock();
        if (this.isRecentlyStopped(identifier)) {
            nasConnection.unlock();
            logger.warn("Duplicate radius packet (session already stopped by accounting-stop packet).");
            return null;
        }
        VoiceNasConnection oldNasCon = this.setConnectionIfAbsent(nasConnection);
        return oldNasCon != null ? oldNasCon : nasConnection;
    }

    private void saveSessionRuntime(VoiceSessionRuntime sessionRuntime, ConnectionSet connectionSet) throws BGException {
        if (sessionRuntime.getParentSession() != null) {
            sessionRuntime.getSession().setParentId(sessionRuntime.getParentSession().getSession().getId());
        }
        ((VoiceRadiusProcessor)this.processor).saveSessionRuntime(sessionRuntime, connectionSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VoiceNasConnection stopConnection(RadiusListenerWorker<?> worker, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        VoiceNasConnection connection = null;
        try {
            worker.setConnectionModified(true);
            long millis = worker.millis;
            Date time = new Date(millis);
            try {
                VoiceNasConnectionResult result = this.getNasConnectionLocked(request, connectionSet, time);
                connection = result.connection;
                boolean existed = result.existed;
                if (connection == null) {
                    logger.error("connection is null");
                    VoiceNasConnection voiceNasConnection = null;
                    return voiceNasConnection;
                }
                if (connection.getStatus() == NasConnection.Status.stopped) {
                    logger.warn("connection is already finished. skipping");
                    VoiceNasConnection voiceNasConnection = connection;
                    return voiceNasConnection;
                }
                if (!this.stopSession(connectionSet, (VoiceSessionRuntime)connection.getSession(), request, time) && !existed) {
                    this.removeConnection(connection);
                    VoiceNasConnection voiceNasConnection = null;
                    return voiceNasConnection;
                }
                connectionSet.commit();
                if (connection.getAdditinalSession() != null) {
                    this.stopSession(connectionSet, connection.getAdditinalSession(), request, time);
                    connectionSet.commit();
                }
                if (!((VoiceSessionRuntime)connection.getSession()).isOperSession()) {
                    this.stopOperator(request, connection, connectionSet, time);
                }
                this.stopConnection(connectionSet, connection);
                return connection;
            }
            finally {
                if (connection != null) {
                    connection.unlock();
                }
            }
        }
        catch (Exception e) {
            logger.error("error on stop packet", (Throwable)e);
        }
        return connection;
    }

    public void stopConnection(ConnectionSet connectionSet, VoiceNasConnection nasCon) throws BGException {
        nasCon.setStatus(NasConnection.Status.stopped);
        this.finishSessions(connectionSet, nasCon);
        String identifier = ((VoiceSessionRuntime)nasCon.getSession()).getSession().getIdentifier();
        this.addRecentlyStopped(identifier);
        this.removeConnection(nasCon);
    }

    private void removeConnection(VoiceNasConnection nasCon) throws BGException {
        this.removeSessionRuntimes(nasCon);
        String identifier = ((VoiceSessionRuntime)nasCon.getSession()).getSession().getIdentifier();
        logger.info("remove connection with identifier=" + identifier);
        this.connections.remove(identifier, (Object)nasCon);
    }

    public void stopConnection(ConnectionSet connectionSet, String identifier) throws BGException {
        VoiceNasConnection nasCon = (VoiceNasConnection)((Object)this.connections.get(identifier));
        if (nasCon == null) {
            throw new BGException("Nas Connection is null ");
        }
        this.stopConnection(connectionSet, nasCon);
    }

    public void stopConnections(ConnectionSet connectionSet) throws BGException {
        for (VoiceNasConnection nasCon : this.connections.values()) {
            this.stopConnection(connectionSet, nasCon);
        }
    }

    private void removeSessionRuntimes(VoiceNasConnection connection) {
        ((VoiceRadiusProcessor)this.processor).removeSessionRuntime((VoiceSessionRuntime)connection.getSession());
        if (connection.getAdditinalSession() != null) {
            ((VoiceRadiusProcessor)this.processor).removeSessionRuntime(connection.getAdditinalSession());
        }
        if (connection.getOperSession() != null) {
            ((VoiceRadiusProcessor)this.processor).removeSessionRuntime(connection.getAdditinalSession());
        }
    }

    protected void finishSessions(ConnectionSet connectionSet, VoiceNasConnection connection) throws BGException {
        VoiceSessionRuntimeFlushingManager manager = new VoiceSessionRuntimeFlushingManager(((VoiceRadiusProcessor)this.processor).moduleId, ((VoiceSessionRuntime)connection.getSession()).getSession().getSessionStart(), ((VoiceRadiusProcessor)this.processor).getBalanceEP());
        ArrayList<VoiceSession> sessions = new ArrayList<VoiceSession>();
        sessions.add(((VoiceSessionRuntime)connection.getSession()).getSession());
        if (connection.getAdditinalSession() != null) {
            sessions.add(connection.getAdditinalSession().getSession());
        }
        if (connection.getOperSession() != null) {
            sessions.add(connection.getOperSession().getSession());
        }
        manager.finishSession(connectionSet, sessions);
    }

    protected boolean stopSession(ConnectionSet connectionSet, VoiceSessionRuntime sessionRuntime, RadiusPacket request, Date time) throws BGException {
        this.proccessAccountingPacket(request, sessionRuntime, time);
        int result = ((VoiceRadiusProcessor)this.processor).calculateSession(sessionRuntime, connectionSet, true);
        if (result > 0) {
            logger.error("Calculate session return error:" + result);
            return false;
        }
        if (Utils.isEmptyString((String)sessionRuntime.getTarifficationNumber())) {
            logger.error("Tariffication number is empty. Skip session ");
            return false;
        }
        this.saveSessionRuntime(sessionRuntime, connectionSet);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VoiceNasConnection updateConnection(RadiusListenerWorker<?> worker, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        long millis = worker.millis;
        Date time = new Date(millis);
        VoiceNasConnection connection = null;
        try {
            try {
                VoiceNasConnectionResult result = this.getNasConnectionLocked(request, connectionSet, time);
                connection = result.connection;
                boolean existed = result.existed;
                if (connection == null) {
                    logger.error("connection is null");
                    VoiceNasConnection voiceNasConnection = null;
                    return voiceNasConnection;
                }
                this.updateSession(connectionSet, (VoiceSessionRuntime)connection.getSession(), request, time);
                connectionSet.commit();
                if (connection.getAdditinalSession() != null) {
                    this.updateSession(connectionSet, connection.getAdditinalSession(), request, time);
                }
                connectionSet.commit();
                if (((VoiceSessionRuntime)connection.getSession()).isOperSession()) return connection;
                this.updateOperator(request, connection, connectionSet, time);
                return connection;
            }
            finally {
                if (connection != null) {
                    connection.unlock();
                }
            }
        }
        catch (BGException e) {
            logger.error((Object)e.getCause(), (Throwable)e);
        }
        return connection;
    }

    private void updateSession(ConnectionSet connectionSet, VoiceSessionRuntime session, RadiusPacket request, Date time) throws BGException {
        this.proccessAccountingPacket(request, session, time);
        int result = ((VoiceRadiusProcessor)this.processor).calculateSession(session, connectionSet, false);
        if (result > 0) {
            logger.error("Calculate session return error:" + result);
            return;
        }
        if (Utils.isEmptyString((String)session.getTarifficationNumber())) {
            logger.error("Tariffication number is empty. Skip session ");
            return;
        }
        this.saveSessionRuntime(session, connectionSet);
    }

    private void proccessAccountingPacket(RadiusPacket request, VoiceSessionRuntime sessionRuntime, Date time) {
        long delta;
        String connectTimeString;
        int sessionTime = request.getIntAttribute(-1, 46, Integer.valueOf(0));
        int acctStatusType = request.getIntAttribute(-1, 40, Integer.valueOf(0));
        long oldSesionTime = sessionRuntime.getSession().getSessionTime();
        Date startTime = null;
        Date stopTime = null;
        if (this.connectTime != null && (connectTimeString = request.getStringAttribute(this.connectTime.vendor, this.connectTime.attr, null)) != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS z EEE MMM dd yyyy", Locale.US);
            try {
                startTime = dateFormat.parse(connectTimeString);
            }
            catch (ParseException ex) {
                logger.error((Object)ex.getCause(), (Throwable)ex);
            }
        }
        stopTime = time;
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        if (startTime == null) {
            cal.add(13, -sessionTime);
            startTime = cal.getTime();
        } else {
            cal.setTime(startTime);
            cal.add(13, sessionTime);
            stopTime = cal.getTime();
        }
        VoiceSession session = sessionRuntime.getSession();
        session.setSessionStart(startTime);
        session.setSessionTime((long)sessionTime);
        session.setLastActive(time);
        if (acctStatusType == 2) {
            session.setSessionStop(stopTime);
        }
        if ((delta = (long)sessionTime - oldSesionTime) < 0L) {
            // empty if block
        }
        sessionRuntime.setCalculateAmountDelta(delta);
    }

    public String getTarifficationNumber(RadiusPacket request, short callType) {
        TarifMode tariffMode = null;
        String number = null;
        TarifMode tarifMode = tariffMode = callType == 1 ? this.outgoingTariffMode : this.incomingTariffMode;
        if (tariffMode == TarifMode.CALLED_STATION_ID) {
            number = this.getCalledStationId(request);
        } else if (tariffMode == TarifMode.CALLING_STATION_ID) {
            number = this.getCallingStationId(request);
        } else if (tariffMode == TarifMode.NONE) {
            number = null;
        }
        return number;
    }

    public void setCreditTime(RadiusPacket response, int creditTime) {
        response.setStringAttribute(this.creditTimeAttr.vendor, this.creditTimeAttr.attr, String.valueOf(creditTime));
    }

    public int getCreditTime(RadiusPacket response) {
        int creditTime = Utils.parseInt((String)response.getStringAttribute(this.creditTimeAttr.vendor, this.creditTimeAttr.attr, "0"));
        return creditTime;
    }

    public void setErrorCode(RadiusPacket response, int error) {
        response.setStringAttribute(this.errorAttr.vendor, this.errorAttr.attr, String.valueOf(error));
    }

    public void setCreditAmount(RadiusPacket response, BigDecimal creditAmount) {
        response.setStringAttribute(this.creditAmountAttr.vendor, this.creditAmountAttr.attr, String.valueOf(creditAmount));
    }

    public VoiceNasConnection setConnectionIfAbsent(VoiceNasConnection nasCon) {
        String identifier = ((VoiceSessionRuntime)nasCon.getSession()).getSession().getIdentifier();
        if (Utils.isEmptyString((String)identifier)) {
            logger.error("identifier is null. skiping connecion for session " + ((VoiceSessionRuntime)nasCon.getSession()).getSession().getId());
            return null;
        }
        return this.connections.putIfAbsent(identifier, nasCon);
    }

    public String getIdentifier(RadiusPacket request) {
        return request.getStringAttribute(this.identifierAttr.vendor, this.identifierAttr.attr, null);
    }

    public String getCallingStationId(RadiusPacket request) {
        return request.getStringAttribute(this.callingStattionIdAttr.vendor, this.callingStattionIdAttr.attr, null);
    }

    public String getToPort(RadiusPacket request) {
        try {
            if (this.toPortAttr == null) {
                return null;
            }
            return request.getStringAttribute(this.toPortAttr.vendor, this.toPortAttr.attr, this.toPortAttr.key, null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String getFromPort(RadiusPacket request) {
        try {
            if (this.fromPortAttr == null) {
                return null;
            }
            return request.getStringAttribute(this.fromPortAttr.vendor, this.fromPortAttr.attr, this.fromPortAttr.key, null);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String getCalledStationId(RadiusPacket request) {
        return request.getStringAttribute(this.calledStattionIdAttr.vendor, this.calledStattionIdAttr.attr, null);
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public short getCallType(RadiusPacket request) {
        Short callType = (Short)request.getOption(CALL_TYPE);
        if (callType != null && (callType == 2 || callType == 1)) {
            return callType;
        }
        return -1;
    }

    private Integer getOperatorFromRequest(RadiusPacket request) {
        return (Integer)request.getOption(OPERATOR);
    }

    private Integer getOperatorAccountFromRequest(RadiusPacket request) {
        return (Integer)request.getOption(OPERATOR_ACCOUNT);
    }

    public List<VoiceSearchMode> getAuthSearchModes() {
        return this.authSearchModes;
    }

    public List<VoiceSearchMode> getAccSearchModes() {
        return this.accSearchModes;
    }

    public boolean isDeepDeviceSearch() {
        return this.deepDeviceSearch;
    }

    boolean isRecentlyStopped(String identifier) {
        return identifier != null && this.stoppedAcctSessionIds.containsKey((Object)identifier);
    }

    private void addRecentlyStopped(String identifier) {
        if (this.connectionStartStopTimeout > 0L) {
            this.stoppedAcctSessionIds.put((Object)identifier, (Object)Boolean.TRUE, System.currentTimeMillis() + this.connectionStartStopTimeout);
        }
    }

    static enum TarifMode {
        CALLING_STATION_ID,
        CALLED_STATION_ID,
        NONE;

    }
}

