/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDestinationDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.common.Utils;

class GeoCodeImportManager {
    private static final Logger logger = LogManager.getLogger();
    private VoiceGeographicCodeDao codeDao;
    private VoiceDestinationDao destinationDao;
    private int moduleId;
    private int userId;
    private Map<String, VoiceDestination> destinationMapImpl;
    private Map<String, List<VoiceGeographicCode>> codeMapImpl;
    private boolean importMode = false;

    public GeoCodeImportManager(Connection con, int moduleId, int userId) throws BGException {
        this.codeDao = new VoiceGeographicCodeDao(con, moduleId);
        this.destinationDao = new VoiceDestinationDao(con, moduleId);
        this.moduleId = moduleId;
        this.userId = userId;
    }

    public void setImportMode() {
        this.importMode = true;
    }

    public String importGeographicCode(int operatorId, boolean addNew, boolean updateExist, Holder<DataHandler> importContent) throws BGException {
        boolean needEvent = false;
        this.setImportMode();
        String result = "";
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ((DataHandler)importContent.value).writeTo((OutputStream)baos);
            String contentString = baos.toString("UTF-8");
            contentString = contentString.replaceAll("\"", "");
            StringTokenizer tokenizer = new StringTokenizer(contentString, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String row = tokenizer.nextToken();
                VoiceGeographicCode newCode = this.getGeocodeFromString(row, result, operatorId);
                if (newCode == null || this.insertCode(newCode, addNew) <= 0) continue;
                needEvent = true;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438! \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.");
        }
        if (needEvent) {
            EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
        }
        return result;
    }

    int insertCode(VoiceGeographicCode newCode, boolean addNew) throws BGException {
        VoiceDestination destination = this.getDestinationMap(newCode.getOperatorId()).get(newCode.getDestinationTitle());
        if (destination == null) {
            if (!addNew) {
                return -1;
            }
            destination = new VoiceDestination(newCode.getDestinationTitle());
            destination.setOperatorId(newCode.getOperatorId());
            try {
                this.destinationDao.update(destination);
            }
            catch (BGException e) {
                return -1;
            }
            this.getDestinationMap(newCode.getOperatorId()).put(newCode.getDestinationTitle(), destination);
        }
        newCode.setDestinationId(destination.getId());
        return this.updateGeographicCode(newCode, false);
    }

    private VoiceGeographicCode getGeocodeFromString(String row, String result, int operatorId) {
        String[] fields = row.split("\t");
        String code = fields[0];
        if (Utils.parseLong((String)code, (long)-1L) < 0L) {
            result = (String)result + row + "\n";
            return null;
        }
        String destinationTitle = fields[1];
        int startLevel = 0;
        int stopLevel = 0;
        switch (fields.length) {
            case 2: {
                break;
            }
            case 4: {
                startLevel = Utils.parseInt((String)fields[2], (int)0);
                stopLevel = Utils.parseInt((String)fields[3], (int)0);
                break;
            }
            case 6: {
                startLevel = Utils.parseInt((String)fields[4], (int)0);
                stopLevel = Utils.parseInt((String)fields[5], (int)0);
                break;
            }
            default: {
                result = (String)result + row + "\n";
                return null;
            }
        }
        VoiceGeographicCode newCode = new VoiceGeographicCode();
        newCode.setCode(code);
        newCode.setOperatorId(operatorId);
        newCode.setDestinationTitle(destinationTitle);
        newCode.setStartLevel(startLevel);
        newCode.setStopLevel(stopLevel);
        newCode.setDateFrom(null);
        newCode.setDateTo(null);
        return newCode;
    }

    public int updateGeographicCode(VoiceGeographicCode code) throws BGException {
        return this.updateGeographicCode(code, true);
    }

    private int updateGeographicCode(VoiceGeographicCode code, boolean needEvent) throws BGException {
        try {
            List<VoiceGeographicCode> oldCodes = this.getCodeMap(code.getCode(), code.getOperatorId()).get(code.getCode());
            if (this.importMode && oldCodes != null && oldCodes.size() > 0) {
                VoiceGeographicCode oldCode = oldCodes.get(0);
                code.setId(oldCode.getId());
                return code.getId();
            }
            if (!this.validateCode(code.getCode())) {
                return -1;
            }
            this.codeDao.update(code);
            if (oldCodes == null) {
                oldCodes = new ArrayList<VoiceGeographicCode>();
            }
            oldCodes.add(code);
            this.getCodeMap(code.getCode(), code.getOperatorId()).put(code.getCode(), oldCodes);
            if (needEvent) {
                EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return code.getId();
    }

    private boolean validateCode(String code) {
        return code.matches("[0-9]+");
    }

    private Map<String, VoiceDestination> getDestinationMap(int operatorId) throws BGException {
        if (this.destinationMapImpl == null) {
            this.destinationMapImpl = this.destinationDao.titleMap(operatorId);
        }
        return this.destinationMapImpl;
    }

    private Map<String, List<VoiceGeographicCode>> getCodeMap(String code, int operatorId) throws BGException {
        if (this.codeMapImpl == null) {
            if (this.importMode) {
                code = null;
            }
            this.codeMapImpl = this.codeDao.codeMap(code, operatorId);
        }
        return this.codeMapImpl;
    }
}

