/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordArray;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.ErrorTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.TarifficationTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceHourSessionProcessor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceResourceAuditor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.mediation.Mediator;
import ru.bitel.bgbilling.modules.voice.server.event.LogProcessInterrupted;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperatorRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.common.Utils;

public class VoiceAccountFinder
implements Callable<Object> {
    private static Logger logger = LogManager.getLogger();
    private final VoiceHourSessionProcessor sessionProcessor;
    private final VoiceAccountRuntimeMap accountRuntimeMap;
    private final VoiceOperAccountRuntimeMap operAccountRuntimeMap;
    private final VoiceResourceAuditor resourceAuditor;
    private final VoiceOperatorRuntimeMap operatorRuntimeMap;
    private final VoiceDeviceRuntime deviceRuntime;
    private boolean deepFind = true;

    public VoiceAccountFinder(VoiceDeviceRuntime deviceRuntime, VoiceHourSessionProcessor sessionProcessor, VoiceAccountRuntimeMap accountRuntimeMap, VoiceOperAccountRuntimeMap operAccountRuntimeMap, VoiceResourceAuditor resourceAuditor, VoiceOperatorRuntimeMap operatorRuntimeMap) {
        this.sessionProcessor = sessionProcessor;
        this.accountRuntimeMap = accountRuntimeMap;
        this.operAccountRuntimeMap = operAccountRuntimeMap;
        this.resourceAuditor = resourceAuditor;
        this.operatorRuntimeMap = operatorRuntimeMap;
        this.deviceRuntime = deviceRuntime;
    }

    @Override
    public Object call() throws Exception {
        try {
            ArrayList<TarifficationTask> tarificationTasks;
            VoiceRecordArray recordArray;
            while ((recordArray = this.sessionProcessor.takeNextRecordArray(tarificationTasks = new ArrayList<TarifficationTask>())) != null) {
                int i;
                logger.trace("started array {}", (Object)recordArray.getId());
                ArrayList<VoiceSessionRuntime> foundSessionsAll = new ArrayList<VoiceSessionRuntime>(recordArray.getSize());
                ErrorTask errorTask = new ErrorTask();
                for (i = 0; i < recordArray.getSize(); ++i) {
                    VoiceRecord record = recordArray.get(i);
                    String validation = record.validationString();
                    if (!Utils.isEmptyString((String)validation)) {
                        logger.error(validation);
                        continue;
                    }
                    ArrayList<VoiceSessionRuntime> recordSessions = new ArrayList<VoiceSessionRuntime>();
                    this.getSessions(record, recordSessions, this.sessionProcessor.getDeviceId(), this.sessionProcessor.getHour(), errorTask);
                    foundSessionsAll.addAll(recordSessions);
                }
                for (VoiceSessionRuntime session : foundSessionsAll) {
                    int idx = session.getContractId() % tarificationTasks.size();
                    ((TarifficationTask)tarificationTasks.get(idx)).addSession(session);
                }
                for (i = 0; i < tarificationTasks.size(); ++i) {
                    ((TarifficationTask)tarificationTasks.get(i)).finish();
                }
                tarificationTasks.clear();
                if (errorTask.getErrors().size() > 0) {
                    this.sessionProcessor.addErrorTask(errorTask);
                }
                logger.trace("end array " + recordArray.getId());
                this.sessionProcessor.returnRecordArray(recordArray);
            }
        }
        catch (InterruptedException ex) {
            logger.error(this.getClass().getName() + " was interrupted", (Throwable)ex);
        }
        catch (Throwable e) {
            logger.error("fatal error in " + this.getClass().getName() + ", interrupting ", e);
            ServerContext workerContext = (ServerContext)ServerContext.get();
            int moduleId = workerContext.getModuleId();
            EventProcessor.getInstance().request((QueueEvent)new LogProcessInterrupted(moduleId, 0));
        }
        return null;
    }

    public void getSessions(VoiceRecord record, List<VoiceSessionRuntime> recordSessions, int deviceId, Date hour, ErrorTask errorTask) {
        VoiceAccountRuntime accountRuntime = this.findAccountForOutGoingCall(deviceId, record);
        if (accountRuntime != null) {
            this.addSession(recordSessions, record, accountRuntime, (short)1, deviceId, hour);
        }
        if ((accountRuntime = this.findAccountForIncomingCall(deviceId, record)) != null) {
            this.addSession(recordSessions, record, accountRuntime, (short)2, deviceId, hour);
        }
        int abonSessionSize = recordSessions.size();
        boolean abonErrorAdd = false;
        boolean operErrorAdd = false;
        if (recordSessions.size() == 0) {
            abonErrorAdd = true;
        }
        List<VoiceOperAccountRuntime> rules = this.findOperRules(record, deviceId);
        for (VoiceOperAccountRuntime ruleRuntime : rules) {
            VoiceSession session = this.addSession(recordSessions, record, ruleRuntime, ((VoiceOperAccount)ruleRuntime.getAccount()).getCallType(), deviceId, hour);
            VoiceOperator operator = this.operatorRuntimeMap.getOperatorByContractId(session.getContractId());
            if (operator == null) {
                logger.warn("operator not found for contractId " + session.getContractId());
                continue;
            }
            if (!operator.isUseCustomGeoDict()) continue;
            session.setOperatorId(operator.getId());
        }
        if (recordSessions.size() == abonSessionSize) {
            operErrorAdd = true;
        }
        logger.debug("record.e164CallingStationId={}, record.e164CalledStationId={}, recordSessions.size()={}, operErrorAdd={}", (Object)record.e164CallingStationId, (Object)record.e164CalledStationId, (Object)recordSessions.size(), (Object)operErrorAdd);
        Mediator mediator = this.deviceRuntime.getMediatorInstance();
        boolean addError = mediator.postSessionCreate(recordSessions, record, abonErrorAdd, operErrorAdd);
        logger.debug("mediator.postSessionCreate(...)={}", (Object)addError);
        VoiceError error = null;
        if (recordSessions.size() == 0) {
            error = this.addError(record, deviceId, hour, true);
        }
        if (addError) {
            error = this.addError(record, deviceId, hour, false);
        }
        if (error != null) {
            errorTask.addError(error);
        }
    }

    private VoiceError addError(VoiceRecord record, int deviceId, Date hour, boolean audit) {
        logger.debug("addError: audit={}", (Object)audit);
        if (audit && !this.resourceAuditor.containsNumber(Utils.parseLong((String)record.e164CallingStationId, (long)0L)) && !this.resourceAuditor.containsNumber(Utils.parseLong((String)record.e164CalledStationId, (long)0L))) {
            return null;
        }
        VoiceError error = new VoiceError();
        error.setCode(1);
        error.setSessionStart(record.sessionStart);
        error.setDeviceId(deviceId);
        error.setHour(hour);
        error.setPhoneFrom(record.e164CallingStationId);
        error.setPhoneTo(record.e164CalledStationId);
        error.setFromPort(record.trunkIncoming);
        error.setToPort(record.trunkOutgoing);
        error.setDuration((long)record.duration);
        logger.debug("addError: error={}", (Object)error);
        return error;
    }

    public List<VoiceOperAccountRuntime> findOperRules(VoiceRecord record, int deviceId) {
        List<VoiceOperAccountRuntime> result = this.operAccountRuntimeMap.find(deviceId, record.sessionStart, record.e164CallingStationId, record.e164CalledStationId, record.trunkIncoming, record.trunkOutgoing);
        return result;
    }

    protected VoiceSession addSession(List<VoiceSessionRuntime> foundSessions, VoiceRecord record, VoiceAbtractAccountRuntime accountRuntime, short callType, int deviceId, Date hour) {
        VoiceSession session = record.toVoiceSession();
        session.setHour(hour);
        session.setDeviceId(deviceId);
        session.setAccountId(accountRuntime.getAccount().getId());
        session.setContractId(accountRuntime.getAccount().getContractId());
        session.setCallType(callType);
        VoiceSessionRuntime sessionRuntime = new VoiceSessionRuntime(session, accountRuntime);
        foundSessions.add(sessionRuntime);
        return session;
    }

    public VoiceAccountRuntime findAccountForOutGoingCall(int deviceId, VoiceRecord record) {
        Long e164CallingStationId;
        try {
            e164CallingStationId = Long.valueOf(record.e164CallingStationId);
        }
        catch (Exception ex) {
            logger.error("error parsing e164CallingStationId " + record.e164CallingStationId);
            return null;
        }
        VoiceAccountRuntime voiceAccountRuntime = this.accountRuntimeMap.searchByDeviceAndNumber(deviceId, e164CallingStationId, record.sessionStart, this.deepFind);
        if (voiceAccountRuntime == null) {
            voiceAccountRuntime = this.accountRuntimeMap.findByPort(record.trunkIncoming, record.sessionStart);
        }
        return voiceAccountRuntime;
    }

    public VoiceAccountRuntime findAccountForIncomingCall(int deviceId, VoiceRecord record) {
        Long e164CalendStationId;
        try {
            e164CalendStationId = Long.valueOf(record.e164CalledStationId);
        }
        catch (Exception ex) {
            logger.error("error parsing e164CalledStationId " + record.e164CalledStationId);
            return null;
        }
        VoiceAccountRuntime voiceAccountRuntime = this.accountRuntimeMap.searchByDeviceAndNumber(deviceId, e164CalendStationId, record.sessionStart, this.deepFind);
        if (voiceAccountRuntime == null) {
            voiceAccountRuntime = this.accountRuntimeMap.findByPort(record.trunkOutgoing, record.sessionStart);
        }
        return voiceAccountRuntime;
    }
}

