/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.modules.uniteller.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.uniteller.common.bean.Transaction;
import ru.bitel.bgbilling.modules.uniteller.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.uniteller.common.service.UnitellerService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            String contractTitle = TransactionPanel.this.contractTitleField.getText();
            AbstractTransactionStatus status = (AbstractTransactionStatus)TransactionPanel.this.statusComboBox.getSelectedItem();
            SearchResult searchResult = ((UnitellerService)((ClientContext)TransactionPanel.this.getContext()).getWebService(UnitellerService.class)).searchTransactionList(TransactionPanel.this.getContractId(), contractTitle, status.getCode(), TransactionPanel.this.periodPanel.getPeriod(), TransactionPanel.this.getTable().getSort(), TransactionPanel.this.pagePanel.getPage());
            ((TransactionTableModel)TransactionPanel.this.transactionModel).setData(searchResult.getList());
            TransactionPanel.this.pagePanel.setPage(searchResult.getPage());
            TransactionPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            TransactionPanel.this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        }
    };

    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected JPanel getExtraFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getCheckButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        return panel;
    }

    protected BGButton getCheckButton() {
        BGButton button = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c...");
        button.setToolTipText("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u0441\u0435\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439");
        button.addActionListener(event -> {
            try {
                ((UnitellerService)((ClientContext)this.getContext()).getWebService(UnitellerService.class)).checkTransactions(this.getContractId());
                this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return button;
    }

    protected void initListeners() {
        super.initListeners();
        super.initPopupListener();
    }

    protected void initPopupMenu() {
        this.getTable().getPopupMenu().add(this.getOpenContractMenuItem());
        this.getTable().getPopupMenu().add(this.getTransactionDataMenuItem());
    }

    protected JMenuItem getTransactionDataMenuItem() {
        return new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        JTextArea textArea = new JTextArea(transaction.getParameters(), 20, 50);
                        textArea.setMargin(new Insets(5, 5, 5, 5));
                        textArea.setEditable(false);
                        JScrollPane scrollPane = new JScrollPane(textArea);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", 1);
                    }
                });
            }
        };
    }
}

