/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access;

import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvAccountDeviceStateAndOptionsModifyEvent;
import ru.bitel.common.Utils;

@XmlRootElement
public class TvAccountDeviceStateAndOptionsModifiedEvent
extends Event {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int tvAccountId;
    @XmlAttribute
    private final String deviceAccountId;
    @XmlAttribute
    private final short deviceState;
    @XmlAttribute
    private final Set<Integer> deviceOptionIds;

    protected TvAccountDeviceStateAndOptionsModifiedEvent() {
        this.deviceId = -1;
        this.tvAccountId = -1;
        this.deviceAccountId = null;
        this.deviceState = (short)-1;
        this.deviceOptionIds = null;
    }

    public TvAccountDeviceStateAndOptionsModifiedEvent(TvAccountDeviceStateAndOptionsModifyEvent modify) {
        super(modify.getModuleId(), modify.getContractId(), modify.getUserId());
        this.deviceId = modify.getDeviceId();
        this.tvAccountId = modify.getTvAccountId();
        this.deviceAccountId = modify.getDeviceAccountId();
        this.deviceState = modify.getDeviceState();
        this.deviceOptionIds = modify.getDeviceOptionIds();
    }

    @Deprecated
    public TvAccountDeviceStateAndOptionsModifiedEvent(int moduleId, int deviceId, int tvAccountId, String deviceAccountId, short state, Set<Integer> optionSet) {
        super(moduleId, CONTRACT_GLOBAL, -1);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.deviceAccountId = deviceAccountId;
        this.deviceState = state;
        this.deviceOptionIds = optionSet;
    }

    public TvAccountDeviceStateAndOptionsModifiedEvent(int moduleId, int contractId, int deviceId, int tvAccountId, String deviceAccountId, short state, Set<Integer> optionSet) {
        super(moduleId, contractId, -1);
        this.deviceId = deviceId;
        this.tvAccountId = tvAccountId;
        this.deviceAccountId = deviceAccountId;
        this.deviceState = state;
        this.deviceOptionIds = optionSet;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getTvAccountId() {
        return this.tvAccountId;
    }

    public String getDeviceAccountId() {
        return this.deviceAccountId;
    }

    public short getDeviceState() {
        return this.deviceState;
    }

    public Set<Integer> getDeviceOptionIds() {
        return this.deviceOptionIds;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; tvAccountId: ");
        sb.append(this.tvAccountId);
        sb.append("; state: ");
        sb.append(this.deviceState);
        sb.append("; optionIds: ");
        sb.append(Utils.toString(this.deviceOptionIds));
    }
}

