/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.utils;

import bitel.billing.server.contract.object.bean.AddressParamValue;
import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;

public class InternalUserAddressUtils {
    private final HouseDao houseDao;
    private final CityDao cityDao;
    private final CountryDao countryDao;
    private final AddressParamValue addressParamValue;
    private House house;

    public InternalUserAddressUtils(AddressParamValue addressParamValue, Connection connection) throws BGException {
        this.houseDao = new HouseDao(connection);
        this.cityDao = new CityDao(connection);
        this.countryDao = new CountryDao(connection);
        this.addressParamValue = addressParamValue;
        this.house = this.houseDao.get(addressParamValue.getHouseId());
    }

    public String getIndex() throws BGException {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getPostIndex(), (String)"");
    }

    public String getCountry() throws BGException {
        if (this.house == null) {
            return "";
        }
        City city = (City)this.cityDao.get(this.house.getCityId());
        Country country = city == null ? null : (Country)this.countryDao.get(city.getCountryId());
        return country == null ? "" : Utils.maskBlank((String)country.getGuiTitle(), (String)"");
    }

    public String getArea() {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getAreaTitle(), (String)"");
    }

    public String getCity() {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getCityTitle(), (String)"");
    }

    public String getStreet() {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getStreetTitle(), (String)"");
    }

    public String getHouse() {
        return this.house == null ? "" : String.valueOf(this.house.getHouse());
    }

    public String getFrac() {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getFrac(), (String)"");
    }

    public String getFlat() {
        return Utils.maskBlank((String)this.addressParamValue.getFlat(), (String)"");
    }
}

