/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.task;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.Product;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.ProductDao;
import ru.bitel.common.TimeUtils;

public class SubscriptionCheckActivateDailyTask
extends TaskBase {
    private static Logger logger = LogManager.getLogger();
    private SoftLineSubscriptionService subscriptionService;
    private Connection con;

    protected boolean initTask() {
        int moduleId = this.getModuleId();
        this.con = this.setup.getDBConnectionFromPool();
        ServerContext serverContext = (ServerContext)ServerContext.get();
        try {
            this.subscriptionService = (SoftLineSubscriptionService)serverContext.getService(SoftLineSubscriptionService.class, moduleId);
        }
        catch (BGException e) {
            logger.error(e.getMessage());
        }
        return true;
    }

    protected void executeTask() {
        try {
            for (SoftLineSubscription subscription : this.getActiveSubscriptions()) {
                if (subscription.getSuspendReason() != null && subscription.getSuspendReason() == SubscriptionSuspendReason.user_refuse) continue;
                Calendar endDate = TimeUtils.convertDateToCalendar((Date)subscription.getEndDate());
                ProductDao productDao = new ProductDao(this.con, this.getModuleId());
                Product productOfSubscription = (Product)productDao.get(subscription.getProductId());
                if (!SoftLineUtils.checkTodayDate((Date)subscription.getEndDate()) || !SoftLineUtils.checkActivation((Connection)this.con, (SoftLineSubscription)subscription, (Product)productOfSubscription)) continue;
                SoftLineUtils.prolongationDateEndSubscription((SoftLineSubscription)subscription, (Product)productOfSubscription);
                SoftLineUtils.addContractAccount((Connection)this.con, (int)this.moduleId, (SoftLineSubscription)subscription, (Date)TimeUtils.convertCalendarToDate((Calendar)endDate));
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage());
        }
    }

    private List<SoftLineSubscription> getActiveSubscriptions() throws BGException {
        return this.subscriptionService.searchSubscriptions(null, null, -1, -1, SubscriptionStatus.ACTIVE, -1).getList();
    }

    public String getDescription() {
        return null;
    }
}

