/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractTitlePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorLabel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableRow;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTable;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostGroupService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;

public class ForpostContractGroupPanel
extends ForpostContractBasePanel {
    private static final String ACTION_GROUP_REFRESH = "group.refresh";
    private GroupTableModel tableModel;
    private ForpostGroupService groupService = null;

    @Override
    protected void jbInit() throws Exception {
        Dimension dimension = new Dimension(300, 100);
        JScrollPane scrollPane = new JScrollPane((Component)this.getTable());
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(new ContractTitlePanel("\u0413\u0440\u0443\u043f\u043f\u044b:", (JComponent)((Object)this)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected BGTableModel<?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new GroupTableModel(GroupTableModel.class.getName());
        }
        return this.tableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ForpostContractGroupPanel.this.getGroupDialog(ForpostContractGroupPanel.this.getForpostGroupService().getDefaultForpostGroup()).setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ForpostGroup forpostGroup = (ForpostGroup)((GroupTableModel)ForpostContractGroupPanel.this.getTableModel()).getSelectedRow();
                if (forpostGroup == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0413\u0440\u0443\u043f\u043f\u0443\" \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
                } else {
                    ForpostContractGroupPanel.this.getGroupEditDialog(forpostGroup).setVisible(true);
                    ForpostContractGroupPanel.this.performAction(ForpostContractGroupPanel.ACTION_GROUP_REFRESH);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ForpostGroup forpostGroup = (ForpostGroup)((GroupTableModel)ForpostContractGroupPanel.this.getTableModel()).getSelectedRow();
                if (forpostGroup == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0413\u0440\u0443\u043f\u043f\u0443\" \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.");
                } else if (ClientUtils.confirmDelete((Object)forpostGroup.getName())) {
                    ForpostContractGroupPanel.this.getForpostGroupService().deleteForpostGroup(forpostGroup.getId());
                    ForpostContractGroupPanel.this.performAction(ForpostContractGroupPanel.ACTION_GROUP_REFRESH);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(ACTION_GROUP_REFRESH, "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", ICON_REFRESH){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((GroupTableModel)ForpostContractGroupPanel.this.getTableModel()).setData(ForpostContractGroupPanel.this.getForpostGroupService().searchForpostAccountGroups(ForpostContractGroupPanel.this.accountId).getList());
            }
        };
    }

    private JDialog getGroupDialog(ForpostGroup forpostGroup) {
        EditorTextField groupName = new EditorTextField(30, "\u0421\u0442\u0440\u043e\u043a\u0430<br>\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", this.focusListener);
        EditorTextField groupParentId = new EditorTextField(30, "\u0427\u0438\u0441\u043b\u043e<br>\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b", this.focusListener);
        Component[][] components = new Component[][]{{new EditorLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0413\u0440\u0443\u043f\u043f\u044b"), groupName}, {new EditorLabel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b"), groupParentId}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        groupName.setText(String.valueOf(forpostGroup.getName() != null ? forpostGroup.getName() : ""));
        groupParentId.setText(String.valueOf(forpostGroup.getParentId()));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            Color color = Color.YELLOW;
            boolean error = this.checkTextField(groupName, color, false);
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return;
            }
            forpostGroup.setAccountId(this.accountId);
            forpostGroup.setName(groupName.getText());
            forpostGroup.setParentId(Utils.parseInt((String)groupParentId.getText()));
            try {
                int id = this.getForpostGroupService().addForpostGroup(forpostGroup);
                this.performAction(ACTION_GROUP_REFRESH);
                this.getTableModel().setSelectedRow(Integer.valueOf(id));
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        });
        return dialog;
    }

    private JDialog getGroupEditDialog(final ForpostGroup forpostGroup) {
        final ForpostParamTableModel paramTableModel = new ForpostParamTableModel();
        CellEditorListener cellEditorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ParamTableRow tableRow = (ParamTableRow)paramTableModel.getSelectedRow();
                try {
                    ForpostContractGroupPanel.this.getForpostGroupService().updateForpostGroupParam(forpostGroup.getId(), tableRow.getName(), tableRow.getValue());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        };
        ForpostParamTable paramTable = new ForpostParamTable((TableModel)((Object)paramTableModel), cellEditorListener);
        paramTable.setContext((ClientContext)this.getContext());
        paramTableModel.addRow(new ParamTableRow("Name", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", forpostGroup.getName()));
        paramTableModel.addRow(new ParamTableRow("ParentID", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b", String.valueOf(forpostGroup.getParentId())));
        int gridy = 0;
        Dimension dimension = new Dimension(600, 100);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)new JScrollPane((Component)((Object)paramTable)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b", new JButton[]{new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")});
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> dialog.setVisible(false));
        return dialog;
    }

    private ForpostGroupService getForpostGroupService() {
        if (this.groupService == null) {
            this.groupService = (ForpostGroupService)((ClientContext)this.getContext()).getPort(ForpostGroupService.class);
        }
        return this.groupService;
    }

    class GroupTableModel
    extends BGTableModel<ForpostGroup> {
        public GroupTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", 200, 300, 400, "name", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", 200, 300, -1, "parentId", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(ForpostGroup forpostGroup, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("parentId".equals(identifier)) {
                String value = "";
                for (ForpostGroup forpostGroup2 : this.getRows()) {
                    if (forpostGroup.getParentId() != forpostGroup2.getId()) continue;
                    value = forpostGroup2.getName();
                    break;
                }
                return value;
            }
            return super.getValueAt((Object)forpostGroup, column);
        }
    }
}

