/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.smarthouse.client.AbstractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.BaseOptionTableModel;
import ru.bitel.bgbilling.modules.smarthouse.client.BasePackageTableModel;
import ru.bitel.bgbilling.modules.smarthouse.client.PackageDurationPanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.BooleanEditor;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorLabel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorUtils;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;
import ru.bitel.common.model.SearchResult;

public class PackageBasePanel
extends AbstractBasePanel<SmartHousePackageBase, BasePackageTableModel> {
    private static final String EDIT_OPTION = "editOption";
    private BasePackageTableModel tableModel = null;

    protected void jbInit() throws Exception {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.getTable()), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                PackageBasePanel.this.getPackageDialog("\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442", new SmartHousePackageBase()).setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                SmartHousePackageBase basePackage = (SmartHousePackageBase)PackageBasePanel.this.getTableModel().getSelectedRow();
                if (basePackage == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                } else {
                    PackageBasePanel.this.getPackageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u043a\u0435\u0442\u0430", basePackage).setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(EDIT_OPTION, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", ClientUtils.getIcon((String)"fugue/present")){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                SmartHousePackageBase basePackage = (SmartHousePackageBase)PackageBasePanel.this.getTableModel().getSelectedRow();
                if (basePackage == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                } else {
                    PackageBasePanel.this.getOptionDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", basePackage).setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                SearchResult searchResult = PackageBasePanel.this.getSmartHousePackageService().packageBaseSearch(null, false, PackageBasePanel.this.getTable().getSort(), PackageBasePanel.this.getPages().getPage());
                PackageBasePanel.this.getTableModel().setData(searchResult.getList());
                PackageBasePanel.this.getPages().setPage(searchResult.getPage());
                PackageBasePanel.this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
            }
        };
    }

    @Override
    protected void getPopupMenuItems() {
        this.getPopupMenu().add(new JMenuItem(this.getActionMap().get("edit")));
        this.getPopupMenu().add(new JMenuItem(this.getActionMap().get(EDIT_OPTION)));
    }

    @Override
    protected BasePackageTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BasePackageTableModel(BasePackageTableModel.class.getName());
        }
        return this.tableModel;
    }

    private JDialog getPackageDialog(String dialogTitle, SmartHousePackageBase packageBase) {
        EditorTextField title = new EditorTextField(40, "", this.focusListener);
        EditorTextField comment = new EditorTextField(40, "", this.focusListener);
        PackageDurationPanel duration = new PackageDurationPanel();
        BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB(false);
        Component[][] components = new Component[][]{{new EditorLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), title}, {new EditorLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), comment}, {new EditorLabel("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c"), duration}, {new EditorLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), period}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        title.setText(packageBase.getTitle());
        comment.setText(packageBase.getComment());
        period.setPeriod(packageBase.getPeriod());
        duration.getValue().setText(String.valueOf(packageBase.getDurationValue()));
        int unitCode = packageBase.getDurationUnitCode();
        int itemCount = duration.getUnit().getItemCount();
        for (int index = 0; index < itemCount; ++index) {
            if (duration.getUnit().getItemAt(index).getId() != unitCode) continue;
            duration.getUnit().setSelectedIndex(index);
            break;
        }
        BGOptionPane optionPane = new BGOptionPane((Object)panel, dialogTitle);
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            Color color = Color.YELLOW;
            boolean error = EditorUtils.checkTextField(title, color, false);
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return;
            }
            packageBase.setTitle(title.getText());
            packageBase.setComment(comment.getText());
            packageBase.setPeriod(period.getPeriod());
            packageBase.setDurationValue(Utils.parseInt((String)duration.getValue().getText(), (int)1));
            packageBase.setDurationUnitCode(((IdTitle)duration.getUnit().getSelectedItem()).getId());
            try {
                this.getSmartHousePackageService().smartHousePackageBaseUpdate(packageBase);
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return dialog;
    }

    private JDialog getOptionDialog(String dialogTitle, SmartHousePackageBase packageBase) {
        BaseOptionTableModel baseOptionTableModel = new BaseOptionTableModel(BaseOptionTableModel.class.getName());
        BGUTable optionTable = new BGUTable((TableModel)((Object)baseOptionTableModel)){

            public TableCellEditor getCellEditor(int row, int column) {
                return new BooleanEditor();
            }
        };
        optionTable.setContext((ClientContext)this.getContext());
        optionTable.setSelectionMode(0);
        int gridy = 0;
        Dimension dimension = new Dimension(600, 250);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)new JScrollPane((Component)optionTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        ArrayList<RowData> list = new ArrayList<RowData>();
        try {
            JSONArray optionNames = new JSONArray(packageBase.getOptionNames());
            for (SmartHousePackageOption packageOption : this.getSmartHousePackageService().packageOptionList()) {
                JSONObject json = new JSONObject();
                json.put("name", (Object)packageOption.getName());
                json.put("title", (Object)packageOption.getTitle());
                boolean selected = false;
                for (int index = 0; index < optionNames.length(); ++index) {
                    if (!packageOption.getName().equals(optionNames.getString(index))) continue;
                    selected = true;
                    break;
                }
                json.put("selected", selected);
                list.add(new RowData(json));
            }
            baseOptionTableModel.setData(list);
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
        BGOptionPane optionPane = new BGOptionPane((Object)panel, dialogTitle);
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                JSONArray jsonArray = new JSONArray();
                for (RowData rowData : list) {
                    if (!rowData.getJson().optBoolean("selected")) continue;
                    jsonArray.put(rowData.getJson().get("name"));
                }
                packageBase.setOptionNames(jsonArray.toString());
                this.getSmartHousePackageService().packageBaseOptionUpdate(packageBase.getId(), packageBase.getOptionNames());
                this.performAction("refresh");
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return dialog;
    }

    private JPanel getFilterPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new BGTextField(20), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0430\u0440\u0445\u0438\u0432\u043d\u044b\u0435"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)new JToggleButton("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.recordCount, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.getPages(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }
}

