/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMContractServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.event.RSCMContractServiceUpdateEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class RSCMInstallmentTask
extends TaskBase {
    private Connection con;
    private ConnectionSet connectionSet;

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        ServerContext threadContext = (ServerContext)ThreadContext.get();
        this.connectionSet = threadContext != null ? threadContext.getConnectionSet() : ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        this.con = this.connectionSet.getConnection();
        try (BalanceDao balanceDao = new BalanceDao(this.con);
             BalanceUtils balanceUtils = new BalanceUtils(this.con);
             RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(this.con, this.moduleId);){
            for (RSCMContractServiceInstallment contractServiceInstallment : rscmContractServiceManager.getContractServiceInstallmentList()) {
                LocalDate dateNext;
                if (!contractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.NEW) && !contractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS) || (dateNext = contractServiceInstallment.getDateNext()) == null || dateNext.isAfter(LocalDate.now())) continue;
                JSONObject jsonObject = new JSONObject(contractServiceInstallment.getInstallment());
                JSONArray paymentsArray = jsonObject.optJSONArray("paymentsArray");
                int number = contractServiceInstallment.getPaymentCount() + 1;
                BigDecimal percent = paymentsArray.getBigDecimal(number - 1);
                BigDecimal amount = contractServiceInstallment.getAmount().multiply(percent).divide(new BigDecimal(100));
                RSCMContractService contractService = new RSCMContractService();
                contractService.setContractId(contractServiceInstallment.getContractId());
                contractService.setServiceId(contractServiceInstallment.getServiceId());
                contractService.setInstallmentId(contractServiceInstallment.getId());
                contractService.setDate(dateNext);
                contractService.setAmount(amount);
                contractService.setComment(String.format("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0412\u0437\u043d\u043e\u0441 [%s%%] => %s \u0438\u0437 %s ", percent, number, paymentsArray.length()));
                rscmContractServiceManager.updateContractService(contractService);
                if (number == paymentsArray.length()) {
                    contractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.COMPLETED);
                    contractServiceInstallment.setDateNext(null);
                } else {
                    contractServiceInstallment.setPaymentCount(number);
                    dateNext = dateNext.withDayOfMonth(1).plusMonths(1L);
                    dateNext = dateNext.withDayOfMonth(Math.min(contractServiceInstallment.getDateFrom().getDayOfMonth(), dateNext.lengthOfMonth()));
                    contractServiceInstallment.setDateNext(dateNext);
                }
                JSONArray contractServiceIds = jsonObject.optJSONArray("contractServiceIds");
                if (contractServiceIds == null) {
                    contractServiceIds = new JSONArray();
                    jsonObject.put("contractServiceIds", (Object)contractServiceIds);
                }
                contractServiceIds.put(contractService.getId());
                contractServiceInstallment.setInstallment(jsonObject.toString());
                rscmContractServiceManager.updateRSCMContractServiceInstallment(contractServiceInstallment);
                EventProcessor.getInstance().publish((Event)new RSCMContractServiceUpdateEvent(0, this.moduleId, contractService.getContractId(), contractService));
                rscmContractServiceManager.hotCalc(contractService.getContractId(), contractService.getDate());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c RSCM. \u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430, \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0435\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }
}

