/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.task;

import bitel.billing.server.admin.errorlog.bean.PeriodicErrorManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMCalculatorUtils;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMTariffRequestResult;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RSCMCalculator
extends TaskBase {
    private Map<Integer, TariffTreeSet> tariffSets = new HashMap<Integer, TariffTreeSet>();
    private Calendar startMonth;
    private Calendar stopMonth;
    private String cids;
    private boolean externalConnection = false;
    private Connection con;
    private Connection conSlave;
    private PeriodicErrorManager errorManager;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c RSCM. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"yyyy.MM");
    }

    public void setCids(String cids) {
        this.cids = cids;
    }

    protected boolean initTask() {
        GregorianCalendar now;
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        this.startMonth.add(11, -1);
        TimeUtils.floor((Calendar)this.startMonth, (int)2);
        this.stopMonth = (Calendar)this.startMonth.clone();
        this.stopMonth.add(2, 1);
        if (this.moduleId <= 0) {
            this.log.error("Param mid NOT Found in task config");
            return false;
        }
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        boolean notCalculateFutureServices = moduleSetup.getBoolean("not.calculate.future.services", false);
        if (notCalculateFutureServices && (now = new GregorianCalendar()).before(this.stopMonth)) {
            this.stopMonth = now;
            this.stopMonth.add(5, 1);
            TimeUtils.floor((Calendar)this.stopMonth, (int)5);
        }
        return true;
    }

    public void setConnection(Connection con) {
        this.con = con;
        this.conSlave = con;
        this.externalConnection = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        if (!this.externalConnection) {
            this.con = this.setup.getDBConnectionFromPool();
            this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        }
        try (ContractManager contractManager = new ContractManager(this.con);){
            this.errorManager = new PeriodicErrorManager(this.con);
            this.errorManager.initErrorMessage(this.moduleId, "RSCM", String.valueOf(this.moduleId), this.startMonth.getTime());
            String tableName = "rscm_service_account_" + this.moduleId;
            if (this.log.isInfoEnabled()) {
                this.log.info("Processing " + tableName + " [" + TimeUtils.formatDate((Calendar)this.startMonth) + "-" + TimeUtils.formatDate((Calendar)this.stopMonth) + ")");
            }
            ServiceCostCache costCache = new ServiceCostCache();
            String query = "SELECT s.cid, s.sid, s.date, s.amount, c.domainId FROM " + tableName + " AS s INNER JOIN contract AS c ON c.id=s.cid WHERE s.date >= ? AND s.date < ?";
            if (Utils.notBlankString((String)this.cids)) {
                query = query + " AND s.cid IN (" + this.cids + ")";
            }
            PreparedStatement ps = this.conSlave.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.stopMonth));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int contractId = rs.getInt("s.cid");
                int serviceId = rs.getInt("s.sid");
                int domainId = rs.getInt("c.domainId");
                BigDecimal amount = rs.getBigDecimal("s.amount");
                Calendar time = TimeUtils.convertDateToCalendar((Date)rs.getDate("s.date"));
                List<TariffTreeSet.TariffSetEntry> treeList = this.getTreeList(contractId, time, contractManager);
                if (treeList != null && treeList.size() > 0) {
                    RSCMTariffRequestResult result = RSCMCalculatorUtils.processTariffRequest(costCache, treeList, domainId, contractId, serviceId, amount, time, this.log);
                    if (result.accepted || this.errorManager.isCapReached()) continue;
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractId + "): \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d.\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId + ". \u0414\u0430\u0442\u0430: " + TimeUtils.formatDate((Calendar)time) + ".";
                    this.errorManager.addErrorToList("\u041e\u0448\u0438\u0431\u043a\u0430!", text);
                    this.log.error("Tariff request wasn't processed: " + result.tariffRequestString);
                    continue;
                }
                if (this.errorManager.isCapReached()) continue;
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractId + "): \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e.\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId + ". \u0414\u0430\u0442\u0430: " + TimeUtils.formatDate((Calendar)time) + ".";
                this.errorManager.addErrorToList("\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e!", text);
                this.log.error("Tariff not found contract id => " + contractId + "; date => " + TimeUtils.format((Calendar)time, (String)"dd.MM.yyyy"));
            }
            rs.close();
            ps.close();
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                String sids = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
                balanceUtils.setAccount(this.con, this.log, this.startMonth, costCache, sids, this.cids, null);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (Utils.isBlankString((String)this.cids)) {
                this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
            }
            this.errorManager.processErrors();
            if (!this.externalConnection) {
                ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
            }
            this.con = null;
            this.conSlave = null;
            this.externalConnection = false;
        }
    }

    private List<TariffTreeSet.TariffSetEntry> getTreeList(int cid, Calendar time, ContractManager cm) {
        List result = null;
        TariffTreeSet tts = this.tariffSets.get(cid);
        if (tts == null) {
            tts = cm.getRealtimeTariffTreeSet(cid, this.startMonth.getTime(), "rscm", this.moduleId, 0, 0, true);
            this.tariffSets.put(cid, tts);
        }
        result = tts.getTreeEntryList(time);
        return result;
    }

    public static BigDecimal getCost(Connection con, int moduleId, int contractId, int serviceId, Date time, long amount) {
        BigDecimal result = null;
        ContractManager cm = new ContractManager(con);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(time);
        TariffTreeSet tts = cm.getRealtimeTariffTreeSet(contractId, time, "rscm", moduleId, 0, 0, true);
        List treeList = tts.getTreeEntryList((Calendar)calendar);
        if (treeList != null && treeList.size() > 0) {
            boolean accepted = false;
            for (TariffTreeSet.TariffSetEntry tree : treeList) {
                TariffRequest req = new TariffRequest();
                req.setRequestParam("sid", (Object)serviceId);
                req.setRequestParam("time", (Object)time);
                tree.getTree().processRequest(req);
                BigDecimal cost = (BigDecimal)req.getResponseParam("cost");
                BigDecimal divisor = (BigDecimal)req.getResponseParam("divisor");
                if (req.wasAccepted() && cost != null && divisor != null && divisor.longValue() > 0L) {
                    accepted = true;
                    result = new BigDecimal(amount).multiply(cost.divide(divisor, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
                }
                if (!accepted) continue;
                break;
            }
        }
        cm.close();
        return result;
    }
}

