/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import bitel.billing.server.util.MailMsg;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.rscm.server.task.RSCMCalculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class RSCMRecalculator
extends RunTaskRecalculator<RSCMCalculator> {
    private String cids;

    public RSCMRecalculator(int moduleId, Calendar dt, String email, String contractIds) {
        super(moduleId, dt, email);
        this.cids = contractIds;
    }

    public void executeTask() {
        try {
            RSCMCalculator calculator = this.createTask();
            long start = System.currentTimeMillis();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041e\u0431\u0441\u0447\u0435\u0442 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\n");
                report.append("\u0412\u0440\u0435\u043c\u044f: ");
                report.append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                new MailMsg((Preferences)this.setup).sendMessage(this.email, "\u041e\u0431\u0441\u0447\u0435\u0442 RSCM \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", report.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected RSCMCalculator createTask() {
        RSCMCalculator calculator = new RSCMCalculator();
        calculator.setCids(this.cids);
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid);
        return calculator;
    }
}

