/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rfiec.server.servlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.rfiec.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rfiec.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.rfiec.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.rfiec.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;

@WebServlet(name="RFIe\u00adCommerceExecutor", urlPatterns={"/rfiec/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final char CHAR_NEW_LINE = '\n';
    private static final char CHAR_EQUAL = '=';
    private static final String PARAM_CARD = "card";
    private static final String PARAM_CHECK = "check";
    private static final String PARAM_COMMAND = "command";
    private static final String PARAM_COMMENT = "comment";
    private static final String PARAM_EMAIL = "email";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_ORDER_ID = "order_id";
    private static final String PARAM_PARTNER_ID = "partner_id";
    private static final String PARAM_PARTNER_INCOME = "partner_income";
    private static final String PARAM_PHONE_NUMBER = "phone_number";
    private static final String PARAM_RECURRENT_ORDER_ID = "recurrent_order_id";
    private static final String PARAM_SERVICE_ID = "service_id";
    private static final String PARAM_SYSTEM_INCOME = "system_income";
    private static final String PARAM_TEST = "test";
    private static final String PARAM_TID = "tid";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_VERSION = "version";
    private static final String COMMAND_SUCCESS = "success";
    private static final String COMMAND_CANCEL = "cancel";
    private static final String COMMAND_RECURRENT_CANCEL = "recurrent_cancel";
    private static final String COMMAND_RECURRENT_EXPIRE = "recurrent_expire";
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block37: {
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                String command = request.getParameter(PARAM_COMMAND);
                if (command != null) {
                    String recurrentOrderId;
                    String version = request.getParameter(PARAM_VERSION);
                    if (version == null) {
                        version = "1.0";
                    }
                    if ((recurrentOrderId = request.getParameter(PARAM_RECURRENT_ORDER_ID)) != null) {
                        TransactionManager transactionManager = new TransactionManager(con, moduleId);
                        Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)recurrentOrderId));
                        transactionManager.close();
                        if (COMMAND_RECURRENT_CANCEL.equals(command) || COMMAND_RECURRENT_EXPIRE.equals(command)) {
                            AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(transaction.getContractId());
                            if (autopayment != null) {
                                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                                autopaymentManager.updateAutopayment(autopayment);
                            }
                            autopaymentManager.close();
                        } else if (COMMAND_CANCEL.equals(command)) {
                            AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(transaction.getContractId());
                            if (autopayment != null && autopayment.getMode() != AutopaymentMode.OFF && Utils.isEmptyString((String)autopayment.getAccessToken())) {
                                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                                autopaymentManager.updateAutopayment(autopayment);
                            }
                            autopaymentManager.close();
                        } else if (COMMAND_SUCCESS.equals(command)) {
                            AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(transaction.getContractId());
                            if (autopayment != null) {
                                PeriodWithTime period = autopayment.getPeriod();
                                if (period == null) {
                                    period = new PeriodWithTime(LocalDateTime.now(), null);
                                    autopayment.setPeriod(period);
                                } else if (period.getDateFrom() == null) {
                                    period.setLocalDateTimeFrom(LocalDateTime.now());
                                }
                                logger.info("Set reccurent_order_id to autopayment");
                                autopayment.setAccessToken(recurrentOrderId);
                                String data = autopayment.getData();
                                autopayment.setData((String)(data == null ? "" : data + "\n") + "card=" + request.getParameter(PARAM_CARD));
                                autopaymentManager.updateAutopayment(autopayment);
                            } else {
                                logger.info("Autopayment not found for this reccurent_order_id");
                            }
                            autopaymentManager.close();
                        }
                    }
                    response.setStatus(200);
                    return;
                }
                String transactionId = request.getParameter(PARAM_TID);
                String name = request.getParameter(PARAM_NAME);
                String comment = request.getParameter(PARAM_COMMENT);
                String partnerId = request.getParameter(PARAM_PARTNER_ID);
                String serviceId = request.getParameter(PARAM_SERVICE_ID);
                String orderId = request.getParameter(PARAM_ORDER_ID);
                String type = request.getParameter(PARAM_TYPE);
                String partnerIncome = request.getParameter(PARAM_PARTNER_INCOME);
                String systemIncome = request.getParameter(PARAM_SYSTEM_INCOME);
                String test = request.getParameter(PARAM_TEST);
                String check = request.getParameter(PARAM_CHECK);
                String secret = moduleSetup.get("rfiec.secret.key", "");
                if (orderId == null || check == null) break block37;
                String signData = (transactionId != null ? transactionId : "") + (name != null ? name : "") + (comment != null ? comment : "") + (partnerId != null ? partnerId : "") + (serviceId != null ? serviceId : "") + (orderId != null ? orderId : "") + (type != null ? type : "") + (partnerIncome != null ? partnerIncome : "") + (systemIncome != null ? systemIncome : "") + (test != null ? test : "") + (secret != null ? secret : "");
                String checkSignData = Utils.getDigest((String)signData, (String)"UTF-8").toLowerCase();
                if (check.equals(checkSignData)) {
                    String email = request.getParameter(PARAM_EMAIL);
                    String phoneNumber = request.getParameter(PARAM_PHONE_NUMBER);
                    String paramData = PARAM_TID + '=' + (transactionId != null ? transactionId : "") + '\n' + PARAM_NAME + '=' + (name != null ? name : "") + '\n' + PARAM_COMMENT + '=' + (comment != null ? comment : "") + '\n' + PARAM_PARTNER_ID + '=' + (partnerId != null ? partnerId : "") + '\n' + PARAM_SERVICE_ID + '=' + (serviceId != null ? serviceId : "") + '\n' + PARAM_ORDER_ID + '=' + (orderId != null ? orderId : "") + '\n' + PARAM_TYPE + '=' + (type != null ? type : "") + '\n' + PARAM_PARTNER_INCOME + '=' + (partnerIncome != null ? partnerIncome : "") + '\n' + PARAM_SYSTEM_INCOME + '=' + (systemIncome != null ? systemIncome : "") + '\n' + PARAM_TEST + '=' + (test != null ? test : "") + '\n' + PARAM_PHONE_NUMBER + '=' + (phoneNumber != null ? phoneNumber : "") + '\n' + PARAM_EMAIL + '=' + (email != null ? email : "");
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderId));
                    transactionManager.close();
                    if (transaction == null) {
                        logger.error("Not found transaction for ID = " + orderId);
                        response.setStatus(500);
                        return;
                    }
                    if (!transaction.getStatus().equals(TransactionStatus.CREATED.getCode())) {
                        logger.error("Transaction for ID = " + orderId + " has status != 'created'");
                        response.setStatus(200);
                        return;
                    }
                    if (transaction.getPaymentId() > 0) {
                        logger.error("Transaction for ID = " + orderId + " has PaymentId > 0");
                        response.setStatus(200);
                        return;
                    }
                    transaction.setSum(new BigDecimal(systemIncome));
                    transaction.setTransactionId(transactionId);
                    transaction.setTransactionDate(new Date());
                    transaction.setParameters(paramData);
                    transaction.setStatus(TransactionStatus.OK.getCode());
                    Payment payment = new Payment();
                    payment.setContractId(transaction.getContractId());
                    payment.setSum(transaction.getSum());
                    Date paymentDate = transaction.getTransactionDate();
                    if (paymentDate == null) {
                        paymentDate = new Date();
                        transaction.setTransactionDate(paymentDate);
                    }
                    payment.setDate(paymentDate);
                    payment.setTypeId(moduleSetup.getInt("rfiec.payment.type.id", 0));
                    payment.setComment(moduleSetup.get("rfiec.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437 \u0420\u0424\u0418 \u0411\u0430\u043d\u043a\u0430 [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                    try (PaymentDao paymentDao = new PaymentDao(con);){
                        paymentDao.update((Object)payment);
                    }
                    transaction.setPaymentId(payment.getId());
                    transactionManager.update(transaction);
                    transactionManager.close();
                    ServerUtils.commitConnection((Connection)con);
                    BalanceUtils balanceUtils = new BalanceUtils(con);
                    balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                    balanceUtils.close();
                    ServerUtils.commitConnection((Connection)con);
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    break block37;
                }
                logger.error("Error check sign (in request check = '" + check + "' no equals calculate = '" + checkSignData + "' )");
                response.setStatus(500);
                return;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

