/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rfiec.server.bean;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.rfiec.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rfiec.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.rfiec.server.event.RFIeCommerceAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final Logger logger = LogManager.getLogger();
    public Map<String, String> fields = new HashMap<String, String>();

    public TransactionManager(Connection con, int mid) {
        super(con, mid, "rfiec_transaction");
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            query.append(" AND pt.result=?");
        }
    }

    protected int psStatus(PreparedStatement ps, String status, int index) throws SQLException {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            ps.setString(index++, status);
        }
        return index;
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, String customerAddress2, BigDecimal sum, Map<String, Object> dataMap, boolean requestRecurrentOrderId) throws BGException {
        if (requestRecurrentOrderId) {
            RFIeCommerceAutopaymentSumEvent event = new RFIeCommerceAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((RFIeCommerceAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = new Transaction();
        transaction.setSum(sum);
        transaction.setContractId(contractId);
        transaction.setCreateDate(new Date());
        this.update(transaction);
        HashMap<String, String> params = new HashMap<String, String>();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String name = moduleSetup.get("rfiec.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle);
        params.put("version", "2.0");
        params.put("service_id", moduleSetup.get("rfiec.service.id", ""));
        params.put("order_id", new DecimalFormat("##########000000").format(transaction.getId()));
        params.put("cost", new DecimalFormat("###########0.00").format(sum).replace(",", "."));
        params.put("name", name);
        if (logger.isDebugEnabled()) {
            logger.debug("service_id: " + (String)params.get("service_id"));
            logger.debug("order_id: " + (String)params.get("order_id"));
            logger.debug("cost: " + (String)params.get("cost"));
            logger.debug("name: " + (String)params.get("name"));
        }
        if (requestRecurrentOrderId) {
            params.put("payment_type", moduleSetup.get("rfiec.autopayment.payment.type", "spg"));
            params.put("recurrent_type", "first");
            params.put("recurrent_comment", moduleSetup.get("rfiec.autopayment.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
            params.put("recurrent_url", moduleSetup.get("rfiec.autopayment.url", "http://example.com/rules"));
            params.put("recurrent_period", moduleSetup.get("rfiec.autopayment.period", "byrequest"));
            if (Utils.notBlankString((String)customerAddress2)) {
                if (customerAddress2.contains("@")) {
                    params.put("email", customerAddress2);
                } else {
                    params.put("phone_number", customerAddress2);
                }
            }
            if (Utils.notBlankString((String)customerAddress)) {
                if (customerAddress.contains("@")) {
                    params.put("email", customerAddress);
                } else {
                    params.put("phone_number", customerAddress);
                }
            }
        }
        dataMap.putAll(params);
        try {
            String gateUrl = moduleSetup.get("rfiec.url.gate", "https://partner.rficb.ru/alba/input/");
            dataMap.put("check", TransactionManager.signVer2("POST", gateUrl, params, moduleSetup.get("rfiec.secret.key", "")));
        }
        catch (UnsupportedEncodingException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException e) {
            dataMap.put("check", e.getMessage());
        }
        return transaction;
    }

    public void doAutopaymentRequest(int contractId, String contractTitle, String customerAddress, String recurrentOrderId, BigDecimal sum) {
        try {
            JSONObject resultJson;
            String resultStatus;
            RFIeCommerceAutopaymentSumEvent event = new RFIeCommerceAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((RFIeCommerceAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
            Transaction transaction = new Transaction();
            transaction.setSum(sum);
            transaction.setContractId(contractId);
            transaction.setCreateDate(new Date());
            transaction.setAutopayment(true);
            this.update(transaction);
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            String gateUrl = moduleSetup.get("rfiec.url.gate", "https://partner.rficb.ru/alba/input/");
            String name = moduleSetup.get("rfiec.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", "2.0");
            params.put("service_id", moduleSetup.get("rfiec.service.id", ""));
            params.put("order_id", new DecimalFormat("##########000000").format(transaction.getId()));
            params.put("cost", new DecimalFormat("###########0.00").format(sum).replace(",", "."));
            params.put("name", name);
            params.put("payment_type", moduleSetup.get("rfiec.autopayment.payment.type", "spg"));
            params.put("recurrent_type", "next");
            params.put("recurrent_comment", moduleSetup.get("rfiec.autopayment.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
            params.put("recurrent_url", moduleSetup.get("rfiec.autopayment.url", "http://example.com/rules"));
            params.put("background", "1");
            params.put("recurrent_order_id", recurrentOrderId);
            if (Utils.notBlankString((String)customerAddress)) {
                if (customerAddress.contains("@")) {
                    params.put("email", customerAddress);
                } else {
                    params.put("phone_number", customerAddress);
                }
            }
            StringBuilder formData = new StringBuilder();
            for (String key : params.keySet()) {
                if (formData.length() > 0) {
                    formData.append("&");
                }
                formData.append(key).append("=").append(Utils.htmlEncode((String)((String)params.get(key)), (String)"UTF-8"));
            }
            formData.append("&check=").append(Utils.htmlEncode((String)TransactionManager.signVer2("POST", gateUrl, params, moduleSetup.get("rfiec.secret.key", "")), (String)"UTF-8"));
            if (logger.isDebugEnabled()) {
                logger.debug("\t\u0417\u0430\u043f\u0440\u043e\u0441: " + formData.toString());
            }
            URL urlGate = new URL(gateUrl);
            HttpsURLConnection connection = (HttpsURLConnection)urlGate.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            PrintStream ps = new PrintStream(connection.getOutputStream(), true);
            ps.print(formData.toString());
            ps.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = null;
            StringBuilder result = new StringBuilder();
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            br.close();
            if (logger.isDebugEnabled()) {
                logger.debug("\t\u041e\u0442\u0432\u0435\u0442: " + result.toString());
            }
            if (!"success".equals(resultStatus = (resultJson = new JSONObject(result.toString())).getString("status")) && "error".equals(resultStatus)) {
                String code = resultJson.getString("code");
                String msg = resultJson.getString("msg");
                Object parameters = transaction.getParameters();
                if (parameters == null) {
                    parameters = "";
                }
                parameters = (String)parameters + "code=" + code + "\nmsg=" + msg;
                transaction.setParameters((String)parameters);
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                this.update(transaction);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    protected Transaction getById(int id) throws BGException, SQLException {
        Transaction transaction = null;
        PreparedStatement ps = this.con.prepareStatement("SELECT t.*, c.title AS contract_title FROM " + this.tableName + " AS t LEFT JOIN contract c ON c.id=t.contract_id WHERE t.id=?");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            transaction = this.getFromRS(rs);
        }
        rs.close();
        ps.close();
        return transaction;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setContractTitle(rs.getString("contract_title"));
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setTransactionId(rs.getString("transaction_id"));
        transaction.setAutopayment(rs.getBoolean("autopayment"));
        transaction.setStatus(rs.getString("result"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        return transaction;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, autopayment=?, result=?, params=?, sum=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, autopayment=?, result=?, params=?, sum=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setBoolean(index++, transaction.isAutopayment());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public static String signVer2(String method, String url, Map<String, String> params, String secretKey) throws URISyntaxException, UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        URI uri = new URI(url);
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", key, URLEncoder.encode(params.get(key), "UTF-8").replace("+", "%20").replace("*", "%2A")));
        }
        String urlParameters = sb.toString();
        String data = method.toUpperCase() + "\n" + uri.getHost() + "\n" + uri.getPath() + "\n" + urlParameters;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Check data = " + data);
        }
        Mac hmacInstance = Mac.getInstance("HmacSHA256");
        Charset charSet = Charset.forName("UTF-8");
        SecretKeySpec keySpec = new SecretKeySpec(charSet.encode(secretKey).array(), "HmacSHA256");
        hmacInstance.init(keySpec);
        return DatatypeConverter.printBase64Binary((byte[])hmacInstance.doFinal(data.getBytes("UTF-8")));
    }
}

