/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.report;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseStaticText;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.util.Rotation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;

public abstract class BGJasperReport
extends BGReport {
    protected String _query;

    public BGJasperReport() {
        this.contentType = "jasper";
    }

    public List<String> getFields() {
        ArrayList<String> result = new ArrayList<String>();
        JasperReport report = this.getJasperReport(this.id);
        if (report != null) {
            for (Object obj : report.getTitle().getChildren()) {
                if (!(obj instanceof JRBaseStaticText)) continue;
                JRBaseStaticText text = (JRBaseStaticText)obj;
                result.add(text.getText());
            }
        }
        return result;
    }

    public JasperReport getJasperReport(String templName) {
        File file = null;
        file = this.cfg_clazz != null ? DynamicCodeDao.getClassFile((String)(this.cfg_clazz.getResourcePackageName() + "." + templName + ":jrxml")) : new File("reports/" + templName + ".jrxml");
        return BGReportTemplate.getJasperReport(file.toURI());
    }

    protected Image createPieChart(PieDataset data, String title, String key, int width, int height) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)title, (PieDataset)data, (boolean)true, (boolean)true, (boolean)false);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
        ByteArrayOutputStream imgBytes = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsPNG((OutputStream)imgBytes, (JFreeChart)chart, (int)width, (int)height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new ImageIcon(imgBytes.toByteArray()).getImage();
    }

    protected Image createVarWidthAreaChart(CategoryDataset data, String xLabel, String yLabel, String title, int height) {
        int width = 700 + 7 * (data.getColumnCount() - 24);
        if (width > 1200) {
            width = 1200;
        }
        return this.createAreaChart(data, xLabel, yLabel, title, width, height);
    }

    protected Image createAreaChart(CategoryDataset data, String xLabel, String yLabel, String title, int width, int height) {
        JFreeChart chart = ChartFactory.createAreaChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setMaximumCategoryLabelWidthRatio(1.0f);
        ByteArrayOutputStream imgBytes = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsPNG((OutputStream)imgBytes, (JFreeChart)chart, (int)width, (int)height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new ImageIcon(imgBytes.toByteArray()).getImage();
    }

    protected final void fillReportToStream(String templName, OutputStream os, Map<?, ?> params, JRDataSource ds) throws JRException {
        JasperReport report = this.getJasperReport(templName);
        this.fillReportToStream(report, os, params, ds);
    }

    protected final void fillReportToStream(JasperReport report, OutputStream os, Map<?, ?> params, JRDataSource ds) throws JRException {
        JasperFillManager.fillReportToStream((JasperReport)report, (OutputStream)os, params, (JRDataSource)ds);
    }
}

