/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Reward
extends BGJasperReport {
    private static final Pattern colonPat = Pattern.compile(":");
    private static final Pattern semicolonPat = Pattern.compile(";");

    public Report_Reward() {
        this.id = "kernel_contract_reward";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            boolean ndsInSumm;
            int agentCid = Utils.parseInt((String)this.getStringParam("cid"), (int)-1);
            Calendar date = TimeUtils.parseCalendar((String)this.getStringParam("date"), (String)"dd.MM.yyyy");
            int agentParamId = this.moduleSetup.getInt("reports.reward.agent.pid", -1);
            float ndsMultiplier = this.moduleSetup.getInt("reports.reward.nds", 0);
            HashSet fixedPriceSet = new HashSet(Utils.toIntegerList((String)this.moduleSetup.get("reports.reward.services.fixed", "")));
            HashMap<Integer, Float> servicesRewards = new HashMap<Integer, Float>();
            ndsMultiplier /= 100.0f;
            if (ndsMultiplier < 0.0f) {
                ndsMultiplier = Math.abs(ndsMultiplier) + 1.0f;
                ndsInSumm = true;
            } else {
                ndsInSumm = false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("date", TimeUtils.monthNames[date.get(2)] + " " + date.get(1));
            ContractDao contractDao = new ContractDao(this.con, 0);
            Contract agentContract = (Contract)contractDao.get(agentCid);
            contractDao.close();
            params.put("contractTitle", agentContract.getTitle());
            params.put("contractComment", agentContract.getComment());
            BGDataSource bds = new BGDataSource();
            float totalReward = 0.0f;
            float totalSummNds = 0.0f;
            float totalNds = 0.0f;
            float totalSumm = 0.0f;
            PreparedStatement ps = this.con.prepareStatement("SELECT val FROM contract_parameter_type_1 WHERE cid=? AND pid=?");
            ps.setInt(1, agentCid);
            for (String par : semicolonPat.split(this.moduleSetup.get("reports.reward.services", ""))) {
                int sid;
                String[] p = colonPat.split(par);
                if (p.length != 2 || (sid = Utils.parseInt((String)p[0], (int)0)) <= 0) continue;
                ps.setInt(2, Utils.parseInt((String)p[1], (int)0));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    float val = Utils.parseFloat((String)rs.getString(1), (float)0.0f);
                    if (!(val > 0.0f)) continue;
                    servicesRewards.put(sid, Float.valueOf(val));
                }
            }
            ps.close();
            if (servicesRewards.size() > 0) {
                HashMap<Integer, String> serviceTitles = new HashMap<Integer, String>();
                StringBuilder query = new StringBuilder(100);
                query.append("SELECT COUNT(sid), sid, SUM(summa) FROM contract_account");
                query.append(" WHERE yy=? AND mm=? AND summa>0 AND sid IN (");
                for (Integer sid : servicesRewards.keySet()) {
                    query.append(sid);
                    query.append(',');
                }
                query.setLength(query.length() - 1);
                query.append(')');
                PreparedStatement getServiceTitlePS = this.con.prepareStatement("SELECT title FROM service WHERE id=?");
                ps = this.con.prepareStatement("SELECT params.cid, contract.title, contract.comment, contract.scid, contract.sub_list FROM contract_parameter_type_8 as params LEFT JOIN contract ON contract.id=params.cid WHERE params.val=? AND params.pid=? AND contract.scid<=0");
                ps.setInt(1, agentCid);
                ps.setInt(2, agentParamId);
                ResultSet contractRS = ps.executeQuery();
                PreparedStatement getSubContract = this.con.prepareStatement("SELECT id FROM contract WHERE scid=?");
                while (contractRS.next()) {
                    Object cids;
                    int _cid = contractRS.getInt(1);
                    String contract = String.valueOf(_cid);
                    String contractTitle = contractRS.getString(2);
                    String contractComment = contractRS.getString(3);
                    int scid = contractRS.getInt("scid");
                    if (scid == -1) {
                        getSubContract.setInt(1, _cid);
                        ResultSet subRs = getSubContract.executeQuery();
                        StringBuilder subCids = new StringBuilder();
                        while (subRs.next()) {
                            subCids.append(subRs.getInt(1));
                            subCids.append(',');
                        }
                        subRs.close();
                        subCids.setLength(subCids.length() - 1);
                        cids = _cid + "," + subCids.toString();
                    } else {
                        cids = String.valueOf(_cid);
                    }
                    PreparedStatement accountPS = this.con.prepareStatement(query.toString() + " AND cid IN (" + (String)cids + ") GROUP BY sid");
                    accountPS.setInt(1, date.get(1));
                    accountPS.setInt(2, date.get(2) + 1);
                    ResultSet rs = accountPS.executeQuery();
                    while (rs.next()) {
                        float nds;
                        float summNds;
                        int num = rs.getInt(1);
                        int sid = rs.getInt(2);
                        float summ = rs.getFloat(3);
                        if (ndsInSumm) {
                            summNds = summ;
                            nds = summ - summ / ndsMultiplier;
                        } else {
                            nds = summ * ndsMultiplier;
                            summNds = summ + nds;
                        }
                        float rewardPercent = ((Float)servicesRewards.get(sid)).floatValue();
                        float reward = summ * rewardPercent / 100.0f;
                        totalSumm += summ;
                        totalNds += nds;
                        totalSummNds += summNds;
                        totalReward += reward;
                        String service = (String)serviceTitles.get(sid);
                        if (service == null) {
                            getServiceTitlePS.setInt(1, sid);
                            ResultSet getServiceTitleRS = getServiceTitlePS.executeQuery();
                            while (getServiceTitleRS.next()) {
                                service = getServiceTitleRS.getString(1);
                                serviceTitles.put(sid, service);
                            }
                        }
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("cid", contract);
                        row.put("contract", contractTitle);
                        row.put("contractComment", contractComment);
                        row.put("service", service);
                        row.put("summ", Utils.formatCost((float)summ));
                        if (fixedPriceSet.contains(sid)) {
                            row.put("price", Utils.formatCost((float)(summ / (float)num)));
                            row.put("num", String.valueOf(num));
                        } else {
                            row.put("price", Utils.formatCost((float)summ));
                            row.put("num", "1");
                        }
                        row.put("nds", Utils.formatCost((float)nds));
                        row.put("summnds", Utils.formatCost((float)summNds));
                        row.put("percent", Utils.formatCost((float)rewardPercent));
                        row.put("reward", Utils.formatCost((float)reward));
                        bds.addRow(row);
                    }
                    accountPS.close();
                }
                ps.close();
                getSubContract.close();
                getServiceTitlePS.close();
            }
            params.put("summ", Utils.formatCost((float)totalSumm));
            params.put("nds", Utils.formatCost((float)totalNds));
            params.put("summnds", Utils.formatCost((float)totalSummNds));
            params.put("reward", Utils.formatCost((float)totalReward));
            Calendar now = new GregorianCalendar();
            params.put("now", TimeUtils.formatDate((Calendar)now));
            now = (Calendar)date.clone();
            now.add(2, 1);
            now.set(5, 1);
            now.add(5, -1);
            params.put("month", TimeUtils.formatDate((Calendar)now));
            this.fillReportToStream(this.id, out, params, (JRDataSource)bds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

